/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.commons.MathTools;
import us.ihmc.robotics.controllers.AbstractPDController;
import us.ihmc.robotics.controllers.AbstractPIDController;
import us.ihmc.robotics.controllers.PDController;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPIDGains;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class PIDController
extends AbstractPIDController {
    private final PDController pdController;
    private final YoDouble integralGain;
    private final YoDouble maxIntegralError;
    private final YoDouble maxFeedback;
    private final YoDouble integralLeakRatio;

    public PIDController(String suffix, YoRegistry registry) {
        super(suffix, registry);
        this.pdController = new PDController(suffix, registry);
        this.integralGain = new YoDouble("ki_" + suffix, registry);
        this.integralGain.set(0.0);
        this.maxIntegralError = new YoDouble("maxIntegralError_" + suffix, registry);
        this.maxIntegralError.set(Double.POSITIVE_INFINITY);
        this.maxFeedback = new YoDouble("maxOutput_" + suffix, registry);
        this.maxFeedback.set(Double.POSITIVE_INFINITY);
        this.integralLeakRatio = new YoDouble("leak_" + suffix, registry);
        this.integralLeakRatio.set(1.0);
        this.addLeakRatioClipper();
    }

    private void addLeakRatioClipper() {
        YoVariableChangedListener leakRatioClipper = new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                PIDController.this.integralLeakRatio.set(MathTools.clamp((double)PIDController.this.integralLeakRatio.getDoubleValue(), (double)0.0, (double)1.0), false);
            }
        };
        this.integralLeakRatio.addListener(leakRatioClipper);
    }

    public PIDController(YoDouble proportionalGain, YoDouble integralGain, YoDouble derivativeGain, YoDouble maxIntegralError, String suffix, YoRegistry registry) {
        super(suffix, registry);
        this.pdController = new PDController(proportionalGain, derivativeGain, suffix, registry);
        this.integralGain = integralGain;
        this.maxIntegralError = maxIntegralError;
        this.maxFeedback = new YoDouble("maxOutput_" + suffix, registry);
        this.maxFeedback.set(Double.POSITIVE_INFINITY);
        this.integralLeakRatio = new YoDouble("leak_" + suffix, registry);
        this.integralLeakRatio.set(1.0);
        this.addLeakRatioClipper();
    }

    public PIDController(YoPIDGains yoPIDGains, String suffix, YoRegistry registry) {
        super(suffix, registry);
        this.pdController = new PDController(yoPIDGains, suffix, registry);
        this.integralGain = yoPIDGains.getYoKi();
        this.maxIntegralError = yoPIDGains.getYoMaxIntegralError();
        this.maxFeedback = yoPIDGains.getYoMaximumFeedback();
        this.integralLeakRatio = yoPIDGains.getYoIntegralLeakRatio();
    }

    public void setMaximumOutputLimit(double max) {
        if (max <= 0.0) {
            this.maxFeedback.set(Double.POSITIVE_INFINITY);
        } else {
            this.maxFeedback.set(max);
        }
    }

    public void setProportionalGain(double proportionalGain) {
        this.pdController.setProportionalGain(proportionalGain);
    }

    public void setDerivativeGain(double derivativeGain) {
        this.pdController.setDerivativeGain(derivativeGain);
    }

    public void setPositionDeadband(double deadband) {
        this.pdController.setPositionDeadband(deadband);
    }

    public void setIntegralGain(double integralGain) {
        this.integralGain.set(integralGain);
    }

    public void setIntegralLeakRatio(double integralLeakRatio) {
        this.integralLeakRatio.set(MathTools.clamp((double)integralLeakRatio, (double)0.0, (double)1.0));
    }

    public void setMaxIntegralError(double maxIntegralError) {
        this.maxIntegralError.set(maxIntegralError);
    }

    public void setGains(PIDGainsReadOnly gains) {
        this.pdController.setGains(gains);
        this.setMaximumOutputLimit(gains.getMaximumFeedback());
        this.setIntegralLeakRatio(gains.getIntegralLeakRatio());
        this.setIntegralGain(gains.getKi());
        this.setMaxIntegralError(gains.getMaxIntegralError());
    }

    @Override
    protected AbstractPDController getPDController() {
        return this.pdController;
    }

    @Override
    public double getMaximumFeedback() {
        return this.maxFeedback.getDoubleValue();
    }

    @Override
    public double getIntegralGain() {
        return this.integralGain.getDoubleValue();
    }

    @Override
    public double getMaxIntegralError() {
        return this.maxIntegralError.getDoubleValue();
    }

    @Override
    public double getIntegralLeakRatio() {
        return this.integralLeakRatio.getDoubleValue();
    }
}

