/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.robotics.controllers.CylindricalPDGains;
import us.ihmc.robotics.controllers.PositionController;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.geometry.CylindricalCoordinatesCalculator;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class CylindricalCoordinatesPositionController
implements PositionController {
    private final YoRegistry registry;
    private final YoDouble positionErrorRadial;
    private final YoDouble positionErrorAngle;
    private final YoDouble positionErrorZ;
    private final YoDouble velocityErrorRadial;
    private final YoDouble velocityErrorAngle;
    private final YoDouble velocityErrorZ;
    private final YoDouble kpRadial;
    private final YoDouble kpAngle;
    private final YoDouble kpZ;
    private final YoDouble kdRadial;
    private final YoDouble kdAngle;
    private final YoDouble kdZ;
    private final ReferenceFrame bodyFrame;
    private final ReferenceFrame cylinderFrame;
    private final FramePoint3D currentPosition;

    public CylindricalCoordinatesPositionController(String prefix, ReferenceFrame bodyFrame, ReferenceFrame cylinderFrame, YoRegistry parentRegistry) {
        this.bodyFrame = bodyFrame;
        this.currentPosition = new FramePoint3D(bodyFrame);
        this.registry = new YoRegistry(prefix + this.getClass().getSimpleName());
        this.positionErrorRadial = new YoDouble(prefix + "RadialPositionError", this.registry);
        this.positionErrorAngle = new YoDouble(prefix + "AnglePositionError", this.registry);
        this.positionErrorZ = new YoDouble(prefix + "ZPositionError", this.registry);
        this.velocityErrorRadial = new YoDouble(prefix + "RadialVelocityError", this.registry);
        this.velocityErrorAngle = new YoDouble(prefix + "AngleVelocityError", this.registry);
        this.velocityErrorZ = new YoDouble(prefix + "ZVelocityError", this.registry);
        String baseProportionalGainName = prefix + "Kp";
        this.kpRadial = new YoDouble(baseProportionalGainName + "Radial", this.registry);
        this.kpAngle = new YoDouble(baseProportionalGainName + "Angle", this.registry);
        this.kpZ = new YoDouble(baseProportionalGainName + "Z", this.registry);
        String baseDerivativeGainName = prefix + "Kd";
        this.kdRadial = new YoDouble(baseDerivativeGainName + "Radial", this.registry);
        this.kdAngle = new YoDouble(baseDerivativeGainName + "Angle", this.registry);
        this.kdZ = new YoDouble(baseDerivativeGainName + "Z", this.registry);
        this.cylinderFrame = cylinderFrame;
        parentRegistry.addChild(this.registry);
    }

    @Override
    public void compute(FrameVector3D output, FramePoint3D desiredPosition, FrameVector3D desiredVelocity, FrameVector3D currentVelocity, FrameVector3D feedForward) {
        desiredPosition.changeFrame(this.cylinderFrame);
        desiredVelocity.changeFrame(this.cylinderFrame);
        currentVelocity.changeFrame(this.cylinderFrame);
        feedForward.changeFrame(this.cylinderFrame);
        this.currentPosition.setToZero(this.bodyFrame);
        this.currentPosition.changeFrame(this.cylinderFrame);
        double desiredAngle = CylindricalCoordinatesCalculator.getAngle(desiredPosition);
        double currentAngle = CylindricalCoordinatesCalculator.getAngle(this.currentPosition);
        double angleError = AngleTools.computeAngleDifferenceMinusPiToPi(desiredAngle, currentAngle);
        double desiredAngularVelocity = CylindricalCoordinatesCalculator.getAngularVelocity(this.currentPosition, desiredVelocity);
        double currentAngularVelocity = CylindricalCoordinatesCalculator.getAngularVelocity(this.currentPosition, currentVelocity);
        double angularVelocityError = desiredAngularVelocity - currentAngularVelocity;
        double angleFeedBack = this.kpAngle.getDoubleValue() * angleError + this.kdAngle.getDoubleValue() * angularVelocityError;
        double desiredRadius = CylindricalCoordinatesCalculator.getRadius(desiredPosition);
        double currentRadius = CylindricalCoordinatesCalculator.getRadius(this.currentPosition);
        double radiusError = desiredRadius - currentRadius;
        double desiredRadialVelocity = CylindricalCoordinatesCalculator.getRadialVelocity(desiredPosition, desiredVelocity);
        double currentRadialVelocity = CylindricalCoordinatesCalculator.getRadialVelocity(this.currentPosition, currentVelocity);
        double radialVelocityError = desiredRadialVelocity - currentRadialVelocity;
        double radiusFeedBack = this.kpRadial.getDoubleValue() * radiusError + this.kdRadial.getDoubleValue() * radialVelocityError;
        double desiredZ = desiredPosition.getZ();
        double currentZ = this.currentPosition.getZ();
        double zError = desiredZ - currentZ;
        double desiredZVelocity = desiredVelocity.getZ();
        double currentZVelocity = currentVelocity.getZ();
        double zVelocityError = desiredZVelocity - currentZVelocity;
        double zFeedBack = this.kpZ.getDoubleValue() * zError + this.kdZ.getDoubleValue() * zVelocityError;
        CylindricalCoordinatesCalculator.getAcceleration(output, this.cylinderFrame, currentAngle, currentAngularVelocity, angleFeedBack, currentRadius, currentRadialVelocity, radiusFeedBack, zFeedBack);
        output.changeFrame(this.bodyFrame);
        feedForward.changeFrame(this.bodyFrame);
        output.add((FrameTuple3DReadOnly)feedForward);
        this.positionErrorAngle.set(angleError);
        this.positionErrorRadial.set(radiusError);
        this.positionErrorZ.set(zError);
        this.velocityErrorAngle.set(angularVelocityError);
        this.velocityErrorRadial.set(radialVelocityError);
        this.velocityErrorZ.set(zVelocityError);
    }

    @Override
    public ReferenceFrame getBodyFrame() {
        return this.bodyFrame;
    }

    public void setGains(CylindricalPDGains gains) {
        this.kpRadial.set(gains.getKpRadius());
        this.kpAngle.set(gains.getKpAngle());
        this.kpZ.set(gains.getKpZ());
        this.kdRadial.set(gains.getKdRadius());
        this.kdAngle.set(gains.getKdAngle());
        this.kdZ.set(gains.getKdZ());
    }
}

