/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import us.ihmc.commons.MathTools;
import us.ihmc.robotics.controllers.PIDController;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class BacklashCompensatingPIDController
extends PIDController {
    private final YoDouble maxProportionalGain;
    private final YoDouble maxDerivativeGain;
    private final YoDouble lowGainReduction;
    private final YoDouble gainReduction;
    private final YoDouble rampUpTime;
    private final YoDouble rampDownTime;
    private final YoDouble holdLowGainsTime;
    private final YoEnum<GainChangerState> gainChangerState;
    private final YoDouble switchTime;
    private final YoBoolean previousTorqueWasPositive;
    private boolean gainReductionUpToDate = false;

    public BacklashCompensatingPIDController(String suffix, YoRegistry registry) {
        super(suffix, registry);
        this.maxProportionalGain = new YoDouble("max_kp_" + suffix, registry);
        this.maxDerivativeGain = new YoDouble("max_kd_" + suffix, registry);
        this.gainReduction = new YoDouble("gainReduction_" + suffix, registry);
        this.lowGainReduction = new YoDouble("lowGainReduction_" + suffix, registry);
        this.gainChangerState = new YoEnum("gainChangerState_" + suffix, registry, GainChangerState.class);
        this.rampDownTime = new YoDouble("rampDownTime_" + suffix, registry);
        this.rampUpTime = new YoDouble("rampUpTime_" + suffix, registry);
        this.holdLowGainsTime = new YoDouble("holdLowGainsTime_" + suffix, registry);
        this.previousTorqueWasPositive = new YoBoolean("previousTorqueWasPositive_" + suffix, registry);
        this.switchTime = new YoDouble("switchTime_" + suffix, registry);
        this.gainChangerState.set((Enum)GainChangerState.LOW_GAINS);
        this.switchTime.set(0.0);
        this.previousTorqueWasPositive.set(false);
        this.gainReduction.set(1.0);
        this.lowGainReduction.set(0.5);
        this.rampUpTime.set(1.0);
        this.rampDownTime.set(0.3);
        this.holdLowGainsTime.set(0.5);
    }

    public void setLowGainBacklashReduction(double lowGainReduction) {
        this.lowGainReduction.set(lowGainReduction);
    }

    public void setRampUpTime(double rampUpTime) {
        this.rampUpTime.set(rampUpTime);
    }

    public void setRampDownTime(double rampDownTime) {
        this.rampDownTime.set(rampDownTime);
    }

    public void setHoldLowGainsTime(double holdLowGainsTime) {
        this.holdLowGainsTime.set(holdLowGainsTime);
    }

    public double getLowGainBacklashReduction() {
        return this.lowGainReduction.getDoubleValue();
    }

    public double getRampUpTime() {
        return this.rampUpTime.getDoubleValue();
    }

    public double getRampDownTime() {
        return this.rampDownTime.getDoubleValue();
    }

    public double getHoldLowGainsTime() {
        return this.holdLowGainsTime.getDoubleValue();
    }

    public void computeGainReduction(double time, double actuatorTorque) {
        this.gainReductionUpToDate = true;
        switch ((GainChangerState)this.gainChangerState.getEnumValue()) {
            case HIGH_GAINS: {
                this.gainReduction.set(1.0);
                if (!this.signChanged(actuatorTorque)) break;
                this.gainChangerState.set((Enum)GainChangerState.RAMPDOWN);
                this.switchTime.set(time);
                break;
            }
            case LOW_GAINS: {
                this.gainReduction.set(this.lowGainReduction.getDoubleValue());
                if (this.signChanged(actuatorTorque)) {
                    this.switchTime.set(time);
                    break;
                }
                if (!(time > this.switchTime.getDoubleValue() + this.holdLowGainsTime.getDoubleValue())) break;
                this.gainChangerState.set((Enum)GainChangerState.RAMPUP);
                this.switchTime.set(time);
                break;
            }
            case RAMPDOWN: {
                double deltaTime = time - this.switchTime.getDoubleValue();
                double percentRampDown = deltaTime / this.rampDownTime.getDoubleValue();
                if (percentRampDown >= 1.0) {
                    this.gainChangerState.set((Enum)GainChangerState.LOW_GAINS);
                    this.switchTime.set(time);
                }
                percentRampDown = MathTools.clamp((double)percentRampDown, (double)0.0, (double)1.0);
                this.gainReduction.set(1.0 - percentRampDown * (1.0 - this.lowGainReduction.getDoubleValue()));
                break;
            }
            case RAMPUP: {
                double deltaTime = time - this.switchTime.getDoubleValue();
                double percentRampUp = deltaTime / this.rampUpTime.getDoubleValue();
                if (percentRampUp >= 1.0) {
                    this.gainChangerState.set((Enum)GainChangerState.HIGH_GAINS);
                    this.switchTime.set(time);
                }
                percentRampUp = MathTools.clamp((double)percentRampUp, (double)0.0, (double)1.0);
                this.gainReduction.set(this.lowGainReduction.getDoubleValue() + percentRampUp * (1.0 - this.lowGainReduction.getDoubleValue()));
                break;
            }
            default: {
                throw new RuntimeException("Shouldn't get here!");
            }
        }
    }

    private boolean signChanged(double actuatorTorque) {
        if (this.previousTorqueWasPositive.getBooleanValue() && actuatorTorque <= 0.0) {
            this.previousTorqueWasPositive.set(false);
            return true;
        }
        if (!this.previousTorqueWasPositive.getBooleanValue() && actuatorTorque >= 0.0) {
            this.previousTorqueWasPositive.set(true);
            return true;
        }
        return false;
    }

    @Override
    public double compute(double currentPosition, double desiredPosition, double currentRate, double desiredRate, double deltaTime) {
        this.checkGainReductionUpToDate();
        this.setGainsReducedIfBacklash();
        return super.compute(currentPosition, desiredPosition, currentRate, desiredRate, deltaTime);
    }

    @Override
    public double computeForAngles(double currentPosition, double desiredPosition, double currentRate, double desiredRate, double deltaTime) {
        this.checkGainReductionUpToDate();
        this.setGainsReducedIfBacklash();
        return super.computeForAngles(currentPosition, desiredPosition, currentRate, desiredRate, deltaTime);
    }

    private void checkGainReductionUpToDate() {
        if (!this.gainReductionUpToDate) {
            throw new RuntimeException("gain reduction is not up to date!");
        }
        this.gainReductionUpToDate = false;
    }

    @Override
    public double getProportionalGain() {
        return this.maxProportionalGain.getDoubleValue();
    }

    @Override
    public double getDerivativeGain() {
        return this.maxDerivativeGain.getDoubleValue();
    }

    @Override
    public void setProportionalGain(double proportionalGain) {
        this.maxProportionalGain.set(proportionalGain);
    }

    @Override
    public void setDerivativeGain(double derivativeGain) {
        this.maxDerivativeGain.set(derivativeGain);
    }

    private void setGainsReducedIfBacklash() {
        double proportionalGain = this.gainReduction.getDoubleValue() * this.maxProportionalGain.getDoubleValue();
        double derivativeGain = this.gainReduction.getDoubleValue() * this.maxDerivativeGain.getDoubleValue();
        super.setProportionalGain(proportionalGain);
        super.setDerivativeGain(derivativeGain);
    }

    private static enum GainChangerState {
        LOW_GAINS,
        HIGH_GAINS,
        RAMPDOWN,
        RAMPUP;

    }
}

