/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.time;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.robotics.time.TimeTools;

public class TimeToolsTest {
    private static final double EPSILON = 1.0E-9;

    @Test
    public void testUnitConversions() {
        for (long millis = 0L; millis < 10000L; ++millis) {
            Assertions.assertEquals((double)((double)millis / 1000.0), (double)TimeTools.toDoubleSeconds((Duration)Duration.ofMillis(millis)), (double)1.0E-9);
        }
        for (int seconds = 0; seconds < 10; ++seconds) {
            for (int nanos = 0; nanos < 1000000000; nanos += 1000) {
                Duration duration = Duration.ofSeconds(seconds, nanos);
                double doubleSeconds = (double)seconds + Conversions.nanosecondsToSeconds((long)nanos);
                Assertions.assertEquals((double)doubleSeconds, (double)TimeTools.toDoubleSeconds((Duration)duration), (double)1.0E-9);
            }
        }
        for (long seconds = 0L; seconds < 100L; ++seconds) {
            for (long millis = 0L; millis < 10000L; ++millis) {
                double doubleSeconds = (double)seconds + Conversions.millisecondsToSeconds((double)millis);
                Assertions.assertEquals((double)doubleSeconds, (double)TimeTools.secondsMillisToDoubleSeconds((long)seconds, (long)millis), (double)1.0E-9);
            }
        }
        Duration twoPointFiveSeconds = TimeTools.durationOfSeconds((double)2.5);
        Assertions.assertEquals((long)2L, (long)twoPointFiveSeconds.getSeconds());
        Assertions.assertEquals((double)5.0E8, (double)twoPointFiveSeconds.getNano());
        for (double seconds = 0.0; seconds < 50.0; seconds += 0.05) {
            Duration duration = TimeTools.durationOfSeconds((double)seconds);
            long durationSeconds = duration.getSeconds();
            long durationNanos = duration.getNano();
            long trueSeconds = (long)seconds;
            long trueNanos = (long)((seconds - (double)trueSeconds) * 1.0E9);
            Assertions.assertEquals((long)trueSeconds, (long)durationSeconds);
            Assertions.assertEquals((long)trueNanos, (long)durationNanos);
        }
    }

    @Test
    public void testSecondsBetween() {
        Instant start = Instant.now();
        for (int i = 0; i < 100; ++i) {
            Instant secondsAfter = start.plusSeconds(i);
            double startToAfter = TimeTools.secondsBetween((Temporal)start, (Temporal)secondsAfter);
            Assertions.assertEquals((double)i, (double)startToAfter, (double)1.0E-6);
            double afterToStart = TimeTools.secondsBetween((Temporal)secondsAfter, (Temporal)start);
            Assertions.assertEquals((double)(-i), (double)afterToStart, (double)1.0E-6);
        }
    }

    @Test
    public void testFindClosestTime() {
        Instant target = Instant.now();
        Instant milliAfter = target.plusMillis(1L);
        Instant twoMillisAfter = target.plusMillis(2L);
        Instant secondAfter = target.plusSeconds(1L);
        Instant twoSecondsAfter = target.plusSeconds(2L);
        Instant milliBefore = target.minusMillis(1L);
        Instant twoMillisBefore = target.minusMillis(2L);
        Instant secondBefore = target.minusSeconds(1L);
        Instant twoSecondsBefore = target.minusSeconds(2L);
        this.testFindClosestTime(target, List.of(), -1);
        this.testFindClosestTime(target, List.of(twoSecondsBefore, milliBefore, twoMillisAfter, secondAfter), 1);
        this.testFindClosestTime(target, List.of(milliAfter, twoMillisBefore, secondBefore), 0);
        this.testFindClosestTime(target, List.of(milliBefore, milliAfter, target, twoSecondsAfter), 2);
        this.testFindClosestTime(target, List.of(twoSecondsBefore, twoSecondsAfter), 0);
        this.testFindClosestTime(target, List.of(secondAfter, secondBefore), 0);
    }

    private void testFindClosestTime(Temporal target, List<? extends Temporal> times, int expectedResult) {
        int closestIndex = TimeTools.findClosestTimeIndex((Temporal)target, times);
        Assertions.assertEquals((int)expectedResult, (int)closestIndex);
    }
}

