/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.testing;

import Jama.Matrix;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.testing.JUnitTools;

public class JUnitToolsTest {
    @Test
    public void testAssertJamaMatrixEquals() {
        int ITERATIONS = 1000;
        double EPSILON = 1.0E-6;
        int MATRIX_SIZE_BOUND = 100;
        Random random1 = new Random(4274L);
        Random random2 = new Random(4274L);
        for (int i = 0; i < 1000; ++i) {
            int n1 = random1.nextInt(100);
            int m1 = random1.nextInt(100);
            Matrix matrix1 = new Matrix(this.randomDoubleArray(random1, n1 * m1), m1);
            int n2 = random2.nextInt(100);
            int m2 = random2.nextInt(100);
            Matrix matrix2 = new Matrix(this.randomDoubleArray(random2, n2 * m2), m2);
            JUnitTools.assertMatrixEquals(matrix1, matrix2, 1.0E-6);
            JUnitTools.assertMatrixEquals("testAssertJamaMatrixEquals", matrix1, matrix2, 1.0E-6);
        }
    }

    @Test
    public void testAssertDoubleArrayEquals() {
        int ITERATIONS = 1000;
        double EPSILON = 1.0E-6;
        int MAX_ARRAY_SIZE = 500;
        Random random1 = new Random(4285L);
        Random random2 = new Random(4285L);
        for (int i = 0; i < 1000; ++i) {
            double[] array1 = this.randomDoubleArray(random1, random1.nextInt(500));
            double[] array2 = this.randomDoubleArray(random2, random2.nextInt(500));
            JUnitTools.assertDoubleArrayEquals(array1, array2, 1.0E-6);
        }
    }

    private double[] randomDoubleArray(Random random, int length) {
        double LARGE_VALUE = 4.294967296E9;
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = -4.294967296E9 + 8.589934592E9 * random.nextDouble();
        }
        return array;
    }
}

