/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.testing;

import Jama.Matrix;
import gnu.trove.list.array.TDoubleArrayList;
import us.ihmc.robotics.Assert;

public class JUnitTools {
    public static void assertMatrixEquals(Matrix expected, Matrix actual, double delta) {
        JUnitTools.assertMatrixEquals("", expected, actual, delta);
    }

    public static void assertMatrixEquals(String message, Matrix expected, Matrix actual, double delta) {
        Assert.assertEquals(message, expected.getRowDimension(), actual.getRowDimension());
        Assert.assertEquals(message, expected.getColumnDimension(), actual.getColumnDimension());
        for (int i = 0; i < expected.getRowDimension(); ++i) {
            for (int j = 0; j < expected.getColumnDimension(); ++j) {
                Assert.assertEquals(message, actual.get(i, j), expected.get(i, j), delta);
            }
        }
    }

    public static void assertDoubleArrayEquals(double[] expectedDoubleArray, double[] actualDoubleArray, double epsilon) {
        Assert.assertNotNull("Expected array is null.", expectedDoubleArray);
        Assert.assertNotNull("Actual array is null.", actualDoubleArray);
        Assert.assertEquals("Arrays are not the same size. ", expectedDoubleArray.length, actualDoubleArray.length);
        for (int i = 0; i < expectedDoubleArray.length; ++i) {
            Assert.assertEquals("Array disagree at index " + i + " :", expectedDoubleArray[i], actualDoubleArray[i], epsilon);
        }
    }

    public static void assertTDoubleArrayListEquals(TDoubleArrayList expected, TDoubleArrayList actual, double epsilon) {
        Assert.assertEquals("Size is not equal. Expected " + expected.size() + ", received " + actual.size() + ".", expected.size(), actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals("Value " + i + " is not equal. Expected " + expected.get(i) + ", received " + actual.get(i) + ".", expected.get(i), actual.get(i), epsilon);
        }
    }
}

