/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.testExecutor;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.taskExecutor.ParallelState;
import us.ihmc.robotics.taskExecutor.PipeLine;
import us.ihmc.robotics.testExecutor.CountActionsTask;

public class PipeLineTest {
    @Test
    public void testEmptyPipeline() {
        PipeLine pipeLine = new PipeLine();
        pipeLine.doControl();
        pipeLine.doControl();
        Assert.assertTrue(pipeLine.isDone());
    }

    @Test
    public void testPipelineWithOneSingleTaskStage() {
        PipeLine pipeLine = new PipeLine();
        CountActionsTask stage0SingleTask = new CountActionsTask(2);
        pipeLine.submitSingleTaskStage((State)stage0SingleTask);
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0SingleTask.checkNumberOfCalls(1, 1, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0SingleTask.checkNumberOfCalls(1, 2, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0SingleTask.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(pipeLine.isDone());
    }

    @Test
    public void testPipelineWithTwoSingleTaskStages() {
        PipeLine pipeLine = new PipeLine();
        CountActionsTask stage0SingleTask = new CountActionsTask(2);
        pipeLine.submitSingleTaskStage((State)stage0SingleTask);
        CountActionsTask stage1SingleTask = new CountActionsTask(3);
        pipeLine.submitSingleTaskStage((State)stage1SingleTask);
        pipeLine.doControl();
        Assert.assertTrue(stage0SingleTask.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(0, 0, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0SingleTask.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(0, 0, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(pipeLine.getCurrentStage() == stage1SingleTask);
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(stage0SingleTask.checkNumberOfCalls(1, 2, 1));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(stage0SingleTask.checkNumberOfCalls(1, 2, 1));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 3, 0));
        Assert.assertTrue(stage0SingleTask.checkNumberOfCalls(1, 2, 1));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 3, 1));
        Assert.assertTrue(stage0SingleTask.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(pipeLine.isDone());
    }

    @Test
    public void testPipelineOneStageTwoPipesThenOneSingleTaskStage() {
        PipeLine pipeLine = new PipeLine();
        ParallelTaskKey taskKeyA = new ParallelTaskKey();
        ParallelTaskKey taskKeyB = new ParallelTaskKey();
        CountActionsTask stage0TaskA = new CountActionsTask(1);
        CountActionsTask stage0TaskB = new CountActionsTask(2);
        CountActionsTask stage1SingleTask = new CountActionsTask(2);
        pipeLine.submitTaskForPallelPipesStage((Object)taskKeyA, (State)stage0TaskA);
        pipeLine.submitTaskForPallelPipesStage((Object)taskKeyB, (State)stage0TaskB);
        pipeLine.submitSingleTaskStage((State)stage1SingleTask);
        pipeLine.doControl();
        Assert.assertTrue(pipeLine.getCurrentStage() instanceof ParallelState);
        Assert.assertTrue(stage0TaskA.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(stage0TaskB.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(0, 0, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(pipeLine.getCurrentStage() instanceof ParallelState);
        Assert.assertTrue(stage0TaskA.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(stage0TaskB.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(0, 0, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(pipeLine.getCurrentStage() instanceof ParallelState);
        Assert.assertTrue(stage0TaskA.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(stage0TaskB.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(0, 0, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(pipeLine.getCurrentStage() == stage1SingleTask);
        Assert.assertTrue(stage0TaskA.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(stage0TaskB.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 1, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(stage0TaskB.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 2, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(stage0TaskB.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(pipeLine.isDone());
    }

    @Test
    public void testTwoParallelPipes() {
        PipeLine pipeLine = new PipeLine();
        ParallelTaskKey taskKeyA = new ParallelTaskKey();
        ParallelTaskKey taskKeyB = new ParallelTaskKey();
        CountActionsTask stage0TaskA0 = new CountActionsTask(2);
        CountActionsTask stage0TaskA1 = new CountActionsTask(2);
        CountActionsTask stage0TaskB0 = new CountActionsTask(2);
        pipeLine.submitTaskForPallelPipesStage((Object)taskKeyA, (State)stage0TaskA0);
        pipeLine.submitTaskForPallelPipesStage((Object)taskKeyA, (State)stage0TaskA1);
        pipeLine.submitTaskForPallelPipesStage((Object)taskKeyB, (State)stage0TaskB0);
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 1, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(pipeLine.isDone());
    }

    @Test
    public void testThreePipesWithParallelAndSeriesTasks() {
        PipeLine pipeLine = new PipeLine();
        ParallelTaskKey taskKeyA = new ParallelTaskKey();
        ParallelTaskKey taskKeyB = new ParallelTaskKey();
        ParallelTaskKey taskKeyC = new ParallelTaskKey();
        CountActionsTask stage0TaskA0 = new CountActionsTask(2);
        CountActionsTask stage0TaskA1 = new CountActionsTask(2);
        CountActionsTask stage0TaskB0 = new CountActionsTask(2);
        CountActionsTask stage1SingleTask = new CountActionsTask(1);
        CountActionsTask stage2TaskA0 = new CountActionsTask(2);
        CountActionsTask stage2TaskA1 = new CountActionsTask(2);
        CountActionsTask stage2TaskB0 = new CountActionsTask(2);
        CountActionsTask stage2TaskC0 = new CountActionsTask(5);
        pipeLine.submitTaskForPallelPipesStage((Object)taskKeyA, (State)stage0TaskA0);
        pipeLine.submitTaskForPallelPipesStage((Object)taskKeyA, (State)stage0TaskA1);
        pipeLine.submitTaskForPallelPipesStage((Object)taskKeyB, (State)stage0TaskB0);
        pipeLine.submitSingleTaskStage((State)stage1SingleTask);
        pipeLine.submitTaskForPallelPipesStage((Object)taskKeyA, (State)stage2TaskA0);
        pipeLine.submitTaskForPallelPipesStage((Object)taskKeyA, (State)stage2TaskA1);
        pipeLine.submitTaskForPallelPipesStage((Object)taskKeyB, (State)stage2TaskB0);
        pipeLine.submitTaskForPallelPipesStage((Object)taskKeyC, (State)stage2TaskC0);
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskA0.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskA1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskB0.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskC0.checkNumberOfCalls(0, 0, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskA0.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskA1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskB0.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskC0.checkNumberOfCalls(0, 0, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskA0.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskA1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskB0.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskC0.checkNumberOfCalls(0, 0, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskA0.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskA1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskB0.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskC0.checkNumberOfCalls(0, 0, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskA0.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskA1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskB0.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskC0.checkNumberOfCalls(0, 0, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(stage2TaskA0.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskA1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskB0.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskC0.checkNumberOfCalls(0, 0, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(stage2TaskA0.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(stage2TaskA1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskB0.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(stage2TaskC0.checkNumberOfCalls(1, 1, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(stage2TaskA0.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(stage2TaskA1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(stage2TaskB0.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(stage2TaskC0.checkNumberOfCalls(1, 2, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(stage2TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage2TaskA1.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(stage2TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage2TaskC0.checkNumberOfCalls(1, 3, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(stage2TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage2TaskA1.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(stage2TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage2TaskC0.checkNumberOfCalls(1, 4, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(stage2TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage2TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage2TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage2TaskC0.checkNumberOfCalls(1, 5, 0));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(stage2TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage2TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage2TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage2TaskC0.checkNumberOfCalls(1, 5, 1));
        Assert.assertFalse(pipeLine.isDone());
        pipeLine.doControl();
        Assert.assertTrue(stage0TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage0TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage1SingleTask.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(stage2TaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage2TaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage2TaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(stage2TaskC0.checkNumberOfCalls(1, 5, 1));
        Assert.assertTrue(pipeLine.isDone());
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForPackage(PipeLineTest.class);
    }

    private class ParallelTaskKey {
        private ParallelTaskKey() {
        }
    }
}

