/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.testExecutor;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.taskExecutor.NullState;
import us.ihmc.robotics.taskExecutor.ParallelState;
import us.ihmc.robotics.taskExecutor.StateExecutor;
import us.ihmc.robotics.testExecutor.CountActionsTask;

public class ParallelTaskTest {
    @Test
    public void testOneSerialTask() {
        StateExecutor taskExecutor = new StateExecutor();
        ParallelState parallelTask = new ParallelState();
        ParallelTaskKey taskKeyA = new ParallelTaskKey();
        CountActionsTask exampleTaskA0 = new CountActionsTask(2);
        parallelTask.submit((Object)taskKeyA, (State)exampleTaskA0);
        taskExecutor.submit((State)parallelTask);
        Assert.assertFalse(taskExecutor.isDone());
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 1, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 2, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 2, 1));
        taskExecutor.doControl();
        Assert.assertTrue(taskExecutor.isDone());
        Assert.assertTrue(parallelTask != taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 2, 1));
    }

    @Test
    public void testTwoSerialTasks() {
        StateExecutor taskExecutor = new StateExecutor();
        ParallelState parallelTask = new ParallelState();
        ParallelTaskKey taskKeyA = new ParallelTaskKey();
        CountActionsTask exampleTaskA0 = new CountActionsTask(2);
        CountActionsTask exampleTaskA1 = new CountActionsTask(2);
        parallelTask.submit((Object)taskKeyA, (State)exampleTaskA0);
        parallelTask.submit((Object)taskKeyA, (State)exampleTaskA1);
        taskExecutor.submit((State)parallelTask);
        Assert.assertFalse(taskExecutor.isDone());
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(0, 0, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(0, 0, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(1, 1, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(1, 2, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(1, 2, 1));
        taskExecutor.doControl();
        Assert.assertTrue(parallelTask != taskExecutor.getCurrentTask());
        Assert.assertTrue(taskExecutor.isDone());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(1, 2, 1));
    }

    @Test
    public void testTwoParallelTasks() {
        StateExecutor taskExecutor = new StateExecutor();
        ParallelState parallelTask = new ParallelState();
        ParallelTaskKey taskKeyA = new ParallelTaskKey();
        ParallelTaskKey taskKeyB = new ParallelTaskKey();
        CountActionsTask exampleTaskA0 = new CountActionsTask(2);
        CountActionsTask exampleTaskB0 = new CountActionsTask(3);
        parallelTask.submit((Object)taskKeyA, (State)exampleTaskA0);
        parallelTask.submit((Object)taskKeyB, (State)exampleTaskB0);
        taskExecutor.submit((State)parallelTask);
        Assert.assertFalse(taskExecutor.isDone());
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 1, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 2, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 3, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 3, 1));
        taskExecutor.doControl();
        Assert.assertTrue(taskExecutor.isDone());
        Assert.assertTrue(parallelTask != taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 3, 1));
    }

    @Test
    public void testABunchOfParallelAndSeriesTasks() {
        StateExecutor taskExecutor = new StateExecutor();
        ParallelState parallelTask = new ParallelState();
        ParallelTaskKey taskKeyA = new ParallelTaskKey();
        ParallelTaskKey taskKeyB = new ParallelTaskKey();
        ParallelTaskKey taskKeyC = new ParallelTaskKey();
        CountActionsTask exampleTaskA0 = new CountActionsTask(1);
        CountActionsTask exampleTaskA1 = new CountActionsTask(2);
        CountActionsTask exampleTaskB0 = new CountActionsTask(2);
        CountActionsTask exampleTaskB1 = new CountActionsTask(2);
        CountActionsTask exampleTaskC0 = new CountActionsTask(5);
        parallelTask.submit((Object)taskKeyA, (State)exampleTaskA0);
        parallelTask.submit((Object)taskKeyA, (State)exampleTaskA1);
        parallelTask.submit((Object)taskKeyB, (State)exampleTaskB0);
        parallelTask.submit((Object)taskKeyB, (State)exampleTaskB1);
        parallelTask.submit((Object)taskKeyC, (State)exampleTaskC0);
        taskExecutor.submit((State)parallelTask);
        Assert.assertFalse(taskExecutor.isDone());
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(exampleTaskB1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(exampleTaskC0.checkNumberOfCalls(1, 1, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(exampleTaskB1.checkNumberOfCalls(0, 0, 0));
        Assert.assertTrue(exampleTaskC0.checkNumberOfCalls(1, 2, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB1.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(exampleTaskC0.checkNumberOfCalls(1, 3, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB1.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(exampleTaskC0.checkNumberOfCalls(1, 4, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskC0.checkNumberOfCalls(1, 5, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskC0.checkNumberOfCalls(1, 5, 1));
        CountActionsTask exampleTaskA2 = new CountActionsTask(2);
        parallelTask.submit((Object)taskKeyA, (State)exampleTaskA2);
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskA2.checkNumberOfCalls(1, 1, 0));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskC0.checkNumberOfCalls(1, 5, 1));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskA2.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskC0.checkNumberOfCalls(1, 5, 1));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskA2.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskC0.checkNumberOfCalls(1, 5, 1));
        taskExecutor.doControl();
        Assert.assertTrue(taskExecutor.isDone());
        Assert.assertFalse(parallelTask == taskExecutor.getCurrentTask());
        Assert.assertTrue(taskExecutor.getCurrentTask() instanceof NullState);
        Assert.assertTrue(exampleTaskA0.checkNumberOfCalls(1, 1, 1));
        Assert.assertTrue(exampleTaskA1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskA2.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskB1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTaskC0.checkNumberOfCalls(1, 5, 1));
    }

    private class ParallelTaskKey {
        private ParallelTaskKey() {
        }
    }
}

