/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.statistics;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.statistics.Point2DStandardDeviationCalculator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class Point2DStandardDeviationCalculatorTest {
    private static final double epsilon = 1.0E-8;

    @Test
    public void testNoVariance() {
        YoRegistry testRegistry = new YoRegistry(this.getClass().getSimpleName());
        YoFramePoint2D valueProvider = new YoFramePoint2D("valueProvider", ReferenceFrame.getWorldFrame(), testRegistry);
        Point2DStandardDeviationCalculator calculator = new Point2DStandardDeviationCalculator("value", (Point2DReadOnly)valueProvider, testRegistry);
        int numberOfValues = 100;
        Point2D value = new Point2D(17.3, 5.6);
        valueProvider.set((Tuple2DReadOnly)value);
        for (int i = 0; i < numberOfValues; ++i) {
            calculator.update();
        }
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)value, (Point2DReadOnly)calculator.getMean(), (double)1.0E-8);
        Assert.assertEquals(0.0, calculator.getStandardDeviation(), 1.0E-8);
        Assert.assertEquals(0.0, calculator.getVariance(), 1.0E-8);
    }

    @Test
    public void testFromList() {
        YoRegistry testRegistry = new YoRegistry(this.getClass().getSimpleName());
        YoFramePoint2D valueProvider = new YoFramePoint2D("valueProvider", ReferenceFrame.getWorldFrame(), testRegistry);
        Point2DStandardDeviationCalculator calculator = new Point2DStandardDeviationCalculator("value", (Point2DReadOnly)valueProvider, testRegistry);
        int numberOfValues = 100;
        Random random = new Random(1738L);
        ArrayList<Point2D> valueList = new ArrayList<Point2D>();
        double bias = 10.0;
        double seed = 5.0;
        for (int i = 0; i < numberOfValues; ++i) {
            Point2D value = new Point2D(bias, bias);
            value.add(RandomNumbers.nextDouble((Random)random, (double)seed), RandomNumbers.nextDouble((Random)random, (double)seed));
            valueList.add(value);
            valueProvider.set((Tuple2DReadOnly)value);
            calculator.update();
        }
        Point2D summedValues = new Point2D();
        for (int i = 0; i < numberOfValues; ++i) {
            summedValues.add((Tuple2DReadOnly)valueList.get(i));
        }
        Point2D mean = new Point2D((Tuple2DReadOnly)summedValues);
        mean.scale(1.0 / (double)numberOfValues);
        double sumOfSquares = 0.0;
        for (int i = 0; i < numberOfValues; ++i) {
            sumOfSquares += ((Point2D)valueList.get(i)).distanceSquared((Point2DReadOnly)mean);
        }
        double variance = sumOfSquares / (double)numberOfValues;
        double populationVariance = sumOfSquares / (double)(numberOfValues - 1);
        double standardDeviation = Math.sqrt(variance);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)mean, (Point2DReadOnly)calculator.getMean(), (double)1.0E-8);
        Assert.assertEquals(variance, calculator.getVariance(), 1.0E-8);
        Assert.assertEquals(standardDeviation, calculator.getStandardDeviation(), 1.0E-8);
    }
}

