/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.statistics;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.statistics.PermutationRecursive;

public class PermutationTest {
    @Test
    public void testNumberOfPossiblePermutations() {
        ArrayList<String> set1 = new ArrayList<String>();
        set1.add("a");
        set1.add("b");
        ArrayList<String> set2 = new ArrayList<String>();
        set2.add("c");
        set2.add("d");
        ArrayList<String> set3 = new ArrayList<String>();
        set3.add("e");
        set3.add("f");
        ArrayList<String> set4 = new ArrayList<String>();
        set4.add("g");
        set4.add("h");
        set4.add("i");
        ArrayList<ArrayList<String>> toBePermutated = new ArrayList<ArrayList<String>>();
        toBePermutated.add(set1);
        toBePermutated.add(set2);
        PermutationRecursive testPermutation = new PermutationRecursive();
        Assert.assertEquals(4L, testPermutation.numberOfPossiblePermutations(toBePermutated));
        toBePermutated.add(set3);
        Assert.assertEquals(8L, testPermutation.numberOfPossiblePermutations(toBePermutated));
        toBePermutated.add(set4);
        Assert.assertEquals(24L, testPermutation.numberOfPossiblePermutations(toBePermutated));
    }

    @Test
    public void testCreateResultContainer() {
        ArrayList<String> set1 = new ArrayList<String>();
        set1.add("a");
        set1.add("b");
        ArrayList<String> set2 = new ArrayList<String>();
        set2.add("c");
        set2.add("d");
        ArrayList<String> set3 = new ArrayList<String>();
        set3.add("e");
        set3.add("f");
        ArrayList<ArrayList<String>> toBePermutated = new ArrayList<ArrayList<String>>();
        toBePermutated.add(set1);
        toBePermutated.add(set2);
        toBePermutated.add(set3);
        PermutationRecursive testPermutation = new PermutationRecursive();
        int permutatedSize = testPermutation.numberOfPossiblePermutations(toBePermutated);
        ArrayList result = testPermutation.createResultContainer(8);
        Assert.assertEquals(8L, result.size());
    }

    @Test
    public void testPermutate() {
        int i;
        ArrayList<String> set1 = new ArrayList<String>();
        set1.add("a");
        set1.add("b");
        ArrayList<String> set2 = new ArrayList<String>();
        set2.add("c");
        set2.add("d");
        ArrayList<String> set3 = new ArrayList<String>();
        set3.add("e");
        set3.add("f");
        ArrayList<ArrayList<String>> toBePermutated = new ArrayList<ArrayList<String>>();
        toBePermutated.clear();
        toBePermutated.add(set1);
        toBePermutated.add(set2);
        toBePermutated.add(set3);
        ArrayList result = new ArrayList();
        PermutationRecursive testPermutation = new PermutationRecursive();
        int permutatedSize = testPermutation.numberOfPossiblePermutations(toBePermutated);
        result = testPermutation.createResultContainer(permutatedSize);
        int[] position = new int[]{0, 0};
        int[] rowIndicator = new int[toBePermutated.size()];
        for (i = 0; i < toBePermutated.size(); ++i) {
            rowIndicator[i] = 0;
        }
        result = testPermutation.permutate(position, rowIndicator, 0, toBePermutated, result);
        Assert.assertEquals("a", ((ArrayList)result.get(0)).get(0));
        Assert.assertEquals("c", ((ArrayList)result.get(1)).get(1));
        Assert.assertEquals("e", ((ArrayList)result.get(2)).get(2));
        Assert.assertEquals("b", ((ArrayList)result.get(5)).get(0));
        Assert.assertEquals("d", ((ArrayList)result.get(6)).get(1));
        Assert.assertEquals("f", ((ArrayList)result.get(7)).get(2));
        set1.clear();
        set2.clear();
        set3.clear();
        toBePermutated.clear();
        result.clear();
        set1.add("a");
        set1.add("b");
        set1.add("c");
        set2.add("d");
        set2.add("e");
        set2.add("f");
        set3.add("g");
        set3.add("h");
        set3.add("i");
        toBePermutated.add(set1);
        toBePermutated.add(set2);
        toBePermutated.add(set3);
        permutatedSize = testPermutation.numberOfPossiblePermutations(toBePermutated);
        result = testPermutation.createResultContainer(permutatedSize);
        position[0] = 0;
        position[1] = 0;
        for (i = 0; i < toBePermutated.size(); ++i) {
            rowIndicator[i] = 0;
        }
        result = testPermutation.permutate(position, rowIndicator, 0, toBePermutated, result);
        Assert.assertEquals("a", ((ArrayList)result.get(0)).get(0));
        Assert.assertEquals("d", ((ArrayList)result.get(1)).get(1));
        Assert.assertEquals("i", ((ArrayList)result.get(2)).get(2));
        Assert.assertEquals("a", ((ArrayList)result.get(5)).get(0));
        Assert.assertEquals("f", ((ArrayList)result.get(6)).get(1));
        Assert.assertEquals("h", ((ArrayList)result.get(7)).get(2));
    }

    @Test
    public void testDifferentElementTypes() {
        ArrayList<Object> set1 = new ArrayList<Object>();
        set1.add(1);
        set1.add("a");
        ArrayList<Object> set2 = new ArrayList<Object>();
        set2.add(2);
        set2.add("b");
        ArrayList<ArrayList<Object>> toBePermutated = new ArrayList<ArrayList<Object>>();
        toBePermutated.clear();
        toBePermutated.add(set1);
        toBePermutated.add(set2);
        ArrayList result = new ArrayList();
        PermutationRecursive testPermutation = new PermutationRecursive();
        int permutatedSize = testPermutation.numberOfPossiblePermutations(toBePermutated);
        result = testPermutation.createResultContainer(permutatedSize);
        int[] position = new int[]{0, 0};
        int[] rowIndicator = new int[toBePermutated.size()];
        for (int i = 0; i < toBePermutated.size(); ++i) {
            rowIndicator[i] = 0;
        }
        result = testPermutation.permutate(position, rowIndicator, 0, toBePermutated, result);
        Assert.assertEquals((Object)1, ((ArrayList)result.get(0)).get(0));
        Assert.assertEquals("b", ((ArrayList)result.get(1)).get(1));
        Assert.assertEquals((Object)2, ((ArrayList)result.get(2)).get(1));
    }
}

