/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.statistics;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.statistics.Line2DStatisticsCalculator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLine2D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class Line2DStandardDeviationCalculatorTest {
    private static final double epsilon = 1.0E-6;

    @Test
    public void testNoVariance() {
        YoRegistry testRegistry = new YoRegistry(this.getClass().getSimpleName());
        YoFrameLine2D valueProvider = new YoFrameLine2D("valueProvider", ReferenceFrame.getWorldFrame(), testRegistry);
        Line2DStatisticsCalculator calculator = new Line2DStatisticsCalculator("value", (Line2DReadOnly)valueProvider, testRegistry);
        int numberOfValues = 100;
        Vector2D direction = new Vector2D(17.3, 5.6);
        Point2D position = new Point2D(17.3, 5.6);
        direction.normalize();
        valueProvider.getDirection().set((Tuple2DReadOnly)direction);
        valueProvider.getPoint().set((Tuple2DReadOnly)position);
        for (int i = 0; i < numberOfValues; ++i) {
            calculator.update();
        }
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)valueProvider, (EuclidGeometry)calculator.getLineMean(), (double)1.0E-6);
        Assert.assertEquals(0.0, calculator.getDirectionStandardDeviation(), 1.0E-6);
        Assert.assertEquals(0.0, calculator.getPositionStandardDeviation(), 1.0E-6);
        Assert.assertEquals(0.0, calculator.getDirectionVariance(), 1.0E-6);
        Assert.assertEquals(0.0, calculator.getPositionVariance(), 1.0E-6);
    }

    @Test
    public void testNoVarianceWithOppositeDirections() {
        YoRegistry testRegistry = new YoRegistry(this.getClass().getSimpleName());
        YoFrameLine2D valueProvider = new YoFrameLine2D("valueProvider", ReferenceFrame.getWorldFrame(), testRegistry);
        Line2DStatisticsCalculator calculator = new Line2DStatisticsCalculator("value", (Line2DReadOnly)valueProvider, testRegistry);
        int numberOfValues = 100;
        Vector2D direction = new Vector2D(17.3, 5.6);
        Point2D position = new Point2D(17.3, 5.6);
        direction.normalize();
        valueProvider.getDirection().set((Tuple2DReadOnly)direction);
        valueProvider.getPoint().set((Tuple2DReadOnly)position);
        for (int i = 0; i < numberOfValues; ++i) {
            direction.negate();
            valueProvider.getDirection().set((Tuple2DReadOnly)direction);
            calculator.update();
        }
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)valueProvider, (EuclidGeometry)calculator.getLineMean(), (double)1.0E-6);
        Assert.assertEquals(0.0, calculator.getDirectionStandardDeviation(), 1.0E-6);
        Assert.assertEquals(0.0, calculator.getPositionStandardDeviation(), 1.0E-6);
        Assert.assertEquals(0.0, calculator.getDirectionVariance(), 1.0E-6);
        Assert.assertEquals(0.0, calculator.getPositionVariance(), 1.0E-6);
    }

    @Test
    public void testNoVarianceAlongLine() {
        YoRegistry testRegistry = new YoRegistry(this.getClass().getSimpleName());
        YoFrameLine2D valueProvider = new YoFrameLine2D("valueProvider", ReferenceFrame.getWorldFrame(), testRegistry);
        Line2DStatisticsCalculator calculator = new Line2DStatisticsCalculator("value", (Line2DReadOnly)valueProvider, testRegistry);
        int numberOfValues = 100;
        Vector2D direction = new Vector2D(17.3, 5.6);
        Point2D position = new Point2D(17.3, 5.6);
        direction.normalize();
        valueProvider.getDirection().set((Tuple2DReadOnly)direction);
        valueProvider.getPoint().set((Tuple2DReadOnly)position);
        Line2D originalValue = new Line2D((Line2DReadOnly)valueProvider);
        Random random = new Random(1738L);
        for (int i = 0; i < numberOfValues; ++i) {
            Point2D modifiedPosition = new Point2D((Tuple2DReadOnly)position);
            Vector2D positionModification = new Vector2D((Tuple2DReadOnly)direction);
            positionModification.scale(RandomNumbers.nextDouble((Random)random, (double)10.0));
            modifiedPosition.add((Tuple2DReadOnly)positionModification);
            valueProvider.getPoint().set((Tuple2DReadOnly)modifiedPosition);
            calculator.update();
        }
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)originalValue, (EuclidGeometry)calculator.getLineMean(), (double)1.0E-6);
        Assert.assertEquals(0.0, calculator.getPositionVariance(), 1.0E-6);
        Assert.assertEquals(0.0, calculator.getDirectionVariance(), 1.0E-6);
        Assert.assertEquals(0.0, calculator.getDirectionStandardDeviation(), 1.0E-6);
        Assert.assertEquals(0.0, calculator.getPositionStandardDeviation(), 1.0E-6);
    }
}

