/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.State;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateMachine;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateTransition;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateTransitionAction;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateTransitionCondition;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class StateMachineExampleTwoTest {
    @Test
    public void testComplexStateMachineExample() {
        YoRegistry registry = new YoRegistry("registry");
        YoInteger ticksInStateOne = new YoInteger("ticksInStateOne", registry);
        YoInteger ticksInStateTwo = new YoInteger("ticksInStateTwo", registry);
        YoInteger ticksInStateThree = new YoInteger("ticksInStateThree", registry);
        YoInteger ticksInStateFour = new YoInteger("ticksInStateFour", registry);
        YoBoolean inStateOne = new YoBoolean("inStateOne", registry);
        YoBoolean inStateTwo = new YoBoolean("inStateTwo", registry);
        YoBoolean inStateThree = new YoBoolean("inStateThree", registry);
        YoBoolean inStateFour = new YoBoolean("inStateFour", registry);
        YoBoolean didTransitionIntoStateOne = new YoBoolean("didTransitionIntoStateOne", registry);
        YoBoolean didTransitionIntoStateTwo = new YoBoolean("didTransitionIntoStateTwo", registry);
        YoBoolean didTransitionIntoStateThree = new YoBoolean("didTransitionIntoStateThree", registry);
        YoBoolean didTransitionIntoStateFour = new YoBoolean("didTransitionIntoStateFour", registry);
        YoBoolean didTransitionOutOfStateOne = new YoBoolean("didTransitionOutOfStateOne", registry);
        YoBoolean didTransitionOutOfStateTwo = new YoBoolean("didTransitionOutOfStateTwo", registry);
        YoBoolean didTransitionOutOfStateThree = new YoBoolean("didTransitionOutOfStateThree", registry);
        YoBoolean didTransitionOutOfStateFour = new YoBoolean("didTransitionOutOfStateFour", registry);
        YoBoolean transitionFromOneToFour = new YoBoolean("transitionFromOneToFour", registry);
        YoBoolean transitionFromThreeToFour = new YoBoolean("transitionFromThreeToFour", registry);
        YoBoolean transitionFromThreeToOne = new YoBoolean("transitionFromThreeToOne", registry);
        YoBoolean threeToOneTransitionAction = new YoBoolean("threeToOneTransitionAction", registry);
        YoDouble timeProvider = new YoDouble("time", registry);
        timeProvider.set(13.3);
        StateMachine stateMachine = new StateMachine("complexStateMachine", "switchTime", StateEnum.class, (Enum)StateEnum.FOUR, timeProvider, registry);
        ExampleState stateOne = new ExampleState(StateEnum.ONE, inStateOne, didTransitionIntoStateOne, didTransitionOutOfStateOne, ticksInStateOne);
        ExampleState stateTwo = new ExampleState(StateEnum.TWO, inStateTwo, didTransitionIntoStateTwo, didTransitionOutOfStateTwo, ticksInStateTwo);
        ExampleState stateThree = new ExampleState(StateEnum.THREE, inStateThree, didTransitionIntoStateThree, didTransitionOutOfStateThree, ticksInStateThree);
        ExampleState stateFour = new ExampleState(StateEnum.FOUR, inStateFour, didTransitionIntoStateFour, didTransitionOutOfStateFour, ticksInStateFour);
        stateOne.setDefaultNextState(StateEnum.TWO);
        stateOne.addStateTransition(StateEnum.FOUR, new ExampleStateTransitionCondition(transitionFromOneToFour));
        stateTwo.addDelayBasedStateTransition(StateEnum.THREE, 1.0);
        ExampleStateTransitionCondition threeToFourCondition = new ExampleStateTransitionCondition(transitionFromThreeToFour);
        stateThree.addStateTransition(StateEnum.FOUR, threeToFourCondition);
        ExampleStateTransitionCondition stateTransitionCondition = new ExampleStateTransitionCondition(transitionFromThreeToOne);
        ExampleStateTransitionAction stateTransitionAction = new ExampleStateTransitionAction(threeToOneTransitionAction);
        StateTransition stateTransition = new StateTransition((Enum)StateEnum.ONE, (StateTransitionCondition)stateTransitionCondition, (StateTransitionAction)stateTransitionAction);
        stateThree.addStateTransition(stateTransition);
        stateThree.addImmediateStateTransition(StateEnum.THREE);
        ArrayList stateTransitions = stateThree.getStateTransitions();
        Assert.assertEquals(3L, stateTransitions.size());
        Assert.assertEquals((Object)StateEnum.FOUR, ((StateTransition)stateTransitions.get(0)).getNextStateEnum());
        Assert.assertEquals((Object)StateEnum.ONE, ((StateTransition)stateTransitions.get(1)).getNextStateEnum());
        Assert.assertEquals((Object)StateEnum.THREE, ((StateTransition)stateTransitions.get(2)).getNextStateEnum());
        stateFour.addImmediateStateTransition(StateEnum.THREE);
        stateMachine.addState((State)stateOne);
        stateMachine.addState((State)stateTwo);
        stateMachine.addState((State)stateThree);
        stateMachine.addState((State)stateFour);
        Assert.assertEquals((Object)stateFour, stateMachine.getCurrentState());
        Assert.assertEquals((Object)StateEnum.FOUR, stateMachine.getCurrentStateEnum());
        Assert.assertEquals(null, stateMachine.getPreviousStateEnum());
        Assert.assertEquals(null, stateMachine.getPreviousState());
        Assert.assertNull(stateOne.getPreviousState());
        Assert.assertFalse(inStateOne.getBooleanValue());
        Assert.assertFalse(didTransitionIntoStateOne.getBooleanValue());
        Assert.assertFalse(didTransitionOutOfStateOne.getBooleanValue());
        Assert.assertEquals(0L, ticksInStateOne.getIntegerValue());
        Assert.assertNull(stateFour.getPreviousState());
        Assert.assertFalse(inStateFour.getBooleanValue());
        Assert.assertFalse(didTransitionIntoStateFour.getBooleanValue());
        Assert.assertFalse(didTransitionOutOfStateFour.getBooleanValue());
        Assert.assertEquals(0L, ticksInStateFour.getIntegerValue());
        stateMachine.setCurrentState((Enum)StateEnum.ONE);
        Assert.assertTrue(inStateOne.getBooleanValue());
        Assert.assertEquals((Object)stateOne, stateMachine.getCurrentState());
        Assert.assertEquals((Object)StateEnum.ONE, stateMachine.getCurrentStateEnum());
        Assert.assertTrue(didTransitionIntoStateOne.getBooleanValue());
        Assert.assertFalse(didTransitionOutOfStateOne.getBooleanValue());
        Assert.assertEquals(0L, ticksInStateOne.getIntegerValue());
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertTrue(inStateOne.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateOne.getBooleanValue());
        Assert.assertFalse(didTransitionOutOfStateOne.getBooleanValue());
        Assert.assertEquals(1L, ticksInStateOne.getIntegerValue());
        stateOne.transitionToDefaultNextState();
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertFalse(inStateOne.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateOne.getBooleanValue());
        Assert.assertTrue(didTransitionOutOfStateOne.getBooleanValue());
        Assert.assertEquals(2L, ticksInStateOne.getIntegerValue());
        Assert.assertEquals((Object)StateEnum.ONE, stateMachine.getPreviousStateEnum());
        Assert.assertEquals((Object)stateOne, stateMachine.getPreviousState());
        Assert.assertEquals((Object)stateOne, stateTwo.getPreviousState());
        Assert.assertTrue(inStateTwo.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateTwo.getBooleanValue());
        Assert.assertFalse(didTransitionOutOfStateTwo.getBooleanValue());
        Assert.assertEquals(0L, ticksInStateTwo.getIntegerValue());
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertTrue(inStateTwo.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateTwo.getBooleanValue());
        Assert.assertFalse(didTransitionOutOfStateTwo.getBooleanValue());
        Assert.assertEquals(1L, ticksInStateTwo.getIntegerValue());
        Assert.assertFalse(didTransitionIntoStateThree.getBooleanValue());
        timeProvider.add(1.01);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertFalse(inStateTwo.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateTwo.getBooleanValue());
        Assert.assertTrue(didTransitionOutOfStateTwo.getBooleanValue());
        Assert.assertEquals(2L, ticksInStateTwo.getIntegerValue());
        Assert.assertEquals((Object)StateEnum.TWO, stateMachine.getPreviousStateEnum());
        Assert.assertEquals((Object)stateTwo, stateMachine.getPreviousState());
        Assert.assertEquals((Object)stateTwo, stateThree.getPreviousState());
        Assert.assertTrue(inStateThree.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateThree.getBooleanValue());
        Assert.assertFalse(didTransitionOutOfStateThree.getBooleanValue());
        Assert.assertEquals(0L, ticksInStateThree.getIntegerValue());
        didTransitionIntoStateThree.set(false);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertTrue(inStateThree.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateThree.getBooleanValue());
        Assert.assertTrue(didTransitionOutOfStateThree.getBooleanValue());
        Assert.assertEquals(1L, ticksInStateThree.getIntegerValue());
        didTransitionOutOfStateThree.set(false);
        didTransitionIntoStateThree.set(false);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertTrue(inStateThree.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateThree.getBooleanValue());
        Assert.assertTrue(didTransitionOutOfStateThree.getBooleanValue());
        Assert.assertEquals(2L, ticksInStateThree.getIntegerValue());
        transitionFromThreeToFour.set(true);
        didTransitionIntoStateThree.set(false);
        didTransitionOutOfStateThree.set(false);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertFalse(inStateThree.getBooleanValue());
        Assert.assertFalse(didTransitionIntoStateThree.getBooleanValue());
        Assert.assertTrue(didTransitionOutOfStateThree.getBooleanValue());
        Assert.assertEquals(3L, ticksInStateThree.getIntegerValue());
        Assert.assertEquals((Object)StateEnum.THREE, stateMachine.getPreviousStateEnum());
        Assert.assertEquals((Object)stateThree, stateMachine.getPreviousState());
        Assert.assertEquals((Object)stateThree, stateFour.getPreviousState());
        Assert.assertTrue(inStateFour.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateFour.getBooleanValue());
        Assert.assertFalse(didTransitionOutOfStateFour.getBooleanValue());
        Assert.assertEquals(0L, ticksInStateFour.getIntegerValue());
        didTransitionIntoStateThree.set(false);
        didTransitionOutOfStateThree.set(false);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertFalse(inStateFour.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateFour.getBooleanValue());
        Assert.assertTrue(didTransitionOutOfStateFour.getBooleanValue());
        Assert.assertEquals(1L, ticksInStateFour.getIntegerValue());
        Assert.assertEquals((Object)StateEnum.FOUR, stateMachine.getPreviousStateEnum());
        Assert.assertEquals((Object)stateFour, stateMachine.getPreviousState());
        Assert.assertEquals((Object)stateFour, stateThree.getPreviousState());
        Assert.assertTrue(inStateThree.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateThree.getBooleanValue());
        Assert.assertFalse(didTransitionOutOfStateThree.getBooleanValue());
        Assert.assertEquals(3L, ticksInStateThree.getIntegerValue());
        transitionFromThreeToOne.set(true);
        transitionFromThreeToFour.set(false);
        didTransitionIntoStateOne.set(false);
        didTransitionOutOfStateOne.set(false);
        Assert.assertFalse(threeToOneTransitionAction.getBooleanValue());
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertTrue(threeToOneTransitionAction.getBooleanValue());
        Assert.assertTrue(inStateOne.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateOne.getBooleanValue());
        Assert.assertFalse(didTransitionOutOfStateOne.getBooleanValue());
        Assert.assertEquals(2L, ticksInStateOne.getIntegerValue());
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertEquals((Object)StateEnum.THREE, stateMachine.getPreviousStateEnum());
        Assert.assertEquals((Object)stateThree, stateMachine.getPreviousState());
        Assert.assertEquals((Object)stateThree, stateOne.getPreviousState());
        Assert.assertTrue(inStateOne.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateOne.getBooleanValue());
        Assert.assertFalse(didTransitionOutOfStateOne.getBooleanValue());
        Assert.assertEquals(3L, ticksInStateOne.getIntegerValue());
        transitionFromOneToFour.set(true);
        didTransitionIntoStateFour.set(false);
        didTransitionOutOfStateFour.set(false);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertFalse(inStateOne.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateOne.getBooleanValue());
        Assert.assertTrue(didTransitionOutOfStateOne.getBooleanValue());
        Assert.assertEquals(4L, ticksInStateOne.getIntegerValue());
        Assert.assertEquals((Object)stateOne, stateFour.getPreviousState());
        Assert.assertEquals((Object)stateFour, stateMachine.getCurrentState());
        Assert.assertTrue(inStateFour.getBooleanValue());
        Assert.assertTrue(didTransitionIntoStateFour.getBooleanValue());
        Assert.assertFalse(didTransitionOutOfStateFour.getBooleanValue());
        Assert.assertEquals(1L, ticksInStateFour.getIntegerValue());
        Assert.assertEquals("ONE: (FOUR)", stateOne.toString());
        Assert.assertEquals("TWO: (THREE)", stateTwo.toString());
        Assert.assertEquals("THREE: (FOUR, ONE, THREE)", stateThree.toString());
        Assert.assertEquals("FOUR: (THREE)", stateFour.toString());
        Assert.assertEquals("State Machine:\nONE: (FOUR)\nTWO: (THREE)\nTHREE: (FOUR, ONE, THREE)\nFOUR: (THREE)\n", stateMachine.toString());
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForPackage(StateMachineExampleTwoTest.class);
    }

    private static enum StateEnum {
        TWO,
        FOUR,
        ONE,
        THREE;

    }

    private class ExampleState
    extends State<StateEnum> {
        private final YoBoolean inState;
        private final YoBoolean didTransitionIntoState;
        private final YoBoolean didTransitionOutOfState;
        private final YoInteger ticksInState;

        public ExampleState(StateEnum stateEnum, YoBoolean inState, YoBoolean didTransitionIntoState, YoBoolean didTransitionOutOfState, YoInteger ticksInState) {
            super((Enum)stateEnum);
            this.inState = inState;
            this.didTransitionIntoState = didTransitionIntoState;
            this.didTransitionOutOfState = didTransitionOutOfState;
            this.ticksInState = ticksInState;
        }

        public void doAction() {
            this.ticksInState.increment();
        }

        public void doTransitionIntoAction() {
            this.didTransitionIntoState.set(true);
            this.inState.set(true);
        }

        public void doTransitionOutOfAction() {
            this.didTransitionOutOfState.set(true);
            this.inState.set(false);
        }
    }

    private class ExampleStateTransitionCondition
    implements StateTransitionCondition {
        private final YoBoolean transitionVariable;

        public ExampleStateTransitionCondition(YoBoolean transitionVariable) {
            this.transitionVariable = transitionVariable;
        }

        public boolean checkCondition() {
            return this.transitionVariable.getBooleanValue();
        }
    }

    private class ExampleStateTransitionAction
    implements StateTransitionAction {
        private final YoBoolean transitionVariable;

        public ExampleStateTransitionAction(YoBoolean transitionVariable) {
            this.transitionVariable = transitionVariable;
        }

        public void doTransitionAction() {
            this.transitionVariable.set(true);
        }
    }
}

