/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.FinishableState;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.State;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateMachine;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class FinishableStateTest {
    @Test
    public void testExampleStateMachineWithFinishableStates() {
        YoRegistry registry = new YoRegistry("registry");
        YoDouble time = new YoDouble("time", registry);
        StateMachine stateMachine = new StateMachine("stateMachine", "switchTime", StateEnum.class, time, registry);
        ExampleFinishableState stateOne = new ExampleFinishableState(StateEnum.ONE);
        stateOne.addDoneWithStateTransition(StateEnum.TWO);
        stateMachine.addState((State)stateOne);
        ExampleFinishableState stateTwo = new ExampleFinishableState(StateEnum.TWO);
        stateTwo.addDoneWithStateTransition(StateEnum.THREE);
        stateMachine.addState((State)stateTwo);
        ExampleFinishableState stateThree = new ExampleFinishableState(StateEnum.THREE);
        stateThree.addDoneWithStateTransition(StateEnum.ONE);
        stateMachine.addState((State)stateThree);
        stateMachine.setCurrentState((Enum)StateEnum.ONE);
        Assert.assertTrue(stateOne.inState);
        Assert.assertFalse(stateOne.didAction);
        Assert.assertFalse(stateOne.didTransitionOutOfAction);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertEquals(stateMachine.getCurrentState(), (Object)stateOne);
        Assert.assertTrue(stateOne.didAction);
        Assert.assertFalse(stateOne.didTransitionOutOfAction);
        stateOne.setIsDone(true);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertTrue(stateOne.didTransitionOutOfAction);
        Assert.assertTrue(stateTwo.inState);
        Assert.assertFalse(stateTwo.didAction);
        Assert.assertFalse(stateTwo.didTransitionOutOfAction);
        Assert.assertEquals(stateMachine.getCurrentState(), (Object)stateTwo);
        stateTwo.setIsDone(true);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertTrue(stateTwo.didTransitionOutOfAction);
        Assert.assertTrue(stateThree.inState);
        Assert.assertFalse(stateThree.didAction);
        Assert.assertFalse(stateThree.didTransitionOutOfAction);
        Assert.assertEquals(stateMachine.getCurrentState(), (Object)stateThree);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertTrue(stateThree.inState);
        Assert.assertTrue(stateThree.didAction);
        Assert.assertFalse(stateThree.didTransitionOutOfAction);
        Assert.assertEquals(stateMachine.getCurrentState(), (Object)stateThree);
        stateThree.setIsDone(true);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertTrue(stateThree.didTransitionOutOfAction);
        Assert.assertEquals(stateMachine.getCurrentState(), (Object)stateOne);
    }

    private static enum StateEnum {
        ONE,
        TWO,
        THREE,
        FOUR;

    }

    private class ExampleFinishableState
    extends FinishableState<StateEnum> {
        private boolean isDone;
        public boolean inState;
        public boolean didAction;
        public boolean didTransitionOutOfAction;

        public ExampleFinishableState(StateEnum stateEnum) {
            super((Enum)stateEnum);
            this.isDone = false;
            this.inState = false;
            this.didAction = false;
            this.didTransitionOutOfAction = false;
        }

        public void setIsDone(boolean isDone) {
            this.isDone = isDone;
        }

        public boolean isDone() {
            return this.isDone;
        }

        public void doAction() {
            this.didAction = true;
        }

        public void doTransitionIntoAction() {
            this.inState = true;
        }

        public void doTransitionOutOfAction() {
            this.didTransitionOutOfAction = true;
            this.inState = false;
        }
    }
}

