/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.ArrayList;
import java.util.Random;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix3DTest;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;

public class WeightMatrix6DTest {
    private static final int ITERATIONS = 500;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testGettersSetters() {
        Random random = new Random(123423L);
        WeightMatrix6D weightMatrix6D = new WeightMatrix6D();
        Assert.assertNull(weightMatrix6D.getAngularWeightFrame());
        Assert.assertNull(weightMatrix6D.getLinearWeightFrame());
        WeightMatrix3D linearPart = weightMatrix6D.getLinearPart();
        Assert.assertTrue(Double.isNaN(linearPart.getXAxisWeight()));
        Assert.assertTrue(Double.isNaN(linearPart.getYAxisWeight()));
        Assert.assertTrue(Double.isNaN(linearPart.getZAxisWeight()));
        WeightMatrix3D angularPart = weightMatrix6D.getAngularPart();
        Assert.assertTrue(Double.isNaN(angularPart.getXAxisWeight()));
        Assert.assertTrue(Double.isNaN(angularPart.getYAxisWeight()));
        Assert.assertTrue(Double.isNaN(angularPart.getZAxisWeight()));
        for (int i = 0; i < 500; ++i) {
            double angularXWeight = random.nextDouble();
            double angularYWeight = random.nextDouble();
            double angularZWeight = random.nextDouble();
            double linearXWeight = random.nextDouble();
            double linearYWeight = random.nextDouble();
            double linearZWeight = random.nextDouble();
            weightMatrix6D.setAngularWeights(angularXWeight, angularYWeight, angularZWeight);
            weightMatrix6D.setLinearWeights(linearXWeight, linearYWeight, linearZWeight);
            Assert.assertEquals(angularXWeight, weightMatrix6D.getAngularPart().getXAxisWeight(), 1.0E-8);
            Assert.assertEquals(angularYWeight, weightMatrix6D.getAngularPart().getYAxisWeight(), 1.0E-8);
            Assert.assertEquals(angularZWeight, weightMatrix6D.getAngularPart().getZAxisWeight(), 1.0E-8);
            Assert.assertEquals(linearXWeight, weightMatrix6D.getLinearPart().getXAxisWeight(), 1.0E-8);
            Assert.assertEquals(linearYWeight, weightMatrix6D.getLinearPart().getYAxisWeight(), 1.0E-8);
            Assert.assertEquals(linearZWeight, weightMatrix6D.getLinearPart().getZAxisWeight(), 1.0E-8);
            angularXWeight = random.nextDouble();
            angularYWeight = random.nextDouble();
            angularZWeight = random.nextDouble();
            linearXWeight = random.nextDouble();
            linearYWeight = random.nextDouble();
            linearZWeight = random.nextDouble();
            Vector3D angularWeights = new Vector3D(angularXWeight, angularYWeight, angularZWeight);
            Vector3D linearWeights = new Vector3D(linearXWeight, linearYWeight, linearZWeight);
            weightMatrix6D.setAngularWeights((Tuple3DReadOnly)angularWeights);
            weightMatrix6D.setLinearWeights((Tuple3DReadOnly)linearWeights);
            Assert.assertEquals(angularXWeight, weightMatrix6D.getAngularPart().getXAxisWeight(), 1.0E-8);
            Assert.assertEquals(angularYWeight, weightMatrix6D.getAngularPart().getYAxisWeight(), 1.0E-8);
            Assert.assertEquals(angularZWeight, weightMatrix6D.getAngularPart().getZAxisWeight(), 1.0E-8);
            Assert.assertEquals(linearXWeight, weightMatrix6D.getLinearPart().getXAxisWeight(), 1.0E-8);
            Assert.assertEquals(linearYWeight, weightMatrix6D.getLinearPart().getYAxisWeight(), 1.0E-8);
            Assert.assertEquals(linearZWeight, weightMatrix6D.getLinearPart().getZAxisWeight(), 1.0E-8);
            weightMatrix6D.clearAngularWeights();
            angularPart = weightMatrix6D.getAngularPart();
            Assert.assertTrue(Double.isNaN(angularPart.getXAxisWeight()));
            Assert.assertTrue(Double.isNaN(angularPart.getYAxisWeight()));
            Assert.assertTrue(Double.isNaN(angularPart.getZAxisWeight()));
            Assert.assertEquals(linearXWeight, weightMatrix6D.getLinearPart().getXAxisWeight(), 1.0E-8);
            Assert.assertEquals(linearYWeight, weightMatrix6D.getLinearPart().getYAxisWeight(), 1.0E-8);
            Assert.assertEquals(linearZWeight, weightMatrix6D.getLinearPart().getZAxisWeight(), 1.0E-8);
            weightMatrix6D.setAngularWeights((Tuple3DReadOnly)angularWeights);
            weightMatrix6D.clearLinearWeights();
            Assert.assertEquals(angularXWeight, weightMatrix6D.getAngularPart().getXAxisWeight(), 1.0E-8);
            Assert.assertEquals(angularYWeight, weightMatrix6D.getAngularPart().getYAxisWeight(), 1.0E-8);
            Assert.assertEquals(angularZWeight, weightMatrix6D.getAngularPart().getZAxisWeight(), 1.0E-8);
            linearPart = weightMatrix6D.getLinearPart();
            Assert.assertTrue(Double.isNaN(linearPart.getXAxisWeight()));
            Assert.assertTrue(Double.isNaN(linearPart.getYAxisWeight()));
            Assert.assertTrue(Double.isNaN(linearPart.getZAxisWeight()));
            weightMatrix6D.clear();
            Assert.assertNull(weightMatrix6D.getLinearWeightFrame());
            Assert.assertNull(weightMatrix6D.getAngularWeightFrame());
            linearPart = weightMatrix6D.getLinearPart();
            Assert.assertTrue(Double.isNaN(linearPart.getXAxisWeight()));
            Assert.assertTrue(Double.isNaN(linearPart.getYAxisWeight()));
            Assert.assertTrue(Double.isNaN(linearPart.getZAxisWeight()));
            angularPart = weightMatrix6D.getAngularPart();
            Assert.assertTrue(Double.isNaN(angularPart.getXAxisWeight()));
            Assert.assertTrue(Double.isNaN(angularPart.getYAxisWeight()));
            Assert.assertTrue(Double.isNaN(angularPart.getZAxisWeight()));
            ReferenceFrame randomFrame = EuclidFrameRandomTools.nextReferenceFrame((String)("blop" + i), (Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame());
            weightMatrix6D.setWeightFrame(randomFrame);
            Assert.assertTrue(randomFrame == weightMatrix6D.getLinearWeightFrame());
            Assert.assertTrue(randomFrame == weightMatrix6D.getAngularWeightFrame());
            weightMatrix6D.clearWeightFrame();
            Assert.assertNull(weightMatrix6D.getLinearWeightFrame());
            Assert.assertNull(weightMatrix6D.getAngularWeightFrame());
            weightMatrix6D.setWeightFrame(randomFrame);
            weightMatrix6D.clear();
            Assert.assertNull(weightMatrix6D.getLinearWeightFrame());
            Assert.assertNull(weightMatrix6D.getAngularWeightFrame());
            weightMatrix6D.setWeightFrame(randomFrame);
            weightMatrix6D.clear();
            Assert.assertNull(weightMatrix6D.getLinearWeightFrame());
            Assert.assertNull(weightMatrix6D.getAngularWeightFrame());
            weightMatrix6D.setWeightFrames(randomFrame, ReferenceFrame.getWorldFrame());
            Assert.assertTrue(randomFrame == weightMatrix6D.getAngularWeightFrame());
            Assert.assertTrue(ReferenceFrame.getWorldFrame() == weightMatrix6D.getLinearWeightFrame());
            weightMatrix6D.clear();
            Assert.assertNull(weightMatrix6D.getLinearWeightFrame());
            Assert.assertNull(weightMatrix6D.getAngularWeightFrame());
            weightMatrix6D.setWeightFrames(ReferenceFrame.getWorldFrame(), randomFrame);
            Assert.assertTrue(randomFrame == weightMatrix6D.getLinearWeightFrame());
            Assert.assertTrue(ReferenceFrame.getWorldFrame() == weightMatrix6D.getAngularWeightFrame());
            weightMatrix6D.clear();
            Assert.assertNull(weightMatrix6D.getLinearWeightFrame());
            Assert.assertNull(weightMatrix6D.getAngularWeightFrame());
            weightMatrix6D.setWeightFrame(randomFrame);
            weightMatrix6D.clearAngularWeightFrame();
            Assert.assertTrue(randomFrame == weightMatrix6D.getLinearWeightFrame());
            Assert.assertNull(weightMatrix6D.getAngularWeightFrame());
            weightMatrix6D.setWeightFrame(randomFrame);
            weightMatrix6D.clearLinearWeightFrame();
            Assert.assertTrue(randomFrame == weightMatrix6D.getAngularWeightFrame());
            Assert.assertNull(weightMatrix6D.getLinearWeightFrame());
        }
    }

    @Test
    public void testGetFullSelectionMatrixInFrame() throws Exception {
        Random random = new Random(456465L);
        WeightMatrix6D weightMatrix6D = new WeightMatrix6D();
        WeightMatrix3D angularPart3D = new WeightMatrix3D();
        WeightMatrix3D linearPart3D = new WeightMatrix3D();
        RigidBodyTransform randomTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        ArrayList<ReferenceFrame> referenceFrames = new ArrayList<ReferenceFrame>();
        referenceFrames.add(null);
        referenceFrames.add(ReferenceFrame.getWorldFrame());
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        referenceFrames.add(EuclidFrameRandomTools.nextReferenceFrame((String)"blop2", (Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame()));
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1Bis", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        for (int i = 0; i < 500; ++i) {
            for (ReferenceFrame selectionFrame : referenceFrames) {
                for (ReferenceFrame destinationFrame : referenceFrames.subList(1, referenceFrames.size())) {
                    DMatrixRMaj actualSelectionMatrix = RandomMatrices_DDRM.rectangle((int)6, (int)6, (double)-1.0, (double)1.0, (Random)random);
                    DMatrixRMaj expectedSelectionMatrix = RandomMatrices_DDRM.rectangle((int)6, (int)6, (double)-1.0, (double)1.0, (Random)random);
                    double angularXWeight = random.nextDouble();
                    double angularYWeight = random.nextDouble();
                    double angularZWeight = random.nextDouble();
                    double linearXWeight = random.nextDouble();
                    double linearYWeight = random.nextDouble();
                    double linearZWeight = random.nextDouble();
                    weightMatrix6D.setAngularWeights(angularXWeight, angularYWeight, angularZWeight);
                    weightMatrix6D.setLinearWeights(linearXWeight, linearYWeight, linearZWeight);
                    weightMatrix6D.setWeightFrame(selectionFrame);
                    angularPart3D.setWeights(angularXWeight, angularYWeight, angularZWeight);
                    angularPart3D.setWeightFrame(selectionFrame);
                    linearPart3D.setWeights(linearXWeight, linearYWeight, linearZWeight);
                    linearPart3D.setWeightFrame(selectionFrame);
                    weightMatrix6D.getFullWeightMatrixInFrame(destinationFrame, actualSelectionMatrix);
                    expectedSelectionMatrix.zero();
                    angularPart3D.getFullWeightMatrixInFrame(destinationFrame, 0, 0, expectedSelectionMatrix);
                    linearPart3D.getFullWeightMatrixInFrame(destinationFrame, 3, 3, expectedSelectionMatrix);
                    WeightMatrix6DTest.assertMatrixEquals(expectedSelectionMatrix, actualSelectionMatrix, 1.0E-12);
                }
            }
        }
    }

    @Test
    public void testGetEfficientSelectionMatrixInFrame() throws Exception {
        Random random = new Random(456465L);
        WeightMatrix6D weightMatrix6D = new WeightMatrix6D();
        RigidBodyTransform randomTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        ArrayList<ReferenceFrame> referenceFrames = new ArrayList<ReferenceFrame>();
        referenceFrames.add(null);
        referenceFrames.add(ReferenceFrame.getWorldFrame());
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        referenceFrames.add(EuclidFrameRandomTools.nextReferenceFrame((String)"blop2", (Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame()));
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1Bis", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        for (int i = 0; i < 500; ++i) {
            for (ReferenceFrame selectionFrame : referenceFrames) {
                for (ReferenceFrame destinationFrame : referenceFrames.subList(1, referenceFrames.size())) {
                    DMatrixRMaj actualSelectionMatrix = RandomMatrices_DDRM.rectangle((int)6, (int)6, (double)-1.0, (double)1.0, (Random)random);
                    DMatrixRMaj expectedSelectionMatrix = RandomMatrices_DDRM.rectangle((int)6, (int)6, (double)-1.0, (double)1.0, (Random)random);
                    double angularXWeight = random.nextDouble();
                    double angularYWeight = random.nextDouble();
                    double angularZWeight = random.nextDouble();
                    double linearXWeight = random.nextDouble();
                    double linearYWeight = random.nextDouble();
                    double linearZWeight = random.nextDouble();
                    weightMatrix6D.setAngularWeights(angularXWeight, angularYWeight, angularZWeight);
                    weightMatrix6D.setLinearWeights(linearXWeight, linearYWeight, linearZWeight);
                    weightMatrix6D.setWeightFrame(selectionFrame);
                    weightMatrix6D.getFullWeightMatrixInFrame(destinationFrame, expectedSelectionMatrix);
                    MatrixTools.removeZeroRows((DMatrix1Row)expectedSelectionMatrix, (double)1.0E-7);
                    weightMatrix6D.getCompactWeightMatrixInFrame(destinationFrame, actualSelectionMatrix);
                    WeightMatrix6DTest.assertMatrixEquals(expectedSelectionMatrix, actualSelectionMatrix, 1.0E-12);
                }
            }
        }
    }

    private static void assertMatrixEquals(DMatrixRMaj expected, DMatrixRMaj actual, double epsilon) {
        Assert.assertTrue(WeightMatrix6DTest.assertErrorMessage(expected, actual), MatrixFeatures_DDRM.isEquals((DMatrixD1)expected, (DMatrixD1)actual, (double)epsilon));
    }

    private static String assertErrorMessage(DMatrixRMaj expected, DMatrixRMaj actual) {
        return "Expected:\n" + String.valueOf(expected) + "\nActual:\n" + String.valueOf(actual);
    }

    public static void main(String[] args) {
        MutationTestFacilitator mutationTestFacilitator = new MutationTestFacilitator();
        mutationTestFacilitator.addClassesToMutate(new Class[]{SelectionMatrix3D.class, WeightMatrix6D.class});
        mutationTestFacilitator.addTestClassesToRun(new Class[]{SelectionMatrix3DTest.class, WeightMatrix6DTest.class});
        mutationTestFacilitator.doMutationTest();
        mutationTestFacilitator.openResultInBrowser();
    }
}

