/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.PlanarJoint;
import us.ihmc.mecano.multiBodySystem.PrismaticJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.screwTheory.ScrewTools;

public class ScrewToolsTest {
    private static final Vector3D X = new Vector3D(1.0, 0.0, 0.0);
    private static final Vector3D Y = new Vector3D(0.0, 1.0, 0.0);
    private static final Vector3D Z = new Vector3D(0.0, 0.0, 1.0);
    private RigidBodyBasics elevator;
    private Random random;
    private List<RigidBodyBasics> firstLevelSubTrees;
    private List<RigidBodyBasics> secondLevelSubTrees;
    private Set<RigidBodyBasics> exclusions;
    private Set<JointBasics> exclusionsJoints;
    private ArrayList<RevoluteJoint> joints;
    protected static final double epsilon = 1.0E-10;
    protected ReferenceFrame theFrame = ReferenceFrameTools.constructARootFrame((String)"theFrame");
    protected ReferenceFrame aFrame = ReferenceFrameTools.constructARootFrame((String)"aFrame");

    @BeforeEach
    public void setUp() {
        this.elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
        this.random = new Random(1986L);
        this.setUpRandomTree(this.elevator);
        this.firstLevelSubTrees = new ArrayList<RigidBodyBasics>();
        for (Object childJoint : this.elevator.getChildrenJoints()) {
            this.firstLevelSubTrees.add(childJoint.getSuccessor());
        }
        this.secondLevelSubTrees = new ArrayList<RigidBodyBasics>();
        for (int i = 0; i < 3; ++i) {
            for (JointBasics childJoint : this.firstLevelSubTrees.get(i).getChildrenJoints()) {
                this.secondLevelSubTrees.add(childJoint.getSuccessor());
            }
        }
        this.exclusions = new LinkedHashSet<RigidBodyBasics>();
        this.exclusionsJoints = new LinkedHashSet<JointBasics>();
        this.exclusions.add(this.firstLevelSubTrees.get(1));
        for (JointBasics excludedJoint : this.firstLevelSubTrees.get(1).getChildrenJoints()) {
            this.exclusionsJoints.add(excludedJoint);
        }
        JointBasics[] subtreeJoints = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{this.firstLevelSubTrees.get(2)});
        RigidBodyBasics[] lastSubTree = MultiBodySystemTools.collectSuccessors((JointBasics[])subtreeJoints);
        RigidBodyBasics halfwayDownLastSubTree = lastSubTree[3];
        this.exclusions.add(halfwayDownLastSubTree);
        for (JointBasics excludedJoint : halfwayDownLastSubTree.getChildrenJoints()) {
            this.exclusionsJoints.add(excludedJoint);
        }
    }

    private void setUpRandomTree(RigidBodyBasics elevator) {
        this.joints = new ArrayList();
        Vector3D[] jointAxes1 = new Vector3D[]{X, Y, Z, Y, X};
        this.joints.addAll(MultiBodySystemRandomTools.nextRevoluteJointChain((Random)this.random, (String)"chainA", (RigidBodyBasics)elevator, (Vector3DReadOnly[])jointAxes1));
        Vector3D[] jointAxes2 = new Vector3D[]{Z, X, Y, X, X};
        this.joints.addAll(MultiBodySystemRandomTools.nextRevoluteJointChain((Random)this.random, (String)"chainB", (RigidBodyBasics)elevator, (Vector3DReadOnly[])jointAxes2));
        Vector3D[] jointAxes3 = new Vector3D[]{Y, Y, X, X, X};
        this.joints.addAll(MultiBodySystemRandomTools.nextRevoluteJointChain((Random)this.random, (String)"chainC", (RigidBodyBasics)elevator, (Vector3DReadOnly[])jointAxes3));
    }

    private Set<RigidBodyBasics> getExcludedRigidBodies() {
        LinkedHashSet<RigidBodyBasics> excludedBodies = new LinkedHashSet<RigidBodyBasics>();
        for (RigidBodyBasics rigidBody : this.exclusions) {
            excludedBodies.add(rigidBody);
            RigidBodyBasics[] subTree = MultiBodySystemTools.collectSuccessors((JointBasics[])MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{rigidBody}));
            excludedBodies.addAll(Arrays.asList(subTree));
        }
        return excludedBodies;
    }

    private Set<JointBasics> getExcludedJoints() {
        Set<RigidBodyBasics> excludedBodies = this.getExcludedRigidBodies();
        LinkedHashSet<JointBasics> excludedJoints = new LinkedHashSet<JointBasics>();
        for (RigidBodyBasics rigidBody : excludedBodies) {
            excludedJoints.addAll(rigidBody.getChildrenJoints());
        }
        return excludedJoints;
    }

    @Test
    public void testAddRevoluteJoint_String_RigidBody_Vector3d_Vector3d() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        chain.nextState(this.random, new JointStateType[]{JointStateType.CONFIGURATION, JointStateType.VELOCITY});
        RigidBodyBasics[] rootBodies = new RigidBodyBasics[]{chain.getElevator()};
        JointBasics[] jointsArray = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])rootBodies);
        RigidBodyBasics[] partialBodiesArray = ScrewTools.computeSubtreeSuccessors((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        RigidBodyBasics[] bodiesArray = new RigidBodyBasics[partialBodiesArray.length + 1];
        bodiesArray[0] = chain.getElevator();
        for (int i = 0; i < partialBodiesArray.length; ++i) {
            bodiesArray[i + 1] = partialBodiesArray[i];
        }
        String jointName = "joint";
        RigidBodyBasics parentBody = bodiesArray[bodiesArray.length - 1];
        Vector3D jointOffset = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)5.0);
        Vector3D jointAxis = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)5.0);
        RevoluteJoint joint = new RevoluteJoint(jointName, parentBody, (Tuple3DReadOnly)jointOffset, (Vector3DReadOnly)jointAxis);
        Assertions.assertEquals((Object)jointName, (Object)joint.getName(), (String)"Should be equal");
        Assertions.assertTrue((boolean)parentBody.equals(joint.getPredecessor()));
        Assertions.assertTrue((boolean)jointAxis.equals((EuclidGeometry)joint.getJointAxis()));
    }

    @Test
    public void testAddRevoluteJoint_String_RigidBody_Transform3D_Vector3d() {
        String jointName = "joint";
        RigidBody parentBody = new RigidBody("body", ReferenceFrame.getWorldFrame());
        RigidBodyTransform transformToParent = EuclidCoreRandomTools.nextRigidBodyTransform((Random)this.random);
        Vector3D jointAxis = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)5.0);
        RevoluteJoint joint = new RevoluteJoint(jointName, (RigidBodyBasics)parentBody, (RigidBodyTransformReadOnly)transformToParent, (Vector3DReadOnly)jointAxis);
        Assertions.assertEquals((Object)jointName, (Object)joint.getName(), (String)"Should be equal");
        Assertions.assertTrue((boolean)parentBody.equals(joint.getPredecessor()));
        Assertions.assertTrue((boolean)jointAxis.equals((EuclidGeometry)joint.getJointAxis()));
    }

    @Test
    public void testAddPrismaticJoint_String_RigidBody_Vector3d_Vector3d() {
        String jointName = "joint";
        RigidBody parentBody = new RigidBody("body", ReferenceFrame.getWorldFrame());
        Vector3D jointOffset = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)5.0);
        Vector3D jointAxis = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)5.0);
        PrismaticJoint joint = new PrismaticJoint(jointName, (RigidBodyBasics)parentBody, (Tuple3DReadOnly)jointOffset, (Vector3DReadOnly)jointAxis);
        Assertions.assertEquals((Object)jointName, (Object)joint.getName(), (String)"Should be equal");
        Assertions.assertTrue((boolean)parentBody.equals(joint.getPredecessor()));
    }

    @Test
    public void testAddPrismaticJoint_String_RigidBody_Transform3D_Vector3d() {
        String jointName = "joint";
        RigidBody parentBody = new RigidBody("body", ReferenceFrame.getWorldFrame());
        RigidBodyTransform transformToParent = EuclidCoreRandomTools.nextRigidBodyTransform((Random)this.random);
        Vector3D jointAxis = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)5.0);
        PrismaticJoint joint = new PrismaticJoint(jointName, (RigidBodyBasics)parentBody, (RigidBodyTransformReadOnly)transformToParent, (Vector3DReadOnly)jointAxis);
        Assertions.assertEquals((Object)jointName, (Object)joint.getName(), (String)"Should be equal");
        Assertions.assertTrue((boolean)parentBody.equals(joint.getPredecessor()));
    }

    @Test
    public void testAddRigidBody_String_InverseDynamicsJoint_Matrix3d_double_Vector3d() {
        String name = "body";
        RigidBody predecessor = new RigidBody("Predecessor", this.theFrame);
        PlanarJoint parentJoint = new PlanarJoint(name, (RigidBodyBasics)predecessor);
        Matrix3D momentOfInertia = new Matrix3D();
        double mass = this.random.nextDouble();
        RigidBody body = new RigidBody(name, (JointBasics)parentJoint, (Matrix3DReadOnly)momentOfInertia, mass, (Tuple3DReadOnly)X);
        Assertions.assertEquals((Object)name, (Object)body.getName(), (String)"Should be equal");
        Assertions.assertTrue((boolean)parentJoint.equals(body.getParentJoint()));
    }

    @Test
    public void testAddRigidBody_String_InverseDynamicsJoint_Matrix3d_double_Transform3D() {
        String name = "body";
        RigidBody predecessor = new RigidBody("Predecessor", this.theFrame);
        PlanarJoint parentJoint = new PlanarJoint(name, (RigidBodyBasics)predecessor);
        Matrix3D momentOfInertia = new Matrix3D();
        double mass = this.random.nextDouble();
        RigidBodyTransform inertiaPose = new RigidBodyTransform();
        RigidBody body = new RigidBody(name, (JointBasics)parentJoint, (Matrix3DReadOnly)momentOfInertia, mass, (RigidBodyTransformReadOnly)inertiaPose);
        Assertions.assertEquals((Object)name, (Object)body.getName(), (String)"Should be equal");
        Assertions.assertTrue((boolean)parentJoint.equals(body.getParentJoint()));
    }

    @Test
    public void testComputeSuccessors() {
        int numJoints = 3;
        RigidBodyBasics[] bodyArray = new RigidBodyBasics[numJoints];
        for (int i = 0; i < numJoints; ++i) {
            JointBasics joint = (JointBasics)this.joints.get(i);
            bodyArray[i] = joint.getSuccessor();
        }
        JointBasics[] joints1 = new JointBasics[]{(JointBasics)this.joints.get(0), (JointBasics)this.joints.get(1), (JointBasics)this.joints.get(2)};
        RigidBodyBasics[] bodies = MultiBodySystemTools.collectSuccessors((JointBasics[])joints1);
        Assertions.assertEquals((int)bodyArray.length, (int)bodies.length, (String)"Should be equal");
        for (int i = 0; i < bodies.length; ++i) {
            Assertions.assertTrue((boolean)bodies[i].equals(bodyArray[i]));
        }
    }

    @Test
    public void testComputeSupportAndSubtreeSuccessors_RigidBody() {
        int numberOfBodiesOnChain = 6;
        int numberOfBodies = 16;
        RigidBodyBasics[] successors = ScrewTools.computeSupportAndSubtreeSuccessors((RigidBodyBasics[])new RigidBodyBasics[]{this.secondLevelSubTrees.get(0)});
        Assertions.assertEquals((int)(numberOfBodiesOnChain - 1), (int)successors.length);
        successors = ScrewTools.computeSupportAndSubtreeSuccessors((RigidBodyBasics[])new RigidBodyBasics[]{this.elevator});
        Assertions.assertEquals((int)(numberOfBodies - 1), (int)successors.length);
    }

    @Test
    public void testComputeSupportAndSubtreeJoints_RigidBody() {
        int numberOfJointsOnChain = 5;
        int numberOfJoints = 15;
        JointBasics[] successors = MultiBodySystemTools.collectSupportAndSubtreeJoints((RigidBodyBasics)this.secondLevelSubTrees.get(0));
        Assertions.assertEquals((int)numberOfJointsOnChain, (int)successors.length);
        successors = MultiBodySystemTools.collectSupportAndSubtreeJoints((RigidBodyBasics)this.elevator);
        Assertions.assertEquals((int)numberOfJoints, (int)successors.length);
    }

    @Test
    public void testComputeSupportJoints_RigidBody() {
        RigidBodyBasics[] bodies = new RigidBodyBasics[]{this.elevator};
        JointBasics[] supportJoints = MultiBodySystemTools.collectSupportJoints((RigidBodyBasics[])bodies);
        Assertions.assertTrue((boolean)this.elevator.isRootBody());
        Assertions.assertEquals((int)0, (int)supportJoints.length);
        int jointsSupportingSecondLevelSubTree = 2;
        int numberOfChainsUsed = 2;
        RigidBodyBasics[] bodies1 = new RigidBodyBasics[]{this.secondLevelSubTrees.get(0), this.secondLevelSubTrees.get(1)};
        supportJoints = MultiBodySystemTools.collectSupportJoints((RigidBodyBasics[])bodies1);
        Assertions.assertEquals((int)(jointsSupportingSecondLevelSubTree * numberOfChainsUsed), (int)supportJoints.length);
    }

    @Test
    public void testComputeSubtreeJoints_RigidBody() {
        ArrayList<RigidBodyBasics> bodies = new ArrayList<RigidBodyBasics>();
        bodies.add(this.elevator);
        bodies.add(this.elevator);
        JointBasics[] fromBodies = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{this.elevator, this.elevator});
        JointReadOnly[] fromBodiesList = MultiBodySystemTools.collectSubtreeJoints(bodies);
        Assertions.assertEquals((int)fromBodies.length, (int)fromBodiesList.length, (String)"These should be equal");
        for (int i = 0; i < fromBodies.length; ++i) {
            Assertions.assertTrue((boolean)fromBodies[i].equals(fromBodiesList[i]));
        }
    }

    @Test
    public void testGetRootBody() {
        RigidBodyBasics randomBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)this.joints.get(this.joints.size() - 1).getPredecessor());
        Assertions.assertTrue((boolean)randomBody.isRootBody());
    }

    @Test
    public void testCreateJointPath() {
        int numberOfJoints = this.joints.size();
        int numberOfBodies = numberOfJoints + 1;
        RigidBodyBasics[] allBodies = new RigidBodyBasics[numberOfBodies];
        allBodies[0] = this.elevator;
        for (int i = 0; i < numberOfJoints; ++i) {
            allBodies[i + 1] = this.joints.get(i).getSuccessor();
        }
        RigidBodyBasics start = allBodies[0];
        RigidBodyBasics end = allBodies[allBodies.length - 1];
        JointBasics[] jointPath = MultiBodySystemTools.createJointPath((RigidBodyBasics)start, (RigidBodyBasics)end);
        for (int i = 0; i < jointPath.length; ++i) {
            Assertions.assertTrue((boolean)jointPath[i].getName().equalsIgnoreCase("chainCjoint" + i));
        }
    }

    @Test
    public void testIsAncestor() {
        int numberOfJoints = this.joints.size();
        int numberOfBodies = numberOfJoints + 1;
        RigidBodyBasics[] allBodies = new RigidBodyBasics[numberOfBodies];
        allBodies[0] = this.elevator;
        for (int i = 0; i < numberOfJoints; ++i) {
            allBodies[i + 1] = this.joints.get(i).getSuccessor();
        }
        RigidBodyBasics d0 = allBodies[0];
        RigidBodyBasics d1 = allBodies[1];
        RigidBodyBasics d2 = allBodies[2];
        RigidBodyBasics d3 = allBodies[3];
        Assertions.assertTrue((boolean)MultiBodySystemTools.isAncestor((RigidBodyReadOnly)d0, (RigidBodyReadOnly)d0));
        Assertions.assertTrue((boolean)MultiBodySystemTools.isAncestor((RigidBodyReadOnly)d3, (RigidBodyReadOnly)d0));
        Assertions.assertFalse((boolean)MultiBodySystemTools.isAncestor((RigidBodyReadOnly)d0, (RigidBodyReadOnly)d3));
    }

    @Test
    public void testComputeDistanceToAncestor() {
        int numberOfJoints = this.joints.size();
        int numberOfBodies = numberOfJoints + 1;
        RigidBodyBasics[] allBodies = new RigidBodyBasics[numberOfBodies];
        allBodies[0] = this.elevator;
        for (int i = 0; i < numberOfJoints; ++i) {
            allBodies[i + 1] = this.joints.get(i).getSuccessor();
        }
        RigidBodyBasics d0 = allBodies[0];
        RigidBodyBasics d1 = allBodies[1];
        RigidBodyBasics d2 = allBodies[2];
        RigidBodyBasics d3 = allBodies[3];
        Assertions.assertEquals((int)0, (int)MultiBodySystemTools.computeDistanceToAncestor((RigidBodyReadOnly)d0, (RigidBodyReadOnly)d0));
        Assertions.assertEquals((int)3, (int)MultiBodySystemTools.computeDistanceToAncestor((RigidBodyReadOnly)d3, (RigidBodyReadOnly)d0));
        Assertions.assertEquals((int)-1, (int)MultiBodySystemTools.computeDistanceToAncestor((RigidBodyReadOnly)d0, (RigidBodyReadOnly)d3));
    }

    @Test
    public void testPackJointVelocitiesMatrix_Array() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        JointBasics[] jointsArray = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        DMatrixRMaj originalVelocities = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])jointsArray), 1);
        for (int i = 0; i < originalVelocities.getNumRows() * originalVelocities.getNumCols(); ++i) {
            originalVelocities.set(i, this.random.nextDouble());
        }
        MultiBodySystemTools.insertJointsState((JointBasics[])jointsArray, (JointStateType)JointStateType.VELOCITY, (DMatrix)originalVelocities);
        DMatrixRMaj newVelocities = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])jointsArray), 1);
        MultiBodySystemTools.extractJointsState((JointReadOnly[])jointsArray, (JointStateType)JointStateType.VELOCITY, (DMatrix)newVelocities);
        for (int i = 0; i < jointsArray.length; ++i) {
            Assertions.assertEquals((double)originalVelocities.get(i), (double)newVelocities.get(i), (double)1.0E-10, (String)"Should be equal velocities");
        }
    }

    @Test
    public void testPackJointVelocitiesMatrix_Iterable() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        JointBasics[] jointsArray = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        ArrayList<JointBasics> jointsList = new ArrayList<JointBasics>();
        for (int i = 0; i < jointsArray.length; ++i) {
            jointsList.add(jointsArray[i]);
        }
        DMatrixRMaj originalVelocities = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])jointsArray), 1);
        for (int i = 0; i < originalVelocities.getNumRows() * originalVelocities.getNumCols(); ++i) {
            originalVelocities.set(i, this.random.nextDouble());
        }
        MultiBodySystemTools.insertJointsState((JointBasics[])jointsArray, (JointStateType)JointStateType.VELOCITY, (DMatrix)originalVelocities);
        DMatrixRMaj newVelocities = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])jointsArray), 1);
        MultiBodySystemTools.extractJointsState(jointsList, (JointStateType)JointStateType.VELOCITY, (DMatrix)newVelocities);
        for (int i = 0; i < jointsArray.length; ++i) {
            Assertions.assertEquals((double)originalVelocities.get(i), (double)newVelocities.get(i), (double)1.0E-10, (String)"Should be equal velocities");
        }
    }

    @Test
    public void testPackDesiredJointAccelerationsMatrix() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        JointBasics[] jointsArray = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        DMatrixRMaj originalAccel = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])jointsArray), 1);
        for (int i = 0; i < originalAccel.getNumRows() * originalAccel.getNumCols(); ++i) {
            originalAccel.set(i, this.random.nextDouble());
        }
        MultiBodySystemTools.insertJointsState((JointBasics[])jointsArray, (JointStateType)JointStateType.ACCELERATION, (DMatrix)originalAccel);
        DMatrixRMaj newAccelerations = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])jointsArray), 1);
        MultiBodySystemTools.extractJointsState((JointReadOnly[])jointsArray, (JointStateType)JointStateType.ACCELERATION, (DMatrix)newAccelerations);
        for (int i = 0; i < jointsArray.length; ++i) {
            Assertions.assertEquals((double)originalAccel.get(i), (double)newAccelerations.get(i), (double)1.0E-10, (String)"Should be equal velocities");
        }
    }

    @Test
    public void testComputeDegreesOfFreedom_Array() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        chain.nextState(this.random, new JointStateType[]{JointStateType.CONFIGURATION, JointStateType.VELOCITY});
        RigidBodyBasics[] rootBodies = new RigidBodyBasics[]{chain.getElevator()};
        JointBasics[] jointsArray = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])rootBodies);
        RigidBodyBasics[] partialBodiesArray = ScrewTools.computeSubtreeSuccessors((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        RigidBodyBasics[] bodiesArray = new RigidBodyBasics[partialBodiesArray.length + 1];
        bodiesArray[0] = chain.getElevator();
        for (int i = 0; i < partialBodiesArray.length; ++i) {
            bodiesArray[i + 1] = partialBodiesArray[i];
        }
        int result = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])jointsArray);
        Assertions.assertEquals((int)11, (int)result);
    }

    @Test
    public void testComputeDegreesOfFreedom_Iterable() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        chain.nextState(this.random, new JointStateType[]{JointStateType.CONFIGURATION, JointStateType.VELOCITY});
        JointBasics[] jointsArray = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        ArrayList jointsList = new ArrayList(jointsArray.length);
        RigidBodyBasics[] partialBodiesArray = ScrewTools.computeSubtreeSuccessors((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        RigidBodyBasics[] bodiesArray = new RigidBodyBasics[partialBodiesArray.length + 1];
        bodiesArray[0] = chain.getElevator();
        for (int i = 0; i < partialBodiesArray.length; ++i) {
            bodiesArray[i + 1] = partialBodiesArray[i];
        }
        MultiBodySystemTools.computeDegreesOfFreedom(jointsList);
    }

    @Test
    public void testCreateGravitationalSpatialAcceleration() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        chain.nextState(this.random, new JointStateType[]{JointStateType.CONFIGURATION, JointStateType.VELOCITY});
        double gravity = RandomNumbers.nextDouble((Random)this.random, (double)100.0);
        SpatialAcceleration result = ScrewTools.createGravitationalSpatialAcceleration((RigidBodyBasics)chain.getElevator(), (double)gravity);
        FixedFrameVector3DBasics angularPart = result.getAngularPart();
        Vector3D zeroes = new Vector3D(0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)angularPart.epsilonEquals((EuclidGeometry)zeroes, 1.0E-10));
        FixedFrameVector3DBasics linearPart = result.getLinearPart();
        Assertions.assertEquals((double)zeroes.getX(), (double)linearPart.getX(), (double)1.0E-10);
        Assertions.assertEquals((double)zeroes.getY(), (double)linearPart.getY(), (double)1.0E-10);
        Assertions.assertEquals((double)gravity, (double)linearPart.getZ(), (double)1.0E-10);
    }

    @Test
    public void testSetDesiredAccelerations() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        JointBasics[] jointsArray = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        DMatrixRMaj jointAccelerations = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])jointsArray), 1);
        for (int i = 0; i < jointAccelerations.getNumRows() * jointAccelerations.getNumCols(); ++i) {
            jointAccelerations.set(i, this.random.nextDouble());
        }
        MultiBodySystemTools.insertJointsState((JointBasics[])jointsArray, (JointStateType)JointStateType.ACCELERATION, (DMatrix)jointAccelerations);
        DMatrixRMaj sixDoFAccel = new DMatrixRMaj(6, 1);
        jointsArray[0].getJointAcceleration(0, (DMatrix)sixDoFAccel);
        for (int i = 0; i < 6; ++i) {
            Assertions.assertEquals((double)jointAccelerations.get(i), (double)sixDoFAccel.get(i), (double)1.0E-10, (String)"Should be equal accelerations");
        }
        for (int i = 6; i < jointAccelerations.getNumRows() * jointAccelerations.getNumCols(); ++i) {
            OneDoFJointBasics joint = (OneDoFJointBasics)jointsArray[i - 5];
            Assertions.assertEquals((double)jointAccelerations.get(i), (double)joint.getQdd(), (double)1.0E-10, (String)"Should be equal accelerations");
        }
    }

    @Test
    public void testSetVelocities() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        JointBasics[] jointsArray = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        DMatrixRMaj jointVelocities = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])jointsArray), 1);
        for (int i = 0; i < jointVelocities.getNumRows() * jointVelocities.getNumCols(); ++i) {
            jointVelocities.set(i, this.random.nextDouble());
        }
        MultiBodySystemTools.insertJointsState((JointBasics[])jointsArray, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
        DMatrixRMaj sixDoFVeloc = new DMatrixRMaj(6, 1);
        jointsArray[0].getJointVelocity(0, (DMatrix)sixDoFVeloc);
        for (int i = 0; i < 6; ++i) {
            Assertions.assertEquals((double)jointVelocities.get(i), (double)sixDoFVeloc.get(i), (double)1.0E-10, (String)"Should be equal velocitiess");
        }
        for (int i = 6; i < jointVelocities.getNumRows() * jointVelocities.getNumCols(); ++i) {
            OneDoFJointBasics joint = (OneDoFJointBasics)jointsArray[i - 5];
            Assertions.assertEquals((double)jointVelocities.get(i), (double)joint.getQd(), (double)1.0E-10, (String)"Should be equal velocities");
        }
    }

    @Test
    public void testComputeIndicesForJoint() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        JointBasics[] jointsArr = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        JointBasics rootJoint = jointsArr[0];
        JointBasics testJoint4 = jointsArr[5];
        TIntArrayList indices = new TIntArrayList();
        ScrewTools.computeIndicesForJoint((JointBasics[])jointsArr, (TIntArrayList)indices, (JointBasics[])new JointBasics[]{testJoint4, rootJoint});
        Assertions.assertEquals((int)7, (int)indices.size());
        for (int i = 0; i < rootJoint.getDegreesOfFreedom(); ++i) {
            Assertions.assertEquals((int)i, (int)indices.get(i));
        }
        Assertions.assertEquals((int)10, (int)indices.get(indices.size() - 1));
    }

    @Test
    public void testExtractRevoluteJoints() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        JointBasics[] jointsArr = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        RevoluteJoint[] revoluteJoints = (RevoluteJoint[])MultiBodySystemTools.filterJoints((JointReadOnly[])jointsArr, RevoluteJoint.class);
        Assertions.assertEquals((int)(jointsArr.length - 1), (int)revoluteJoints.length);
        for (int i = 0; i < revoluteJoints.length; ++i) {
            Assertions.assertEquals((Object)("testJoint" + i), (Object)revoluteJoints[i].getName());
        }
    }

    @Test
    public void testComputeNumberOfJointsOfType() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        JointBasics[] jointsArr = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        int number6DoF = MultiBodySystemTools.computeNumberOfJointsOfType(SixDoFJoint.class, (JointReadOnly[])jointsArr);
        int numberRev = MultiBodySystemTools.computeNumberOfJointsOfType(RevoluteJoint.class, (JointReadOnly[])jointsArr);
        Assertions.assertEquals((int)1, (int)number6DoF);
        Assertions.assertEquals((int)(jointsArr.length - 1), (int)numberRev);
    }

    @Test
    public void testFilterJoints() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        JointBasics[] jointsArr = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        RevoluteJoint[] justRevolutes = (RevoluteJoint[])MultiBodySystemTools.filterJoints((JointReadOnly[])jointsArr, RevoluteJoint.class);
        Assertions.assertEquals((int)(jointsArr.length - 1), (int)justRevolutes.length);
        SixDoFJoint[] justSix = (SixDoFJoint[])MultiBodySystemTools.filterJoints((JointReadOnly[])jointsArr, SixDoFJoint.class);
        Assertions.assertEquals((int)1, (int)justSix.length);
        Assertions.assertTrue((boolean)(justSix[0] instanceof SixDoFJoint));
        Boolean clean = false;
        for (RevoluteJoint joint : justRevolutes) {
            clean = joint instanceof RevoluteJoint ? Boolean.valueOf(true) : Boolean.valueOf(false);
            Assertions.assertTrue((boolean)clean);
        }
    }

    @Test
    public void testFilterJoints_dest() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain chain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(this.random, jointAxes);
        JointBasics[] jointsArr = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{chain.getElevator()});
        RevoluteJoint[] justRevolutes = new RevoluteJoint[jointsArr.length - 1];
        MultiBodySystemTools.filterJoints((JointReadOnly[])jointsArr, (JointReadOnly[])justRevolutes, RevoluteJoint.class);
        Assertions.assertEquals((int)(jointsArr.length - 1), (int)justRevolutes.length);
        SixDoFJoint[] justSix = new SixDoFJoint[1];
        MultiBodySystemTools.filterJoints((JointReadOnly[])jointsArr, (JointReadOnly[])justSix, SixDoFJoint.class);
        Assertions.assertEquals((int)1, (int)justSix.length);
        Assertions.assertTrue((boolean)(justSix[0] instanceof SixDoFJoint));
        Boolean clean = false;
        for (RevoluteJoint joint : justRevolutes) {
            clean = joint instanceof RevoluteJoint ? Boolean.valueOf(true) : Boolean.valueOf(false);
            Assertions.assertTrue((boolean)clean);
        }
    }

    @Test
    public void testFindJointsWithNames() {
        int numberOfJoints = this.joints.size();
        JointBasics[] allJoints = new JointBasics[this.joints.size()];
        for (int i = 0; i < numberOfJoints; ++i) {
            allJoints[i] = (JointBasics)this.joints.get(i);
        }
        try {
            JointBasics[] matches = ScrewTools.findJointsWithNames((JointBasics[])allJoints, (String[])new String[]{"woof"});
            Assertions.fail((String)"Should throw RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        JointBasics[] matches = ScrewTools.findJointsWithNames((JointBasics[])allJoints, (String[])new String[]{"chainAJoint0"});
    }

    @Test
    public void testFindRigidBodiesWithNames_RigidBody_String() {
        int numberOfJoints = this.joints.size();
        RigidBodyBasics[] allBodies = new RigidBodyBasics[this.joints.size() + 1];
        allBodies[0] = this.elevator;
        for (int i = 0; i < numberOfJoints; ++i) {
            allBodies[i + 1] = this.joints.get(i).getSuccessor();
        }
        try {
            RigidBodyBasics[] matches = ScrewTools.findRigidBodiesWithNames((RigidBodyBasics[])allBodies, (String[])new String[]{"elevatorOOPS"});
            Assertions.fail((String)"Should throw RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        RigidBodyBasics[] matches = ScrewTools.findRigidBodiesWithNames((RigidBodyBasics[])allBodies, (String[])new String[]{"elevator", "chainABody0", "chainABody1", "chainABody2", "chainABody4", "chainBBody0", "chainBBody1", "chainBBody2", "chainBBody3", "chainBBody4", "chainCBody0", "chainCBody1", "chainCBody2", "chainCBody3", "chainCBody4"});
    }
}

