/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.robotics.screwTheory.NumericalMovingReferenceFrame;

public class NumericalMovingReferenceFrameTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testWithChainRobot() {
        Random random = new Random(3452345L);
        int numberOfJoints = 20;
        double updateDT = 1.0E-8;
        MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(updateDT);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        HashMap<MovingReferenceFrame, NumericalMovingReferenceFrame> jointFramesToFDFrames = new HashMap<MovingReferenceFrame, NumericalMovingReferenceFrame>();
        for (OneDoFJointBasics joint : joints) {
            MovingReferenceFrame frameBeforeJoint = joint.getFrameBeforeJoint();
            NumericalMovingReferenceFrame frameBeforeJointFD = new NumericalMovingReferenceFrame((ReferenceFrame)frameBeforeJoint, updateDT);
            jointFramesToFDFrames.put(frameBeforeJoint, frameBeforeJointFD);
            MovingReferenceFrame frameAfterJoint = joint.getFrameAfterJoint();
            NumericalMovingReferenceFrame frameAfterJointFD = new NumericalMovingReferenceFrame((ReferenceFrame)frameAfterJoint, updateDT);
            jointFramesToFDFrames.put(frameAfterJoint, frameAfterJointFD);
        }
        Twist actualTwist = new Twist();
        Twist expectedTwist = new Twist();
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, (Iterable)joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
        ((OneDoFJoint)joints.get(0)).getPredecessor().updateFramesRecursively();
        jointFramesToFDFrames.values().forEach(MovingReferenceFrame::update);
        for (int i = 0; i < 100; ++i) {
            integrator.integrateFromVelocity(joints);
            ((OneDoFJoint)joints.get(0)).getPredecessor().updateFramesRecursively();
            for (NumericalMovingReferenceFrame fdFrame : jointFramesToFDFrames.values()) {
                fdFrame.update();
            }
            Set entrySet = jointFramesToFDFrames.entrySet();
            for (Map.Entry entry : entrySet) {
                ((MovingReferenceFrame)entry.getKey()).getTwistOfFrame((TwistBasics)expectedTwist);
                ((NumericalMovingReferenceFrame)entry.getValue()).getTwistOfFrame((TwistBasics)actualTwist);
                expectedTwist.setBodyFrame((ReferenceFrame)entry.getValue());
                expectedTwist.changeFrame((ReferenceFrame)entry.getValue());
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-5);
            }
        }
    }
}

