/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.robotics.referenceFrames.MidFootZUpGroundFrame;
import us.ihmc.robotics.screwTheory.MovingMidFootZUpGroundFrame;
import us.ihmc.robotics.screwTheory.MovingZUpFrame;
import us.ihmc.robotics.screwTheory.NumericalMovingReferenceFrame;

public class MovingMidFootZUpGroundFrameTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testAgainstFiniteDifferenceWithChainRobot() {
        Random random = new Random(3452345L);
        int numberOfJoints = 20;
        double updateDT = 1.0E-8;
        MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(updateDT);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        HashMap<MovingMidFootZUpGroundFrame, NumericalMovingReferenceFrame> jointFramesToFDFrames = new HashMap<MovingMidFootZUpGroundFrame, NumericalMovingReferenceFrame>();
        for (int i = 0; i < 5; ++i) {
            int firstJointIndex = random.nextInt(numberOfJoints);
            int secondJointIndex = random.nextInt(numberOfJoints - 1) + firstJointIndex;
            MovingReferenceFrame nonZUpFrameOne = ((OneDoFJoint)joints.get(firstJointIndex)).getFrameAfterJoint();
            MovingReferenceFrame nonZUpFrameTwo = ((OneDoFJoint)joints.get(secondJointIndex %= numberOfJoints)).getFrameAfterJoint();
            MovingZUpFrame frameOne = new MovingZUpFrame(nonZUpFrameOne, nonZUpFrameOne.getName() + "ZUp");
            MovingZUpFrame frameTwo = new MovingZUpFrame(nonZUpFrameTwo, nonZUpFrameTwo.getName() + "ZUp");
            MovingMidFootZUpGroundFrame movingMidFrameZUpFrame = new MovingMidFootZUpGroundFrame("midFrame" + i, frameOne, frameTwo);
            NumericalMovingReferenceFrame frameFD = new NumericalMovingReferenceFrame((ReferenceFrame)movingMidFrameZUpFrame, updateDT);
            jointFramesToFDFrames.put(movingMidFrameZUpFrame, frameFD);
        }
        Twist actualTwist = new Twist();
        Twist expectedTwist = new Twist();
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, (Iterable)joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
        ((OneDoFJoint)joints.get(0)).getPredecessor().updateFramesRecursively();
        jointFramesToFDFrames.keySet().forEach(MovingReferenceFrame::update);
        jointFramesToFDFrames.values().forEach(MovingReferenceFrame::update);
        for (int i = 0; i < 100; ++i) {
            integrator.integrateFromVelocity(joints);
            ((OneDoFJoint)joints.get(0)).getPredecessor().updateFramesRecursively();
            jointFramesToFDFrames.keySet().forEach(MovingReferenceFrame::update);
            jointFramesToFDFrames.values().forEach(MovingReferenceFrame::update);
            Set entrySet = jointFramesToFDFrames.entrySet();
            for (Map.Entry entry : entrySet) {
                ((MovingMidFootZUpGroundFrame)entry.getKey()).getTwistOfFrame((TwistBasics)expectedTwist);
                ((NumericalMovingReferenceFrame)entry.getValue()).getTwistOfFrame((TwistBasics)actualTwist);
                expectedTwist.setBodyFrame((ReferenceFrame)entry.getValue());
                expectedTwist.changeFrame((ReferenceFrame)entry.getValue());
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-5);
            }
        }
    }

    @Test
    public void testConsistencyWithMidFrameZUpFrameWithChainRobot() {
        Random random = new Random(3452345L);
        int numberOfJoints = 20;
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        HashMap<MidFootZUpGroundFrame, MovingMidFootZUpGroundFrame> zUpFramesToMovingZUpFrames = new HashMap<MidFootZUpGroundFrame, MovingMidFootZUpGroundFrame>();
        for (int i = 0; i < 5; ++i) {
            int firstJointIndex = random.nextInt(numberOfJoints);
            int secondJointIndex = random.nextInt(numberOfJoints - 1) + firstJointIndex;
            MovingReferenceFrame nonZUpFrameOne = ((OneDoFJoint)joints.get(firstJointIndex)).getFrameAfterJoint();
            MovingReferenceFrame nonZUpFrameTwo = ((OneDoFJoint)joints.get(secondJointIndex %= numberOfJoints)).getFrameAfterJoint();
            MovingZUpFrame frameOne = new MovingZUpFrame(nonZUpFrameOne, nonZUpFrameOne.getName() + "ZUp");
            MovingZUpFrame frameTwo = new MovingZUpFrame(nonZUpFrameTwo, nonZUpFrameTwo.getName() + "ZUp");
            MovingMidFootZUpGroundFrame movingMidFrameZUpFrame = new MovingMidFootZUpGroundFrame("midFrame" + i, frameOne, frameTwo);
            MidFootZUpGroundFrame midFrameZUpFrame = new MidFootZUpGroundFrame("midFrame" + i, (ReferenceFrame)frameOne, (ReferenceFrame)frameTwo);
            zUpFramesToMovingZUpFrames.put(midFrameZUpFrame, movingMidFrameZUpFrame);
        }
        RigidBodyTransform actualTransform = new RigidBodyTransform();
        RigidBodyTransform expectedTransform = new RigidBodyTransform();
        for (int i = 0; i < 100; ++i) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, (Iterable)joints);
            ((OneDoFJoint)joints.get(0)).getPredecessor().updateFramesRecursively();
            zUpFramesToMovingZUpFrames.keySet().forEach(ReferenceFrame::update);
            zUpFramesToMovingZUpFrames.values().forEach(ReferenceFrame::update);
            Set entrySet = zUpFramesToMovingZUpFrames.entrySet();
            for (Map.Entry entry : entrySet) {
                expectedTransform.set(((MidFootZUpGroundFrame)entry.getKey()).getTransformToRoot());
                actualTransform.set(((MovingMidFootZUpGroundFrame)entry.getValue()).getTransformToRoot());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)actualTransform, (double)1.0E-12);
            }
        }
    }
}

