/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.SpatialAccelerationCalculator;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.PrismaticJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.screwTheory.CenterOfMassAccelerationCalculator;

public class CenterOfMassAccelerationCalculatorTest {
    @BeforeEach
    public void setUp() {
    }

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testOneRigidBody() {
        Random random = new Random(1779L);
        double mass = 1.0;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        MovingReferenceFrame elevatorFrame = elevator.getBodyFixedFrame();
        SixDoFJoint sixDoFJoint = new SixDoFJoint("sixDoF", (RigidBodyBasics)elevator);
        new RigidBody("body", (JointBasics)sixDoFJoint, (Matrix3DReadOnly)this.getRandomDiagonalMatrix(random), mass, (Tuple3DReadOnly)new Vector3D());
        SpatialAcceleration rootAcceleration = new SpatialAcceleration((ReferenceFrame)elevatorFrame, worldFrame, (ReferenceFrame)elevatorFrame);
        SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)elevator, ReferenceFrame.getWorldFrame());
        spatialAccelerationCalculator.setRootAcceleration((SpatialAccelerationReadOnly)rootAcceleration);
        CenterOfMassAccelerationCalculator comAccelerationCalculator = new CenterOfMassAccelerationCalculator((RigidBodyBasics)elevator, spatialAccelerationCalculator);
        MovingReferenceFrame frameAfterJoint = sixDoFJoint.getFrameAfterJoint();
        MovingReferenceFrame frameBeforeJoint = sixDoFJoint.getFrameBeforeJoint();
        SpatialAcceleration jointAcceleration = new SpatialAcceleration((ReferenceFrame)frameAfterJoint, (ReferenceFrame)frameBeforeJoint, (ReferenceFrame)frameAfterJoint, (Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)this.getRandomVector(random));
        sixDoFJoint.setJointPosition((Tuple3DReadOnly)this.getRandomVector(random));
        sixDoFJoint.getJointPose().getOrientation().setYawPitchRoll(random.nextDouble(), random.nextDouble(), random.nextDouble());
        sixDoFJoint.setJointAcceleration((SpatialAccelerationReadOnly)jointAcceleration);
        elevator.updateFramesRecursively();
        RotationMatrix rotationMatrix = new RotationMatrix();
        rotationMatrix.set((Orientation3DReadOnly)sixDoFJoint.getJointPose().getOrientation());
        spatialAccelerationCalculator.reset();
        FrameVector3D comAcceleration = new FrameVector3D(ReferenceFrame.getWorldFrame());
        comAccelerationCalculator.getCoMAcceleration(comAcceleration);
        Vector3D expected = new Vector3D((Tuple3DReadOnly)jointAcceleration.getLinearPart());
        rotationMatrix.transform((Tuple3DBasics)expected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)comAcceleration, (double)1.0E-5);
    }

    @Test
    public void testTwoSliderJointsZeroAcceleration() {
        Random random = new Random(1779L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        MovingReferenceFrame elevatorFrame = elevator.getBodyFixedFrame();
        Vector3D jointAxis = new Vector3D(1.0, 0.0, 0.0);
        PrismaticJoint j1 = new PrismaticJoint("j1", (RigidBodyBasics)elevator, (Tuple3DReadOnly)new Vector3D(), (Vector3DReadOnly)jointAxis);
        RigidBody r1 = new RigidBody("r1", (JointBasics)j1, (Matrix3DReadOnly)this.getRandomDiagonalMatrix(random), random.nextDouble(), (Tuple3DReadOnly)this.getRandomVector(random));
        PrismaticJoint j2 = new PrismaticJoint("j2", (RigidBodyBasics)r1, (Tuple3DReadOnly)new Vector3D(), (Vector3DReadOnly)jointAxis);
        RigidBody r2 = new RigidBody("r2", (JointBasics)j2, (Matrix3DReadOnly)this.getRandomDiagonalMatrix(random), random.nextDouble(), (Tuple3DReadOnly)this.getRandomVector(random));
        SpatialAcceleration rootAcceleration = new SpatialAcceleration((ReferenceFrame)elevatorFrame, worldFrame, (ReferenceFrame)elevatorFrame);
        SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)elevator, ReferenceFrame.getWorldFrame());
        spatialAccelerationCalculator.setRootAcceleration((SpatialAccelerationReadOnly)rootAcceleration);
        CenterOfMassAccelerationCalculator comAccelerationCalculator = new CenterOfMassAccelerationCalculator((RigidBodyBasics)elevator, spatialAccelerationCalculator);
        double qdd1 = random.nextDouble();
        double m1 = r1.getInertia().getMass();
        double m2 = r2.getInertia().getMass();
        double qdd2 = -(m1 + m2) * qdd1 / m2;
        j1.setQ(random.nextDouble());
        j2.setQ(random.nextDouble());
        j1.setQd(random.nextDouble());
        j2.setQd(random.nextDouble());
        j1.setQdd(qdd1);
        j2.setQdd(qdd2);
        elevator.updateFramesRecursively();
        spatialAccelerationCalculator.reset();
        FrameVector3D comAcceleration = new FrameVector3D(ReferenceFrame.getWorldFrame());
        comAccelerationCalculator.getCoMAcceleration(comAcceleration);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(), (EuclidGeometry)comAcceleration, (double)1.0E-5);
    }

    @Test
    public void testPendulumCentripetalAcceleration() {
        Random random = new Random(1779L);
        double mass = random.nextDouble();
        double qd = random.nextDouble();
        double length = 3.0;
        Vector3D comOffset = new Vector3D(0.0, 0.0, length);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        MovingReferenceFrame elevatorFrame = elevator.getBodyFixedFrame();
        Vector3D jointAxis = new Vector3D(0.0, 1.0, 0.0);
        RevoluteJoint j1 = new RevoluteJoint("j1", (RigidBodyBasics)elevator, (Tuple3DReadOnly)new Vector3D(), (Vector3DReadOnly)jointAxis);
        new RigidBody("r1", (JointBasics)j1, (Matrix3DReadOnly)this.getRandomDiagonalMatrix(random), mass, (Tuple3DReadOnly)comOffset);
        j1.setQ(random.nextDouble());
        j1.setQd(qd);
        j1.setQdd(0.0);
        elevator.updateFramesRecursively();
        SpatialAcceleration rootAcceleration = new SpatialAcceleration((ReferenceFrame)elevatorFrame, worldFrame, (ReferenceFrame)elevatorFrame);
        SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)elevator, ReferenceFrame.getWorldFrame());
        spatialAccelerationCalculator.setRootAcceleration((SpatialAccelerationReadOnly)rootAcceleration);
        CenterOfMassAccelerationCalculator comAccelerationCalculator = new CenterOfMassAccelerationCalculator((RigidBodyBasics)elevator, spatialAccelerationCalculator);
        spatialAccelerationCalculator.reset();
        FrameVector3D comAcceleration = new FrameVector3D(worldFrame);
        comAccelerationCalculator.getCoMAcceleration(comAcceleration);
        Assert.assertEquals(length * qd * qd, comAcceleration.length(), 1.0E-5);
    }

    @Test
    public void testTree() {
        Random random = new Random(1779L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        MovingReferenceFrame elevatorFrame = elevator.getBodyFixedFrame();
        Vector3D jointAxis = new Vector3D(1.0, 0.0, 0.0);
        PrismaticJoint j1 = new PrismaticJoint("j1", (RigidBodyBasics)elevator, (Tuple3DReadOnly)new Vector3D(), (Vector3DReadOnly)jointAxis);
        new RigidBody("r1", (JointBasics)j1, (Matrix3DReadOnly)this.getRandomDiagonalMatrix(random), random.nextDouble(), (Tuple3DReadOnly)this.getRandomVector(random));
        PrismaticJoint j2 = new PrismaticJoint("j2", (RigidBodyBasics)elevator, (Tuple3DReadOnly)new Vector3D(), (Vector3DReadOnly)jointAxis);
        new RigidBody("r2", (JointBasics)j2, (Matrix3DReadOnly)this.getRandomDiagonalMatrix(random), random.nextDouble(), (Tuple3DReadOnly)this.getRandomVector(random));
        SpatialAcceleration rootAcceleration = new SpatialAcceleration((ReferenceFrame)elevatorFrame, worldFrame, (ReferenceFrame)elevatorFrame);
        SpatialAccelerationCalculator spatialAccelerationCalculator = new SpatialAccelerationCalculator((RigidBodyReadOnly)elevator, ReferenceFrame.getWorldFrame());
        spatialAccelerationCalculator.setRootAcceleration((SpatialAccelerationReadOnly)rootAcceleration);
        CenterOfMassAccelerationCalculator comAccelerationCalculator = new CenterOfMassAccelerationCalculator((RigidBodyBasics)elevator, spatialAccelerationCalculator);
        spatialAccelerationCalculator.reset();
        FrameVector3D comAcceleration = new FrameVector3D(ReferenceFrame.getWorldFrame());
        comAccelerationCalculator.getCoMAcceleration(comAcceleration);
    }

    private Vector3D getRandomVector(Random random) {
        return new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
    }

    private Matrix3D getRandomDiagonalMatrix(Random random) {
        Matrix3D ret = new Matrix3D();
        ret.setM00(random.nextDouble());
        ret.setM11(random.nextDouble());
        ret.setM22(random.nextDouble());
        return ret;
    }
}

