/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class PoseReferenceFrameTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testAsynchronousUpdatesOne() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame poseFrame0 = new PoseReferenceFrame("poseFrame0", worldFrame);
        PoseReferenceFrame poseFrame00 = new PoseReferenceFrame("poseFrame00", (ReferenceFrame)poseFrame0);
        PoseReferenceFrame poseFrame000 = new PoseReferenceFrame("poseFrame000", (ReferenceFrame)poseFrame00);
        FramePoint3D framePoint = new FramePoint3D((ReferenceFrame)poseFrame000, 1.0, 2.8, 4.4);
        Random random = new Random(1776L);
        this.doRandomPoseChangeAndUpdate(poseFrame0, random);
        this.doRandomPoseChangeAndUpdate(poseFrame00, random);
        this.doRandomPoseChangeAndUpdate(poseFrame000, random);
        FramePoint3D framePointInWorldOne = new FramePoint3D((FrameTuple3DReadOnly)framePoint);
        framePointInWorldOne.changeFrame(worldFrame);
        this.doRandomPoseChangeAndUpdate(poseFrame0, random);
        FramePoint3D framePointInWorldTwo = new FramePoint3D((FrameTuple3DReadOnly)framePoint);
        framePointInWorldTwo.changeFrame(worldFrame);
        Assert.assertFalse(framePointInWorldOne.epsilonEquals((EuclidFrameGeometry)framePointInWorldTwo, 1.0E-7));
        poseFrame0.update();
        poseFrame00.update();
        poseFrame000.update();
        FramePoint3D framePointInWorldThree = new FramePoint3D((FrameTuple3DReadOnly)framePoint);
        framePointInWorldThree.changeFrame(worldFrame);
        Assert.assertTrue(framePointInWorldThree.epsilonEquals((EuclidFrameGeometry)framePointInWorldTwo, 1.0E-7));
    }

    @Test
    public void testLongChainEfficiency() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        int numberOfFramesInChain = 100;
        ReferenceFrame previousFrame = worldFrame;
        for (int i = 0; i < numberOfFramesInChain; ++i) {
            PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame" + i, previousFrame);
            poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)new FramePoint3D(previousFrame, 1.0, 0.0, 0.0));
            previousFrame = poseFrame;
        }
        FramePoint3D finalPosition = new FramePoint3D(previousFrame);
        finalPosition.changeFrame(worldFrame);
        long startTime = System.currentTimeMillis();
        int numberOfChangeFrames = 1000000;
        for (int i = 0; i < numberOfChangeFrames; ++i) {
            FramePoint3D finalPosition2 = new FramePoint3D(previousFrame);
            finalPosition2.changeFrame(worldFrame);
        }
        long endTime = System.currentTimeMillis();
        double millisPerChangeFrame = (double)(endTime - startTime) / (double)numberOfChangeFrames;
        System.out.println("millisPerChangeFrame = " + millisPerChangeFrame);
        Assert.assertTrue(millisPerChangeFrame < 0.01);
        FramePoint3D finalPosition3 = new FramePoint3D(previousFrame);
        finalPosition3.changeFrame(worldFrame);
    }

    @Test
    public void testAsynchronousUpdatesTwo() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame poseFrame0 = new PoseReferenceFrame("poseFrame0", worldFrame);
        PoseReferenceFrame poseFrame00 = new PoseReferenceFrame("poseFrame00", (ReferenceFrame)poseFrame0);
        PoseReferenceFrame poseFrame01 = new PoseReferenceFrame("poseFrame01", (ReferenceFrame)poseFrame0);
        PoseReferenceFrame poseFrame010 = new PoseReferenceFrame("poseFrame010", (ReferenceFrame)poseFrame01);
        PoseReferenceFrame poseFrame000 = new PoseReferenceFrame("poseFrame000", (ReferenceFrame)poseFrame00);
        PoseReferenceFrame poseFrame001 = new PoseReferenceFrame("poseFrame001", (ReferenceFrame)poseFrame00);
        PoseReferenceFrame poseFrame1 = new PoseReferenceFrame("poseFrame1", worldFrame);
        PoseReferenceFrame poseFrame10 = new PoseReferenceFrame("poseFrame10", (ReferenceFrame)poseFrame1);
        PoseReferenceFrame poseFrame100 = new PoseReferenceFrame("poseFrame100", (ReferenceFrame)poseFrame10);
        PoseReferenceFrame poseFrame101 = new PoseReferenceFrame("poseFrame101", (ReferenceFrame)poseFrame10);
        PoseReferenceFrame[] referenceFrames = new PoseReferenceFrame[]{poseFrame0, poseFrame00, poseFrame01, poseFrame010, poseFrame000, poseFrame001, poseFrame1, poseFrame10, poseFrame100, poseFrame101};
        Point3D position = new Point3D(1.0, 2.2, 3.4);
        FramePoint3D framePoint = new FramePoint3D((ReferenceFrame)poseFrame010, (Tuple3DReadOnly)position);
        this.updateAllFrames(referenceFrames);
        Random random = new Random(1776L);
        FramePoint3D newPoint = this.doRandomChangeFrames(referenceFrames, framePoint, random);
        newPoint.changeFrame(framePoint.getReferenceFrame());
        Assert.assertTrue(newPoint.epsilonEquals((EuclidFrameGeometry)framePoint, 1.0E-7));
        this.doRandomPoseChangeAndUpdate(poseFrame01, random);
        newPoint = this.doRandomChangeFrames(referenceFrames, framePoint, random);
        FramePoint3D newPointInWorldOne = new FramePoint3D((FrameTuple3DReadOnly)newPoint);
        newPointInWorldOne.changeFrame(worldFrame);
        this.updateAllFrames(referenceFrames);
        FramePoint3D newPointInWorldTwo = new FramePoint3D((FrameTuple3DReadOnly)newPoint);
        newPointInWorldTwo.changeFrame(worldFrame);
        Assert.assertTrue(newPointInWorldOne.epsilonEquals((EuclidFrameGeometry)newPointInWorldTwo, 1.0E-7));
    }

    private void updateAllFrames(PoseReferenceFrame[] referenceFrames) {
        for (PoseReferenceFrame poseReferenceFrame : referenceFrames) {
            poseReferenceFrame.update();
        }
    }

    private void doRandomPoseChangeAndUpdate(PoseReferenceFrame poseReferenceFrame, Random random) {
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        FramePose3D framePose = new FramePose3D(poseReferenceFrame.getParent(), (RigidBodyTransformReadOnly)transform);
        poseReferenceFrame.setPoseAndUpdate((FramePose3DReadOnly)framePose);
    }

    private FramePoint3D doRandomChangeFrames(PoseReferenceFrame[] referenceFrames, FramePoint3D framePoint, Random random) {
        for (int i = 0; i < 10; ++i) {
            int index = random.nextInt(referenceFrames.length);
            PoseReferenceFrame desiredFrame = referenceFrames[index];
            framePoint = new FramePoint3D((FrameTuple3DReadOnly)framePoint);
            framePoint.changeFrame((ReferenceFrame)desiredFrame);
        }
        return framePoint;
    }
}

