/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.occupancyGrid;

import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.occupancyGrid.OccupancyGrid;
import us.ihmc.robotics.occupancyGrid.OccupancyGridCell;
import us.ihmc.yoVariables.registry.YoRegistry;

public class OccupancyGridTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @Test
    public void testDuplicatePoints() {
        OccupancyGrid occupancyGrid = new OccupancyGrid("", worldFrame, new YoRegistry("test"));
        Assert.assertEquals(1L, occupancyGrid.registerPoint((FramePoint2DReadOnly)new FramePoint2D()));
        Assert.assertEquals(1L, occupancyGrid.registerPoint((FramePoint2DReadOnly)new FramePoint2D()));
        Assert.assertTrue(occupancyGrid.occupancyCellMap.containsKey(OccupancyGridCell.computeHashCode((int)0, (int)0)));
        Assert.assertEquals(1L, occupancyGrid.allCellsPool.size());
        Assert.assertTrue(occupancyGrid.isCellOccupied(0, 0));
        for (int i = 0; i < 10; ++i) {
            occupancyGrid.update();
        }
        Assert.assertEquals(1L, occupancyGrid.getNumberOfOccupiedCells());
        double decayRate = 0.1;
        int ticksToBarelyOccupied = (int)Math.floor(Math.log(0.5) / Math.log(1.0 - decayRate));
        occupancyGrid.setOccupancyDecayRate(decayRate);
        for (int i = 0; i < ticksToBarelyOccupied; ++i) {
            occupancyGrid.update();
        }
        Assert.assertTrue(occupancyGrid.isCellOccupied(0, 0));
        occupancyGrid.update();
        Assert.assertFalse(occupancyGrid.isCellOccupied(0, 0));
        occupancyGrid.registerPoint((FramePoint2DReadOnly)new FramePoint2D());
        Assert.assertTrue(occupancyGrid.isCellOccupied(0, 0));
    }

    @Test
    public void testRegisteringFourPoints() {
        OccupancyGrid occupancyGrid = new OccupancyGrid("", worldFrame, new YoRegistry("test"));
        occupancyGrid.registerPoint((FramePoint2DReadOnly)new FramePoint2D(worldFrame, 1.0, 1.0));
        occupancyGrid.registerPoint((FramePoint2DReadOnly)new FramePoint2D(worldFrame, -1.0, 1.0));
        occupancyGrid.registerPoint((FramePoint2DReadOnly)new FramePoint2D(worldFrame, -1.0, -1.0));
        occupancyGrid.registerPoint((FramePoint2DReadOnly)new FramePoint2D(worldFrame, 1.0, -1.0));
        Assert.assertEquals(4L, occupancyGrid.getAllActiveCells().size());
        Assert.assertEquals(4L, occupancyGrid.allCellsPool.size());
        Assert.assertEquals(4L, occupancyGrid.getNumberOfOccupiedCells());
        Assert.assertTrue(occupancyGrid.isCellOccupied(1.0, 1.0));
        Assert.assertTrue(occupancyGrid.isCellOccupied(-1.0, 1.0));
        Assert.assertTrue(occupancyGrid.isCellOccupied(-1.0, -1.0));
        Assert.assertTrue(occupancyGrid.isCellOccupied(1.0, -1.0));
        Assert.assertFalse(occupancyGrid.isCellOccupied(0.0, -1.0));
        Assert.assertFalse(occupancyGrid.isCellOccupied(0.0, 1.0));
        Assert.assertFalse(occupancyGrid.isCellOccupied(1.0, 0.0));
        Assert.assertFalse(occupancyGrid.isCellOccupied(-1.0, 0.0));
        occupancyGrid.reset();
        Assert.assertEquals(0L, occupancyGrid.getAllActiveCells().size());
        Assert.assertFalse(occupancyGrid.isCellOccupied(1.0, 1.0));
        Assert.assertFalse(occupancyGrid.isCellOccupied(-1.0, 1.0));
        Assert.assertFalse(occupancyGrid.isCellOccupied(-1.0, -1.0));
        Assert.assertFalse(occupancyGrid.isCellOccupied(1.0, -1.0));
        Assert.assertEquals(0L, occupancyGrid.getAllActiveCells().size());
        Assert.assertEquals(0L, occupancyGrid.getNumberOfOccupiedCells());
    }

    @Test
    public void testHashMapUniqueness() {
        int hashMap0 = OccupancyGridCell.computeHashCode((int)100, (int)100);
        int hashMap1 = OccupancyGridCell.computeHashCode((int)-100, (int)100);
        int hashMap2 = OccupancyGridCell.computeHashCode((int)-100, (int)-100);
        int hashMap3 = OccupancyGridCell.computeHashCode((int)100, (int)-100);
        Assert.assertFalse(hashMap0 == hashMap1);
        Assert.assertFalse(hashMap0 == hashMap2);
        Assert.assertFalse(hashMap0 == hashMap3);
        Assert.assertFalse(hashMap1 == hashMap2);
        Assert.assertFalse(hashMap1 == hashMap3);
        Assert.assertFalse(hashMap2 == hashMap3);
    }
}

