/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.numericalMethods;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.numericalMethods.QuarticEquationSolver;

public class QuarticEquationSolverTest {
    private static final boolean DEBUG = false;

    @Test
    public void testUpToQuarticEquationSolver() {
        QuarticEquationSolver solver = new QuarticEquationSolver();
        this.printIfDebug("Quatric Equation Solver.  Tests...");
        this.printIfDebug("Test Quadratic Equation Solver First.  Solutions to 3.0x^2 + 2.1x + 9.5 are:");
        double[] solutionRealParts = new double[4];
        double[] solutionImaginaryParts = new double[4];
        solver.solveQuadraticEquation(3.0, 2.1, 9.5, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-0.35, 1.744754042, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-0.35, -1.744754042, solutionRealParts, solutionImaginaryParts);
        this.printIfDebug(solutionRealParts[0] + " + " + solutionImaginaryParts[0] + "i, " + solutionRealParts[1] + " + " + solutionImaginaryParts[1] + "i, ");
        this.printIfDebug("Answer should be   -0.3500000000 + 1.744754042*I,    -0.3500000000 - 1.744754042*I");
        this.printIfDebug("");
        this.printIfDebug("Test Cubic Equation Solver Next.  Solutions to x^3 - x^2 + x -1 are:");
        solver.solveCubicEquation(-1.0, 1.0, -1.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(0.0, 1.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(0.0, -1.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(1.0, 0.0, solutionRealParts, solutionImaginaryParts);
        this.printIfDebug(solutionRealParts[0] + " + " + solutionImaginaryParts[0] + "i, " + solutionRealParts[1] + " + " + solutionImaginaryParts[1] + "i, " + solutionRealParts[2] + " + " + solutionImaginaryParts[2] + "i, ");
        this.printIfDebug("Answer should be   1.0,    I,    -I");
        this.printIfDebug("");
        this.printIfDebug("Test another Cubic Equation Solver Next.  Solutions to x^3 + 6x^2 + 9x + 6 are:");
        solver.solveCubicEquation(6.0, 9.0, 6.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-4.195823345, 0.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-0.9020883273, -0.7850032632, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-0.9020883273, 0.7850032632, solutionRealParts, solutionImaginaryParts);
        this.printIfDebug(solutionRealParts[0] + " + " + solutionImaginaryParts[0] + "i, " + solutionRealParts[1] + " + " + solutionImaginaryParts[1] + "i, " + solutionRealParts[2] + " + " + solutionImaginaryParts[2] + "i, ");
        this.printIfDebug("Answer should be -4.195823345,   -.9020883273-.7850032632*I,   -.9020883273+.7850032632*I");
        this.printIfDebug("");
        this.printIfDebug("Test another Cubic Equation Solver Next.  Solutions to x^3 - 1 are:");
        solver.solveCubicEquation(0.0, 0.0, -1.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-0.5, 0.8660254038, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-0.5, -0.8660254038, solutionRealParts, solutionImaginaryParts);
        this.printIfDebug(solutionRealParts[0] + " + " + solutionImaginaryParts[0] + "i, " + solutionRealParts[1] + " + " + solutionImaginaryParts[1] + "i, " + solutionRealParts[2] + " + " + solutionImaginaryParts[2] + "i, ");
        this.printIfDebug("Answer should be 1.0,  -0.5000000000 + 0.8660254038*I,   -0.5000000000 - 0.8660254038*I");
        this.printIfDebug("");
        this.printIfDebug("Test another Cubic Equation Solver Next.  Solutions to x^3 + 2x^2 - 5x - 6 are:");
        solver.solveCubicEquation(2.0, -5.0, -6.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-1.0, 0.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(2.0, 0.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-3.0, 0.0, solutionRealParts, solutionImaginaryParts);
        this.printIfDebug(solutionRealParts[0] + " + " + solutionImaginaryParts[0] + "i, " + solutionRealParts[1] + " + " + solutionImaginaryParts[1] + "i, " + solutionRealParts[2] + " + " + solutionImaginaryParts[2] + "i, ");
        this.printIfDebug("Answer should be: -1, 2, -3");
        this.printIfDebug("");
    }

    @Disabled
    @Test
    public void testQuarticEquationSolver() {
        QuarticEquationSolver solver = new QuarticEquationSolver();
        double[] solutionRealParts = new double[4];
        double[] solutionImaginaryParts = new double[4];
        this.printIfDebug("Test Quartic Equation Solver.  Solutions to x^4 + 6x^3 - 5x^2 - 10x -3 are:");
        solver.solveQuarticEquation(6.0, -5.0, -10.0, -3.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(1.618033989, 0.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-0.6180339888, 0.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-0.4586187348, 0.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-6.541381265, 0.0, solutionRealParts, solutionImaginaryParts);
        this.printIfDebug(solutionRealParts[0] + " + " + solutionImaginaryParts[0] + "i, " + solutionRealParts[1] + " + " + solutionImaginaryParts[1] + "i, " + solutionRealParts[2] + " + " + solutionImaginaryParts[2] + "i, " + solutionRealParts[3] + " + " + solutionImaginaryParts[3] + "i, ");
        this.printIfDebug("Answer should be:  1.618033989,   -0.6180339888,   -0.4586187348,   -6.541381265");
        this.printIfDebug("");
        this.printIfDebug("Test Quartic Equation Solver.  Given the real solutions a, b, c, d construct the equation:");
        double a = 1.77;
        double b = 0.34;
        double c = 0.99;
        double d = 12.3;
        double x3 = a + b + c + d;
        double x2 = a * b + a * c + a * d + b * c + b * d + c * d;
        double x1 = a * b * c + a * b * d + a * c * d + b * d * c;
        double x0 = a * b * c * d;
        solver.solveQuarticEquation(x3, x2, x1, x0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-a, 0.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-b, 0.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-c, 0.0, solutionRealParts, solutionImaginaryParts);
        this.assertSolutionContains(-d, 0.0, solutionRealParts, solutionImaginaryParts);
    }

    private void printIfDebug(String string) {
    }

    private void assertSolutionContains(double realPart, double imaginaryPart, double[] realSolutions, double[] imaginarySolutions) {
        for (int i = 0; i < realSolutions.length; ++i) {
            if (!(Math.abs(realSolutions[i] - realPart) < 1.0E-7) || !(Math.abs(imaginarySolutions[i] - imaginaryPart) < 1.0E-7)) continue;
            return;
        }
        String errorMessage = "Cannot find " + realPart + " + " + imaginaryPart + " I. Solutions are: ";
        for (int i = 0; i < realSolutions.length; ++i) {
            errorMessage = errorMessage + "\n " + realSolutions[i] + " + " + imaginarySolutions[i] + " I";
        }
        Assert.fail(errorMessage);
    }
}

