/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.numericalMethods;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.numericalMethods.NewtonRaphsonMethod;

public class NewtonRaphsonMethodTest {
    private static final boolean VERBOSE = false;

    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testThirdOrderPolynomial() {
        int maxIterations = 100;
        double epsilon = 1.0E-7;
        NewtonRaphsonMethod newt = new NewtonRaphsonMethod(maxIterations, epsilon);
        double x = 0.0;
        while (!newt.stop()) {
            newt.update(x, this.thirdOrderPolynomial(x));
            x = newt.nextX();
        }
        this.assertEpsilonEquals(this.thirdOrderPolynomial(x), 0.0, epsilon);
    }

    private double thirdOrderPolynomial(double x) {
        double a0 = 1.0;
        double a1 = 3.0;
        double a2 = -2.0;
        double a3 = 4.0;
        double ret = a0 + a1 * x + a2 * x * x + a3 * x * x * x;
        return ret;
    }

    private double weirdFunction(double lambda2, double r1, double r2) {
        double alpha = 1.0;
        double lambda1 = r1 * lambda2 / (r2 * (1.0 - Math.exp(-lambda2)) - lambda2);
        double A = r1 / lambda1;
        double B = r2 / (lambda2 * Math.exp(lambda2));
        double C = -(A + B);
        double ret = A * Math.exp(lambda1 * alpha) + B * Math.exp(lambda2 * alpha) + C - 1.0;
        return ret;
    }

    private void assertEpsilonEquals(double value, double checkValue, double epsilon) {
        Assert.assertTrue("Function value is not approximately zero, value = " + value + ", checkValue = " + checkValue, Math.abs(value - checkValue) < epsilon);
    }
}

