/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSO3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.SO3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.YoFrameSO3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.FrameSO3TrajectoryPointTest;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoFrameSO3TrajectoryPointTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testCommonUsageExample() {
        String namePrefix = "point";
        String nameSuffix = "toTest";
        YoRegistry registry = new YoRegistry("myRegistry");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        YoFrameSO3TrajectoryPoint yoFrameSO3TrajectoryPoint = new YoFrameSO3TrajectoryPoint(namePrefix, nameSuffix, registry);
        SO3TrajectoryPoint simpleTrajectoryPoint = new SO3TrajectoryPoint();
        double time = 3.4;
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        orientation.normalize();
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleTrajectoryPoint.set(time, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)angularVelocity);
        yoFrameSO3TrajectoryPoint.setIncludingFrame(worldFrame, (SO3TrajectoryPointReadOnly)simpleTrajectoryPoint);
        yoFrameSO3TrajectoryPoint.changeFrame((ReferenceFrame)poseFrame);
        RigidBodyTransform transformToPoseFrame = worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame);
        orientation.applyTransform((Transform)transformToPoseFrame);
        transformToPoseFrame.transform((Vector3DBasics)angularVelocity);
        namePrefix = "point";
        nameSuffix = "toVerify";
        YoFrameSO3TrajectoryPoint expectedYoFrameSO3TrajectoryPoint = new YoFrameSO3TrajectoryPoint(namePrefix, nameSuffix, registry, (ReferenceFrame)poseFrame);
        expectedYoFrameSO3TrajectoryPoint.setTime(time);
        expectedYoFrameSO3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)orientation);
        expectedYoFrameSO3TrajectoryPoint.getAngularVelocity().set((Tuple3DReadOnly)angularVelocity);
        Assert.assertEquals(3.4, yoFrameSO3TrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertEquals(3.4, expectedYoFrameSO3TrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertTrue(expectedYoFrameSO3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameSO3TrajectoryPoint, 1.0E-10));
    }

    @Test
    public void testConstructor() {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-20;
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = 0.0;
        FrameQuaternion expectedOrientation = new FrameQuaternion(expectedFrame);
        FrameVector3D expectedAngularVelocity = new FrameVector3D(expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameSO3TrajectoryPoint testedYoFrameSO3TrajectoryPoint = new YoFrameSO3TrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSO3TrajectoryPoint, epsilon);
    }

    @Test
    public void testSetters() {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-20;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = 0.0;
        FrameQuaternion expectedOrientation = new FrameQuaternion(expectedFrame);
        FrameVector3D expectedAngularVelocity = new FrameVector3D(expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameSO3TrajectoryPoint testedYoFrameSO3TrajectoryPoint = new YoFrameSO3TrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSO3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedYoFrameSO3TrajectoryPoint.set(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSO3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedYoFrameSO3TrajectoryPoint.set(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSO3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        YoFrameSO3TrajectoryPoint expectedYoFrameSO3TrajectoryPoint = new YoFrameSO3TrajectoryPoint("sdfsd", "asd", new YoRegistry("asawe"), expectedFrame);
        testedYoFrameSO3TrajectoryPoint.set((FrameSO3TrajectoryPointReadOnly)expectedYoFrameSO3TrajectoryPoint);
        Assert.assertTrue(expectedYoFrameSO3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)testedYoFrameSO3TrajectoryPoint, epsilon));
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, testedYoFrameSO3TrajectoryPoint.getReferenceFrame(), testedYoFrameSO3TrajectoryPoint.getTime(), (FrameQuaternionReadOnly)testedYoFrameSO3TrajectoryPoint.getOrientation(), (FrameVector3DReadOnly)testedYoFrameSO3TrajectoryPoint.getAngularVelocity(), testedYoFrameSO3TrajectoryPoint, epsilon);
    }

    @Test
    public void testChangeFrame() throws Exception {
        int i;
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FrameQuaternion expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameSO3TrajectoryPoint testedYoFrameSO3TrajectoryPoint = new YoFrameSO3TrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        testedYoFrameSO3TrajectoryPoint.set(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        ReferenceFrame[] randomFrames = new ReferenceFrame[10];
        randomFrames[0] = worldFrame;
        for (i = 1; i < 10; ++i) {
            randomFrames[i] = EuclidFrameRandomTools.nextReferenceFrame((String)("randomFrame" + i), (Random)random, (ReferenceFrame)(random.nextBoolean() ? worldFrame : randomFrames[random.nextInt(i)]));
        }
        for (i = 0; i < 10000; ++i) {
            expectedFrame = randomFrames[random.nextInt(10)];
            expectedOrientation.changeFrame(expectedFrame);
            expectedAngularVelocity.changeFrame(expectedFrame);
            testedYoFrameSO3TrajectoryPoint.changeFrame(expectedFrame);
            this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSO3TrajectoryPoint, epsilon);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FrameQuaternion expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameSO3TrajectoryPoint testedYoFrameSO3TrajectoryPoint = new YoFrameSO3TrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        testedYoFrameSO3TrajectoryPoint.set(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        expectedTime = 0.0;
        expectedOrientation.setToZero();
        expectedAngularVelocity.setToZero();
        testedYoFrameSO3TrajectoryPoint.setToZero();
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSO3TrajectoryPoint, epsilon);
        expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"blop", (Random)random, (ReferenceFrame)worldFrame);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        testedYoFrameSO3TrajectoryPoint.setToZero(worldFrame);
        testedYoFrameSO3TrajectoryPoint.set(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        expectedTime = 0.0;
        expectedOrientation.setToZero(expectedFrame);
        expectedAngularVelocity.setToZero(expectedFrame);
        testedYoFrameSO3TrajectoryPoint.setToZero(expectedFrame);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSO3TrajectoryPoint, epsilon);
    }

    @Test
    public void testSetToNaN() throws Exception {
        ReferenceFrame worldFrame;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FrameQuaternion expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameSO3TrajectoryPoint testedYoFrameSO3TrajectoryPoint = new YoFrameSO3TrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        testedYoFrameSO3TrajectoryPoint.set(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedYoFrameSO3TrajectoryPoint.setToNaN();
        Assert.assertTrue(Double.isNaN(testedYoFrameSO3TrajectoryPoint.getTime()));
        Assert.assertTrue(testedYoFrameSO3TrajectoryPoint.getOrientation().containsNaN());
        Assert.assertTrue(testedYoFrameSO3TrajectoryPoint.getAngularVelocity().containsNaN());
        expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"blop", (Random)random, (ReferenceFrame)worldFrame);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        testedYoFrameSO3TrajectoryPoint.setToZero(worldFrame);
        testedYoFrameSO3TrajectoryPoint.set(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedYoFrameSO3TrajectoryPoint.setToNaN(expectedFrame);
        Assert.assertTrue(expectedFrame == testedYoFrameSO3TrajectoryPoint.getReferenceFrame());
        Assert.assertTrue(Double.isNaN(testedYoFrameSO3TrajectoryPoint.getTime()));
        Assert.assertTrue(testedYoFrameSO3TrajectoryPoint.getOrientation().containsNaN());
        Assert.assertTrue(testedYoFrameSO3TrajectoryPoint.getAngularVelocity().containsNaN());
    }

    private void assertWaypointContainsExpectedData(String expectedNamePrefix, String expectedNameSuffix, ReferenceFrame expectedFrame, double expectedTime, FrameQuaternionReadOnly expectedOrientation, FrameVector3DReadOnly expectedAngularVelocity, YoFrameSO3TrajectoryPoint testedYoFrameSO3TrajectoryPoint, double epsilon) {
        Assert.assertTrue(expectedFrame == testedYoFrameSO3TrajectoryPoint.getReferenceFrame());
        Assert.assertEquals(expectedTime, testedYoFrameSO3TrajectoryPoint.getTime(), epsilon);
        Assert.assertEquals(expectedNamePrefix, testedYoFrameSO3TrajectoryPoint.getNamePrefix());
        Assert.assertEquals(expectedNameSuffix, testedYoFrameSO3TrajectoryPoint.getNameSuffix());
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedOrientation, (EuclidFrameGeometry)testedYoFrameSO3TrajectoryPoint.getOrientation(), (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedAngularVelocity, (EuclidFrameGeometry)testedYoFrameSO3TrajectoryPoint.getAngularVelocity(), (double)epsilon);
        FrameSO3TrajectoryPoint actualFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint();
        actualFrameSO3TrajectoryPoint.setIncludingFrame((FrameSO3TrajectoryPointReadOnly)testedYoFrameSO3TrajectoryPoint);
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, expectedOrientation, expectedAngularVelocity, actualFrameSO3TrajectoryPoint, epsilon);
        actualFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint(expectedFrame);
        actualFrameSO3TrajectoryPoint.set((FrameSO3TrajectoryPointReadOnly)testedYoFrameSO3TrajectoryPoint);
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, expectedOrientation, expectedAngularVelocity, actualFrameSO3TrajectoryPoint, epsilon);
        Quaternion actualOrientation = new Quaternion();
        Vector3D actualAngularVelocity = new Vector3D();
        actualOrientation.set((QuaternionReadOnly)testedYoFrameSO3TrajectoryPoint.getOrientation());
        actualAngularVelocity.set((Tuple3DReadOnly)testedYoFrameSO3TrajectoryPoint.getAngularVelocity());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedOrientation, (EuclidGeometry)actualOrientation, (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularVelocity, (EuclidGeometry)actualAngularVelocity, (double)epsilon);
        FrameQuaternion actualFrameOrientation = new FrameQuaternion(expectedFrame);
        FrameVector3D actualFrameAngularVelocity = new FrameVector3D(expectedFrame);
        actualFrameOrientation.set((FrameQuaternionReadOnly)testedYoFrameSO3TrajectoryPoint.getOrientation());
        actualFrameAngularVelocity.set((FrameTuple3DReadOnly)testedYoFrameSO3TrajectoryPoint.getAngularVelocity());
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedOrientation, (EuclidFrameGeometry)actualFrameOrientation, (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedAngularVelocity, (EuclidFrameGeometry)actualFrameAngularVelocity, (double)epsilon);
        actualFrameOrientation = new FrameQuaternion();
        actualFrameAngularVelocity = new FrameVector3D();
        actualFrameOrientation.setIncludingFrame((FrameQuaternionReadOnly)testedYoFrameSO3TrajectoryPoint.getOrientation());
        actualFrameAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)testedYoFrameSO3TrajectoryPoint.getAngularVelocity());
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedOrientation, (EuclidFrameGeometry)actualFrameOrientation, (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedAngularVelocity, (EuclidFrameGeometry)actualFrameAngularVelocity, (double)epsilon);
    }

    @Test
    public void testSomeSetsAngGets() {
        String namePrefix = "point";
        String nameSuffix = "toTest";
        YoRegistry registry = new YoRegistry("myRegistry");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoFrameSO3TrajectoryPoint yoFrameSO3TrajectoryPoint = new YoFrameSO3TrajectoryPoint(namePrefix, nameSuffix, registry, worldFrame);
        yoFrameSO3TrajectoryPoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        SO3TrajectoryPoint simpleTrajectoryPoint = new SO3TrajectoryPoint();
        double time = 3.4;
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        orientation.normalize();
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleTrajectoryPoint.set(time, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)angularVelocity);
        yoFrameSO3TrajectoryPoint.setIncludingFrame(worldFrame, (SO3TrajectoryPointReadOnly)simpleTrajectoryPoint);
        YoFrameQuaternion quaternionForVerification = new YoFrameQuaternion("quaternionForVerification", worldFrame, registry);
        YoFrameVector3D angularVelocityForVerification = new YoFrameVector3D("angularVelocityForVerification", worldFrame, registry);
        quaternionForVerification.set((FrameQuaternionReadOnly)yoFrameSO3TrajectoryPoint.getOrientation());
        angularVelocityForVerification.set((FrameTuple3DReadOnly)yoFrameSO3TrajectoryPoint.getAngularVelocity());
        Assert.assertEquals(time, yoFrameSO3TrajectoryPoint.getTime(), 1.0E-10);
        Assert.assertTrue(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-10));
        Assert.assertTrue(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-10));
        Assert.assertFalse(yoFrameSO3TrajectoryPoint.containsNaN());
        yoFrameSO3TrajectoryPoint.getOrientation().setToNaN();
        Assert.assertTrue(yoFrameSO3TrajectoryPoint.containsNaN());
        yoFrameSO3TrajectoryPoint.getOrientation().setToZero();
        Assert.assertFalse(yoFrameSO3TrajectoryPoint.containsNaN());
        yoFrameSO3TrajectoryPoint.getAngularVelocity().setToNaN();
        Assert.assertTrue(yoFrameSO3TrajectoryPoint.containsNaN());
        yoFrameSO3TrajectoryPoint.getAngularVelocity().setToZero();
        Assert.assertFalse(yoFrameSO3TrajectoryPoint.containsNaN());
        orientation.set((QuaternionReadOnly)yoFrameSO3TrajectoryPoint.getOrientation());
        angularVelocity.set((Tuple3DReadOnly)yoFrameSO3TrajectoryPoint.getAngularVelocity());
        Assert.assertTrue(orientation.epsilonEquals((EuclidGeometry)new Quaternion(), 1.0E-10));
        Assert.assertTrue(angularVelocity.epsilonEquals((EuclidGeometry)new Vector3D(), 1.0E-10));
        time = 9.9;
        quaternionForVerification.setYawPitchRoll(0.2, 0.6, 1.1);
        angularVelocityForVerification.set(7.1, 2.2, 3.33);
        Assert.assertFalse(Math.abs(yoFrameSO3TrajectoryPoint.getTime() - time) < 1.0E-7);
        Assert.assertFalse(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-7));
        Assert.assertFalse(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-7));
        yoFrameSO3TrajectoryPoint.set(time, (FrameOrientation3DReadOnly)quaternionForVerification, (FrameVector3DReadOnly)angularVelocityForVerification);
        orientation.set((QuaternionReadOnly)yoFrameSO3TrajectoryPoint.getOrientation());
        angularVelocity.set((Tuple3DReadOnly)yoFrameSO3TrajectoryPoint.getAngularVelocity());
        Assert.assertEquals(time, yoFrameSO3TrajectoryPoint.getTime(), 1.0E-10);
        Assert.assertTrue(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-10));
        Assert.assertTrue(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-10));
        YoFrameSO3TrajectoryPoint yoFrameSO3TrajectoryPointTwo = new YoFrameSO3TrajectoryPoint(namePrefix, nameSuffix + "Two", registry, worldFrame);
        Assert.assertFalse(yoFrameSO3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameSO3TrajectoryPointTwo, 1.0E-7));
        yoFrameSO3TrajectoryPointTwo.set((FrameSO3TrajectoryPointReadOnly)yoFrameSO3TrajectoryPoint);
        Assert.assertTrue(yoFrameSO3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameSO3TrajectoryPointTwo, 1.0E-7));
        SO3TrajectoryPoint simplePoint = new SO3TrajectoryPoint();
        simplePoint.set((SO3TrajectoryPointReadOnly)yoFrameSO3TrajectoryPoint);
        yoFrameSO3TrajectoryPoint.setToNaN();
        Assert.assertTrue(yoFrameSO3TrajectoryPoint.containsNaN());
        Assert.assertFalse(yoFrameSO3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameSO3TrajectoryPointTwo, 1.0E-7));
        SO3TrajectoryPoint trajectoryPointAsInterface = simplePoint;
        yoFrameSO3TrajectoryPoint.set((SO3TrajectoryPointReadOnly)trajectoryPointAsInterface);
        Assert.assertTrue(yoFrameSO3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameSO3TrajectoryPointTwo, 1.0E-7));
        String string = yoFrameSO3TrajectoryPoint.toString();
        String expectedString = "SO3 trajectory point: [time= 9.900, orientation=( 0.472,  0.301, -0.072,  0.826 ), angular velocity=( 7.100,  2.200,  3.330 )] - World";
        Assert.assertEquals(expectedString, string);
    }

    @Test
    public void testSomeMoreSettersAndGetters() {
        String namePrefix = "point";
        String nameSuffix = "toTest";
        YoRegistry registry = new YoRegistry("myRegistry");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoFrameSO3TrajectoryPoint yoFrameSO3TrajectoryPoint = new YoFrameSO3TrajectoryPoint(namePrefix, nameSuffix, registry, worldFrame);
        yoFrameSO3TrajectoryPoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        double time = 3.4;
        FrameQuaternion orientation = new FrameQuaternion(worldFrame, (QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        FrameVector3D angularVelocity = new FrameVector3D(worldFrame, 1.7, 8.4, 2.2);
        yoFrameSO3TrajectoryPoint.setTime(time);
        yoFrameSO3TrajectoryPoint.getOrientation().set((FrameOrientation3DReadOnly)orientation);
        yoFrameSO3TrajectoryPoint.getAngularVelocity().set((FrameTuple3DReadOnly)angularVelocity);
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        yoFrameSO3TrajectoryPoint.changeFrame((ReferenceFrame)poseFrame);
        Assert.assertFalse(orientation.epsilonEquals((EuclidFrameGeometry)yoFrameSO3TrajectoryPoint.getOrientation(), 1.0E-10));
        Assert.assertFalse(angularVelocity.epsilonEquals((EuclidFrameGeometry)yoFrameSO3TrajectoryPoint.getAngularVelocity(), 1.0E-10));
        orientation.changeFrame((ReferenceFrame)poseFrame);
        angularVelocity.changeFrame((ReferenceFrame)poseFrame);
        Assert.assertTrue(orientation.epsilonEquals((EuclidFrameGeometry)yoFrameSO3TrajectoryPoint.getOrientation(), 1.0E-10));
        Assert.assertTrue(angularVelocity.epsilonEquals((EuclidFrameGeometry)yoFrameSO3TrajectoryPoint.getAngularVelocity(), 1.0E-10));
        YoFrameSO3TrajectoryPoint yoFrameSO3TrajectoryPointTwo = new YoFrameSO3TrajectoryPoint(namePrefix, nameSuffix + "Two", registry, (ReferenceFrame)poseFrame);
        yoFrameSO3TrajectoryPointTwo.setTime(time);
        yoFrameSO3TrajectoryPointTwo.getOrientation().set((FrameOrientation3DReadOnly)orientation);
        yoFrameSO3TrajectoryPointTwo.getAngularVelocity().set((FrameTuple3DReadOnly)angularVelocity);
        Assert.assertTrue(yoFrameSO3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)yoFrameSO3TrajectoryPointTwo, 1.0E-10));
    }
}

