/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.SE3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.YoFrameSE3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSE3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SE3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.FrameSE3TrajectoryPointTest;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoFrameSE3TrajectoryPointTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testCommonUsageExample() {
        String namePrefix = "point";
        String nameSuffix = "toTest";
        YoRegistry registry = new YoRegistry("myRegistry");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        YoFrameSE3TrajectoryPoint yoFrameSE3TrajectoryPoint = new YoFrameSE3TrajectoryPoint(namePrefix, nameSuffix, registry);
        SE3TrajectoryPoint simpleTrajectoryPoint = new SE3TrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        orientation.normalize();
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleTrajectoryPoint.set(time, (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)linearVelocity, (Vector3DReadOnly)angularVelocity);
        yoFrameSE3TrajectoryPoint.setIncludingFrame(worldFrame, (SE3TrajectoryPointReadOnly)simpleTrajectoryPoint);
        yoFrameSE3TrajectoryPoint.changeFrame((ReferenceFrame)poseFrame);
        RigidBodyTransform transformToPoseFrame = worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame);
        transformToPoseFrame.transform((Point3DBasics)position);
        orientation.applyTransform((Transform)transformToPoseFrame);
        transformToPoseFrame.transform((Vector3DBasics)linearVelocity);
        transformToPoseFrame.transform((Vector3DBasics)angularVelocity);
        namePrefix = "point";
        nameSuffix = "toVerify";
        YoFrameSE3TrajectoryPoint expectedYoFrameSE3TrajectoryPoint = new YoFrameSE3TrajectoryPoint(namePrefix, nameSuffix, registry, (ReferenceFrame)poseFrame);
        expectedYoFrameSE3TrajectoryPoint.setTime(time);
        expectedYoFrameSE3TrajectoryPoint.getPosition().set((Tuple3DReadOnly)position);
        expectedYoFrameSE3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)orientation);
        expectedYoFrameSE3TrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)linearVelocity);
        expectedYoFrameSE3TrajectoryPoint.getAngularVelocity().set((Tuple3DReadOnly)angularVelocity);
        Assert.assertEquals(3.4, yoFrameSE3TrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertEquals(3.4, expectedYoFrameSE3TrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertTrue(expectedYoFrameSE3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPoint, 1.0E-10));
    }

    @Test
    public void testConstructor() {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-20;
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = 0.0;
        FramePoint3D expectedPosition = new FramePoint3D(expectedFrame);
        FrameQuaternion expectedOrientation = new FrameQuaternion(expectedFrame);
        FrameVector3D expectedLinearVelocity = new FrameVector3D(expectedFrame);
        FrameVector3D expectedAngularVelocity = new FrameVector3D(expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameSE3TrajectoryPoint testedYoFrameSE3TrajectoryPoint = new YoFrameSE3TrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSE3TrajectoryPoint, epsilon);
    }

    @Test
    public void testSetters() {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-14;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = 0.0;
        FramePoint3D expectedPosition = new FramePoint3D(expectedFrame);
        FrameQuaternion expectedOrientation = new FrameQuaternion(expectedFrame);
        FrameVector3D expectedLinearVelocity = new FrameVector3D(expectedFrame);
        FrameVector3D expectedAngularVelocity = new FrameVector3D(expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameSE3TrajectoryPoint testedYoFrameSE3TrajectoryPoint = new YoFrameSE3TrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSE3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedYoFrameSE3TrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSE3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedYoFrameSE3TrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSE3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        YoFrameSE3TrajectoryPoint expectedYoFrameSE3TrajectoryPoint = new YoFrameSE3TrajectoryPoint("sdfsd", "asd", new YoRegistry("asawe"), expectedFrame);
        testedYoFrameSE3TrajectoryPoint.set((FrameSE3TrajectoryPointReadOnly)expectedYoFrameSE3TrajectoryPoint);
        Assert.assertTrue(expectedYoFrameSE3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)testedYoFrameSE3TrajectoryPoint, epsilon));
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, testedYoFrameSE3TrajectoryPoint.getReferenceFrame(), testedYoFrameSE3TrajectoryPoint.getTime(), (FramePoint3DReadOnly)testedYoFrameSE3TrajectoryPoint.getPosition(), (FrameQuaternionReadOnly)testedYoFrameSE3TrajectoryPoint.getOrientation(), (FrameVector3DReadOnly)testedYoFrameSE3TrajectoryPoint.getLinearVelocity(), (FrameVector3DReadOnly)testedYoFrameSE3TrajectoryPoint.getAngularVelocity(), testedYoFrameSE3TrajectoryPoint, epsilon);
    }

    @Test
    public void testChangeFrame() throws Exception {
        int i;
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameQuaternion expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameSE3TrajectoryPoint testedYoFrameSE3TrajectoryPoint = new YoFrameSE3TrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        testedYoFrameSE3TrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        ReferenceFrame[] randomFrames = new ReferenceFrame[10];
        randomFrames[0] = worldFrame;
        for (i = 1; i < 10; ++i) {
            randomFrames[i] = EuclidFrameRandomTools.nextReferenceFrame((String)("randomFrame" + i), (Random)random, (ReferenceFrame)(random.nextBoolean() ? worldFrame : randomFrames[random.nextInt(i)]));
        }
        for (i = 0; i < 10000; ++i) {
            expectedFrame = randomFrames[random.nextInt(10)];
            expectedPosition.changeFrame(expectedFrame);
            expectedOrientation.changeFrame(expectedFrame);
            expectedLinearVelocity.changeFrame(expectedFrame);
            expectedAngularVelocity.changeFrame(expectedFrame);
            testedYoFrameSE3TrajectoryPoint.changeFrame(expectedFrame);
            this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSE3TrajectoryPoint, epsilon);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameQuaternion expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameSE3TrajectoryPoint testedYoFrameSE3TrajectoryPoint = new YoFrameSE3TrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        testedYoFrameSE3TrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        expectedTime = 0.0;
        expectedPosition.setToZero();
        expectedOrientation.setToZero();
        expectedLinearVelocity.setToZero();
        expectedAngularVelocity.setToZero();
        testedYoFrameSE3TrajectoryPoint.setToZero();
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSE3TrajectoryPoint, epsilon);
        expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"blop", (Random)random, (ReferenceFrame)worldFrame);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        testedYoFrameSE3TrajectoryPoint.setToZero(worldFrame);
        testedYoFrameSE3TrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        expectedTime = 0.0;
        expectedPosition.setToZero(expectedFrame);
        expectedOrientation.setToZero(expectedFrame);
        expectedLinearVelocity.setToZero(expectedFrame);
        expectedAngularVelocity.setToZero(expectedFrame);
        testedYoFrameSE3TrajectoryPoint.setToZero(expectedFrame);
        this.assertWaypointContainsExpectedData(expectedNamePrefix, expectedNameSuffix, expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedYoFrameSE3TrajectoryPoint, epsilon);
    }

    @Test
    public void testSetToNaN() throws Exception {
        ReferenceFrame worldFrame;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameQuaternion expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        String expectedNamePrefix = "test";
        String expectedNameSuffix = "blop";
        YoFrameSE3TrajectoryPoint testedYoFrameSE3TrajectoryPoint = new YoFrameSE3TrajectoryPoint(expectedNamePrefix, expectedNameSuffix, new YoRegistry("schnoop"), expectedFrame);
        testedYoFrameSE3TrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedYoFrameSE3TrajectoryPoint.setToNaN();
        Assert.assertTrue(Double.isNaN(testedYoFrameSE3TrajectoryPoint.getTime()));
        Assert.assertTrue(testedYoFrameSE3TrajectoryPoint.getPosition().containsNaN());
        Assert.assertTrue(testedYoFrameSE3TrajectoryPoint.getOrientation().containsNaN());
        Assert.assertTrue(testedYoFrameSE3TrajectoryPoint.getLinearVelocity().containsNaN());
        Assert.assertTrue(testedYoFrameSE3TrajectoryPoint.getAngularVelocity().containsNaN());
        expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"blop", (Random)random, (ReferenceFrame)worldFrame);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        testedYoFrameSE3TrajectoryPoint.setToZero(worldFrame);
        testedYoFrameSE3TrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedYoFrameSE3TrajectoryPoint.setToNaN(expectedFrame);
        Assert.assertTrue(expectedFrame == testedYoFrameSE3TrajectoryPoint.getReferenceFrame());
        Assert.assertTrue(Double.isNaN(testedYoFrameSE3TrajectoryPoint.getTime()));
        Assert.assertTrue(testedYoFrameSE3TrajectoryPoint.getPosition().containsNaN());
        Assert.assertTrue(testedYoFrameSE3TrajectoryPoint.getOrientation().containsNaN());
        Assert.assertTrue(testedYoFrameSE3TrajectoryPoint.getLinearVelocity().containsNaN());
        Assert.assertTrue(testedYoFrameSE3TrajectoryPoint.getAngularVelocity().containsNaN());
    }

    private void assertWaypointContainsExpectedData(String expectedNamePrefix, String expectedNameSuffix, ReferenceFrame expectedFrame, double expectedTime, FramePoint3DReadOnly expectedPosition, FrameQuaternionReadOnly expectedOrientation, FrameVector3DReadOnly expectedLinearVelocity, FrameVector3DReadOnly expectedAngularVelocity, YoFrameSE3TrajectoryPoint testedYoFrameSE3TrajectoryPoint, double epsilon) {
        Assert.assertTrue(expectedFrame == testedYoFrameSE3TrajectoryPoint.getReferenceFrame());
        Assert.assertEquals(expectedTime, testedYoFrameSE3TrajectoryPoint.getTime(), epsilon);
        Assert.assertEquals(expectedNamePrefix, testedYoFrameSE3TrajectoryPoint.getNamePrefix());
        Assert.assertEquals(expectedNameSuffix, testedYoFrameSE3TrajectoryPoint.getNameSuffix());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidFrameGeometry)testedYoFrameSE3TrajectoryPoint.getPosition(), epsilon));
        Quaternion trajectoryPointQuaternion = new Quaternion((QuaternionReadOnly)testedYoFrameSE3TrajectoryPoint.getOrientation());
        Assert.assertEquals(expectedOrientation.getReferenceFrame(), testedYoFrameSE3TrajectoryPoint.getOrientation().getReferenceFrame());
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedOrientation, (Orientation3DReadOnly)trajectoryPointQuaternion, (double)epsilon);
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidFrameGeometry)testedYoFrameSE3TrajectoryPoint.getLinearVelocity(), epsilon));
        Assert.assertTrue(expectedAngularVelocity.epsilonEquals((EuclidFrameGeometry)testedYoFrameSE3TrajectoryPoint.getAngularVelocity(), epsilon));
        FrameSE3TrajectoryPoint actualFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint();
        actualFrameSE3TrajectoryPoint.setIncludingFrame((FrameSE3TrajectoryPointReadOnly)testedYoFrameSE3TrajectoryPoint);
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, actualFrameSE3TrajectoryPoint, epsilon);
        actualFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint(expectedFrame);
        actualFrameSE3TrajectoryPoint.set((FrameSE3TrajectoryPointReadOnly)testedYoFrameSE3TrajectoryPoint);
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, expectedPosition, expectedOrientation, expectedLinearVelocity, expectedAngularVelocity, actualFrameSE3TrajectoryPoint, epsilon);
        Point3D actualPosition = new Point3D();
        Quaternion actualOrientation = new Quaternion();
        Vector3D actualLinearVelocity = new Vector3D();
        Vector3D actualAngularVelocity = new Vector3D();
        actualPosition.set((Tuple3DReadOnly)testedYoFrameSE3TrajectoryPoint.getPosition());
        actualOrientation.set((QuaternionReadOnly)testedYoFrameSE3TrajectoryPoint.getOrientation());
        actualLinearVelocity.set((Tuple3DReadOnly)testedYoFrameSE3TrajectoryPoint.getLinearVelocity());
        actualAngularVelocity.set((Tuple3DReadOnly)testedYoFrameSE3TrajectoryPoint.getAngularVelocity());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidGeometry)actualPosition, epsilon));
        Assert.assertTrue(expectedOrientation.geometricallyEquals((EuclidGeometry)actualOrientation, epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidGeometry)actualLinearVelocity, epsilon));
        Assert.assertTrue(expectedAngularVelocity.epsilonEquals((EuclidGeometry)actualAngularVelocity, epsilon));
        FramePoint3D actualFramePosition = new FramePoint3D(expectedFrame);
        FrameQuaternion actualFrameOrientation = new FrameQuaternion(expectedFrame);
        FrameVector3D actualFrameLinearVelocity = new FrameVector3D(expectedFrame);
        FrameVector3D actualFrameAngularVelocity = new FrameVector3D(expectedFrame);
        actualFramePosition.set((FrameTuple3DReadOnly)testedYoFrameSE3TrajectoryPoint.getPosition());
        actualFrameOrientation.set((FrameQuaternionReadOnly)testedYoFrameSE3TrajectoryPoint.getOrientation());
        actualFrameLinearVelocity.set((FrameTuple3DReadOnly)testedYoFrameSE3TrajectoryPoint.getLinearVelocity());
        actualFrameAngularVelocity.set((FrameTuple3DReadOnly)testedYoFrameSE3TrajectoryPoint.getAngularVelocity());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidFrameGeometry)actualFramePosition, epsilon));
        Assert.assertTrue(expectedOrientation.geometricallyEquals((EuclidFrameGeometry)actualFrameOrientation, epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidFrameGeometry)actualFrameLinearVelocity, epsilon));
        Assert.assertTrue(expectedAngularVelocity.epsilonEquals((EuclidFrameGeometry)actualFrameAngularVelocity, epsilon));
        actualFramePosition = new FramePoint3D();
        actualFrameOrientation = new FrameQuaternion();
        actualFrameLinearVelocity = new FrameVector3D();
        actualFrameAngularVelocity = new FrameVector3D();
        actualFramePosition.setIncludingFrame((FrameTuple3DReadOnly)testedYoFrameSE3TrajectoryPoint.getPosition());
        actualFrameOrientation.setIncludingFrame((FrameQuaternionReadOnly)testedYoFrameSE3TrajectoryPoint.getOrientation());
        actualFrameLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)testedYoFrameSE3TrajectoryPoint.getLinearVelocity());
        actualFrameAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)testedYoFrameSE3TrajectoryPoint.getAngularVelocity());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidFrameGeometry)actualFramePosition, epsilon));
        Assert.assertTrue(expectedOrientation.geometricallyEquals((EuclidFrameGeometry)actualFrameOrientation, epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidFrameGeometry)actualFrameLinearVelocity, epsilon));
        Assert.assertTrue(expectedAngularVelocity.epsilonEquals((EuclidFrameGeometry)actualFrameAngularVelocity, epsilon));
    }

    @Test
    public void testSomeSetsAngGets() {
        String namePrefix = "point";
        String nameSuffix = "toTest";
        YoRegistry registry = new YoRegistry("myRegistry");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoFrameSE3TrajectoryPoint yoFrameSE3TrajectoryPoint = new YoFrameSE3TrajectoryPoint(namePrefix, nameSuffix, registry, worldFrame);
        yoFrameSE3TrajectoryPoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        SE3TrajectoryPoint simpleTrajectoryPoint = new SE3TrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        orientation.normalize();
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleTrajectoryPoint.set(time, (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)linearVelocity, (Vector3DReadOnly)angularVelocity);
        yoFrameSE3TrajectoryPoint.setIncludingFrame(worldFrame, (SE3TrajectoryPointReadOnly)simpleTrajectoryPoint);
        YoFramePoint3D pointForVerification = new YoFramePoint3D("pointForVerification", worldFrame, registry);
        YoFrameQuaternion quaternionForVerification = new YoFrameQuaternion("quaternionForVerification", worldFrame, registry);
        YoFrameVector3D linearVelocityForVerification = new YoFrameVector3D("linearVelocityForVerification", worldFrame, registry);
        YoFrameVector3D angularVelocityForVerification = new YoFrameVector3D("angularVelocityForVerification", worldFrame, registry);
        pointForVerification.set((FrameTuple3DReadOnly)yoFrameSE3TrajectoryPoint.getPosition());
        quaternionForVerification.set((FrameQuaternionReadOnly)yoFrameSE3TrajectoryPoint.getOrientation());
        linearVelocityForVerification.set((FrameTuple3DReadOnly)yoFrameSE3TrajectoryPoint.getLinearVelocity());
        angularVelocityForVerification.set((FrameTuple3DReadOnly)yoFrameSE3TrajectoryPoint.getAngularVelocity());
        Assert.assertEquals(time, yoFrameSE3TrajectoryPoint.getTime(), 1.0E-10);
        Assert.assertTrue(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-10));
        Assert.assertTrue(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-10));
        Assert.assertTrue(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-10));
        Assert.assertTrue(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-10));
        Assert.assertFalse(yoFrameSE3TrajectoryPoint.containsNaN());
        yoFrameSE3TrajectoryPoint.getPosition().setToNaN();
        Assert.assertTrue(yoFrameSE3TrajectoryPoint.containsNaN());
        yoFrameSE3TrajectoryPoint.getPosition().setToZero();
        Assert.assertFalse(yoFrameSE3TrajectoryPoint.containsNaN());
        yoFrameSE3TrajectoryPoint.getOrientation().setToNaN();
        Assert.assertTrue(yoFrameSE3TrajectoryPoint.containsNaN());
        yoFrameSE3TrajectoryPoint.getOrientation().setToZero();
        Assert.assertFalse(yoFrameSE3TrajectoryPoint.containsNaN());
        yoFrameSE3TrajectoryPoint.getLinearVelocity().setToNaN();
        Assert.assertTrue(yoFrameSE3TrajectoryPoint.containsNaN());
        yoFrameSE3TrajectoryPoint.getLinearVelocity().setToZero();
        Assert.assertFalse(yoFrameSE3TrajectoryPoint.containsNaN());
        yoFrameSE3TrajectoryPoint.getAngularVelocity().setToNaN();
        Assert.assertTrue(yoFrameSE3TrajectoryPoint.containsNaN());
        yoFrameSE3TrajectoryPoint.getAngularVelocity().setToZero();
        Assert.assertFalse(yoFrameSE3TrajectoryPoint.containsNaN());
        position.set((Tuple3DReadOnly)yoFrameSE3TrajectoryPoint.getPosition());
        orientation.set((QuaternionReadOnly)yoFrameSE3TrajectoryPoint.getOrientation());
        linearVelocity.set((Tuple3DReadOnly)yoFrameSE3TrajectoryPoint.getLinearVelocity());
        angularVelocity.set((Tuple3DReadOnly)yoFrameSE3TrajectoryPoint.getAngularVelocity());
        Assert.assertTrue(position.epsilonEquals((EuclidGeometry)new Point3D(), 1.0E-10));
        Assert.assertTrue(orientation.epsilonEquals((EuclidGeometry)new Quaternion(), 1.0E-10));
        Assert.assertTrue(linearVelocity.epsilonEquals((EuclidGeometry)new Vector3D(), 1.0E-10));
        Assert.assertTrue(angularVelocity.epsilonEquals((EuclidGeometry)new Vector3D(), 1.0E-10));
        time = 9.9;
        pointForVerification.set(3.9, 2.2, 1.1);
        quaternionForVerification.setYawPitchRoll(0.2, 0.6, 1.1);
        linearVelocityForVerification.set(8.8, 1.4, 9.22);
        angularVelocityForVerification.set(7.1, 2.2, 3.33);
        Assert.assertFalse(Math.abs(yoFrameSE3TrajectoryPoint.getTime() - time) < 1.0E-7);
        Assert.assertFalse(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-7));
        Assert.assertFalse(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-7));
        Assert.assertFalse(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-7));
        Assert.assertFalse(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-7));
        yoFrameSE3TrajectoryPoint.set(time, (FramePoint3DReadOnly)pointForVerification, (FrameOrientation3DReadOnly)quaternionForVerification, (FrameVector3DReadOnly)linearVelocityForVerification, (FrameVector3DReadOnly)angularVelocityForVerification);
        position.set((Tuple3DReadOnly)yoFrameSE3TrajectoryPoint.getPosition());
        orientation.set((QuaternionReadOnly)yoFrameSE3TrajectoryPoint.getOrientation());
        linearVelocity.set((Tuple3DReadOnly)yoFrameSE3TrajectoryPoint.getLinearVelocity());
        angularVelocity.set((Tuple3DReadOnly)yoFrameSE3TrajectoryPoint.getAngularVelocity());
        Assert.assertEquals(time, yoFrameSE3TrajectoryPoint.getTime(), 1.0E-10);
        Assert.assertTrue(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-10));
        Assert.assertTrue(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-10));
        Assert.assertTrue(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-10));
        Assert.assertTrue(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-10));
        YoFrameSE3TrajectoryPoint yoFrameSE3TrajectoryPointTwo = new YoFrameSE3TrajectoryPoint(namePrefix, nameSuffix + "Two", registry, worldFrame);
        double positionDistance = yoFrameSE3TrajectoryPoint.positionDistance((FrameEuclideanWaypointReadOnly)yoFrameSE3TrajectoryPointTwo);
        Assert.assertEquals(4.610856753359402, positionDistance, 1.0E-7);
        Assert.assertFalse(yoFrameSE3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPointTwo, 1.0E-7));
        yoFrameSE3TrajectoryPointTwo.set((FrameSE3TrajectoryPointReadOnly)yoFrameSE3TrajectoryPoint);
        positionDistance = yoFrameSE3TrajectoryPoint.positionDistance((FrameEuclideanWaypointReadOnly)yoFrameSE3TrajectoryPointTwo);
        Assert.assertEquals(0.0, positionDistance, 1.0E-7);
        Assert.assertTrue(yoFrameSE3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPointTwo, 1.0E-7));
        SE3TrajectoryPoint simplePoint = new SE3TrajectoryPoint();
        simplePoint.set((SE3TrajectoryPointReadOnly)yoFrameSE3TrajectoryPoint);
        yoFrameSE3TrajectoryPoint.setToNaN();
        Assert.assertTrue(yoFrameSE3TrajectoryPoint.containsNaN());
        positionDistance = yoFrameSE3TrajectoryPoint.positionDistance((FrameEuclideanWaypointReadOnly)yoFrameSE3TrajectoryPointTwo);
        Assert.assertTrue(Double.isNaN(positionDistance));
        Assert.assertFalse(yoFrameSE3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPointTwo, 1.0E-7));
        SE3TrajectoryPoint trajectoryPointAsInterface = simplePoint;
        yoFrameSE3TrajectoryPoint.set((SE3TrajectoryPointReadOnly)trajectoryPointAsInterface);
        positionDistance = yoFrameSE3TrajectoryPoint.positionDistance((FrameEuclideanWaypointReadOnly)yoFrameSE3TrajectoryPointTwo);
        Assert.assertEquals(0.0, positionDistance, 1.0E-7);
        Assert.assertTrue(yoFrameSE3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPointTwo, 1.0E-7));
        String string = yoFrameSE3TrajectoryPoint.toString();
        String expectedString = "SE3 trajectory point: [time= 9.900, position=( 3.900,  2.200,  1.100 ), orientation=( 0.472,  0.301, -0.072,  0.826 ), linear velocity=( 8.800,  1.400,  9.220 ), angular velocity=( 7.100,  2.200,  3.330 )] - World";
        Assert.assertEquals(expectedString, string);
    }

    @Test
    public void testSomeMoreSettersAndGetters() {
        String namePrefix = "point";
        String nameSuffix = "toTest";
        YoRegistry registry = new YoRegistry("myRegistry");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoFrameSE3TrajectoryPoint yoFrameSE3TrajectoryPoint = new YoFrameSE3TrajectoryPoint(namePrefix, nameSuffix, registry, worldFrame);
        yoFrameSE3TrajectoryPoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        double time = 3.4;
        FramePoint3D position = new FramePoint3D(worldFrame, 1.0, 2.1, 3.7);
        FrameQuaternion orientation = new FrameQuaternion(worldFrame, (QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        FrameVector3D linearVelocity = new FrameVector3D(worldFrame, -0.4, 1.2, 3.3);
        FrameVector3D angularVelocity = new FrameVector3D(worldFrame, 1.7, 8.4, 2.2);
        yoFrameSE3TrajectoryPoint.setTime(time);
        yoFrameSE3TrajectoryPoint.getPosition().set((FrameTuple3DReadOnly)position);
        yoFrameSE3TrajectoryPoint.getOrientation().set((FrameOrientation3DReadOnly)orientation);
        yoFrameSE3TrajectoryPoint.getLinearVelocity().set((FrameTuple3DReadOnly)linearVelocity);
        yoFrameSE3TrajectoryPoint.getAngularVelocity().set((FrameTuple3DReadOnly)angularVelocity);
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        yoFrameSE3TrajectoryPoint.changeFrame((ReferenceFrame)poseFrame);
        Assert.assertFalse(position.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPoint.getPosition(), 1.0E-10));
        Assert.assertFalse(orientation.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPoint.getOrientation(), 1.0E-10));
        Assert.assertFalse(linearVelocity.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPoint.getLinearVelocity(), 1.0E-10));
        Assert.assertFalse(angularVelocity.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPoint.getAngularVelocity(), 1.0E-10));
        position.changeFrame((ReferenceFrame)poseFrame);
        orientation.changeFrame((ReferenceFrame)poseFrame);
        linearVelocity.changeFrame((ReferenceFrame)poseFrame);
        angularVelocity.changeFrame((ReferenceFrame)poseFrame);
        Assert.assertTrue(position.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPoint.getPosition(), 1.0E-10));
        Assert.assertTrue(orientation.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPoint.getOrientation(), 1.0E-10));
        Assert.assertTrue(linearVelocity.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPoint.getLinearVelocity(), 1.0E-10));
        Assert.assertTrue(angularVelocity.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPoint.getAngularVelocity(), 1.0E-10));
        YoFrameSE3TrajectoryPoint yoFrameSE3TrajectoryPointTwo = new YoFrameSE3TrajectoryPoint(namePrefix, nameSuffix + "Two", registry, (ReferenceFrame)poseFrame);
        yoFrameSE3TrajectoryPointTwo.setTime(time);
        yoFrameSE3TrajectoryPointTwo.getPosition().set((FrameTuple3DReadOnly)position);
        yoFrameSE3TrajectoryPointTwo.getOrientation().set((FrameOrientation3DReadOnly)orientation);
        yoFrameSE3TrajectoryPointTwo.getLinearVelocity().set((FrameTuple3DReadOnly)linearVelocity);
        yoFrameSE3TrajectoryPointTwo.getAngularVelocity().set((FrameTuple3DReadOnly)angularVelocity);
        Assert.assertTrue(yoFrameSE3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)yoFrameSE3TrajectoryPointTwo, 1.0E-10));
    }
}

