/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.trajectorypoints.SO3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.SO3Waypoint;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class SO3TrajectoryPointTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testCommonUsageExample() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        SO3TrajectoryPoint simpleSO3TrajectoryPoint = new SO3TrajectoryPoint();
        SO3TrajectoryPoint simpleTrajectoryPoint = new SO3TrajectoryPoint();
        double time = 3.4;
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        orientation.normalize();
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleTrajectoryPoint.set(time, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)angularVelocity);
        simpleSO3TrajectoryPoint.set((SO3TrajectoryPointReadOnly)simpleTrajectoryPoint);
        simpleSO3TrajectoryPoint.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        RigidBodyTransform transformToPoseFrame = worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame);
        orientation.applyTransform((Transform)transformToPoseFrame);
        transformToPoseFrame.transform((Vector3DBasics)angularVelocity);
        SO3TrajectoryPoint expectedSimpleSO3TrajectoryPoint = new SO3TrajectoryPoint();
        expectedSimpleSO3TrajectoryPoint.setTime(time);
        expectedSimpleSO3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)orientation);
        expectedSimpleSO3TrajectoryPoint.getAngularVelocity().set(angularVelocity);
        Assert.assertEquals(3.4, simpleSO3TrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertEquals(3.4, expectedSimpleSO3TrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertTrue(expectedSimpleSO3TrajectoryPoint.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPoint, 1.0E-10));
    }

    @Test
    public void testConstructors() {
        double epsilon = 1.0E-14;
        Random random = new Random(21651016L);
        double expectedTime = 0.0;
        Quaternion expectedOrientation = new Quaternion();
        Vector3D expectedAngularVelocity = new Vector3D();
        SO3TrajectoryPoint testedSimpleSO3TrajectoryPoint = new SO3TrajectoryPoint();
        SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedOrientation, expectedAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
        expectedTime = 0.0;
        expectedOrientation = new Quaternion();
        expectedAngularVelocity = new Vector3D();
        testedSimpleSO3TrajectoryPoint = new SO3TrajectoryPoint();
        SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedOrientation, expectedAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        testedSimpleSO3TrajectoryPoint = new SO3TrajectoryPoint(expectedTime, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedAngularVelocity);
        SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedOrientation, expectedAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        SO3TrajectoryPoint expectedSimpleSO3TrajectoryPoint = new SO3TrajectoryPoint(expectedTime, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedAngularVelocity);
        testedSimpleSO3TrajectoryPoint = new SO3TrajectoryPoint((SO3TrajectoryPointBasics)expectedSimpleSO3TrajectoryPoint);
        Assert.assertTrue(expectedSimpleSO3TrajectoryPoint.epsilonEquals((EuclidGeometry)testedSimpleSO3TrajectoryPoint, epsilon));
        SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedSimpleSO3TrajectoryPoint.getTime(), expectedOrientation, expectedAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
        double expectedFinalTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Quaternion expectedFinalOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Vector3D expectedFinalAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        SO3TrajectoryPoint expectedSO3TrajectoryPoint = new SO3TrajectoryPoint();
        expectedSO3TrajectoryPoint.setTime(expectedFinalTime);
        expectedSO3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)expectedFinalOrientation);
        expectedSO3TrajectoryPoint.getAngularVelocity().set(expectedFinalAngularVelocity);
        testedSimpleSO3TrajectoryPoint = new SO3TrajectoryPoint((SO3TrajectoryPointBasics)expectedSO3TrajectoryPoint);
        SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFinalTime, expectedFinalOrientation, expectedFinalAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
    }

    @Test
    public void testSetters() {
        double epsilon = 1.0E-14;
        Random random = new Random(21651016L);
        double expectedTime = 0.0;
        Quaternion expectedOrientation = new Quaternion();
        Vector3D expectedAngularVelocity = new Vector3D();
        SO3TrajectoryPoint testedSimpleSO3TrajectoryPoint = new SO3TrajectoryPoint();
        SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedOrientation, expectedAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        testedSimpleSO3TrajectoryPoint.set(expectedTime, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedAngularVelocity);
        SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedOrientation, expectedAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        testedSimpleSO3TrajectoryPoint.set(expectedTime, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedAngularVelocity);
        SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedOrientation, expectedAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        testedSimpleSO3TrajectoryPoint.set(expectedTime, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedAngularVelocity);
        SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedOrientation, expectedAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        SO3TrajectoryPoint expectedSimpleSO3TrajectoryPoint = new SO3TrajectoryPoint(expectedTime, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedAngularVelocity);
        testedSimpleSO3TrajectoryPoint.set((SO3TrajectoryPointReadOnly)expectedSimpleSO3TrajectoryPoint);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        expectedSimpleSO3TrajectoryPoint = new SO3TrajectoryPoint(expectedTime, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedAngularVelocity);
        testedSimpleSO3TrajectoryPoint.set((SO3TrajectoryPointReadOnly)expectedSimpleSO3TrajectoryPoint);
        Assert.assertTrue(expectedSimpleSO3TrajectoryPoint.epsilonEquals((EuclidGeometry)testedSimpleSO3TrajectoryPoint, epsilon));
        SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedSimpleSO3TrajectoryPoint.getTime(), expectedOrientation, expectedAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
        double expectedFinalTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Quaternion expectedFinalOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Vector3D expectedFinalAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        SO3TrajectoryPoint expectedSO3TrajectoryPoint = new SO3TrajectoryPoint();
        expectedSO3TrajectoryPoint.setTime(expectedFinalTime);
        expectedSO3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)expectedFinalOrientation);
        expectedSO3TrajectoryPoint.getAngularVelocity().set(expectedFinalAngularVelocity);
        testedSimpleSO3TrajectoryPoint.set((SO3TrajectoryPointReadOnly)expectedSO3TrajectoryPoint);
        SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFinalTime, expectedFinalOrientation, expectedFinalAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
    }

    @Test
    public void testChangeFrame() throws Exception {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Quaternion expectedOrientation = new Quaternion((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
        Vector3D expectedAngularVelocity = new Vector3D((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        SO3TrajectoryPoint testedSimpleSO3TrajectoryPoint = new SO3TrajectoryPoint(expectedTime, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedAngularVelocity);
        for (int i = 0; i < 10000; ++i) {
            expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)("randomFrame" + i), (Random)random, (ReferenceFrame)(random.nextBoolean() ? worldFrame : expectedFrame));
            expectedOrientation.applyTransform((Transform)worldFrame.getTransformToDesiredFrame(expectedFrame));
            expectedAngularVelocity.applyTransform((Transform)worldFrame.getTransformToDesiredFrame(expectedFrame));
            testedSimpleSO3TrajectoryPoint.applyTransform((Transform)worldFrame.getTransformToDesiredFrame(expectedFrame));
            SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedOrientation, expectedAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Quaternion expectedOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Vector3D expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        SO3TrajectoryPoint testedSimpleSO3TrajectoryPoint = new SO3TrajectoryPoint(expectedTime, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedAngularVelocity);
        expectedTime = 0.0;
        expectedOrientation.set(0.0, 0.0, 0.0, 1.0);
        expectedAngularVelocity.set(0.0, 0.0, 0.0);
        testedSimpleSO3TrajectoryPoint.setToZero();
        SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedOrientation, expectedAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        testedSimpleSO3TrajectoryPoint.set(expectedTime, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedAngularVelocity);
        expectedTime = 0.0;
        expectedOrientation.set(0.0, 0.0, 0.0, 1.0);
        expectedAngularVelocity.set(0.0, 0.0, 0.0);
        testedSimpleSO3TrajectoryPoint.setToZero();
        SO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedOrientation, expectedAngularVelocity, testedSimpleSO3TrajectoryPoint, epsilon);
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(21651016L);
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Quaternion expectedOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Vector3D expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        SO3TrajectoryPoint testedSimpleSO3TrajectoryPoint = new SO3TrajectoryPoint(expectedTime, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedAngularVelocity);
        testedSimpleSO3TrajectoryPoint.setToNaN();
        Assert.assertTrue(Double.isNaN(testedSimpleSO3TrajectoryPoint.getTime()));
        Assert.assertTrue(testedSimpleSO3TrajectoryPoint.containsNaN());
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        testedSimpleSO3TrajectoryPoint.set(expectedTime, (Orientation3DReadOnly)expectedOrientation, (Vector3DReadOnly)expectedAngularVelocity);
        testedSimpleSO3TrajectoryPoint.setToNaN();
        Assert.assertTrue(Double.isNaN(testedSimpleSO3TrajectoryPoint.getTime()));
        Assert.assertTrue(testedSimpleSO3TrajectoryPoint.containsNaN());
    }

    static void assertTrajectoryPointContainsExpectedData(double expectedTime, Quaternion expectedOrientation, Vector3D expectedAngularVelocity, SO3TrajectoryPoint testedSimpleSO3TrajectoryPoint, double epsilon) {
        Assert.assertEquals(expectedTime, testedSimpleSO3TrajectoryPoint.getTime(), epsilon);
        Assert.assertTrue(String.valueOf(expectedOrientation) + ", " + String.valueOf(testedSimpleSO3TrajectoryPoint.getOrientation()), expectedOrientation.epsilonEquals((EuclidGeometry)testedSimpleSO3TrajectoryPoint.getOrientation(), epsilon));
        Assert.assertTrue(expectedAngularVelocity.epsilonEquals((EuclidGeometry)testedSimpleSO3TrajectoryPoint.getAngularVelocity(), epsilon));
        Quaternion actualOrientation = new Quaternion();
        Vector3D actualAngularVelocity = new Vector3D();
        actualOrientation.set(testedSimpleSO3TrajectoryPoint.getOrientation());
        actualAngularVelocity.set(testedSimpleSO3TrajectoryPoint.getAngularVelocity());
        Assert.assertTrue(expectedOrientation.epsilonEquals((EuclidGeometry)actualOrientation, epsilon));
        Assert.assertTrue(expectedAngularVelocity.epsilonEquals((EuclidGeometry)actualAngularVelocity, epsilon));
        Quaternion actualFrameOrientation = new Quaternion();
        Vector3D actualFrameAngularVelocity = new Vector3D();
        actualFrameOrientation.set(testedSimpleSO3TrajectoryPoint.getOrientation());
        actualFrameAngularVelocity.set(testedSimpleSO3TrajectoryPoint.getAngularVelocity());
        Assert.assertTrue(expectedOrientation.epsilonEquals((EuclidGeometry)actualFrameOrientation, epsilon));
        Assert.assertTrue(expectedAngularVelocity.epsilonEquals((EuclidGeometry)actualFrameAngularVelocity, epsilon));
        actualFrameOrientation = new Quaternion();
        actualFrameAngularVelocity = new Vector3D();
        actualFrameOrientation.set(testedSimpleSO3TrajectoryPoint.getOrientation());
        actualFrameAngularVelocity.set(testedSimpleSO3TrajectoryPoint.getAngularVelocity());
        Assert.assertTrue(expectedOrientation.epsilonEquals((EuclidGeometry)actualFrameOrientation, epsilon));
        Assert.assertTrue(expectedAngularVelocity.epsilonEquals((EuclidGeometry)actualFrameAngularVelocity, epsilon));
    }

    @Test
    public void testSomeSetsAngGets() {
        SO3TrajectoryPoint simpleSO3TrajectoryPoint = new SO3TrajectoryPoint();
        SO3TrajectoryPoint simpleTrajectoryPoint = new SO3TrajectoryPoint();
        double time = 3.4;
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        orientation.normalize();
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleTrajectoryPoint.set(time, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)angularVelocity);
        simpleSO3TrajectoryPoint.set((SO3TrajectoryPointReadOnly)simpleTrajectoryPoint);
        Point3D pointForVerification = new Point3D();
        Quaternion quaternionForVerification = new Quaternion();
        Vector3D linearVelocityForVerification = new Vector3D();
        Vector3D angularVelocityForVerification = new Vector3D();
        quaternionForVerification.set(simpleSO3TrajectoryPoint.getOrientation());
        angularVelocityForVerification.set(simpleSO3TrajectoryPoint.getAngularVelocity());
        Assert.assertEquals(time, simpleSO3TrajectoryPoint.getTime(), 1.0E-10);
        Assert.assertTrue(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-10));
        Assert.assertTrue(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-10));
        Assert.assertFalse(simpleSO3TrajectoryPoint.containsNaN());
        simpleSO3TrajectoryPoint.getOrientation().setToNaN();
        Assert.assertTrue(simpleSO3TrajectoryPoint.containsNaN());
        simpleSO3TrajectoryPoint.getOrientation().setToZero();
        Assert.assertFalse(simpleSO3TrajectoryPoint.containsNaN());
        simpleSO3TrajectoryPoint.getAngularVelocity().setToNaN();
        Assert.assertTrue(simpleSO3TrajectoryPoint.containsNaN());
        simpleSO3TrajectoryPoint.getAngularVelocity().setToZero();
        Assert.assertFalse(simpleSO3TrajectoryPoint.containsNaN());
        orientation.set(simpleSO3TrajectoryPoint.getOrientation());
        angularVelocity.set(simpleSO3TrajectoryPoint.getAngularVelocity());
        Assert.assertTrue(orientation.epsilonEquals((EuclidGeometry)new Quaternion(), 1.0E-10));
        Assert.assertTrue(angularVelocity.epsilonEquals((EuclidGeometry)new Vector3D(), 1.0E-10));
        time = 9.9;
        pointForVerification.set(3.9, 2.2, 1.1);
        quaternionForVerification.set(0.2, 0.6, 1.1, 2.1);
        quaternionForVerification.normalize();
        linearVelocityForVerification.set(8.8, 1.4, 9.22);
        angularVelocityForVerification.set(7.1, 2.2, 3.33);
        Assert.assertFalse(Math.abs(simpleSO3TrajectoryPoint.getTime() - time) < 1.0E-7);
        Assert.assertFalse(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-7));
        Assert.assertFalse(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-7));
        simpleSO3TrajectoryPoint.set(time, (Orientation3DReadOnly)quaternionForVerification, (Vector3DReadOnly)angularVelocityForVerification);
        orientation.set(simpleSO3TrajectoryPoint.getOrientation());
        angularVelocity.set(simpleSO3TrajectoryPoint.getAngularVelocity());
        Assert.assertEquals(time, simpleSO3TrajectoryPoint.getTime(), 1.0E-10);
        Assert.assertTrue(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-10));
        Assert.assertTrue(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-10));
        SO3TrajectoryPoint simpleSO3TrajectoryPointTwo = new SO3TrajectoryPoint();
        Assert.assertFalse(simpleSO3TrajectoryPoint.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPointTwo, 1.0E-7));
        simpleSO3TrajectoryPointTwo.set((SO3TrajectoryPointReadOnly)simpleSO3TrajectoryPoint);
        Assert.assertTrue(simpleSO3TrajectoryPoint.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPointTwo, 1.0E-7));
        SO3TrajectoryPoint simplePoint = new SO3TrajectoryPoint();
        simplePoint.set((SO3TrajectoryPointReadOnly)simpleSO3TrajectoryPoint);
        simpleSO3TrajectoryPoint.setToNaN();
        Assert.assertTrue(simpleSO3TrajectoryPoint.containsNaN());
        Assert.assertFalse(simpleSO3TrajectoryPoint.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPointTwo, 1.0E-7));
        SO3TrajectoryPoint trajectoryPointAsInterface = simplePoint;
        simpleSO3TrajectoryPoint.set((SO3TrajectoryPointReadOnly)trajectoryPointAsInterface);
        Assert.assertTrue(simpleSO3TrajectoryPoint.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPointTwo, 1.0E-7));
    }

    @Test
    public void testSomeMoreSettersAndGetters() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        SO3TrajectoryPoint simpleSO3TrajectoryPoint = new SO3TrajectoryPoint();
        double time = 3.4;
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleSO3TrajectoryPoint.setTime(time);
        simpleSO3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)orientation);
        simpleSO3TrajectoryPoint.getAngularVelocity().set(angularVelocity);
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        simpleSO3TrajectoryPoint.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        Assert.assertFalse(orientation.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPoint.getOrientation(), 1.0E-10));
        Assert.assertFalse(angularVelocity.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPoint.getAngularVelocity(), 1.0E-10));
        orientation.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        angularVelocity.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        Assert.assertTrue(orientation.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPoint.getOrientation(), 1.0E-10));
        Assert.assertTrue(angularVelocity.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPoint.getAngularVelocity(), 1.0E-10));
        SO3TrajectoryPoint simpleSO3TrajectoryPointTwo = new SO3TrajectoryPoint();
        simpleSO3TrajectoryPointTwo.setTime(time);
        simpleSO3TrajectoryPointTwo.getOrientation().set((Orientation3DReadOnly)orientation);
        simpleSO3TrajectoryPointTwo.getAngularVelocity().set(angularVelocity);
        Assert.assertTrue(simpleSO3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPoint, 1.0E-10));
        simpleSO3TrajectoryPointTwo = new SO3TrajectoryPoint();
        simpleSO3TrajectoryPointTwo.set(time, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)angularVelocity);
        Assert.assertTrue(simpleSO3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPoint, 1.0E-10));
        simpleSO3TrajectoryPointTwo = new SO3TrajectoryPoint();
        SO3Waypoint simpleSO3Waypoint = new SO3Waypoint();
        simpleSO3Waypoint.set((SO3WaypointReadOnly)simpleSO3TrajectoryPoint);
        simpleSO3TrajectoryPointTwo.set(time, (SO3WaypointReadOnly)simpleSO3Waypoint);
        Assert.assertTrue(simpleSO3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPoint, 1.0E-10));
        simpleSO3TrajectoryPointTwo = new SO3TrajectoryPoint();
        simpleSO3TrajectoryPointTwo.set(time, (SO3WaypointReadOnly)simpleSO3Waypoint);
        Assert.assertTrue(simpleSO3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPoint, 1.0E-10));
        simpleSO3TrajectoryPointTwo = new SO3TrajectoryPoint();
        SO3TrajectoryPoint so3Waypoint = simpleSO3TrajectoryPoint;
        simpleSO3TrajectoryPointTwo.set(time, (SO3WaypointReadOnly)so3Waypoint);
        Assert.assertTrue(simpleSO3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPoint, 1.0E-10));
        simpleSO3TrajectoryPointTwo = new SO3TrajectoryPoint();
        so3Waypoint = new SO3Waypoint();
        so3Waypoint.set((SO3WaypointReadOnly)simpleSO3TrajectoryPoint);
        simpleSO3TrajectoryPointTwo.set(time, (SO3WaypointReadOnly)so3Waypoint);
        Assert.assertTrue(simpleSO3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPoint, 1.0E-10));
        Quaternion orientationToPack = new Quaternion();
        Vector3D angularVelocityToPack = new Vector3D();
        orientationToPack.set(simpleSO3TrajectoryPoint.getOrientation());
        angularVelocityToPack.set(simpleSO3TrajectoryPoint.getAngularVelocity());
        simpleSO3TrajectoryPointTwo = new SO3TrajectoryPoint();
        simpleSO3TrajectoryPointTwo.set(time, (Orientation3DReadOnly)orientationToPack, (Vector3DReadOnly)angularVelocityToPack);
        Assert.assertTrue(simpleSO3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPoint, 1.0E-10));
        orientationToPack = new Quaternion();
        angularVelocityToPack = new Vector3D();
        orientationToPack.set(simpleSO3TrajectoryPoint.getOrientation());
        angularVelocityToPack.set(simpleSO3TrajectoryPoint.getAngularVelocity());
        simpleSO3TrajectoryPointTwo = new SO3TrajectoryPoint();
        simpleSO3TrajectoryPointTwo.set(time, (Orientation3DReadOnly)orientationToPack, (Vector3DReadOnly)angularVelocityToPack);
        Assert.assertTrue(simpleSO3TrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleSO3TrajectoryPoint, 1.0E-10));
        Assert.assertTrue(simpleSO3TrajectoryPointTwo.getOrientation().epsilonEquals((EuclidGeometry)orientationToPack, 1.0E-10));
        Assert.assertTrue(simpleSO3TrajectoryPointTwo.getAngularVelocity().epsilonEquals((EuclidGeometry)angularVelocityToPack, 1.0E-10));
    }
}

