/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsTrajectoryGenerator;
import us.ihmc.robotics.trajectories.yoVariables.YoPolynomial;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class MultipleWaypointsTrajectoryGeneratorTest {
    private final double EPSILON = 0.001;

    @Test
    public void test() {
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        double trajectoryTime = 1.0;
        double dt = 0.001;
        YoDouble trajectoryTimeProvider = new YoDouble("trajectoryTime", registry);
        trajectoryTimeProvider.set(trajectoryTime);
        DoubleProvider initialPositionProvider = () -> 0.0;
        DoubleProvider finalPositionProvider = () -> 1.0;
        YoPolynomial simpleTrajectory = new YoPolynomial("simpleTraj", 4, registry);
        simpleTrajectory.setCubic(0.0, trajectoryTimeProvider.getDoubleValue(), initialPositionProvider.getValue(), finalPositionProvider.getValue());
        int numberOfWaypoints = 11;
        MultipleWaypointsTrajectoryGenerator multipleWaypointsTrajectory = new MultipleWaypointsTrajectoryGenerator("testedTraj", 15, registry);
        multipleWaypointsTrajectory.clear();
        for (int i = 0; i < numberOfWaypoints; ++i) {
            double timeAtWaypoint = (double)i * trajectoryTime / ((double)numberOfWaypoints - 1.0);
            simpleTrajectory.compute(timeAtWaypoint);
            double waypointPosition = simpleTrajectory.getValue();
            double waypointVelocity = simpleTrajectory.getVelocity();
            multipleWaypointsTrajectory.appendWaypoint(timeAtWaypoint, waypointPosition, waypointVelocity);
        }
        multipleWaypointsTrajectory.initialize();
        for (double t = 0.0; t <= trajectoryTime; t += dt) {
            multipleWaypointsTrajectory.compute(t);
            simpleTrajectory.compute(t);
            Assert.assertEquals(simpleTrajectory.getValue(), multipleWaypointsTrajectory.getValue(), 0.001);
            Assert.assertEquals(simpleTrajectory.getVelocity(), multipleWaypointsTrajectory.getVelocity(), 0.001);
            Assert.assertEquals(simpleTrajectory.getAcceleration(), multipleWaypointsTrajectory.getAcceleration(), 0.001);
        }
    }

    @Test
    public void testPassingThroughWayPoints() {
        int i;
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        int numberOfWaypoints = 11;
        MultipleWaypointsTrajectoryGenerator multipleWaypointsTrajectory = new MultipleWaypointsTrajectoryGenerator("testedTraj", 15, registry);
        multipleWaypointsTrajectory.clear();
        Random random = new Random(10L);
        double trajectoryTime = 1.0;
        double[] positions = new double[numberOfWaypoints];
        double[] velocities = new double[numberOfWaypoints];
        for (i = 0; i < numberOfWaypoints; ++i) {
            double waypointVelocity;
            double waypointPosition;
            double timeAtWaypoint = (double)i * trajectoryTime / ((double)numberOfWaypoints - 1.0);
            positions[i] = waypointPosition = random.nextDouble();
            velocities[i] = waypointVelocity = random.nextDouble();
            multipleWaypointsTrajectory.appendWaypoint(timeAtWaypoint, waypointPosition, waypointVelocity);
        }
        multipleWaypointsTrajectory.initialize();
        for (i = 0; i < numberOfWaypoints; ++i) {
            double time = (double)i * trajectoryTime / ((double)numberOfWaypoints - 1.0);
            multipleWaypointsTrajectory.compute(time);
            Assert.assertEquals(positions[i], multipleWaypointsTrajectory.getValue(), 0.001);
            Assert.assertEquals(velocities[i], multipleWaypointsTrajectory.getVelocity(), 0.001);
        }
    }

    @Test
    public void testOneWaypoint() {
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        int maxNumberOfWaypoints = 5;
        MultipleWaypointsTrajectoryGenerator trajectory = new MultipleWaypointsTrajectoryGenerator("testedTraj", maxNumberOfWaypoints, registry);
        trajectory.clear();
        double timeAtWaypoint = 0.0406;
        double positionAtWaypoint = 0.47;
        double velocityAtWaypoint = 0.1;
        trajectory.appendWaypoint(timeAtWaypoint, positionAtWaypoint, velocityAtWaypoint);
        trajectory.initialize();
        trajectory.compute(0.036);
        Assert.assertEquals(positionAtWaypoint, trajectory.getValue());
        Assert.assertEquals(0.0, trajectory.getVelocity());
        Assert.assertEquals(0.0, trajectory.getAcceleration());
        trajectory.compute(0.042);
        Assert.assertEquals(positionAtWaypoint, trajectory.getValue());
        Assert.assertEquals(0.0, trajectory.getVelocity());
        Assert.assertEquals(0.0, trajectory.getAcceleration());
        trajectory.compute(timeAtWaypoint);
        Assert.assertEquals(positionAtWaypoint, trajectory.getValue());
        Assert.assertEquals(velocityAtWaypoint, trajectory.getVelocity());
        Assert.assertEquals(0.0, trajectory.getAcceleration());
    }

    @Test
    public void testEdgeCase() {
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        int maxNumberOfWaypoints = 5;
        MultipleWaypointsTrajectoryGenerator trajectory = new MultipleWaypointsTrajectoryGenerator("testedTraj", maxNumberOfWaypoints, registry);
        trajectory.clear();
        trajectory.appendWaypoint(0.0, 0.0, 0.0);
        trajectory.appendWaypoint(0.5, 0.026337062843167836, 0.0);
        trajectory.initialize();
        trajectory.compute(0.0);
        Assert.assertEquals(0.0, trajectory.getValue(), 1.0E-5);
        Assert.assertEquals(0.0, trajectory.getVelocity(), 1.0E-5);
        trajectory.compute(0.5);
        Assert.assertEquals(0.026337062843167836, trajectory.getValue(), 1.0E-5);
        Assert.assertEquals(0.0, trajectory.getVelocity(), 1.0E-5);
    }
}

