/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.SimpleOrientationTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsOrientationTrajectoryGenerator;
import us.ihmc.yoVariables.registry.YoRegistry;

public class MultipleWaypointsOrientationTrajectoryGeneratorTest {
    private final double EPSILON = 0.001;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testCompareWithSimple() {
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        double trajectoryTime = 1.0;
        double dt = 1.0E-4;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        SimpleOrientationTrajectoryGenerator simpleTraj = new SimpleOrientationTrajectoryGenerator("simpleTraj", true, worldFrame, registry);
        simpleTraj.setTrajectoryTime(trajectoryTime);
        simpleTraj.setInitialOrientation((FrameQuaternionReadOnly)new FrameQuaternion(worldFrame, 1.0, 0.2, -0.5));
        simpleTraj.setFinalOrientation((FrameQuaternionReadOnly)new FrameQuaternion(worldFrame, -0.3, 0.7, 1.0));
        simpleTraj.initialize();
        int numberOfWaypoints = 100;
        MultipleWaypointsOrientationTrajectoryGenerator multipleWaypointTrajectory = new MultipleWaypointsOrientationTrajectoryGenerator("testedTraj", numberOfWaypoints + 1, worldFrame, registry);
        multipleWaypointTrajectory.clear();
        FrameQuaternion waypointOrientation = new FrameQuaternion();
        FrameVector3D waypointAngularVelocity = new FrameVector3D();
        for (int i = 0; i < numberOfWaypoints; ++i) {
            double timeAtWaypoint = numberOfWaypoints == 1 ? trajectoryTime / 2.0 : (double)i * trajectoryTime / ((double)numberOfWaypoints - 1.0);
            simpleTraj.compute(timeAtWaypoint);
            waypointOrientation.setIncludingFrame(simpleTraj.getOrientation());
            waypointAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)simpleTraj.getAngularVelocity());
            multipleWaypointTrajectory.appendWaypoint(timeAtWaypoint, (FrameQuaternionReadOnly)waypointOrientation, (FrameVector3DReadOnly)waypointAngularVelocity);
        }
        multipleWaypointTrajectory.initialize();
        FrameQuaternion orientationToPackMultiple = new FrameQuaternion(worldFrame);
        FrameVector3D angularVelocityToPackMultiple = new FrameVector3D(worldFrame);
        FrameVector3D angularAccelerationToPackMultiple = new FrameVector3D(worldFrame);
        FrameQuaternion orientationToPackSimple = new FrameQuaternion(worldFrame);
        FrameVector3D angularVelocityToPackSimple = new FrameVector3D(worldFrame);
        FrameVector3D angularAccelerationToPackSimple = new FrameVector3D(worldFrame);
        for (double t = 0.0; t <= trajectoryTime; t += dt) {
            multipleWaypointTrajectory.compute(t);
            multipleWaypointTrajectory.getAngularData((FrameOrientation3DBasics)orientationToPackMultiple, (FrameVector3DBasics)angularVelocityToPackMultiple, (FrameVector3DBasics)angularAccelerationToPackMultiple);
            simpleTraj.compute(t);
            simpleTraj.getAngularData((FrameOrientation3DBasics)orientationToPackSimple, (FrameVector3DBasics)angularVelocityToPackSimple, (FrameVector3DBasics)angularAccelerationToPackSimple);
            boolean orientationsEqual = orientationToPackMultiple.epsilonEquals((EuclidFrameGeometry)orientationToPackSimple, 0.001);
            Assert.assertTrue(orientationsEqual);
            boolean angularVelocityEqual = angularVelocityToPackMultiple.epsilonEquals((EuclidFrameGeometry)angularVelocityToPackSimple, 0.001);
            Assert.assertTrue(angularVelocityEqual);
            boolean angularAccelerationEqual = angularAccelerationToPackMultiple.epsilonEquals((EuclidFrameGeometry)angularAccelerationToPackSimple, 0.001);
            angularAccelerationToPackMultiple.sub((FrameTuple3DReadOnly)angularAccelerationToPackSimple);
        }
    }
}

