/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSO3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.SO3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.FrameTrajectoryPointAPIDefaultConfiguration;
import us.ihmc.robotics.math.trajectories.waypoints.TrajectoryPointRandomTools;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class FrameSO3TrajectoryPointTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testCommonUsageExample() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        FrameSO3TrajectoryPoint frameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint(worldFrame);
        SO3TrajectoryPoint simpleTrajectoryPoint = new SO3TrajectoryPoint();
        double time = 3.4;
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        orientation.normalize();
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleTrajectoryPoint.set(time, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)angularVelocity);
        frameSO3TrajectoryPoint.setIncludingFrame(worldFrame, (SO3TrajectoryPointReadOnly)simpleTrajectoryPoint);
        frameSO3TrajectoryPoint.changeFrame((ReferenceFrame)poseFrame);
        RigidBodyTransform transformToPoseFrame = worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame);
        orientation.applyTransform((Transform)transformToPoseFrame);
        transformToPoseFrame.transform((Vector3DBasics)angularVelocity);
        FrameSO3TrajectoryPoint expectedFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint((ReferenceFrame)poseFrame);
        expectedFrameSO3TrajectoryPoint.setTime(time);
        expectedFrameSO3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)orientation);
        expectedFrameSO3TrajectoryPoint.getAngularVelocity().set((Tuple3DReadOnly)angularVelocity);
        Assertions.assertEquals((double)3.4, (double)frameSO3TrajectoryPoint.getTime(), (double)1.0E-7);
        Assertions.assertEquals((double)3.4, (double)expectedFrameSO3TrajectoryPoint.getTime(), (double)1.0E-7);
        Assertions.assertTrue((boolean)expectedFrameSO3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPoint, 1.0E-10));
    }

    @Test
    public void testConstructors() {
        double epsilon = 1.0E-20;
        Random random = new Random(21651016L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        ReferenceFrame aFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"aFrame", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame expectedFrame = worldFrame;
        double expectedTime = 0.0;
        FrameQuaternion expectedOrientation = new FrameQuaternion(expectedFrame);
        FrameVector3D expectedAngularVelocity = new FrameVector3D(expectedFrame);
        FrameSO3TrajectoryPoint testedFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint();
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
        expectedFrame = aFrame;
        expectedTime = 0.0;
        expectedOrientation = new FrameQuaternion(expectedFrame);
        expectedAngularVelocity = new FrameVector3D(expectedFrame);
        testedFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint(expectedFrame);
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameSO3TrajectoryPoint expectedFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint((FrameSO3TrajectoryPointReadOnly)expectedFrameSO3TrajectoryPoint);
        Assertions.assertTrue((boolean)expectedFrameSO3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)testedFrameSO3TrajectoryPoint, epsilon));
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrameSO3TrajectoryPoint.getReferenceFrame(), expectedFrameSO3TrajectoryPoint.getTime(), (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
        ReferenceFrame expectedFinalFrame = aFrame;
        double expectedFinalTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FrameQuaternion expectedFinalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFinalFrame);
        FrameVector3D expectedFinalAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFinalFrame);
        SO3TrajectoryPoint expectedSO3TrajectoryPoint = new SO3TrajectoryPoint();
        expectedSO3TrajectoryPoint.setTime(expectedFinalTime);
        expectedSO3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)expectedFinalOrientation);
        expectedSO3TrajectoryPoint.getAngularVelocity().set((Tuple3DReadOnly)expectedFinalAngularVelocity);
        testedFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint(expectedFinalFrame, (SO3TrajectoryPointReadOnly)expectedSO3TrajectoryPoint);
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFinalFrame, expectedFinalTime, (FrameQuaternionReadOnly)expectedFinalOrientation, (FrameVector3DReadOnly)expectedFinalAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
    }

    @Test
    public void testSetters() {
        double epsilon = 1.0E-15;
        Random random = new Random(21651016L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        ReferenceFrame aFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"aFrame", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame expectedFrame = worldFrame;
        double expectedTime = 0.0;
        FrameQuaternion expectedOrientation = new FrameQuaternion(expectedFrame);
        FrameVector3D expectedAngularVelocity = new FrameVector3D(expectedFrame);
        FrameSO3TrajectoryPoint testedFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint();
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedFrameSO3TrajectoryPoint.set(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedFrameSO3TrajectoryPoint.set(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
        expectedFrame = aFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedFrameSO3TrajectoryPoint.setIncludingFrame(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameSO3TrajectoryPoint expectedFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedFrameSO3TrajectoryPoint.setIncludingFrame((FrameSO3TrajectoryPointReadOnly)expectedFrameSO3TrajectoryPoint);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        expectedFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedFrameSO3TrajectoryPoint.set((FrameSO3TrajectoryPointReadOnly)expectedFrameSO3TrajectoryPoint);
        Assertions.assertTrue((boolean)expectedFrameSO3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)testedFrameSO3TrajectoryPoint, epsilon));
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrameSO3TrajectoryPoint.getReferenceFrame(), expectedFrameSO3TrajectoryPoint.getTime(), (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
        ReferenceFrame expectedFinalFrame = aFrame;
        double expectedFinalTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FrameQuaternion expectedFinalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFinalFrame);
        FrameVector3D expectedFinalAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFinalFrame);
        SO3TrajectoryPoint expectedSO3TrajectoryPoint = new SO3TrajectoryPoint();
        expectedSO3TrajectoryPoint.setTime(expectedFinalTime);
        expectedSO3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)expectedFinalOrientation);
        expectedSO3TrajectoryPoint.getAngularVelocity().set((Tuple3DReadOnly)expectedFinalAngularVelocity);
        testedFrameSO3TrajectoryPoint.setIncludingFrame(expectedFinalFrame, (SO3TrajectoryPointReadOnly)expectedSO3TrajectoryPoint);
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFinalFrame, expectedFinalTime, (FrameQuaternionReadOnly)expectedFinalOrientation, (FrameVector3DReadOnly)expectedFinalAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
    }

    @Test
    public void testChangeFrame() throws Exception {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FrameQuaternion expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameSO3TrajectoryPoint testedFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        for (int i = 0; i < 10000; ++i) {
            expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)("randomFrame" + i), (Random)random, (ReferenceFrame)(random.nextBoolean() ? worldFrame : expectedFrame));
            expectedOrientation.changeFrame(expectedFrame);
            expectedAngularVelocity.changeFrame(expectedFrame);
            testedFrameSO3TrajectoryPoint.changeFrame(expectedFrame);
            FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FrameQuaternion expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameSO3TrajectoryPoint testedFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        expectedTime = 0.0;
        expectedOrientation.setToZero();
        expectedAngularVelocity.setToZero();
        testedFrameSO3TrajectoryPoint.setToZero();
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
        expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"blop", (Random)random, (ReferenceFrame)worldFrame);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        testedFrameSO3TrajectoryPoint.setIncludingFrame(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        expectedTime = 0.0;
        expectedOrientation.setToZero(expectedFrame);
        expectedAngularVelocity.setToZero(expectedFrame);
        testedFrameSO3TrajectoryPoint.setToZero(expectedFrame);
        FrameSO3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSO3TrajectoryPoint, epsilon);
    }

    @Test
    public void testSetToNaN() throws Exception {
        ReferenceFrame worldFrame;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FrameQuaternion expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameSO3TrajectoryPoint testedFrameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedFrameSO3TrajectoryPoint.setToNaN();
        Assertions.assertTrue((boolean)Double.isNaN(testedFrameSO3TrajectoryPoint.getTime()));
        Assertions.assertTrue((boolean)testedFrameSO3TrajectoryPoint.containsNaN());
        expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"blop", (Random)random, (ReferenceFrame)worldFrame);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        testedFrameSO3TrajectoryPoint.setIncludingFrame(expectedTime, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedFrameSO3TrajectoryPoint.setToNaN(expectedFrame);
        Assertions.assertTrue((expectedFrame == testedFrameSO3TrajectoryPoint.getReferenceFrame() ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Double.isNaN(testedFrameSO3TrajectoryPoint.getTime()));
        Assertions.assertTrue((boolean)testedFrameSO3TrajectoryPoint.containsNaN());
    }

    static void assertTrajectoryPointContainsExpectedData(ReferenceFrame expectedFrame, double expectedTime, FrameQuaternionReadOnly expectedOrientation, FrameVector3DReadOnly expectedAngularVelocity, FrameSO3TrajectoryPoint testedFrameSO3TrajectoryPoint, double epsilon) {
        Assertions.assertTrue((expectedFrame == testedFrameSO3TrajectoryPoint.getReferenceFrame() ? 1 : 0) != 0);
        Assertions.assertEquals((double)expectedTime, (double)testedFrameSO3TrajectoryPoint.getTime(), (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedOrientation, (EuclidFrameGeometry)testedFrameSO3TrajectoryPoint.getOrientation(), (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedAngularVelocity, (EuclidFrameGeometry)testedFrameSO3TrajectoryPoint.getAngularVelocity(), (double)epsilon);
        Quaternion actualOrientation = new Quaternion();
        Vector3D actualAngularVelocity = new Vector3D();
        actualOrientation.set((QuaternionReadOnly)testedFrameSO3TrajectoryPoint.getOrientation());
        actualAngularVelocity.set((Tuple3DReadOnly)testedFrameSO3TrajectoryPoint.getAngularVelocity());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedOrientation, (EuclidGeometry)actualOrientation, (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularVelocity, (EuclidGeometry)actualAngularVelocity, (double)epsilon);
        FrameQuaternion actualFrameOrientation = new FrameQuaternion();
        FrameVector3D actualFrameAngularVelocity = new FrameVector3D();
        actualFrameOrientation.setIncludingFrame((FrameQuaternionReadOnly)testedFrameSO3TrajectoryPoint.getOrientation());
        actualFrameAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)testedFrameSO3TrajectoryPoint.getAngularVelocity());
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedOrientation, (EuclidFrameGeometry)actualFrameOrientation, (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedAngularVelocity, (EuclidFrameGeometry)actualFrameAngularVelocity, (double)epsilon);
        actualFrameOrientation = new FrameQuaternion(expectedFrame);
        actualFrameAngularVelocity = new FrameVector3D(expectedFrame);
        actualFrameOrientation.set((FrameQuaternionReadOnly)testedFrameSO3TrajectoryPoint.getOrientation());
        actualFrameAngularVelocity.set((FrameTuple3DReadOnly)testedFrameSO3TrajectoryPoint.getAngularVelocity());
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedOrientation, (EuclidFrameGeometry)actualFrameOrientation, (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedAngularVelocity, (EuclidFrameGeometry)actualFrameAngularVelocity, (double)epsilon);
    }

    @Test
    public void testSomeSetsAngGets() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        FrameSO3TrajectoryPoint FrameSO3TrajectoryPoint2 = new FrameSO3TrajectoryPoint(worldFrame);
        FrameSO3TrajectoryPoint2.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        SO3TrajectoryPoint simpleTrajectoryPoint = new SO3TrajectoryPoint();
        double time = 3.4;
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        orientation.normalize();
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleTrajectoryPoint.set(time, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)angularVelocity);
        FrameSO3TrajectoryPoint2.setIncludingFrame(worldFrame, (SO3TrajectoryPointReadOnly)simpleTrajectoryPoint);
        FrameQuaternion quaternionForVerification = new FrameQuaternion(worldFrame);
        FrameVector3D angularVelocityForVerification = new FrameVector3D(worldFrame);
        quaternionForVerification.set((FrameQuaternionReadOnly)FrameSO3TrajectoryPoint2.getOrientation());
        angularVelocityForVerification.set((FrameTuple3DReadOnly)FrameSO3TrajectoryPoint2.getAngularVelocity());
        Assertions.assertEquals((double)time, (double)FrameSO3TrajectoryPoint2.getTime(), (double)1.0E-10);
        Assertions.assertTrue((boolean)quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-10));
        Assertions.assertTrue((boolean)angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-10));
        Assertions.assertFalse((boolean)FrameSO3TrajectoryPoint2.containsNaN());
        FrameSO3TrajectoryPoint2.getOrientation().setToNaN();
        Assertions.assertTrue((boolean)FrameSO3TrajectoryPoint2.containsNaN());
        FrameSO3TrajectoryPoint2.getOrientation().setToZero();
        Assertions.assertFalse((boolean)FrameSO3TrajectoryPoint2.containsNaN());
        FrameSO3TrajectoryPoint2.getAngularVelocity().setToNaN();
        Assertions.assertTrue((boolean)FrameSO3TrajectoryPoint2.containsNaN());
        FrameSO3TrajectoryPoint2.getAngularVelocity().setToZero();
        Assertions.assertFalse((boolean)FrameSO3TrajectoryPoint2.containsNaN());
        orientation.set((QuaternionReadOnly)FrameSO3TrajectoryPoint2.getOrientation());
        angularVelocity.set((Tuple3DReadOnly)FrameSO3TrajectoryPoint2.getAngularVelocity());
        Assertions.assertTrue((boolean)orientation.epsilonEquals((EuclidGeometry)new Quaternion(), 1.0E-10));
        Assertions.assertTrue((boolean)angularVelocity.epsilonEquals((EuclidGeometry)new Vector3D(), 1.0E-10));
        time = 9.9;
        quaternionForVerification.setYawPitchRoll(0.2, 0.6, 1.1);
        angularVelocityForVerification.set(7.1, 2.2, 3.33);
        Assertions.assertFalse((Math.abs(FrameSO3TrajectoryPoint2.getTime() - time) < 1.0E-7 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-7));
        Assertions.assertFalse((boolean)angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-7));
        FrameSO3TrajectoryPoint2.set(time, (FrameOrientation3DReadOnly)quaternionForVerification, (FrameVector3DReadOnly)angularVelocityForVerification);
        orientation.set((QuaternionReadOnly)FrameSO3TrajectoryPoint2.getOrientation());
        angularVelocity.set((Tuple3DReadOnly)FrameSO3TrajectoryPoint2.getAngularVelocity());
        Assertions.assertEquals((double)time, (double)FrameSO3TrajectoryPoint2.getTime(), (double)1.0E-10);
        Assertions.assertTrue((boolean)quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-10));
        Assertions.assertTrue((boolean)angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-10));
        FrameSO3TrajectoryPoint frameSO3TrajectoryPointTwo = new FrameSO3TrajectoryPoint(worldFrame);
        Assertions.assertFalse((boolean)FrameSO3TrajectoryPoint2.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPointTwo, 1.0E-7));
        frameSO3TrajectoryPointTwo.set((FrameSO3TrajectoryPointReadOnly)FrameSO3TrajectoryPoint2);
        Assertions.assertTrue((boolean)FrameSO3TrajectoryPoint2.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPointTwo, 1.0E-7));
        SO3TrajectoryPoint simplePoint = new SO3TrajectoryPoint();
        simplePoint.set((SO3TrajectoryPointReadOnly)FrameSO3TrajectoryPoint2);
        FrameSO3TrajectoryPoint2.setToNaN();
        Assertions.assertTrue((boolean)FrameSO3TrajectoryPoint2.containsNaN());
        Assertions.assertFalse((boolean)FrameSO3TrajectoryPoint2.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPointTwo, 1.0E-7));
        SO3TrajectoryPoint trajectoryPointAsInterface = simplePoint;
        FrameSO3TrajectoryPoint2.set((SO3TrajectoryPointReadOnly)trajectoryPointAsInterface);
        Assertions.assertTrue((boolean)FrameSO3TrajectoryPoint2.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPointTwo, 1.0E-7));
        String string = FrameSO3TrajectoryPoint2.toString();
        String expectedString = "SO3 trajectory point: [time= 9.900, orientation=( 0.472,  0.301, -0.072,  0.826 ), angular velocity=( 7.100,  2.200,  3.330 )] - World";
        Assertions.assertEquals((Object)expectedString, (Object)string);
    }

    @Test
    public void testSomeMoreSettersAndGetters() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        FrameSO3TrajectoryPoint frameSO3TrajectoryPoint = new FrameSO3TrajectoryPoint(worldFrame);
        frameSO3TrajectoryPoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        double time = 3.4;
        FramePoint3D position = new FramePoint3D(worldFrame, 1.0, 2.1, 3.7);
        FrameQuaternion orientation = new FrameQuaternion(worldFrame, (QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        FrameVector3D linearVelocity = new FrameVector3D(worldFrame, -0.4, 1.2, 3.3);
        FrameVector3D angularVelocity = new FrameVector3D(worldFrame, 1.7, 8.4, 2.2);
        frameSO3TrajectoryPoint.setTime(time);
        frameSO3TrajectoryPoint.getOrientation().set((FrameOrientation3DReadOnly)orientation);
        frameSO3TrajectoryPoint.getAngularVelocity().set((FrameTuple3DReadOnly)angularVelocity);
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        frameSO3TrajectoryPoint.changeFrame((ReferenceFrame)poseFrame);
        Assertions.assertFalse((boolean)orientation.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPoint.getOrientation(), 1.0E-10));
        Assertions.assertFalse((boolean)angularVelocity.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPoint.getAngularVelocity(), 1.0E-10));
        position.changeFrame((ReferenceFrame)poseFrame);
        orientation.changeFrame((ReferenceFrame)poseFrame);
        linearVelocity.changeFrame((ReferenceFrame)poseFrame);
        angularVelocity.changeFrame((ReferenceFrame)poseFrame);
        Assertions.assertTrue((boolean)orientation.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPoint.getOrientation(), 1.0E-10));
        Assertions.assertTrue((boolean)angularVelocity.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPoint.getAngularVelocity(), 1.0E-10));
        FrameSO3TrajectoryPoint frameSO3TrajectoryPointTwo = new FrameSO3TrajectoryPoint((ReferenceFrame)poseFrame);
        frameSO3TrajectoryPointTwo.setTime(time);
        frameSO3TrajectoryPointTwo.getOrientation().set((FrameOrientation3DReadOnly)orientation);
        frameSO3TrajectoryPointTwo.getAngularVelocity().set((FrameTuple3DReadOnly)angularVelocity);
        Assertions.assertTrue((boolean)frameSO3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPointTwo, 1.0E-10));
        frameSO3TrajectoryPointTwo = new FrameSO3TrajectoryPoint(worldFrame);
        frameSO3TrajectoryPointTwo.setIncludingFrame((ReferenceFrame)poseFrame, time, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)new Vector3D((Tuple3DReadOnly)angularVelocity));
        Assertions.assertTrue((boolean)frameSO3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPointTwo, 1.0E-10));
        frameSO3TrajectoryPointTwo = new FrameSO3TrajectoryPoint((ReferenceFrame)poseFrame);
        FrameSO3TrajectoryPoint SO3Waypoint2 = frameSO3TrajectoryPoint;
        frameSO3TrajectoryPointTwo.set(time, (SO3WaypointReadOnly)SO3Waypoint2);
        Assertions.assertTrue((boolean)frameSO3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPoint, 1.0E-10));
        frameSO3TrajectoryPointTwo = new FrameSO3TrajectoryPoint(worldFrame);
        frameSO3TrajectoryPointTwo.setIncludingFrame((ReferenceFrame)poseFrame, time, (SO3WaypointReadOnly)SO3Waypoint2);
        Assertions.assertTrue((boolean)frameSO3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPoint, 1.0E-10));
        frameSO3TrajectoryPointTwo = new FrameSO3TrajectoryPoint((ReferenceFrame)poseFrame);
        FrameSO3TrajectoryPoint frameSO3Waypoint = frameSO3TrajectoryPoint;
        frameSO3TrajectoryPointTwo.set(time, (FrameSO3WaypointReadOnly)frameSO3Waypoint);
        Assertions.assertTrue((boolean)frameSO3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPoint, 1.0E-10));
        frameSO3TrajectoryPointTwo = new FrameSO3TrajectoryPoint(worldFrame);
        frameSO3TrajectoryPointTwo.setIncludingFrame(time, (FrameSO3WaypointReadOnly)frameSO3Waypoint);
        Assertions.assertTrue((boolean)frameSO3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameSO3TrajectoryPoint, 1.0E-10));
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new FrameTrajectoryPointAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(TrajectoryPointRandomTools::nextFrameSO3TrajectoryPoint, methodFilter, 10);
    }

    @Test
    public void testConsistencyWithSO3TrajectoryPoint() throws Exception {
        FrameTypeCopier frameTypeBuilder = (frame, TrajectoryPoint) -> new FrameSO3TrajectoryPoint(frame, (SO3TrajectoryPointReadOnly)TrajectoryPoint);
        RandomFramelessTypeBuilder framelessTypeBuilber = TrajectoryPointRandomTools::nextSO3TrajectoryPoint;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("toString");
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new FrameTrajectoryPointAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilber, methodFilter, 10);
    }

    @Test
    public void testOverloading() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new FrameTrajectoryPointAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameSO3TrajectoryPointBasics.class, SO3TrajectoryPointBasics.class, false, 1);
        tester.assertOverloadingWithFrameObjects(FrameSO3TrajectoryPointReadOnly.class, SO3TrajectoryPointReadOnly.class, false, 1);
    }
}

