/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.SE3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSE3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSE3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SE3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SE3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.FrameTrajectoryPointAPIDefaultConfiguration;
import us.ihmc.robotics.math.trajectories.waypoints.TrajectoryPointRandomTools;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSE3WaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SE3WaypointReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class FrameSE3TrajectoryPointTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testCommonUsageExample() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        FrameSE3TrajectoryPoint frameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint(worldFrame);
        SE3TrajectoryPoint simpleTrajectoryPoint = new SE3TrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        orientation.normalize();
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleTrajectoryPoint.set(time, (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)linearVelocity, (Vector3DReadOnly)angularVelocity);
        frameSE3TrajectoryPoint.setIncludingFrame(worldFrame, (SE3TrajectoryPointReadOnly)simpleTrajectoryPoint);
        frameSE3TrajectoryPoint.changeFrame((ReferenceFrame)poseFrame);
        RigidBodyTransform transformToPoseFrame = worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame);
        transformToPoseFrame.transform((Point3DBasics)position);
        orientation.applyTransform((Transform)transformToPoseFrame);
        transformToPoseFrame.transform((Vector3DBasics)linearVelocity);
        transformToPoseFrame.transform((Vector3DBasics)angularVelocity);
        FrameSE3TrajectoryPoint expectedFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint((ReferenceFrame)poseFrame);
        expectedFrameSE3TrajectoryPoint.setTime(time);
        expectedFrameSE3TrajectoryPoint.getPosition().set((Tuple3DReadOnly)position);
        expectedFrameSE3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)orientation);
        expectedFrameSE3TrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)linearVelocity);
        expectedFrameSE3TrajectoryPoint.getAngularVelocity().set((Tuple3DReadOnly)angularVelocity);
        Assert.assertEquals(3.4, frameSE3TrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertEquals(3.4, expectedFrameSE3TrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertTrue(expectedFrameSE3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint, 1.0E-10));
    }

    @Test
    public void testConstructors() {
        double epsilon = 1.0E-20;
        Random random = new Random(21651016L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        ReferenceFrame aFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"aFrame", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame expectedFrame = worldFrame;
        double expectedTime = 0.0;
        FramePoint3D expectedPosition = new FramePoint3D(expectedFrame);
        FrameQuaternion expectedOrientation = new FrameQuaternion(expectedFrame);
        FrameVector3D expectedLinearVelocity = new FrameVector3D(expectedFrame);
        FrameVector3D expectedAngularVelocity = new FrameVector3D(expectedFrame);
        FrameSE3TrajectoryPoint testedFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint();
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
        expectedFrame = aFrame;
        expectedTime = 0.0;
        expectedPosition = new FramePoint3D(expectedFrame);
        expectedOrientation = new FrameQuaternion(expectedFrame);
        expectedLinearVelocity = new FrameVector3D(expectedFrame);
        expectedAngularVelocity = new FrameVector3D(expectedFrame);
        testedFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint(expectedFrame);
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameSE3TrajectoryPoint expectedFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint((FrameSE3TrajectoryPointBasics)expectedFrameSE3TrajectoryPoint);
        Assert.assertTrue(expectedFrameSE3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)testedFrameSE3TrajectoryPoint, epsilon));
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrameSE3TrajectoryPoint.getReferenceFrame(), expectedFrameSE3TrajectoryPoint.getTime(), (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
        ReferenceFrame expectedFinalFrame = aFrame;
        double expectedFinalTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedFinalPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFinalFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameQuaternion expectedFinalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFinalFrame);
        FrameVector3D expectedFinalLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFinalFrame);
        FrameVector3D expectedFinalAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFinalFrame);
        SE3TrajectoryPoint expectedSE3TrajectoryPoint = new SE3TrajectoryPoint();
        expectedSE3TrajectoryPoint.setTime(expectedFinalTime);
        expectedSE3TrajectoryPoint.getPosition().set((Tuple3DReadOnly)expectedFinalPosition);
        expectedSE3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)expectedFinalOrientation);
        expectedSE3TrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)expectedFinalLinearVelocity);
        expectedSE3TrajectoryPoint.getAngularVelocity().set((Tuple3DReadOnly)expectedFinalAngularVelocity);
        testedFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint(expectedFinalFrame, (SE3TrajectoryPointReadOnly)expectedSE3TrajectoryPoint);
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFinalFrame, expectedFinalTime, (FramePoint3DReadOnly)expectedFinalPosition, (FrameQuaternionReadOnly)expectedFinalOrientation, (FrameVector3DReadOnly)expectedFinalLinearVelocity, (FrameVector3DReadOnly)expectedFinalAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
    }

    @Test
    public void testSetters() {
        double epsilon = 1.0E-15;
        Random random = new Random(21651016L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        ReferenceFrame aFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"aFrame", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame expectedFrame = worldFrame;
        double expectedTime = 0.0;
        FramePoint3D expectedPosition = new FramePoint3D(expectedFrame);
        FrameQuaternion expectedOrientation = new FrameQuaternion(expectedFrame);
        FrameVector3D expectedLinearVelocity = new FrameVector3D(expectedFrame);
        FrameVector3D expectedAngularVelocity = new FrameVector3D(expectedFrame);
        FrameSE3TrajectoryPoint testedFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint();
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedFrameSE3TrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedFrameSE3TrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
        expectedFrame = aFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedFrameSE3TrajectoryPoint.setIncludingFrame(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameSE3TrajectoryPoint expectedFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedFrameSE3TrajectoryPoint.setIncludingFrame((FrameSE3TrajectoryPointReadOnly)expectedFrameSE3TrajectoryPoint);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        expectedFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedFrameSE3TrajectoryPoint.set((FrameSE3TrajectoryPointReadOnly)expectedFrameSE3TrajectoryPoint);
        Assert.assertTrue(expectedFrameSE3TrajectoryPoint.epsilonEquals((EuclidFrameGeometry)testedFrameSE3TrajectoryPoint, epsilon));
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrameSE3TrajectoryPoint.getReferenceFrame(), expectedFrameSE3TrajectoryPoint.getTime(), (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
        ReferenceFrame expectedFinalFrame = aFrame;
        double expectedFinalTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedFinalPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFinalFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameQuaternion expectedFinalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFinalFrame);
        FrameVector3D expectedFinalLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFinalFrame);
        FrameVector3D expectedFinalAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFinalFrame);
        SE3TrajectoryPoint expectedSE3TrajectoryPoint = new SE3TrajectoryPoint();
        expectedSE3TrajectoryPoint.setTime(expectedFinalTime);
        expectedSE3TrajectoryPoint.getPosition().set((Tuple3DReadOnly)expectedFinalPosition);
        expectedSE3TrajectoryPoint.getOrientation().set((Orientation3DReadOnly)expectedFinalOrientation);
        expectedSE3TrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)expectedFinalLinearVelocity);
        expectedSE3TrajectoryPoint.getAngularVelocity().set((Tuple3DReadOnly)expectedFinalAngularVelocity);
        testedFrameSE3TrajectoryPoint.setIncludingFrame(expectedFinalFrame, (SE3TrajectoryPointReadOnly)expectedSE3TrajectoryPoint);
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFinalFrame, expectedFinalTime, (FramePoint3DReadOnly)expectedFinalPosition, (FrameQuaternionReadOnly)expectedFinalOrientation, (FrameVector3DReadOnly)expectedFinalLinearVelocity, (FrameVector3DReadOnly)expectedFinalAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
    }

    @Test
    public void testChangeFrame() throws Exception {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameQuaternion expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameSE3TrajectoryPoint testedFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        for (int i = 0; i < 10000; ++i) {
            expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)("randomFrame" + i), (Random)random, (ReferenceFrame)(random.nextBoolean() ? worldFrame : expectedFrame));
            expectedPosition.changeFrame(expectedFrame);
            expectedOrientation.changeFrame(expectedFrame);
            expectedLinearVelocity.changeFrame(expectedFrame);
            expectedAngularVelocity.changeFrame(expectedFrame);
            testedFrameSE3TrajectoryPoint.changeFrame(expectedFrame);
            FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameQuaternion expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameSE3TrajectoryPoint testedFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        expectedTime = 0.0;
        expectedPosition.setToZero();
        expectedOrientation.setToZero();
        expectedLinearVelocity.setToZero();
        expectedAngularVelocity.setToZero();
        testedFrameSE3TrajectoryPoint.setToZero();
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
        expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"blop", (Random)random, (ReferenceFrame)worldFrame);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        testedFrameSE3TrajectoryPoint.setIncludingFrame(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        expectedTime = 0.0;
        expectedPosition.setToZero(expectedFrame);
        expectedOrientation.setToZero(expectedFrame);
        expectedLinearVelocity.setToZero(expectedFrame);
        expectedAngularVelocity.setToZero(expectedFrame);
        testedFrameSE3TrajectoryPoint.setToZero(expectedFrame);
        FrameSE3TrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameQuaternionReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity, testedFrameSE3TrajectoryPoint, epsilon);
    }

    @Test
    public void testSetToNaN() throws Exception {
        ReferenceFrame worldFrame;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameQuaternion expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameVector3D expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameSE3TrajectoryPoint testedFrameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedFrameSE3TrajectoryPoint.setToNaN();
        Assert.assertTrue(Double.isNaN(testedFrameSE3TrajectoryPoint.getTime()));
        Assert.assertTrue(testedFrameSE3TrajectoryPoint.containsNaN());
        expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"blop", (Random)random, (ReferenceFrame)worldFrame);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        expectedAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        testedFrameSE3TrajectoryPoint.setIncludingFrame(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameOrientation3DReadOnly)expectedOrientation, (FrameVector3DReadOnly)expectedLinearVelocity, (FrameVector3DReadOnly)expectedAngularVelocity);
        testedFrameSE3TrajectoryPoint.setToNaN(expectedFrame);
        Assert.assertTrue(expectedFrame == testedFrameSE3TrajectoryPoint.getReferenceFrame());
        Assert.assertTrue(Double.isNaN(testedFrameSE3TrajectoryPoint.getTime()));
        Assert.assertTrue(testedFrameSE3TrajectoryPoint.containsNaN());
    }

    static void assertTrajectoryPointContainsExpectedData(ReferenceFrame expectedFrame, double expectedTime, FramePoint3DReadOnly expectedPosition, FrameQuaternionReadOnly expectedOrientation, FrameVector3DReadOnly expectedLinearVelocity, FrameVector3DReadOnly expectedAngularVelocity, FrameSE3TrajectoryPoint testedFrameSE3TrajectoryPoint, double epsilon) {
        Assert.assertTrue(expectedFrame == testedFrameSE3TrajectoryPoint.getReferenceFrame());
        Assert.assertEquals(expectedTime, testedFrameSE3TrajectoryPoint.getTime(), epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedPosition, (EuclidFrameGeometry)testedFrameSE3TrajectoryPoint.getPosition(), (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedOrientation, (EuclidFrameGeometry)testedFrameSE3TrajectoryPoint.getOrientation(), (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedLinearVelocity, (EuclidFrameGeometry)testedFrameSE3TrajectoryPoint.getLinearVelocity(), (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedAngularVelocity, (EuclidFrameGeometry)testedFrameSE3TrajectoryPoint.getAngularVelocity(), (double)epsilon);
        Point3D actualPosition = new Point3D();
        Quaternion actualOrientation = new Quaternion();
        Vector3D actualLinearVelocity = new Vector3D();
        Vector3D actualAngularVelocity = new Vector3D();
        actualPosition.set((Tuple3DReadOnly)testedFrameSE3TrajectoryPoint.getPosition());
        actualOrientation.set((QuaternionReadOnly)testedFrameSE3TrajectoryPoint.getOrientation());
        actualLinearVelocity.set((Tuple3DReadOnly)testedFrameSE3TrajectoryPoint.getLinearVelocity());
        actualAngularVelocity.set((Tuple3DReadOnly)testedFrameSE3TrajectoryPoint.getAngularVelocity());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPosition, (EuclidGeometry)actualPosition, (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedOrientation, (EuclidGeometry)actualOrientation, (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLinearVelocity, (EuclidGeometry)actualLinearVelocity, (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularVelocity, (EuclidGeometry)actualAngularVelocity, (double)epsilon);
        FramePoint3D actualFramePosition = new FramePoint3D();
        FrameQuaternion actualFrameOrientation = new FrameQuaternion();
        FrameVector3D actualFrameLinearVelocity = new FrameVector3D();
        FrameVector3D actualFrameAngularVelocity = new FrameVector3D();
        actualFramePosition.setIncludingFrame((FrameTuple3DReadOnly)testedFrameSE3TrajectoryPoint.getPosition());
        actualFrameOrientation.setIncludingFrame((FrameQuaternionReadOnly)testedFrameSE3TrajectoryPoint.getOrientation());
        actualFrameLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)testedFrameSE3TrajectoryPoint.getLinearVelocity());
        actualFrameAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)testedFrameSE3TrajectoryPoint.getAngularVelocity());
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedPosition, (EuclidFrameGeometry)actualFramePosition, (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedOrientation, (EuclidFrameGeometry)actualFrameOrientation, (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedLinearVelocity, (EuclidFrameGeometry)actualFrameLinearVelocity, (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedAngularVelocity, (EuclidFrameGeometry)actualFrameAngularVelocity, (double)epsilon);
        actualFramePosition = new FramePoint3D(expectedFrame);
        actualFrameOrientation = new FrameQuaternion(expectedFrame);
        actualFrameLinearVelocity = new FrameVector3D(expectedFrame);
        actualFrameAngularVelocity = new FrameVector3D(expectedFrame);
        actualFramePosition.set((FrameTuple3DReadOnly)testedFrameSE3TrajectoryPoint.getPosition());
        actualFrameOrientation.set((FrameQuaternionReadOnly)testedFrameSE3TrajectoryPoint.getOrientation());
        actualFrameLinearVelocity.set((FrameTuple3DReadOnly)testedFrameSE3TrajectoryPoint.getLinearVelocity());
        actualFrameAngularVelocity.set((FrameTuple3DReadOnly)testedFrameSE3TrajectoryPoint.getAngularVelocity());
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedPosition, (EuclidFrameGeometry)actualFramePosition, (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedOrientation, (EuclidFrameGeometry)actualFrameOrientation, (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedLinearVelocity, (EuclidFrameGeometry)actualFrameLinearVelocity, (double)epsilon);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedAngularVelocity, (EuclidFrameGeometry)actualFrameAngularVelocity, (double)epsilon);
    }

    @Test
    public void testSomeSetsAngGets() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        FrameSE3TrajectoryPoint FrameSE3TrajectoryPoint2 = new FrameSE3TrajectoryPoint(worldFrame);
        FrameSE3TrajectoryPoint2.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        SE3TrajectoryPoint simpleTrajectoryPoint = new SE3TrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Quaternion orientation = new Quaternion((QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        orientation.normalize();
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        Vector3D angularVelocity = new Vector3D(1.7, 8.4, 2.2);
        simpleTrajectoryPoint.set(time, (Point3DReadOnly)position, (Orientation3DReadOnly)orientation, (Vector3DReadOnly)linearVelocity, (Vector3DReadOnly)angularVelocity);
        FrameSE3TrajectoryPoint2.setIncludingFrame(worldFrame, (SE3TrajectoryPointReadOnly)simpleTrajectoryPoint);
        FramePoint3D pointForVerification = new FramePoint3D(worldFrame);
        FrameQuaternion quaternionForVerification = new FrameQuaternion(worldFrame);
        FrameVector3D linearVelocityForVerification = new FrameVector3D(worldFrame);
        FrameVector3D angularVelocityForVerification = new FrameVector3D(worldFrame);
        pointForVerification.set((FrameTuple3DReadOnly)FrameSE3TrajectoryPoint2.getPosition());
        quaternionForVerification.set((FrameQuaternionReadOnly)FrameSE3TrajectoryPoint2.getOrientation());
        linearVelocityForVerification.set((FrameTuple3DReadOnly)FrameSE3TrajectoryPoint2.getLinearVelocity());
        angularVelocityForVerification.set((FrameTuple3DReadOnly)FrameSE3TrajectoryPoint2.getAngularVelocity());
        Assert.assertEquals(time, FrameSE3TrajectoryPoint2.getTime(), 1.0E-10);
        Assert.assertTrue(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-10));
        Assert.assertTrue(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-10));
        Assert.assertTrue(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-10));
        Assert.assertTrue(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-10));
        Assert.assertFalse(FrameSE3TrajectoryPoint2.containsNaN());
        FrameSE3TrajectoryPoint2.getPosition().setToNaN();
        Assert.assertTrue(FrameSE3TrajectoryPoint2.containsNaN());
        FrameSE3TrajectoryPoint2.getPosition().setToZero();
        Assert.assertFalse(FrameSE3TrajectoryPoint2.containsNaN());
        FrameSE3TrajectoryPoint2.getOrientation().setToNaN();
        Assert.assertTrue(FrameSE3TrajectoryPoint2.containsNaN());
        FrameSE3TrajectoryPoint2.getOrientation().setToZero();
        Assert.assertFalse(FrameSE3TrajectoryPoint2.containsNaN());
        FrameSE3TrajectoryPoint2.getLinearVelocity().setToNaN();
        Assert.assertTrue(FrameSE3TrajectoryPoint2.containsNaN());
        FrameSE3TrajectoryPoint2.getLinearVelocity().setToZero();
        Assert.assertFalse(FrameSE3TrajectoryPoint2.containsNaN());
        FrameSE3TrajectoryPoint2.getAngularVelocity().setToNaN();
        Assert.assertTrue(FrameSE3TrajectoryPoint2.containsNaN());
        FrameSE3TrajectoryPoint2.getAngularVelocity().setToZero();
        Assert.assertFalse(FrameSE3TrajectoryPoint2.containsNaN());
        position.set((Tuple3DReadOnly)FrameSE3TrajectoryPoint2.getPosition());
        orientation.set((QuaternionReadOnly)FrameSE3TrajectoryPoint2.getOrientation());
        linearVelocity.set((Tuple3DReadOnly)FrameSE3TrajectoryPoint2.getLinearVelocity());
        angularVelocity.set((Tuple3DReadOnly)FrameSE3TrajectoryPoint2.getAngularVelocity());
        Assert.assertTrue(position.epsilonEquals((EuclidGeometry)new Point3D(), 1.0E-10));
        Assert.assertTrue(orientation.epsilonEquals((EuclidGeometry)new Quaternion(), 1.0E-10));
        Assert.assertTrue(linearVelocity.epsilonEquals((EuclidGeometry)new Vector3D(), 1.0E-10));
        Assert.assertTrue(angularVelocity.epsilonEquals((EuclidGeometry)new Vector3D(), 1.0E-10));
        time = 9.9;
        pointForVerification.set(3.9, 2.2, 1.1);
        quaternionForVerification.setYawPitchRoll(0.2, 0.6, 1.1);
        linearVelocityForVerification.set(8.8, 1.4, 9.22);
        angularVelocityForVerification.set(7.1, 2.2, 3.33);
        Assert.assertFalse(Math.abs(FrameSE3TrajectoryPoint2.getTime() - time) < 1.0E-7);
        Assert.assertFalse(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-7));
        Assert.assertFalse(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-7));
        Assert.assertFalse(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-7));
        Assert.assertFalse(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-7));
        FrameSE3TrajectoryPoint2.set(time, (FramePoint3DReadOnly)pointForVerification, (FrameOrientation3DReadOnly)quaternionForVerification, (FrameVector3DReadOnly)linearVelocityForVerification, (FrameVector3DReadOnly)angularVelocityForVerification);
        position.set((Tuple3DReadOnly)FrameSE3TrajectoryPoint2.getPosition());
        orientation.set((QuaternionReadOnly)FrameSE3TrajectoryPoint2.getOrientation());
        linearVelocity.set((Tuple3DReadOnly)FrameSE3TrajectoryPoint2.getLinearVelocity());
        angularVelocity.set((Tuple3DReadOnly)FrameSE3TrajectoryPoint2.getAngularVelocity());
        Assert.assertEquals(time, FrameSE3TrajectoryPoint2.getTime(), 1.0E-10);
        Assert.assertTrue(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-10));
        Assert.assertTrue(quaternionForVerification.epsilonEquals((EuclidGeometry)orientation, 1.0E-10));
        Assert.assertTrue(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-10));
        Assert.assertTrue(angularVelocityForVerification.epsilonEquals((EuclidGeometry)angularVelocity, 1.0E-10));
        FrameSE3TrajectoryPoint FrameSE3TrajectoryPointTwo = new FrameSE3TrajectoryPoint(worldFrame);
        double positionDistance = FrameSE3TrajectoryPoint2.positionDistance((FrameEuclideanWaypointReadOnly)FrameSE3TrajectoryPointTwo);
        Assert.assertEquals(4.610856753359402, positionDistance, 1.0E-7);
        Assert.assertFalse(FrameSE3TrajectoryPoint2.epsilonEquals((EuclidFrameGeometry)FrameSE3TrajectoryPointTwo, 1.0E-7));
        FrameSE3TrajectoryPointTwo.set((FrameSE3TrajectoryPointReadOnly)FrameSE3TrajectoryPoint2);
        positionDistance = FrameSE3TrajectoryPoint2.positionDistance((FrameEuclideanWaypointReadOnly)FrameSE3TrajectoryPointTwo);
        Assert.assertEquals(0.0, positionDistance, 1.0E-7);
        Assert.assertTrue(FrameSE3TrajectoryPoint2.epsilonEquals((EuclidFrameGeometry)FrameSE3TrajectoryPointTwo, 1.0E-7));
        SE3TrajectoryPoint simplePoint = new SE3TrajectoryPoint();
        simplePoint.set((SE3TrajectoryPointReadOnly)FrameSE3TrajectoryPoint2);
        FrameSE3TrajectoryPoint2.setToNaN();
        Assert.assertTrue(FrameSE3TrajectoryPoint2.containsNaN());
        positionDistance = FrameSE3TrajectoryPoint2.positionDistance((FrameEuclideanWaypointReadOnly)FrameSE3TrajectoryPointTwo);
        Assert.assertTrue(Double.isNaN(positionDistance));
        Assert.assertFalse(FrameSE3TrajectoryPoint2.epsilonEquals((EuclidFrameGeometry)FrameSE3TrajectoryPointTwo, 1.0E-7));
        SE3TrajectoryPoint trajectoryPointAsInterface = simplePoint;
        FrameSE3TrajectoryPoint2.set((SE3TrajectoryPointReadOnly)trajectoryPointAsInterface);
        positionDistance = FrameSE3TrajectoryPoint2.positionDistance((FrameEuclideanWaypointReadOnly)FrameSE3TrajectoryPointTwo);
        Assert.assertEquals(0.0, positionDistance, 1.0E-7);
        Assert.assertTrue(FrameSE3TrajectoryPoint2.epsilonEquals((EuclidFrameGeometry)FrameSE3TrajectoryPointTwo, 1.0E-7));
    }

    @Test
    public void testSomeMoreSettersAndGetters() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        FrameSE3TrajectoryPoint frameSE3TrajectoryPoint = new FrameSE3TrajectoryPoint(worldFrame);
        frameSE3TrajectoryPoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        double time = 3.4;
        FramePoint3D position = new FramePoint3D(worldFrame, 1.0, 2.1, 3.7);
        FrameQuaternion orientation = new FrameQuaternion(worldFrame, (QuaternionReadOnly)new Quaternion(0.1, 0.22, 0.34, 0.56));
        FrameVector3D linearVelocity = new FrameVector3D(worldFrame, -0.4, 1.2, 3.3);
        FrameVector3D angularVelocity = new FrameVector3D(worldFrame, 1.7, 8.4, 2.2);
        frameSE3TrajectoryPoint.setTime(time);
        frameSE3TrajectoryPoint.getPosition().set((FrameTuple3DReadOnly)position);
        frameSE3TrajectoryPoint.getOrientation().set((FrameOrientation3DReadOnly)orientation);
        frameSE3TrajectoryPoint.getLinearVelocity().set((FrameTuple3DReadOnly)linearVelocity);
        frameSE3TrajectoryPoint.getAngularVelocity().set((FrameTuple3DReadOnly)angularVelocity);
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        frameSE3TrajectoryPoint.changeFrame((ReferenceFrame)poseFrame);
        Assert.assertFalse(position.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint.getPosition(), 1.0E-10));
        Assert.assertFalse(orientation.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint.getOrientation(), 1.0E-10));
        Assert.assertFalse(linearVelocity.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint.getLinearVelocity(), 1.0E-10));
        Assert.assertFalse(angularVelocity.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint.getAngularVelocity(), 1.0E-10));
        position.changeFrame((ReferenceFrame)poseFrame);
        orientation.changeFrame((ReferenceFrame)poseFrame);
        linearVelocity.changeFrame((ReferenceFrame)poseFrame);
        angularVelocity.changeFrame((ReferenceFrame)poseFrame);
        Assert.assertTrue(position.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint.getPosition(), 1.0E-10));
        Assert.assertTrue(orientation.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint.getOrientation(), 1.0E-10));
        Assert.assertTrue(linearVelocity.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint.getLinearVelocity(), 1.0E-10));
        Assert.assertTrue(angularVelocity.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint.getAngularVelocity(), 1.0E-10));
        FrameSE3TrajectoryPoint frameSE3TrajectoryPointTwo = new FrameSE3TrajectoryPoint((ReferenceFrame)poseFrame);
        frameSE3TrajectoryPointTwo.setTime(time);
        frameSE3TrajectoryPointTwo.getPosition().set((FrameTuple3DReadOnly)position);
        frameSE3TrajectoryPointTwo.getOrientation().set((FrameOrientation3DReadOnly)orientation);
        frameSE3TrajectoryPointTwo.getLinearVelocity().set((FrameTuple3DReadOnly)linearVelocity);
        frameSE3TrajectoryPointTwo.getAngularVelocity().set((FrameTuple3DReadOnly)angularVelocity);
        Assert.assertTrue(frameSE3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint, 1.0E-10));
        frameSE3TrajectoryPointTwo = new FrameSE3TrajectoryPoint(worldFrame);
        frameSE3TrajectoryPointTwo.setIncludingFrame((ReferenceFrame)poseFrame, time, (Point3DReadOnly)new Point3D((Tuple3DReadOnly)position), (Orientation3DReadOnly)orientation, (Vector3DReadOnly)new Vector3D((Tuple3DReadOnly)linearVelocity), (Vector3DReadOnly)new Vector3D((Tuple3DReadOnly)angularVelocity));
        Assert.assertTrue(frameSE3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint, 1.0E-10));
        frameSE3TrajectoryPointTwo = new FrameSE3TrajectoryPoint((ReferenceFrame)poseFrame);
        FrameSE3TrajectoryPoint se3Waypoint = frameSE3TrajectoryPoint;
        frameSE3TrajectoryPointTwo.set(time, (SE3WaypointReadOnly)se3Waypoint);
        Assert.assertTrue(frameSE3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint, 1.0E-10));
        frameSE3TrajectoryPointTwo = new FrameSE3TrajectoryPoint(worldFrame);
        frameSE3TrajectoryPointTwo.setIncludingFrame((ReferenceFrame)poseFrame, time, (SE3WaypointReadOnly)se3Waypoint);
        Assert.assertTrue(frameSE3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint, 1.0E-10));
        frameSE3TrajectoryPointTwo = new FrameSE3TrajectoryPoint((ReferenceFrame)poseFrame);
        FrameSE3TrajectoryPoint frameSE3Waypoint = frameSE3TrajectoryPoint;
        frameSE3TrajectoryPointTwo.set(time, (FrameSE3WaypointReadOnly)frameSE3Waypoint);
        Assert.assertTrue(frameSE3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint, 1.0E-10));
        frameSE3TrajectoryPointTwo = new FrameSE3TrajectoryPoint(worldFrame);
        frameSE3TrajectoryPointTwo.setIncludingFrame(time, (FrameSE3WaypointReadOnly)frameSE3Waypoint);
        Assert.assertTrue(frameSE3TrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameSE3TrajectoryPoint, 1.0E-10));
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new FrameTrajectoryPointAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(TrajectoryPointRandomTools::nextFrameSE3TrajectoryPoint, methodFilter, 10);
    }

    @Test
    public void testConsistencyWithSE3TrajectoryPoint() throws Exception {
        FrameTypeCopier frameTypeBuilder = (frame, TrajectoryPoint) -> new FrameSE3TrajectoryPoint(frame, (SE3TrajectoryPointReadOnly)TrajectoryPoint);
        RandomFramelessTypeBuilder framelessTypeBuilber = TrajectoryPointRandomTools::nextSE3TrajectoryPoint;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("toString");
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new FrameTrajectoryPointAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilber, methodFilter, 10);
    }

    @Test
    public void testOverloading() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new FrameTrajectoryPointAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameSE3TrajectoryPointBasics.class, SE3TrajectoryPointBasics.class, false, 1);
        tester.assertOverloadingWithFrameObjects(FrameSE3TrajectoryPointReadOnly.class, SE3TrajectoryPointReadOnly.class, false, 1);
    }
}

