/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.trajectorypoints.EuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.FrameTrajectoryPointAPIDefaultConfiguration;
import us.ihmc.robotics.math.trajectories.waypoints.TrajectoryPointRandomTools;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class FrameEuclideanTrajectoryPointTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testCommonUsageExample() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        FrameEuclideanTrajectoryPoint frameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(worldFrame);
        EuclideanTrajectoryPoint simpleTrajectoryPoint = new EuclideanTrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        simpleTrajectoryPoint.set(time, (Point3DReadOnly)position, (Vector3DReadOnly)linearVelocity);
        frameEuclideanTrajectoryPoint.setIncludingFrame(worldFrame, (EuclideanTrajectoryPointReadOnly)simpleTrajectoryPoint);
        frameEuclideanTrajectoryPoint.changeFrame((ReferenceFrame)poseFrame);
        RigidBodyTransform transformToPoseFrame = worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame);
        transformToPoseFrame.transform((Point3DBasics)position);
        transformToPoseFrame.transform((Vector3DBasics)linearVelocity);
        FrameEuclideanTrajectoryPoint expectedFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint((ReferenceFrame)poseFrame);
        expectedFrameEuclideanTrajectoryPoint.setTime(time);
        expectedFrameEuclideanTrajectoryPoint.getPosition().set((Tuple3DReadOnly)position);
        expectedFrameEuclideanTrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)linearVelocity);
        Assert.assertEquals(3.4, frameEuclideanTrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertEquals(3.4, expectedFrameEuclideanTrajectoryPoint.getTime(), 1.0E-7);
        Assert.assertTrue(expectedFrameEuclideanTrajectoryPoint.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPoint, 1.0E-10));
    }

    @Test
    public void testConstructors() {
        double epsilon = 1.0E-20;
        Random random = new Random(21651016L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        ReferenceFrame aFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"aFrame", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame expectedFrame = worldFrame;
        double expectedTime = 0.0;
        FramePoint3D expectedPosition = new FramePoint3D(expectedFrame);
        FrameVector3D expectedLinearVelocity = new FrameVector3D(expectedFrame);
        FrameEuclideanTrajectoryPoint testedFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint();
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
        expectedFrame = aFrame;
        expectedTime = 0.0;
        expectedPosition = new FramePoint3D(expectedFrame);
        expectedLinearVelocity = new FrameVector3D(expectedFrame);
        testedFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(expectedFrame);
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameEuclideanTrajectoryPoint expectedFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        testedFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint((FrameEuclideanTrajectoryPointReadOnly)expectedFrameEuclideanTrajectoryPoint);
        Assert.assertTrue(expectedFrameEuclideanTrajectoryPoint.epsilonEquals((EuclidFrameGeometry)testedFrameEuclideanTrajectoryPoint, epsilon));
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrameEuclideanTrajectoryPoint.getReferenceFrame(), expectedFrameEuclideanTrajectoryPoint.getTime(), (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
        ReferenceFrame expectedFinalFrame = aFrame;
        double expectedFinalTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedFinalPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFinalFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameVector3D expectedFinalLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFinalFrame);
        EuclideanTrajectoryPoint expectedEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint();
        expectedEuclideanTrajectoryPoint.setTime(expectedFinalTime);
        expectedEuclideanTrajectoryPoint.getPosition().set((Tuple3DReadOnly)expectedFinalPosition);
        expectedEuclideanTrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)expectedFinalLinearVelocity);
        testedFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(expectedFinalFrame, (EuclideanTrajectoryPointReadOnly)expectedEuclideanTrajectoryPoint);
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFinalFrame, expectedFinalTime, (FramePoint3DReadOnly)expectedFinalPosition, (FrameVector3DReadOnly)expectedFinalLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
    }

    @Test
    public void testSetters() {
        double epsilon = 1.0E-20;
        Random random = new Random(21651016L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        ReferenceFrame aFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"aFrame", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame expectedFrame = worldFrame;
        double expectedTime = 0.0;
        FramePoint3D expectedPosition = new FramePoint3D(expectedFrame);
        FrameVector3D expectedLinearVelocity = new FrameVector3D(expectedFrame);
        FrameEuclideanTrajectoryPoint testedFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint();
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedFrameEuclideanTrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedFrameEuclideanTrajectoryPoint.set(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
        expectedFrame = aFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        testedFrameEuclideanTrajectoryPoint.setIncludingFrame(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameEuclideanTrajectoryPoint expectedFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        testedFrameEuclideanTrajectoryPoint.setIncludingFrame((FrameEuclideanTrajectoryPointReadOnly)expectedFrameEuclideanTrajectoryPoint);
        expectedFrame = worldFrame;
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        expectedFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        testedFrameEuclideanTrajectoryPoint.set((FrameEuclideanTrajectoryPointReadOnly)expectedFrameEuclideanTrajectoryPoint);
        Assert.assertTrue(expectedFrameEuclideanTrajectoryPoint.epsilonEquals((EuclidFrameGeometry)testedFrameEuclideanTrajectoryPoint, epsilon));
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrameEuclideanTrajectoryPoint.getReferenceFrame(), expectedFrameEuclideanTrajectoryPoint.getTime(), (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
        ReferenceFrame expectedFinalFrame = aFrame;
        double expectedFinalTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedFinalPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFinalFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameVector3D expectedFinalLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFinalFrame);
        EuclideanTrajectoryPoint expectedEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint();
        expectedEuclideanTrajectoryPoint.setTime(expectedFinalTime);
        expectedEuclideanTrajectoryPoint.getPosition().set((Tuple3DReadOnly)expectedFinalPosition);
        expectedEuclideanTrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)expectedFinalLinearVelocity);
        testedFrameEuclideanTrajectoryPoint.setIncludingFrame(expectedFinalFrame, (EuclideanTrajectoryPointReadOnly)expectedEuclideanTrajectoryPoint);
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFinalFrame, expectedFinalTime, (FramePoint3DReadOnly)expectedFinalPosition, (FrameVector3DReadOnly)expectedFinalLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
    }

    @Test
    public void testChangeFrame() throws Exception {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameVector3D expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameEuclideanTrajectoryPoint testedFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        for (int i = 0; i < 10000; ++i) {
            expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)("randomFrame" + i), (Random)random, (ReferenceFrame)(random.nextBoolean() ? worldFrame : expectedFrame));
            expectedPosition.changeFrame(expectedFrame);
            expectedLinearVelocity.changeFrame(expectedFrame);
            testedFrameEuclideanTrajectoryPoint.changeFrame(expectedFrame);
            FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameVector3D expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameEuclideanTrajectoryPoint testedFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        expectedTime = 0.0;
        expectedPosition.setToZero();
        expectedLinearVelocity.setToZero();
        testedFrameEuclideanTrajectoryPoint.setToZero();
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
        expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"blop", (Random)random, (ReferenceFrame)worldFrame);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        testedFrameEuclideanTrajectoryPoint.setIncludingFrame(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        expectedTime = 0.0;
        expectedPosition.setToZero(expectedFrame);
        expectedLinearVelocity.setToZero(expectedFrame);
        testedFrameEuclideanTrajectoryPoint.setToZero(expectedFrame);
        FrameEuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFrame, expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity, testedFrameEuclideanTrajectoryPoint, epsilon);
    }

    @Test
    public void testSetToNaN() throws Exception {
        ReferenceFrame worldFrame;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        FramePoint3D expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expectedFrame, (double)10.0, (double)10.0, (double)10.0);
        FrameVector3D expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expectedFrame);
        FrameEuclideanTrajectoryPoint testedFrameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        testedFrameEuclideanTrajectoryPoint.setToNaN();
        Assert.assertTrue(Double.isNaN(testedFrameEuclideanTrajectoryPoint.getTime()));
        Assert.assertTrue(testedFrameEuclideanTrajectoryPoint.containsNaN());
        expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"blop", (Random)random, (ReferenceFrame)worldFrame);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
        testedFrameEuclideanTrajectoryPoint.setIncludingFrame(expectedTime, (FramePoint3DReadOnly)expectedPosition, (FrameVector3DReadOnly)expectedLinearVelocity);
        testedFrameEuclideanTrajectoryPoint.setToNaN(expectedFrame);
        Assert.assertTrue(expectedFrame == testedFrameEuclideanTrajectoryPoint.getReferenceFrame());
        Assert.assertTrue(Double.isNaN(testedFrameEuclideanTrajectoryPoint.getTime()));
        Assert.assertTrue(testedFrameEuclideanTrajectoryPoint.containsNaN());
    }

    static void assertTrajectoryPointContainsExpectedData(ReferenceFrame expectedFrame, double expectedTime, FramePoint3DReadOnly expectedPosition, FrameVector3DReadOnly expectedLinearVelocity, FrameEuclideanTrajectoryPoint testedFrameEuclideanTrajectoryPoint, double epsilon) {
        Assert.assertTrue(expectedFrame == testedFrameEuclideanTrajectoryPoint.getReferenceFrame());
        Assert.assertEquals(expectedTime, testedFrameEuclideanTrajectoryPoint.getTime(), epsilon);
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidFrameGeometry)testedFrameEuclideanTrajectoryPoint.getPosition(), epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidFrameGeometry)testedFrameEuclideanTrajectoryPoint.getLinearVelocity(), epsilon));
        Point3D actualPosition = new Point3D();
        Vector3D actualLinearVelocity = new Vector3D();
        actualPosition.set((Tuple3DReadOnly)testedFrameEuclideanTrajectoryPoint.getPosition());
        actualLinearVelocity.set((Tuple3DReadOnly)testedFrameEuclideanTrajectoryPoint.getLinearVelocity());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidGeometry)actualPosition, epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidGeometry)actualLinearVelocity, epsilon));
        FramePoint3D actualFramePosition = new FramePoint3D();
        FrameVector3D actualFrameLinearVelocity = new FrameVector3D();
        actualFramePosition.setIncludingFrame((FrameTuple3DReadOnly)testedFrameEuclideanTrajectoryPoint.getPosition());
        actualFrameLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)testedFrameEuclideanTrajectoryPoint.getLinearVelocity());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidFrameGeometry)actualFramePosition, epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidFrameGeometry)actualFrameLinearVelocity, epsilon));
        actualFramePosition = new FramePoint3D(expectedFrame);
        actualFrameLinearVelocity = new FrameVector3D(expectedFrame);
        actualFramePosition.set((FrameTuple3DReadOnly)testedFrameEuclideanTrajectoryPoint.getPosition());
        actualFrameLinearVelocity.set((FrameTuple3DReadOnly)testedFrameEuclideanTrajectoryPoint.getLinearVelocity());
        Assert.assertTrue(expectedPosition.epsilonEquals((EuclidFrameGeometry)actualFramePosition, epsilon));
        Assert.assertTrue(expectedLinearVelocity.epsilonEquals((EuclidFrameGeometry)actualFrameLinearVelocity, epsilon));
    }

    @Test
    public void testSomeSetsAngGets() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        FrameEuclideanTrajectoryPoint frameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(worldFrame);
        frameEuclideanTrajectoryPoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        EuclideanTrajectoryPoint simpleTrajectoryPoint = new EuclideanTrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        simpleTrajectoryPoint.set(time, (Point3DReadOnly)position, (Vector3DReadOnly)linearVelocity);
        frameEuclideanTrajectoryPoint.setIncludingFrame(worldFrame, (EuclideanTrajectoryPointReadOnly)simpleTrajectoryPoint);
        FramePoint3D pointForVerification = new FramePoint3D(worldFrame);
        FrameVector3D linearVelocityForVerification = new FrameVector3D(worldFrame);
        pointForVerification.set((FrameTuple3DReadOnly)frameEuclideanTrajectoryPoint.getPosition());
        linearVelocityForVerification.set((FrameTuple3DReadOnly)frameEuclideanTrajectoryPoint.getLinearVelocity());
        Assert.assertEquals(time, frameEuclideanTrajectoryPoint.getTime(), 1.0E-10);
        Assert.assertTrue(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-10));
        Assert.assertTrue(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-10));
        Assert.assertFalse(frameEuclideanTrajectoryPoint.containsNaN());
        frameEuclideanTrajectoryPoint.getPosition().setToNaN();
        Assert.assertTrue(frameEuclideanTrajectoryPoint.containsNaN());
        frameEuclideanTrajectoryPoint.getPosition().setToZero();
        Assert.assertFalse(frameEuclideanTrajectoryPoint.containsNaN());
        frameEuclideanTrajectoryPoint.getLinearVelocity().setToNaN();
        Assert.assertTrue(frameEuclideanTrajectoryPoint.containsNaN());
        frameEuclideanTrajectoryPoint.getLinearVelocity().setToZero();
        position.set((Tuple3DReadOnly)frameEuclideanTrajectoryPoint.getPosition());
        linearVelocity.set((Tuple3DReadOnly)frameEuclideanTrajectoryPoint.getLinearVelocity());
        Assert.assertTrue(position.epsilonEquals((EuclidGeometry)new Point3D(), 1.0E-10));
        Assert.assertTrue(linearVelocity.epsilonEquals((EuclidGeometry)new Vector3D(), 1.0E-10));
        time = 9.9;
        pointForVerification.set(3.9, 2.2, 1.1);
        linearVelocityForVerification.set(8.8, 1.4, 9.22);
        Assert.assertFalse(Math.abs(frameEuclideanTrajectoryPoint.getTime() - time) < 1.0E-7);
        Assert.assertFalse(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-7));
        Assert.assertFalse(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-7));
        frameEuclideanTrajectoryPoint.set(time, (FramePoint3DReadOnly)pointForVerification, (FrameVector3DReadOnly)linearVelocityForVerification);
        position.set((Tuple3DReadOnly)frameEuclideanTrajectoryPoint.getPosition());
        linearVelocity.set((Tuple3DReadOnly)frameEuclideanTrajectoryPoint.getLinearVelocity());
        Assert.assertEquals(time, frameEuclideanTrajectoryPoint.getTime(), 1.0E-10);
        Assert.assertTrue(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-10));
        Assert.assertTrue(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-10));
        FrameEuclideanTrajectoryPoint frameEuclideanTrajectoryPointTwo = new FrameEuclideanTrajectoryPoint(worldFrame);
        double positionDistance = frameEuclideanTrajectoryPoint.positionDistance((FrameEuclideanWaypointReadOnly)frameEuclideanTrajectoryPointTwo);
        Assert.assertEquals(4.610856753359402, positionDistance, 1.0E-7);
        Assert.assertFalse(frameEuclideanTrajectoryPoint.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPointTwo, 1.0E-7));
        frameEuclideanTrajectoryPointTwo.set((FrameEuclideanTrajectoryPointReadOnly)frameEuclideanTrajectoryPoint);
        positionDistance = frameEuclideanTrajectoryPoint.positionDistance((FrameEuclideanWaypointReadOnly)frameEuclideanTrajectoryPointTwo);
        Assert.assertEquals(0.0, positionDistance, 1.0E-7);
        Assert.assertTrue(frameEuclideanTrajectoryPoint.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPointTwo, 1.0E-7));
        EuclideanTrajectoryPoint simplePoint = new EuclideanTrajectoryPoint();
        simplePoint.set((EuclideanTrajectoryPointReadOnly)frameEuclideanTrajectoryPoint);
        frameEuclideanTrajectoryPoint.setToNaN();
        Assert.assertTrue(frameEuclideanTrajectoryPoint.containsNaN());
        positionDistance = frameEuclideanTrajectoryPoint.positionDistance((FrameEuclideanWaypointReadOnly)frameEuclideanTrajectoryPointTwo);
        Assert.assertTrue(Double.isNaN(positionDistance));
        Assert.assertFalse(frameEuclideanTrajectoryPoint.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPointTwo, 1.0E-7));
        EuclideanTrajectoryPoint trajectoryPointAsInterface = simplePoint;
        frameEuclideanTrajectoryPoint.set((EuclideanTrajectoryPointReadOnly)trajectoryPointAsInterface);
        positionDistance = frameEuclideanTrajectoryPoint.positionDistance((FrameEuclideanWaypointReadOnly)frameEuclideanTrajectoryPointTwo);
        Assert.assertEquals(0.0, positionDistance, 1.0E-7);
        Assert.assertTrue(frameEuclideanTrajectoryPoint.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPointTwo, 1.0E-7));
    }

    @Test
    public void testSomeMoreSettersAndGetters() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        FrameEuclideanTrajectoryPoint frameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(worldFrame);
        frameEuclideanTrajectoryPoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        double time = 3.4;
        FramePoint3D position = new FramePoint3D(worldFrame, 1.0, 2.1, 3.7);
        FrameVector3D linearVelocity = new FrameVector3D(worldFrame, -0.4, 1.2, 3.3);
        frameEuclideanTrajectoryPoint.setTime(time);
        frameEuclideanTrajectoryPoint.getPosition().set((FrameTuple3DReadOnly)position);
        frameEuclideanTrajectoryPoint.getLinearVelocity().set((FrameTuple3DReadOnly)linearVelocity);
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        frameEuclideanTrajectoryPoint.changeFrame((ReferenceFrame)poseFrame);
        Assert.assertFalse(position.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPoint.getPosition(), 1.0E-10));
        Assert.assertFalse(linearVelocity.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPoint.getLinearVelocity(), 1.0E-10));
        position.changeFrame((ReferenceFrame)poseFrame);
        linearVelocity.changeFrame((ReferenceFrame)poseFrame);
        Assert.assertTrue(position.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPoint.getPosition(), 1.0E-10));
        Assert.assertTrue(linearVelocity.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPoint.getLinearVelocity(), 1.0E-10));
        FrameEuclideanTrajectoryPoint frameEuclideanTrajectoryPointTwo = new FrameEuclideanTrajectoryPoint((ReferenceFrame)poseFrame);
        frameEuclideanTrajectoryPointTwo.setTime(time);
        frameEuclideanTrajectoryPointTwo.getPosition().set((FrameTuple3DReadOnly)position);
        frameEuclideanTrajectoryPointTwo.getLinearVelocity().set((FrameTuple3DReadOnly)linearVelocity);
        Assert.assertTrue(frameEuclideanTrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPoint, 1.0E-10));
        frameEuclideanTrajectoryPointTwo = new FrameEuclideanTrajectoryPoint(worldFrame);
        frameEuclideanTrajectoryPointTwo.setIncludingFrame((ReferenceFrame)poseFrame, time, (Point3DReadOnly)new Point3D((Tuple3DReadOnly)position), (Vector3DReadOnly)linearVelocity);
        Assert.assertTrue(frameEuclideanTrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPoint, 1.0E-10));
        frameEuclideanTrajectoryPointTwo = new FrameEuclideanTrajectoryPoint((ReferenceFrame)poseFrame);
        FrameEuclideanTrajectoryPoint euclideanWaypoint = frameEuclideanTrajectoryPoint;
        frameEuclideanTrajectoryPointTwo.set(time, (EuclideanWaypointReadOnly)euclideanWaypoint);
        Assert.assertTrue(frameEuclideanTrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPoint, 1.0E-10));
        frameEuclideanTrajectoryPointTwo = new FrameEuclideanTrajectoryPoint(worldFrame);
        frameEuclideanTrajectoryPointTwo.setIncludingFrame((ReferenceFrame)poseFrame, time, (EuclideanWaypointReadOnly)euclideanWaypoint);
        Assert.assertTrue(frameEuclideanTrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPoint, 1.0E-10));
        frameEuclideanTrajectoryPointTwo = new FrameEuclideanTrajectoryPoint((ReferenceFrame)poseFrame);
        FrameEuclideanTrajectoryPoint frameEuclideanWaypoint = frameEuclideanTrajectoryPoint;
        frameEuclideanTrajectoryPointTwo.set(time, (FrameEuclideanWaypointReadOnly)frameEuclideanWaypoint);
        Assert.assertTrue(frameEuclideanTrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPoint, 1.0E-10));
        frameEuclideanTrajectoryPointTwo = new FrameEuclideanTrajectoryPoint(worldFrame);
        frameEuclideanTrajectoryPointTwo.setIncludingFrame(time, (FrameEuclideanWaypointReadOnly)frameEuclideanWaypoint);
        Assert.assertTrue(frameEuclideanTrajectoryPointTwo.epsilonEquals((EuclidFrameGeometry)frameEuclideanTrajectoryPoint, 1.0E-10));
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new FrameTrajectoryPointAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(TrajectoryPointRandomTools::nextFrameEuclideanTrajectoryPoint, methodFilter, 10);
    }

    @Test
    public void testConsistencyWithEuclideanTrajectoryPoint() throws Exception {
        FrameTypeCopier frameTypeBuilder = (frame, TrajectoryPoint) -> new FrameEuclideanTrajectoryPoint(frame, (EuclideanTrajectoryPointReadOnly)TrajectoryPoint);
        RandomFramelessTypeBuilder framelessTypeBuilber = TrajectoryPointRandomTools::nextEuclideanTrajectoryPoint;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("toString");
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new FrameTrajectoryPointAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilber, methodFilter, 10);
    }

    @Test
    public void testOverloading() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new FrameTrajectoryPointAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameEuclideanTrajectoryPointBasics.class, EuclideanTrajectoryPointBasics.class, false, 1);
        tester.assertOverloadingWithFrameObjects(FrameEuclideanTrajectoryPointReadOnly.class, EuclideanTrajectoryPointReadOnly.class, false, 1);
    }
}

