/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.trajectorypoints.EuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.EuclideanWaypoint;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class EuclideanTrajectoryPointTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testCommonUsageExample() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        EuclideanTrajectoryPoint simpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint();
        EuclideanTrajectoryPoint simpleTrajectoryPoint = new EuclideanTrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        simpleTrajectoryPoint.set(time, (Point3DReadOnly)position, (Vector3DReadOnly)linearVelocity);
        simpleEuclideanTrajectoryPoint.set((EuclideanTrajectoryPointReadOnly)simpleTrajectoryPoint);
        simpleEuclideanTrajectoryPoint.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        RigidBodyTransform transformToPoseFrame = worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame);
        transformToPoseFrame.transform((Point3DBasics)position);
        transformToPoseFrame.transform((Vector3DBasics)linearVelocity);
        EuclideanTrajectoryPoint expectedSimpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint();
        expectedSimpleEuclideanTrajectoryPoint.setTime(time);
        expectedSimpleEuclideanTrajectoryPoint.getPosition().set(position);
        expectedSimpleEuclideanTrajectoryPoint.getLinearVelocity().set(linearVelocity);
        Assertions.assertEquals((double)3.4, (double)simpleEuclideanTrajectoryPoint.getTime(), (double)1.0E-7);
        Assertions.assertEquals((double)3.4, (double)expectedSimpleEuclideanTrajectoryPoint.getTime(), (double)1.0E-7);
        Assertions.assertTrue((boolean)expectedSimpleEuclideanTrajectoryPoint.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPoint, 1.0E-10));
    }

    @Test
    public void testConstructors() {
        double epsilon = 1.0E-14;
        Random random = new Random(21651016L);
        double expectedTime = 0.0;
        Point3D expectedPosition = new Point3D();
        Vector3D expectedLinearVelocity = new Vector3D();
        EuclideanTrajectoryPoint testedSimpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint();
        EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
        expectedTime = 0.0;
        expectedPosition = new Point3D();
        expectedLinearVelocity = new Vector3D();
        testedSimpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint();
        EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        testedSimpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Vector3DReadOnly)expectedLinearVelocity);
        EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclideanTrajectoryPoint expectedSimpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Vector3DReadOnly)expectedLinearVelocity);
        testedSimpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint((EuclideanTrajectoryPointBasics)expectedSimpleEuclideanTrajectoryPoint);
        Assertions.assertTrue((boolean)expectedSimpleEuclideanTrajectoryPoint.epsilonEquals((EuclidGeometry)testedSimpleEuclideanTrajectoryPoint, epsilon));
        EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedSimpleEuclideanTrajectoryPoint.getTime(), expectedPosition, expectedLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
        double expectedFinalTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Point3D expectedFinalPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        Vector3D expectedFinalLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclideanTrajectoryPoint expectedEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint();
        expectedEuclideanTrajectoryPoint.setTime(expectedFinalTime);
        expectedEuclideanTrajectoryPoint.getPosition().set(expectedFinalPosition);
        expectedEuclideanTrajectoryPoint.getLinearVelocity().set(expectedFinalLinearVelocity);
        testedSimpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint((EuclideanTrajectoryPointBasics)expectedEuclideanTrajectoryPoint);
        EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFinalTime, expectedFinalPosition, expectedFinalLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
    }

    @Test
    public void testSetters() {
        double epsilon = 1.0E-14;
        Random random = new Random(21651016L);
        double expectedTime = 0.0;
        Point3D expectedPosition = new Point3D();
        Vector3D expectedLinearVelocity = new Vector3D();
        EuclideanTrajectoryPoint testedSimpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint();
        EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        testedSimpleEuclideanTrajectoryPoint.set(expectedTime, (Point3DReadOnly)expectedPosition, (Vector3DReadOnly)expectedLinearVelocity);
        EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        testedSimpleEuclideanTrajectoryPoint.set(expectedTime, (Point3DReadOnly)expectedPosition, (Vector3DReadOnly)expectedLinearVelocity);
        EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        testedSimpleEuclideanTrajectoryPoint.set(expectedTime, (Point3DReadOnly)expectedPosition, (Vector3DReadOnly)expectedLinearVelocity);
        EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclideanTrajectoryPoint expectedSimpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Vector3DReadOnly)expectedLinearVelocity);
        testedSimpleEuclideanTrajectoryPoint.set((EuclideanTrajectoryPointReadOnly)expectedSimpleEuclideanTrajectoryPoint);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        expectedSimpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Vector3DReadOnly)expectedLinearVelocity);
        testedSimpleEuclideanTrajectoryPoint.set((EuclideanTrajectoryPointReadOnly)expectedSimpleEuclideanTrajectoryPoint);
        Assertions.assertTrue((boolean)expectedSimpleEuclideanTrajectoryPoint.epsilonEquals((EuclidGeometry)testedSimpleEuclideanTrajectoryPoint, epsilon));
        EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedSimpleEuclideanTrajectoryPoint.getTime(), expectedPosition, expectedLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
        double expectedFinalTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Point3D expectedFinalPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        Vector3D expectedFinalLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclideanTrajectoryPoint expectedEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint();
        expectedEuclideanTrajectoryPoint.setTime(expectedFinalTime);
        expectedEuclideanTrajectoryPoint.getPosition().set(expectedFinalPosition);
        expectedEuclideanTrajectoryPoint.getLinearVelocity().set(expectedFinalLinearVelocity);
        testedSimpleEuclideanTrajectoryPoint.set((EuclideanTrajectoryPointReadOnly)expectedEuclideanTrajectoryPoint);
        EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedFinalTime, expectedFinalPosition, expectedFinalLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
    }

    @Test
    public void testChangeFrame() throws Exception {
        ReferenceFrame worldFrame;
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        ReferenceFrame expectedFrame = worldFrame = ReferenceFrame.getWorldFrame();
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Point3D expectedPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        Vector3D expectedLinearVelocity = new Vector3D((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        EuclideanTrajectoryPoint testedSimpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Vector3DReadOnly)expectedLinearVelocity);
        for (int i = 0; i < 10000; ++i) {
            expectedFrame = EuclidFrameRandomTools.nextReferenceFrame((String)("randomFrame" + i), (Random)random, (ReferenceFrame)(random.nextBoolean() ? worldFrame : expectedFrame));
            expectedPosition.applyTransform((Transform)worldFrame.getTransformToDesiredFrame(expectedFrame));
            expectedLinearVelocity.applyTransform((Transform)worldFrame.getTransformToDesiredFrame(expectedFrame));
            testedSimpleEuclideanTrajectoryPoint.applyTransform((Transform)worldFrame.getTransformToDesiredFrame(expectedFrame));
            EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        double epsilon = 1.0E-10;
        Random random = new Random(21651016L);
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Point3D expectedPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        Vector3D expectedLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclideanTrajectoryPoint testedSimpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Vector3DReadOnly)expectedLinearVelocity);
        expectedTime = 0.0;
        expectedPosition.set(0.0, 0.0, 0.0);
        expectedLinearVelocity.set(0.0, 0.0, 0.0);
        testedSimpleEuclideanTrajectoryPoint.setToZero();
        EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        testedSimpleEuclideanTrajectoryPoint.set(expectedTime, (Point3DReadOnly)expectedPosition, (Vector3DReadOnly)expectedLinearVelocity);
        expectedTime = 0.0;
        expectedPosition.set(0.0, 0.0, 0.0);
        expectedLinearVelocity.set(0.0, 0.0, 0.0);
        testedSimpleEuclideanTrajectoryPoint.setToZero();
        EuclideanTrajectoryPointTest.assertTrajectoryPointContainsExpectedData(expectedTime, expectedPosition, expectedLinearVelocity, testedSimpleEuclideanTrajectoryPoint, epsilon);
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(21651016L);
        double expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        Point3D expectedPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        Vector3D expectedLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclideanTrajectoryPoint testedSimpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint(expectedTime, (Point3DReadOnly)expectedPosition, (Vector3DReadOnly)expectedLinearVelocity);
        testedSimpleEuclideanTrajectoryPoint.setToNaN();
        Assertions.assertTrue((boolean)Double.isNaN(testedSimpleEuclideanTrajectoryPoint.getTime()));
        Assertions.assertTrue((boolean)testedSimpleEuclideanTrajectoryPoint.containsNaN());
        expectedTime = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
        expectedPosition = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
        expectedLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
        testedSimpleEuclideanTrajectoryPoint.set(expectedTime, (Point3DReadOnly)expectedPosition, (Vector3DReadOnly)expectedLinearVelocity);
        testedSimpleEuclideanTrajectoryPoint.setToNaN();
        Assertions.assertTrue((boolean)Double.isNaN(testedSimpleEuclideanTrajectoryPoint.getTime()));
        Assertions.assertTrue((boolean)testedSimpleEuclideanTrajectoryPoint.containsNaN());
    }

    static void assertTrajectoryPointContainsExpectedData(double expectedTime, Point3D expectedPosition, Vector3D expectedLinearVelocity, EuclideanTrajectoryPoint testedSimpleEuclideanTrajectoryPoint, double epsilon) {
        Assertions.assertEquals((double)expectedTime, (double)testedSimpleEuclideanTrajectoryPoint.getTime(), (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPosition, (EuclidGeometry)testedSimpleEuclideanTrajectoryPoint.getPosition(), (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLinearVelocity, (EuclidGeometry)testedSimpleEuclideanTrajectoryPoint.getLinearVelocity(), (double)epsilon);
        Point3D actualPosition = new Point3D();
        Vector3D actualLinearVelocity = new Vector3D();
        actualPosition.set(testedSimpleEuclideanTrajectoryPoint.getPosition());
        actualLinearVelocity.set(testedSimpleEuclideanTrajectoryPoint.getLinearVelocity());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actualPosition, (EuclidGeometry)expectedPosition, (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actualLinearVelocity, (EuclidGeometry)expectedLinearVelocity, (double)epsilon);
        Point3D actualFramePosition = new Point3D();
        Vector3D actualFrameLinearVelocity = new Vector3D();
        actualFramePosition.set(testedSimpleEuclideanTrajectoryPoint.getPosition());
        actualFrameLinearVelocity.set(testedSimpleEuclideanTrajectoryPoint.getLinearVelocity());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPosition, (EuclidGeometry)actualFramePosition, (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLinearVelocity, (EuclidGeometry)actualFrameLinearVelocity, (double)epsilon);
        actualFramePosition = new Point3D();
        actualFrameLinearVelocity = new Vector3D();
        actualFramePosition.set(testedSimpleEuclideanTrajectoryPoint.getPosition());
        actualFrameLinearVelocity.set(testedSimpleEuclideanTrajectoryPoint.getLinearVelocity());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPosition, (EuclidGeometry)actualFramePosition, (double)epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLinearVelocity, (EuclidGeometry)actualFrameLinearVelocity, (double)epsilon);
    }

    @Test
    public void testSomeSetsAngGets() {
        EuclideanTrajectoryPoint simpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint();
        EuclideanTrajectoryPoint simpleTrajectoryPoint = new EuclideanTrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        simpleTrajectoryPoint.set(time, (Point3DReadOnly)position, (Vector3DReadOnly)linearVelocity);
        simpleEuclideanTrajectoryPoint.set((EuclideanTrajectoryPointReadOnly)simpleTrajectoryPoint);
        Point3D pointForVerification = new Point3D();
        Vector3D linearVelocityForVerification = new Vector3D();
        pointForVerification.set(simpleEuclideanTrajectoryPoint.getPosition());
        linearVelocityForVerification.set(simpleEuclideanTrajectoryPoint.getLinearVelocity());
        Assertions.assertEquals((double)time, (double)simpleEuclideanTrajectoryPoint.getTime(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)pointForVerification, (EuclidGeometry)position, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)linearVelocityForVerification, (EuclidGeometry)linearVelocity, (double)1.0E-10);
        Assert.assertFalse(simpleEuclideanTrajectoryPoint.containsNaN());
        simpleEuclideanTrajectoryPoint.getPosition().setToNaN();
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPoint.containsNaN());
        simpleEuclideanTrajectoryPoint.getPosition().setToZero();
        Assert.assertFalse(simpleEuclideanTrajectoryPoint.containsNaN());
        simpleEuclideanTrajectoryPoint.getLinearVelocity().setToNaN();
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPoint.containsNaN());
        simpleEuclideanTrajectoryPoint.getLinearVelocity().setToZero();
        position.set(simpleEuclideanTrajectoryPoint.getPosition());
        linearVelocity.set(simpleEuclideanTrajectoryPoint.getLinearVelocity());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(), (EuclidGeometry)position, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(), (EuclidGeometry)linearVelocity, (double)1.0E-10);
        time = 9.9;
        pointForVerification.set(3.9, 2.2, 1.1);
        linearVelocityForVerification.set(8.8, 1.4, 9.22);
        Assert.assertFalse(Math.abs(simpleEuclideanTrajectoryPoint.getTime() - time) < 1.0E-7);
        Assert.assertFalse(pointForVerification.epsilonEquals((EuclidGeometry)position, 1.0E-7));
        Assert.assertFalse(linearVelocityForVerification.epsilonEquals((EuclidGeometry)linearVelocity, 1.0E-7));
        simpleEuclideanTrajectoryPoint.set(time, (Point3DReadOnly)pointForVerification, (Vector3DReadOnly)linearVelocityForVerification);
        position.set(simpleEuclideanTrajectoryPoint.getPosition());
        linearVelocity.set(simpleEuclideanTrajectoryPoint.getLinearVelocity());
        Assertions.assertEquals((double)time, (double)simpleEuclideanTrajectoryPoint.getTime(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)pointForVerification, (EuclidGeometry)position, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)linearVelocityForVerification, (EuclidGeometry)linearVelocity, (double)1.0E-10);
        EuclideanTrajectoryPoint simpleEuclideanTrajectoryPointTwo = new EuclideanTrajectoryPoint();
        double positionDistance = simpleEuclideanTrajectoryPoint.positionDistance((EuclideanWaypointReadOnly)simpleEuclideanTrajectoryPointTwo);
        Assertions.assertEquals((double)4.610856753359402, (double)positionDistance, (double)1.0E-7);
        Assert.assertFalse(simpleEuclideanTrajectoryPoint.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPointTwo, 1.0E-7));
        simpleEuclideanTrajectoryPointTwo.set((EuclideanTrajectoryPointReadOnly)simpleEuclideanTrajectoryPoint);
        positionDistance = simpleEuclideanTrajectoryPoint.positionDistance((EuclideanWaypointReadOnly)simpleEuclideanTrajectoryPointTwo);
        Assertions.assertEquals((double)0.0, (double)positionDistance, (double)1.0E-7);
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPoint.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPointTwo, 1.0E-7));
        EuclideanTrajectoryPoint simplePoint = new EuclideanTrajectoryPoint();
        simplePoint.set((EuclideanTrajectoryPointReadOnly)simpleEuclideanTrajectoryPoint);
        simpleEuclideanTrajectoryPoint.setToNaN();
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPoint.containsNaN());
        positionDistance = simpleEuclideanTrajectoryPoint.positionDistance((EuclideanWaypointReadOnly)simpleEuclideanTrajectoryPointTwo);
        Assertions.assertTrue((boolean)Double.isNaN(positionDistance));
        Assert.assertFalse(simpleEuclideanTrajectoryPoint.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPointTwo, 1.0E-7));
        EuclideanTrajectoryPoint trajectoryPointAsInterface = simplePoint;
        simpleEuclideanTrajectoryPoint.set((EuclideanTrajectoryPointReadOnly)trajectoryPointAsInterface);
        positionDistance = simpleEuclideanTrajectoryPoint.positionDistance((EuclideanWaypointReadOnly)simpleEuclideanTrajectoryPointTwo);
        Assertions.assertEquals((double)0.0, (double)positionDistance, (double)1.0E-7);
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPoint.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPointTwo, 1.0E-7));
        String string = simpleEuclideanTrajectoryPoint.toString();
        String expectedString = "Euclidean trajectory point: [time= 9.900, position=( 3.900,  2.200,  1.100 ), linear velocity=( 8.800,  1.400,  9.220 )]";
        Assertions.assertEquals((Object)expectedString, (Object)string);
    }

    @Test
    public void testSomeMoreSettersAndGetters() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        EuclideanTrajectoryPoint simpleEuclideanTrajectoryPoint = new EuclideanTrajectoryPoint();
        double time = 3.4;
        Point3D position = new Point3D(1.0, 2.1, 3.7);
        Vector3D linearVelocity = new Vector3D(-0.4, 1.2, 3.3);
        simpleEuclideanTrajectoryPoint.setTime(time);
        simpleEuclideanTrajectoryPoint.getPosition().set(position);
        simpleEuclideanTrajectoryPoint.getLinearVelocity().set(linearVelocity);
        PoseReferenceFrame poseFrame = new PoseReferenceFrame("poseFrame", (FramePose3DReadOnly)new FramePose3D(worldFrame));
        FramePoint3D poseFramePosition = new FramePoint3D(worldFrame, (Tuple3DReadOnly)new Point3D(0.5, 7.7, 9.2));
        poseFrame.setPositionAndUpdate((FramePoint3DReadOnly)poseFramePosition);
        FrameQuaternion poseOrientation = new FrameQuaternion(worldFrame, (Orientation3DReadOnly)new AxisAngle(1.2, 3.9, 4.7, 2.2));
        poseFrame.setOrientationAndUpdate((FrameOrientation3DReadOnly)poseOrientation);
        simpleEuclideanTrajectoryPoint.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        Assert.assertFalse(position.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPoint.getPosition(), 1.0E-10));
        Assert.assertFalse(linearVelocity.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPoint.getLinearVelocity(), 1.0E-10));
        position.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        linearVelocity.applyTransform((Transform)worldFrame.getTransformToDesiredFrame((ReferenceFrame)poseFrame));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)position, (EuclidGeometry)simpleEuclideanTrajectoryPoint.getPosition(), (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)linearVelocity, (EuclidGeometry)simpleEuclideanTrajectoryPoint.getLinearVelocity(), (double)1.0E-10);
        EuclideanTrajectoryPoint simpleEuclideanTrajectoryPointTwo = new EuclideanTrajectoryPoint();
        simpleEuclideanTrajectoryPointTwo.setTime(time);
        simpleEuclideanTrajectoryPointTwo.getPosition().set(position);
        simpleEuclideanTrajectoryPointTwo.getLinearVelocity().set(linearVelocity);
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPoint, 1.0E-10));
        simpleEuclideanTrajectoryPointTwo = new EuclideanTrajectoryPoint();
        simpleEuclideanTrajectoryPointTwo.set(time, (Point3DReadOnly)position, (Vector3DReadOnly)linearVelocity);
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPoint, 1.0E-10));
        simpleEuclideanTrajectoryPointTwo = new EuclideanTrajectoryPoint();
        EuclideanWaypoint simpleEuclideanWaypoint = new EuclideanWaypoint();
        simpleEuclideanWaypoint.set((EuclideanWaypointReadOnly)simpleEuclideanTrajectoryPoint);
        simpleEuclideanTrajectoryPointTwo.set(time, (EuclideanWaypointReadOnly)simpleEuclideanWaypoint);
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPoint, 1.0E-10));
        simpleEuclideanTrajectoryPointTwo = new EuclideanTrajectoryPoint();
        simpleEuclideanTrajectoryPointTwo.set(time, (EuclideanWaypointReadOnly)simpleEuclideanWaypoint);
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPoint, 1.0E-10));
        simpleEuclideanTrajectoryPointTwo = new EuclideanTrajectoryPoint();
        EuclideanTrajectoryPoint euclideanWaypoint = simpleEuclideanTrajectoryPoint;
        simpleEuclideanTrajectoryPointTwo.set(time, (EuclideanWaypointReadOnly)euclideanWaypoint);
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPoint, 1.0E-10));
        simpleEuclideanTrajectoryPointTwo = new EuclideanTrajectoryPoint();
        euclideanWaypoint = new EuclideanWaypoint();
        euclideanWaypoint.set((EuclideanWaypointReadOnly)simpleEuclideanTrajectoryPoint);
        simpleEuclideanTrajectoryPointTwo.set(time, (EuclideanWaypointReadOnly)euclideanWaypoint);
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPoint, 1.0E-10));
        Point3D positionToPack = new Point3D((Tuple3DReadOnly)simpleEuclideanTrajectoryPoint.getPosition());
        Vector3D linearVelocityToPack = new Vector3D((Tuple3DReadOnly)simpleEuclideanTrajectoryPoint.getLinearVelocity());
        simpleEuclideanTrajectoryPointTwo = new EuclideanTrajectoryPoint();
        simpleEuclideanTrajectoryPointTwo.set(time, (Point3DReadOnly)positionToPack, (Vector3DReadOnly)linearVelocityToPack);
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPoint, 1.0E-10));
        positionToPack = new Point3D((Tuple3DReadOnly)simpleEuclideanTrajectoryPoint.getPosition());
        linearVelocityToPack = new Vector3D((Tuple3DReadOnly)simpleEuclideanTrajectoryPoint.getLinearVelocity());
        simpleEuclideanTrajectoryPointTwo = new EuclideanTrajectoryPoint();
        simpleEuclideanTrajectoryPointTwo.set(time, (Point3DReadOnly)positionToPack, (Vector3DReadOnly)linearVelocityToPack);
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPointTwo.epsilonEquals((EuclidGeometry)simpleEuclideanTrajectoryPoint, 1.0E-10));
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPointTwo.getPosition().epsilonEquals((EuclidGeometry)positionToPack, 1.0E-10));
        Assertions.assertTrue((boolean)simpleEuclideanTrajectoryPointTwo.getLinearVelocity().epsilonEquals((EuclidGeometry)linearVelocityToPack, 1.0E-10));
    }
}

