/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.math.linearDynamicSystems.MatlabChart;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.robotics.math.functionGenerator.BaseFunctionGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultiSpline1DSolver;

public class MultiSpline1DSolverTest {
    @Test
    public void testAddPositionObjective() {
        Random random = new Random(1231L);
        for (int i = 0; i < 1000; ++i) {
            double t = random.nextDouble();
            double xd = random.nextDouble();
            double weight = random.nextDouble();
            int numberOfCoefficients = random.nextInt(10) + 1;
            DMatrixRMaj tMatrix = new DMatrixRMaj(numberOfCoefficients, 1);
            double tPow = 1.0;
            int row = numberOfCoefficients - 1;
            for (int coeff = 0; coeff < numberOfCoefficients; ++coeff) {
                tMatrix.set(row--, 0, tPow);
                tPow *= t;
            }
            DMatrixRMaj H_expected = new DMatrixRMaj(numberOfCoefficients, numberOfCoefficients);
            DMatrixRMaj f_expected = new DMatrixRMaj(numberOfCoefficients, 1);
            CommonOps_DDRM.multOuter((DMatrix1Row)tMatrix, (DMatrix1Row)H_expected);
            CommonOps_DDRM.scale((double)weight, (DMatrixD1)H_expected);
            f_expected.set((DMatrixD1)tMatrix);
            CommonOps_DDRM.scale((double)(-xd * weight), (DMatrixD1)f_expected);
            DMatrixRMaj H_actual = new DMatrixRMaj(numberOfCoefficients, numberOfCoefficients);
            DMatrixRMaj f_actual = new DMatrixRMaj(numberOfCoefficients, 1);
            MultiSpline1DSolver.addPositionObjective((double)t, (double)xd, (double)weight, (int)numberOfCoefficients, (int)0, (int)0, (DMatrixRMaj)H_actual, (DMatrixRMaj)f_actual);
            MecanoTestTools.assertDMatrixEquals((DMatrix)H_expected, (DMatrix)H_actual, (double)1.0E-12);
            MecanoTestTools.assertDMatrixEquals((DMatrix)f_expected, (DMatrix)f_actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAddVelocityObjective() {
        Random random = new Random(1231L);
        for (int i = 0; i < 1000; ++i) {
            double t = random.nextDouble();
            double xd = random.nextDouble();
            double weight = random.nextDouble();
            int numberOfCoefficients = random.nextInt(10) + 1;
            DMatrixRMaj tDotMatrix = new DMatrixRMaj(numberOfCoefficients, 1);
            double tPow = 1.0;
            int row = numberOfCoefficients - 1;
            tDotMatrix.set(row--, 0, 0.0);
            for (int coeff = 1; coeff < numberOfCoefficients; ++coeff) {
                tDotMatrix.set(row--, 0, (double)coeff * tPow);
                tPow *= t;
            }
            DMatrixRMaj H_expected = new DMatrixRMaj(numberOfCoefficients, numberOfCoefficients);
            DMatrixRMaj f_expected = new DMatrixRMaj(numberOfCoefficients, 1);
            CommonOps_DDRM.multOuter((DMatrix1Row)tDotMatrix, (DMatrix1Row)H_expected);
            CommonOps_DDRM.scale((double)weight, (DMatrixD1)H_expected);
            f_expected.set((DMatrixD1)tDotMatrix);
            CommonOps_DDRM.scale((double)(-xd * weight), (DMatrixD1)f_expected);
            DMatrixRMaj H_actual = new DMatrixRMaj(numberOfCoefficients, numberOfCoefficients);
            DMatrixRMaj f_actual = new DMatrixRMaj(numberOfCoefficients, 1);
            MultiSpline1DSolver.addVelocityObjective((double)t, (double)xd, (double)weight, (int)numberOfCoefficients, (int)0, (int)0, (DMatrixRMaj)H_actual, (DMatrixRMaj)f_actual);
            MecanoTestTools.assertDMatrixEquals((DMatrix)H_expected, (DMatrix)H_actual, (double)1.0E-12);
            MecanoTestTools.assertDMatrixEquals((DMatrix)f_expected, (DMatrix)f_actual, (double)1.0E-12);
        }
    }

    @Test
    public void testAddAccelerationObjective() {
        Random random = new Random(1231L);
        for (int i = 0; i < 1000; ++i) {
            double t = random.nextDouble();
            double xd = random.nextDouble();
            double weight = random.nextDouble();
            int numberOfCoefficients = random.nextInt(10) + 1;
            DMatrixRMaj tDDotMatrix = new DMatrixRMaj(numberOfCoefficients, 1);
            int row = numberOfCoefficients - 1;
            tDDotMatrix.set(row--, 0, 0.0);
            if (row >= 0) {
                tDDotMatrix.set(row--, 0, 0.0);
                double tPow = 1.0;
                for (int coeff = 2; coeff < numberOfCoefficients; ++coeff) {
                    tDDotMatrix.set(row--, 0, (double)coeff * ((double)coeff - 1.0) * tPow);
                    tPow *= t;
                }
            }
            DMatrixRMaj H_expected = new DMatrixRMaj(numberOfCoefficients, numberOfCoefficients);
            DMatrixRMaj f_expected = new DMatrixRMaj(numberOfCoefficients, 1);
            CommonOps_DDRM.multOuter((DMatrix1Row)tDDotMatrix, (DMatrix1Row)H_expected);
            CommonOps_DDRM.scale((double)weight, (DMatrixD1)H_expected);
            f_expected.set((DMatrixD1)tDDotMatrix);
            CommonOps_DDRM.scale((double)(-xd * weight), (DMatrixD1)f_expected);
            DMatrixRMaj H_actual = new DMatrixRMaj(numberOfCoefficients, numberOfCoefficients);
            DMatrixRMaj f_actual = new DMatrixRMaj(numberOfCoefficients, 1);
            MultiSpline1DSolver.addAccelerationObjective((double)t, (double)xd, (double)weight, (int)numberOfCoefficients, (int)0, (int)0, (DMatrixRMaj)H_actual, (DMatrixRMaj)f_actual);
            MecanoTestTools.assertDMatrixEquals((DMatrix)H_expected, (DMatrix)H_actual, (double)1.0E-11);
            MecanoTestTools.assertDMatrixEquals((DMatrix)f_expected, (DMatrix)f_actual, (double)1.0E-11);
        }
    }

    @Test
    public void testEndpointsObjective() {
        double t0 = 0.0;
        double t1 = 0.5;
        double t2 = 1.0;
        double x0 = 0.0;
        double x1 = 1.0;
        double x2 = 0.0;
        double xd0 = 0.0;
        double xd2 = 0.0;
        MultiSpline1DSolver solver = new MultiSpline1DSolver();
        solver.addWaypoint(t0, x0, xd0);
        solver.addWaypointPosition(t1, x1);
        solver.addWaypoint(t2, x2, xd2);
        solver.solve();
        double expected_xErr0 = Math.abs(x0 - solver.computePosition(t0));
        double expected_xErr2 = Math.abs(x2 - solver.computePosition(t2));
        double expected_xdErr0 = Math.abs(xd0 - solver.computeVelocity(t0));
        double expected_xdErr2 = Math.abs(xd2 - solver.computeVelocity(t2));
        solver.getWaypoint(0).setVelocityWeight(1000000.0);
        solver.solve();
        double actual_xErr0 = Math.abs(x0 - solver.computePosition(t0));
        double actual_xErr2 = Math.abs(x2 - solver.computePosition(t2));
        double actual_xdErr0 = Math.abs(xd0 - solver.computeVelocity(t0));
        double actual_xdErr2 = Math.abs(xd2 - solver.computeVelocity(t2));
        Assertions.assertEquals((double)expected_xErr0, (double)actual_xErr0, (double)1.0E-12);
        Assertions.assertEquals((double)expected_xErr2, (double)actual_xErr2, (double)1.0E-12);
        Assertions.assertEquals((double)expected_xdErr0, (double)actual_xdErr0, (double)1.0E-4);
        Assertions.assertEquals((double)expected_xdErr2, (double)actual_xdErr2, (double)1.0E-12);
        solver.getWaypoint(0).setVelocityWeight(Double.POSITIVE_INFINITY);
        solver.getWaypoint(2).setVelocityWeight(1000000.0);
        solver.solve();
        actual_xErr0 = Math.abs(x0 - solver.computePosition(t0));
        actual_xErr2 = Math.abs(x2 - solver.computePosition(t2));
        actual_xdErr0 = Math.abs(xd0 - solver.computeVelocity(t0));
        actual_xdErr2 = Math.abs(xd2 - solver.computeVelocity(t2));
        Assertions.assertEquals((double)expected_xErr0, (double)actual_xErr0, (double)1.0E-12);
        Assertions.assertEquals((double)expected_xErr2, (double)actual_xErr2, (double)1.0E-12);
        Assertions.assertEquals((double)expected_xdErr0, (double)actual_xdErr0, (double)1.0E-12);
        Assertions.assertEquals((double)expected_xdErr2, (double)actual_xdErr2, (double)1.0E-4);
        solver.getWaypoint(2).setVelocityWeight(Double.POSITIVE_INFINITY);
        solver.getWaypoint(0).setPositionWeight(1000000.0);
        solver.solve();
        actual_xErr0 = Math.abs(x0 - solver.computePosition(t0));
        actual_xErr2 = Math.abs(x2 - solver.computePosition(t2));
        actual_xdErr0 = Math.abs(xd0 - solver.computeVelocity(t0));
        actual_xdErr2 = Math.abs(xd2 - solver.computeVelocity(t2));
        Assertions.assertEquals((double)expected_xErr0, (double)actual_xErr0, (double)1.0E-4);
        Assertions.assertEquals((double)expected_xErr2, (double)actual_xErr2, (double)1.0E-12);
        Assertions.assertEquals((double)expected_xdErr0, (double)actual_xdErr0, (double)1.0E-12);
        Assertions.assertEquals((double)expected_xdErr2, (double)actual_xdErr2, (double)1.0E-12);
        solver.getWaypoint(0).setPositionWeight(Double.POSITIVE_INFINITY);
        solver.getWaypoint(2).setPositionWeight(1000000.0);
        solver.solve();
        actual_xErr0 = Math.abs(x0 - solver.computePosition(t0));
        actual_xErr2 = Math.abs(x2 - solver.computePosition(t2));
        actual_xdErr0 = Math.abs(xd0 - solver.computeVelocity(t0));
        actual_xdErr2 = Math.abs(xd2 - solver.computeVelocity(t2));
        Assertions.assertEquals((double)expected_xErr0, (double)actual_xErr0, (double)1.0E-12);
        Assertions.assertEquals((double)expected_xErr2, (double)actual_xErr2, (double)1.0E-4);
        Assertions.assertEquals((double)expected_xdErr0, (double)actual_xdErr0, (double)1.0E-12);
        Assertions.assertEquals((double)expected_xdErr2, (double)actual_xdErr2, (double)1.0E-12);
    }

    @Test
    public void testMidpointVelocityControl() {
        double t0 = 0.0;
        double t1 = 0.5;
        double t2 = 1.0;
        double x0 = 0.0;
        double x1 = -1.0;
        double x2 = 0.0;
        double xd0 = 0.0;
        double xd1 = 1.0;
        double xd2 = 0.0;
        MultiSpline1DSolver solver = new MultiSpline1DSolver();
        solver.addWaypoint(t0, x0, xd0);
        solver.addWaypoint(t1, x1, xd1);
        solver.addWaypoint(t2, x2, xd2);
        solver.solve();
        double xErr1 = Math.abs(x1 - solver.computePosition(t1));
        double xdErr1 = Math.abs(xd1 - solver.computeVelocity(t1));
        double dt = 1.0E-5;
        double xErr1Plus = Math.abs(x1 - solver.computePosition(t1 + dt));
        double xdErr1Plus = Math.abs(xd1 - solver.computeVelocity(t1 + dt));
        double xErr1Minus = Math.abs(x1 - solver.computePosition(t1 - dt));
        double xdErr1Minus = Math.abs(xd1 - solver.computeVelocity(t1 - dt));
        Assertions.assertEquals((double)xErr1, (double)xErr1Plus, (double)2.0E-5);
        Assertions.assertEquals((double)xErr1, (double)xErr1Minus, (double)2.0E-5);
        Assertions.assertEquals((double)xdErr1, (double)xdErr1Plus, (double)0.001);
        Assertions.assertEquals((double)xdErr1, (double)xdErr1Minus, (double)0.001);
        solver.getWaypoint(1).setVelocityWeight(1000000.0);
        solver.solve();
        xErr1Plus = Math.abs(x1 - solver.computePosition(t1 + dt));
        xdErr1Plus = Math.abs(xd1 - solver.computeVelocity(t1 + dt));
        xErr1Minus = Math.abs(x1 - solver.computePosition(t1 - dt));
        xdErr1Minus = Math.abs(xd1 - solver.computeVelocity(t1 - dt));
        solver.getWaypoint(1).setPositionWeight(1000000.0);
        solver.getWaypoint(1).setVelocityWeight(Double.POSITIVE_INFINITY);
        solver.solve();
        xErr1Plus = Math.abs(x1 - solver.computePosition(t1 + dt));
        xdErr1Plus = Math.abs(xd1 - solver.computeVelocity(t1 + dt));
        xErr1Minus = Math.abs(x1 - solver.computePosition(t1 - dt));
        xdErr1Minus = Math.abs(xd1 - solver.computeVelocity(t1 - dt));
    }

    @Test
    public void testMultiOrders() {
        double t0 = 0.0;
        double t1 = 0.5;
        double t2 = 1.0;
        double x0 = 0.0;
        double x1 = 1.0;
        double x2 = 0.0;
        double xd0 = 0.0;
        double xd2 = 0.0;
        MultiSpline1DSolver solver = new MultiSpline1DSolver();
        solver.addWaypoint(t0, x0, xd0);
        solver.addWaypointPosition(t1, x1);
        solver.addWaypoint(t2, x2, xd2);
        solver.getSplineSegment(0).setNumberOfCoefficients(3);
        solver.solve();
        double xErr0 = Math.abs(x0 - solver.computePosition(t0));
        double xErr1 = Math.abs(x1 - solver.computePosition(t1));
        double xErr2 = Math.abs(x2 - solver.computePosition(t2));
        double xdErr0 = Math.abs(xd0 - solver.computeVelocity(t0));
        double xdErr2 = Math.abs(xd2 - solver.computeVelocity(t2));
        Assertions.assertEquals((double)0.0, (double)xErr0, (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)xErr1, (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)xErr2, (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)xdErr0, (double)1.0E-12);
        Assertions.assertEquals((double)0.0, (double)xdErr2, (double)1.0E-12);
    }

    @Test
    public void testAgainstSinewave() {
        double xdErr;
        double xErr;
        double t;
        int i;
        boolean verbose = false;
        Random random = new Random(34243L);
        SineFunction function = new SineFunction(random);
        MultiSpline1DSolver solver = MultiSpline1DSolverTest.nextFunctionBasedMultiSpline(random, function);
        for (int i2 = 1; i2 < solver.getNumberOfWaypoints() - 1; ++i2) {
            solver.getWaypoint(i2).setVelocityWeight(0.0);
        }
        solver.solve();
        int numTicks = 5000;
        double t0 = solver.getFirstWaypoint().getTime();
        double tf = solver.getLastWaypoint().getTime();
        double xErrAvg = 0.0;
        double xdErrAvg = 0.0;
        double xErrSqAvg = 0.0;
        double xdErrSqAvg = 0.0;
        for (i = 0; i < numTicks; ++i) {
            t = EuclidCoreTools.interpolate((double)t0, (double)tf, (double)((double)i / ((double)numTicks - 1.0)));
            function.compute(t);
            Assertions.assertEquals((double)function.getValue(), (double)solver.computePosition(t), (double)(1.0E-4 * Math.max(1.0, Math.abs(function.getValue()))));
            Assertions.assertEquals((double)function.getValueDot(), (double)solver.computeVelocity(t), (double)(0.001 * Math.max(1.0, Math.abs(function.getValueDot()))));
            if (!verbose) continue;
            xErr = Math.abs(function.getValue() - solver.computePosition(t));
            xdErr = Math.abs(function.getValueDot() - solver.computeVelocity(t));
            xErrAvg += xErr;
            xdErrAvg += xdErr;
            xErrSqAvg += xErr * xErr;
            xdErrSqAvg += xdErr * xdErr;
        }
        if (verbose) {
            System.out.println("xErrAvg: " + (xErrAvg /= (double)numTicks) + ", xdErrAvg: " + (xdErrAvg /= (double)numTicks));
            System.out.println("xErrSqAvg: " + (xErrSqAvg /= (double)numTicks) + ", xdErrSqAvg: " + (xdErrSqAvg /= (double)numTicks));
        }
        for (i = 1; i < solver.getNumberOfWaypoints() - 1; ++i) {
            solver.getWaypoint(i).setVelocityWeight(Double.POSITIVE_INFINITY);
        }
        solver.solve();
        xErrAvg = 0.0;
        xdErrAvg = 0.0;
        xErrSqAvg = 0.0;
        xdErrSqAvg = 0.0;
        for (i = 0; i < numTicks; ++i) {
            t = EuclidCoreTools.interpolate((double)t0, (double)tf, (double)((double)i / ((double)numTicks - 1.0)));
            function.compute(t);
            Assertions.assertEquals((double)function.getValue(), (double)solver.computePosition(t), (double)(1.0E-4 * Math.max(1.0, Math.abs(function.getValue()))));
            Assertions.assertEquals((double)function.getValueDot(), (double)solver.computeVelocity(t), (double)(0.001 * Math.max(1.0, Math.abs(function.getValueDot()))));
            if (!verbose) continue;
            xErr = Math.abs(function.getValue() - solver.computePosition(t));
            xdErr = Math.abs(function.getValueDot() - solver.computeVelocity(t));
            xErrAvg += xErr;
            xdErrAvg += xdErr;
            xErrSqAvg += xErr * xErr;
            xdErrSqAvg += xdErr * xdErr;
        }
        if (verbose) {
            System.out.println("xErrAvg: " + (xErrAvg /= (double)numTicks) + ", xdErrAvg: " + (xdErrAvg /= (double)numTicks));
            System.out.println("xErrSqAvg: " + (xErrSqAvg /= (double)numTicks) + ", xdErrSqAvg: " + (xdErrSqAvg /= (double)numTicks));
        }
        for (i = 1; i < solver.getNumberOfWaypoints() - 1; ++i) {
            solver.getWaypoint(i).setVelocityWeight(1000000.0);
        }
        solver.solve();
        xErrAvg = 0.0;
        xdErrAvg = 0.0;
        xErrSqAvg = 0.0;
        xdErrSqAvg = 0.0;
        for (i = 0; i < numTicks; ++i) {
            t = EuclidCoreTools.interpolate((double)t0, (double)tf, (double)((double)i / ((double)numTicks - 1.0)));
            function.compute(t);
            Assertions.assertEquals((double)function.getValue(), (double)solver.computePosition(t), (double)(1.0E-4 * Math.max(1.0, Math.abs(function.getValue()))));
            Assertions.assertEquals((double)function.getValueDot(), (double)solver.computeVelocity(t), (double)(0.001 * Math.max(1.0, Math.abs(function.getValueDot()))));
            if (!verbose) continue;
            xErr = Math.abs(function.getValue() - solver.computePosition(t));
            xdErr = Math.abs(function.getValueDot() - solver.computeVelocity(t));
            xErrAvg += xErr;
            xdErrAvg += xdErr;
            xErrSqAvg += xErr * xErr;
            xdErrSqAvg += xdErr * xdErr;
        }
        if (verbose) {
            System.out.println("xErrAvg: " + (xErrAvg /= (double)numTicks) + ", xdErrAvg: " + (xdErrAvg /= (double)numTicks));
            System.out.println("xErrSqAvg: " + (xErrSqAvg /= (double)numTicks) + ", xdErrSqAvg: " + (xdErrSqAvg /= (double)numTicks));
        }
    }

    @Test
    public void testAccelerationIntegrationResult() {
        MultiSpline1DSolver solver = new MultiSpline1DSolver();
        double[] times = new double[]{0.0, 0.25, 0.75, 1.0};
        solver.addWaypoint(times[0], 0.0, 1.0);
        solver.addWaypointPosition(times[1], 2.0);
        solver.addWaypointPosition(times[2], -2.0);
        solver.addWaypoint(times[3], 0.0, 1.0);
        double costUsingNative = solver.solveAndComputeCost();
        DMatrixRMaj solution = solver.getSolution();
        int numberOfSplines = solution.getNumRows() / 4;
        double expectedAccelerationIntegrated = 0.0;
        for (int i = 0; i < numberOfSplines; ++i) {
            int offset = i * 4;
            double c0 = solution.get(offset + 0);
            double c1 = solution.get(offset + 1);
            double t0 = times[i];
            double tf = times[i + 1];
            expectedAccelerationIntegrated += 12.0 * c0 * c0 * (tf * tf * tf - t0 * t0 * t0) + 12.0 * c0 * c1 * (tf * tf - t0 * t0) + 4.0 * c1 * c1 * (tf - t0);
        }
        double dt = 1.0E-5;
        double accelerationNumericallyIntegrated = 0.0;
        for (double t = dt; t <= 1.0; t += dt) {
            double accCurr = solver.computeAcceleration(t);
            accelerationNumericallyIntegrated += MathTools.square((double)Math.abs(accCurr)) * dt;
        }
        Assertions.assertEquals((double)(expectedAccelerationIntegrated *= 0.5), (double)costUsingNative, (double)(Math.max(expectedAccelerationIntegrated, 1.0) * 1.0E-12));
        Assertions.assertEquals((double)(accelerationNumericallyIntegrated *= 0.5), (double)costUsingNative, (double)(Math.max(accelerationNumericallyIntegrated, 1.0) * 1.0E-7));
    }

    @Test
    public void testGetWaypointVelocityFromSolution() {
        Random random = new Random(45435L);
        MultiSpline1DSolver solver = new MultiSpline1DSolver();
        for (int i = 0; i < 100; ++i) {
            int j;
            int numberOfWaypoints = random.nextInt(10) + 1;
            double startPosition = EuclidCoreRandomTools.nextDouble((Random)random);
            double endPosition = EuclidCoreRandomTools.nextDouble((Random)random);
            double[] waypointPositions = random.doubles(numberOfWaypoints, -0.5, 10.0).toArray();
            double[] waypointTimes = new double[numberOfWaypoints];
            double[] weights = new double[numberOfWaypoints + 1];
            double sumOfWeights = 0.0;
            for (j = 0; j < weights.length; ++j) {
                weights[j] = random.nextDouble();
                sumOfWeights += weights[j];
            }
            for (j = 0; j < numberOfWaypoints; ++j) {
                waypointTimes[j] = weights[j] / sumOfWeights;
                if (j <= 0) continue;
                int n = j;
                waypointTimes[n] = waypointTimes[n] + waypointTimes[j - 1];
            }
            solver.clearWaypoints();
            solver.addWaypoint(0.0, startPosition, 0.0);
            for (int j2 = 0; j2 < numberOfWaypoints; ++j2) {
                solver.addWaypointPosition(waypointTimes[j2], waypointPositions[j2]);
            }
            solver.addWaypoint(1.0, endPosition, 0.0);
            solver.solve();
            DMatrixRMaj solution = solver.getSolution();
            int waypointIndex = random.nextInt(numberOfWaypoints);
            double waypointTime = waypointTimes[waypointIndex];
            double expectedVelocity = MultiSpline1DSolverTest.computeExpectedVelocity(waypointTime, waypointIndex, solution);
            double actualVelocity = solver.computeVelocity(solver.getWaypoint(waypointIndex + 1).getTime());
            Assertions.assertEquals((double)expectedVelocity, (double)actualVelocity, (double)(1.0E-10 * Math.max(1.0, Math.abs(expectedVelocity))));
        }
    }

    @Test
    public void testGetPosition() {
        Random random = new Random(45435L);
        MultiSpline1DSolver solver = new MultiSpline1DSolver();
        for (int i = 0; i < 100; ++i) {
            int j;
            int numberOfWaypoints = random.nextInt(10) + 1;
            double startPosition = EuclidCoreRandomTools.nextDouble((Random)random);
            double endPosition = EuclidCoreRandomTools.nextDouble((Random)random);
            double startVelocity = EuclidCoreRandomTools.nextDouble((Random)random);
            double endVelocity = EuclidCoreRandomTools.nextDouble((Random)random);
            double[] waypointPositions = random.doubles(numberOfWaypoints, -0.5, 10.0).toArray();
            double[] waypointTimes = new double[numberOfWaypoints];
            double[] weights = new double[numberOfWaypoints + 1];
            double sumOfWeights = 0.0;
            for (j = 0; j < weights.length; ++j) {
                weights[j] = random.nextDouble();
                sumOfWeights += weights[j];
            }
            for (j = 0; j < numberOfWaypoints; ++j) {
                waypointTimes[j] = weights[j] / sumOfWeights;
                if (j <= 0) continue;
                int n = j;
                waypointTimes[n] = waypointTimes[n] + waypointTimes[j - 1];
            }
            solver.clearWaypoints();
            solver.addWaypoint(0.0, startPosition, startVelocity);
            for (int j2 = 0; j2 < numberOfWaypoints; ++j2) {
                solver.addWaypointPosition(waypointTimes[j2], waypointPositions[j2]);
            }
            solver.addWaypoint(1.0, endPosition, endVelocity);
            solver.solve();
            Assertions.assertEquals((double)startPosition, (double)solver.computePosition(0.0), (double)(1.0E-9 * Math.max(1.0, Math.abs(startPosition))));
            Assertions.assertEquals((double)startPosition, (double)solver.computePosition(-0.1), (double)(1.0E-9 * Math.max(1.0, Math.abs(startPosition))));
            Assertions.assertEquals((double)endPosition, (double)solver.computePosition(1.0), (double)(1.0E-8 * Math.max(1.0, Math.abs(endPosition))));
            Assertions.assertEquals((double)endPosition, (double)solver.computePosition(1.1), (double)(1.0E-8 * Math.max(1.0, Math.abs(endPosition))));
            for (int segmentIndex = 0; segmentIndex < numberOfWaypoints; ++segmentIndex) {
                int firstWaypointIndex = segmentIndex;
                double firstWaypointTime = waypointTimes[firstWaypointIndex];
                double secondWaypointTime = segmentIndex >= numberOfWaypoints - 1 ? 1.0 : waypointTimes[firstWaypointIndex + 1];
                double expectedPosition = MultiSpline1DSolverTest.computeExpectedPosition(firstWaypointTime, firstWaypointIndex, solver.getSolution());
                double actualPosition = solver.computePosition(firstWaypointTime);
                Assertions.assertEquals((double)expectedPosition, (double)actualPosition, (double)(1.0E-9 * Math.max(1.0, Math.abs(expectedPosition))));
                Assertions.assertEquals((double)waypointPositions[firstWaypointIndex], (double)expectedPosition, (double)(1.0E-7 * Math.max(1.0, Math.abs(waypointPositions[firstWaypointIndex]))));
                double time = EuclidCoreRandomTools.nextDouble((Random)random, (double)firstWaypointTime, (double)secondWaypointTime);
                expectedPosition = MultiSpline1DSolverTest.computeExpectedPosition(time, firstWaypointIndex + 1, solver.getSolution());
                actualPosition = solver.computePosition(time);
                Assertions.assertEquals((double)expectedPosition, (double)actualPosition, (double)(1.0E-9 * Math.max(1.0, Math.abs(expectedPosition))));
            }
        }
    }

    @Test
    public void testGetVelocity() {
        Random random = new Random(45435L);
        MultiSpline1DSolver solver = new MultiSpline1DSolver();
        for (int i = 0; i < 100; ++i) {
            int j;
            int numberOfWaypoints = random.nextInt(10) + 1;
            double startPosition = EuclidCoreRandomTools.nextDouble((Random)random);
            double endPosition = EuclidCoreRandomTools.nextDouble((Random)random);
            double startVelocity = EuclidCoreRandomTools.nextDouble((Random)random);
            double endVelocity = EuclidCoreRandomTools.nextDouble((Random)random);
            double[] waypointPositions = random.doubles(numberOfWaypoints, -0.5, 10.0).toArray();
            double[] waypointTimes = new double[numberOfWaypoints];
            double[] weights = new double[numberOfWaypoints + 1];
            double sumOfWeights = 0.0;
            for (j = 0; j < weights.length; ++j) {
                weights[j] = random.nextDouble();
                sumOfWeights += weights[j];
            }
            for (j = 0; j < numberOfWaypoints; ++j) {
                waypointTimes[j] = weights[j] / sumOfWeights;
                if (j <= 0) continue;
                int n = j;
                waypointTimes[n] = waypointTimes[n] + waypointTimes[j - 1];
            }
            solver.clearWaypoints();
            solver.addWaypoint(0.0, startPosition, startVelocity);
            for (int j2 = 0; j2 < numberOfWaypoints; ++j2) {
                solver.addWaypointPosition(waypointTimes[j2], waypointPositions[j2]);
            }
            solver.addWaypoint(1.0, endPosition, endVelocity);
            solver.solve();
            Assertions.assertEquals((double)startVelocity, (double)solver.computeVelocity(0.0), (double)(1.0E-8 * Math.max(1.0, Math.abs(startVelocity))));
            Assertions.assertEquals((double)startVelocity, (double)solver.computeVelocity(-0.1), (double)(1.0E-8 * Math.max(1.0, Math.abs(startVelocity))));
            Assertions.assertEquals((double)endVelocity, (double)solver.computeVelocity(1.0), (double)(1.0E-8 * Math.max(1.0, Math.abs(endVelocity))));
            Assertions.assertEquals((double)endVelocity, (double)solver.computeVelocity(1.1), (double)(1.0E-8 * Math.max(1.0, Math.abs(endVelocity))));
            for (int segmentIndex = 0; segmentIndex < numberOfWaypoints; ++segmentIndex) {
                int firstWaypointIndex = segmentIndex;
                double firstWaypointTime = waypointTimes[firstWaypointIndex];
                double secondWaypointTime = segmentIndex >= numberOfWaypoints - 1 ? 1.0 : waypointTimes[firstWaypointIndex + 1];
                double expectedVelocity = MultiSpline1DSolverTest.computeExpectedVelocity(firstWaypointTime, firstWaypointIndex, solver.getSolution());
                double actualVelocity = solver.computeVelocity(firstWaypointTime);
                Assertions.assertEquals((double)expectedVelocity, (double)actualVelocity, (double)(1.0E-10 * Math.max(1.0, Math.abs(expectedVelocity))));
                double time = EuclidCoreRandomTools.nextDouble((Random)random, (double)firstWaypointTime, (double)secondWaypointTime);
                expectedVelocity = MultiSpline1DSolverTest.computeExpectedVelocity(time, firstWaypointIndex + 1, solver.getSolution());
                actualVelocity = solver.computeVelocity(time);
                Assertions.assertEquals((double)expectedVelocity, (double)actualVelocity, (double)(1.0E-10 * Math.max(1.0, Math.abs(expectedVelocity))));
            }
        }
    }

    private static double computeExpectedPosition(double time, int waypointIndex, DMatrixRMaj solution) {
        DMatrixRMaj tempLine = new DMatrixRMaj(1, 4);
        DMatrixRMaj tempCoeffs = new DMatrixRMaj(4, 1);
        MultiSpline1DSolver.getPositionConstraintABlock((double)time, (int)4, (int)0, (int)0, (DMatrixRMaj)tempLine);
        int index = waypointIndex * 4;
        CommonOps_DDRM.extract((DMatrix)solution, (int)index, (int)(index + 4), (int)0, (int)1, (DMatrix)tempCoeffs, (int)0, (int)0);
        return CommonOps_DDRM.dot((DMatrixD1)tempCoeffs, (DMatrixD1)tempLine);
    }

    private static double computeExpectedVelocity(double waypointTime, int waypointIndex, DMatrixRMaj solution) {
        DMatrixRMaj tempLine = new DMatrixRMaj(1, 4);
        DMatrixRMaj tempCoeffs = new DMatrixRMaj(4, 1);
        MultiSpline1DSolver.getVelocityConstraintABlock((double)waypointTime, (int)4, (int)0, (int)0, (DMatrixRMaj)tempLine);
        int index = waypointIndex * 4;
        CommonOps_DDRM.extract((DMatrix)solution, (int)index, (int)(index + 4), (int)0, (int)1, (DMatrix)tempCoeffs, (int)0, (int)0);
        return CommonOps_DDRM.dot((DMatrixD1)tempCoeffs, (DMatrixD1)tempLine);
    }

    public static Function wrap(final BaseFunctionGenerator functionGenerator) {
        return new Function(){
            private double lastTime = 0.0;

            @Override
            public void compute(double t) {
                functionGenerator.integrateAngle(t - this.lastTime);
            }

            @Override
            public double getValue() {
                return functionGenerator.getValue();
            }

            @Override
            public double getValueDot() {
                return functionGenerator.getValueDot();
            }
        };
    }

    public static MultiSpline1DSolver nextFunctionBasedMultiSpline(Random random, Function function) {
        int i;
        MultiSpline1DSolver next = new MultiSpline1DSolver();
        int numberOfWaypoints = 2 + random.nextInt(100);
        double t0 = random.nextDouble();
        double duration = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.3, (double)2.0);
        double tf = t0 + duration;
        double[] times = new double[numberOfWaypoints];
        times[0] = t0;
        times[numberOfWaypoints - 1] = tf;
        for (i = 1; i < numberOfWaypoints - 1; ++i) {
            double meanInterval = duration / (double)(numberOfWaypoints - 1);
            double refTime = t0 + (double)i * meanInterval;
            times[i] = refTime + EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * meanInterval));
        }
        for (i = 0; i < numberOfWaypoints; ++i) {
            function.compute(times[i]);
            double x = function.getValue();
            double xd = function.getValueDot();
            next.addWaypoint().set(times[i], x, xd);
        }
        return next;
    }

    static void plot(MultiSpline1DSolver solver, Function function) {
        MultiSpline1DSolverTest.plot(solver, function, true);
    }

    static void plot(MultiSpline1DSolver solver, Function function, boolean wait) {
        int numTicks = 5000;
        double[] time = new double[numTicks];
        double[] x_solver = new double[numTicks];
        double t0 = solver.getFirstWaypoint().getTime();
        double tf = solver.getLastWaypoint().getTime();
        for (int i = 0; i < numTicks; ++i) {
            double t;
            time[i] = t = EuclidCoreTools.interpolate((double)t0, (double)tf, (double)((double)i / ((double)numTicks - 1.0)));
            x_solver[i] = solver.computePosition(t);
        }
        double[] x_function = null;
        if (function != null) {
            x_function = new double[numTicks];
            for (int i = 0; i < numTicks; ++i) {
                double t = EuclidCoreTools.interpolate((double)t0, (double)tf, (double)((double)i / ((double)numTicks - 1.0)));
                function.compute(t);
                x_function[i] = function.getValue();
            }
        }
        MatlabChart fig = new MatlabChart();
        if (function != null) {
            fig.plot(time, x_function, ":b", 1.0f, "function");
        }
        fig.plot(time, x_solver, "-r", 2.0f, "solver");
        fig.RenderPlot();
        fig.title("Solver output");
        fig.xlabel("t");
        fig.ylabel("x");
        fig.grid("on", "on");
        fig.legend("northeast");
        fig.font("Helvetica", 15);
        fig.displayInJFrame(wait);
    }

    static class SineFunction
    implements Function {
        private double amplitude;
        private double frequency;
        private double offset;
        private double phase;
        private double t = 0.0;

        public SineFunction(double amplitude, double frequency, double offset, double phase) {
            this.amplitude = amplitude;
            this.frequency = frequency;
            this.offset = offset;
            this.phase = phase;
        }

        public SineFunction(Random random) {
            this.amplitude = random.nextDouble();
            this.frequency = 1.0 + 2.0 * random.nextDouble();
            this.offset = random.nextDouble();
            this.phase = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
        }

        @Override
        public void compute(double t) {
            this.t = t;
        }

        @Override
        public double getValue() {
            return this.offset + this.amplitude * Math.sin(Math.PI * 2 * this.frequency * this.t + this.phase);
        }

        @Override
        public double getValueDot() {
            return Math.PI * 2 * this.frequency * this.amplitude * Math.cos(Math.PI * 2 * this.frequency * this.t + this.phase);
        }
    }

    static interface Function {
        public void compute(double var1);

        public double getValue();

        public double getValueDot();
    }
}

