/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.PolynomialEstimator;

public class PolynomialEstimatorTest {
    private static final double epsilon = 1.0E-4;

    @Test
    public void testLinear() {
        PolynomialEstimator estimator = new PolynomialEstimator();
        estimator.reshape(2);
        estimator.addObjectivePosition(0.0, 2.0);
        estimator.addObjectivePosition(2.0, 4.0);
        estimator.solve();
        Assert.assertEquals(2L, estimator.getOrder());
        DMatrixRMaj coefficients = estimator.getCoefficients();
        Assert.assertEquals(2L, coefficients.getNumRows());
        Assert.assertEquals(1L, coefficients.getNumCols());
        Assert.assertEquals(2.0, coefficients.get(0, 0), 1.0E-4);
        Assert.assertEquals(1.0, coefficients.get(1, 0), 1.0E-4);
        estimator.compute(0.0);
        Assert.assertEquals(2.0, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(1.0, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(0.0, estimator.getAcceleration(), 1.0E-4);
        estimator.compute(2.0);
        Assert.assertEquals(4.0, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(1.0, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(0.0, estimator.getAcceleration(), 1.0E-4);
        estimator.reset();
        estimator.addObjectivePosition(10.0, 0.0, 2.0);
        estimator.addObjectivePosition(10.0, 2.0, 4.0);
        estimator.solve();
        Assert.assertEquals(2L, estimator.getOrder());
        coefficients = estimator.getCoefficients();
        Assert.assertEquals(2L, coefficients.getNumRows());
        Assert.assertEquals(1L, coefficients.getNumCols());
        Assert.assertEquals(2.0, coefficients.get(0, 0), 1.0E-4);
        Assert.assertEquals(1.0, coefficients.get(1, 0), 1.0E-4);
        estimator.compute(0.0);
        Assert.assertEquals(2.0, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(1.0, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(0.0, estimator.getAcceleration(), 1.0E-4);
        estimator.compute(2.0);
        Assert.assertEquals(4.0, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(1.0, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(0.0, estimator.getAcceleration(), 1.0E-4);
        estimator.reset();
        estimator.addObjectivePosition(0.0, 2.0);
        estimator.addObjectiveVelocity(0.0, 1.0);
        estimator.solve();
        Assert.assertEquals(2L, estimator.getOrder());
        coefficients = estimator.getCoefficients();
        Assert.assertEquals(2L, coefficients.getNumRows());
        Assert.assertEquals(1L, coefficients.getNumCols());
        Assert.assertEquals(2.0, coefficients.get(0, 0), 1.0E-4);
        Assert.assertEquals(1.0, coefficients.get(1, 0), 1.0E-4);
        estimator.compute(0.0);
        Assert.assertEquals(2.0, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(1.0, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(0.0, estimator.getAcceleration(), 1.0E-4);
        estimator.compute(2.0);
        Assert.assertEquals(4.0, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(1.0, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(0.0, estimator.getAcceleration(), 1.0E-4);
    }

    @Test
    public void testCubic() {
        PolynomialEstimator estimator = new PolynomialEstimator();
        estimator.reshape(4);
        double duration = 2.0;
        double x0 = 2.0;
        double xf = 4.0;
        double v0 = 2.0;
        double vf = -2.0;
        estimator.addObjectivePosition(0.0, x0);
        estimator.addObjectiveVelocity(0.0, v0);
        estimator.addObjectivePosition(duration, xf);
        estimator.addObjectiveVelocity(duration, vf);
        estimator.solve();
        Assert.assertEquals(4L, estimator.getOrder());
        DMatrixRMaj coefficients = estimator.getCoefficients();
        Assert.assertEquals(4L, coefficients.getNumRows());
        Assert.assertEquals(1L, coefficients.getNumCols());
        double c0 = x0;
        double c1 = v0;
        double c2 = 3.0 / (duration * duration) * (xf - x0) - 1.0 / duration * (2.0 * v0 + vf);
        double c3 = 2.0 / (duration * duration * duration) * (x0 - xf) + 1.0 / (duration * duration) * (v0 + vf);
        Assert.assertEquals(c0, coefficients.get(0, 0), 1.0E-4);
        Assert.assertEquals(c1, coefficients.get(1, 0), 1.0E-4);
        Assert.assertEquals(c2, coefficients.get(2, 0), 1.0E-4);
        Assert.assertEquals(c3, coefficients.get(3, 0), 1.0E-4);
        double a0 = 2.0 * c2;
        double af = a0 + 6.0 * duration * c3;
        estimator.compute(0.0);
        Assert.assertEquals(x0, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(v0, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(a0, estimator.getAcceleration(), 1.0E-4);
        estimator.compute(2.0);
        Assert.assertEquals(xf, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(vf, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(af, estimator.getAcceleration(), 1.0E-4);
        estimator.reset();
        estimator.addObjectivePosition(10.0, 0.0, x0);
        estimator.addObjectiveVelocity(10.0, 0.0, v0);
        estimator.addObjectivePosition(10.0, duration, xf);
        estimator.addObjectiveVelocity(10.0, duration, vf);
        estimator.solve();
        Assert.assertEquals(4L, estimator.getOrder());
        coefficients = estimator.getCoefficients();
        Assert.assertEquals(c0, coefficients.get(0, 0), 1.0E-4);
        Assert.assertEquals(c1, coefficients.get(1, 0), 1.0E-4);
        Assert.assertEquals(c2, coefficients.get(2, 0), 1.0E-4);
        Assert.assertEquals(c3, coefficients.get(3, 0), 1.0E-4);
        estimator.compute(0.0);
        Assert.assertEquals(x0, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(v0, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(a0, estimator.getAcceleration(), 1.0E-4);
        estimator.compute(2.0);
        Assert.assertEquals(xf, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(vf, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(af, estimator.getAcceleration(), 1.0E-4);
        estimator.reset();
        estimator.addObjectivePosition(0.0, x0);
        estimator.addObjectiveVelocity(0.0, v0);
        estimator.addObjectiveAcceleration(0.0, a0);
        estimator.addObjectivePosition(duration, xf);
        estimator.solve();
        Assert.assertEquals(4L, estimator.getOrder());
        coefficients = estimator.getCoefficients();
        Assert.assertEquals(c0, coefficients.get(0, 0), 1.0E-4);
        Assert.assertEquals(c1, coefficients.get(1, 0), 1.0E-4);
        Assert.assertEquals(c2, coefficients.get(2, 0), 1.0E-4);
        Assert.assertEquals(c3, coefficients.get(3, 0), 1.0E-4);
        estimator.compute(0.0);
        Assert.assertEquals(x0, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(v0, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(a0, estimator.getAcceleration(), 1.0E-4);
        estimator.compute(2.0);
        Assert.assertEquals(xf, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(vf, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(af, estimator.getAcceleration(), 1.0E-4);
        estimator.reset();
        estimator.addObjectivePosition(0.0, x0);
        estimator.addObjectiveVelocity(0.0, v0);
        estimator.addObjectivePosition(duration, xf);
        estimator.addObjectiveAcceleration(duration, af);
        estimator.solve();
        Assert.assertEquals(4L, estimator.getOrder());
        coefficients = estimator.getCoefficients();
        Assert.assertEquals(c0, coefficients.get(0, 0), 1.0E-4);
        Assert.assertEquals(c1, coefficients.get(1, 0), 1.0E-4);
        Assert.assertEquals(c2, coefficients.get(2, 0), 1.0E-4);
        Assert.assertEquals(c3, coefficients.get(3, 0), 1.0E-4);
        estimator.compute(0.0);
        Assert.assertEquals(x0, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(v0, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(a0, estimator.getAcceleration(), 1.0E-4);
        estimator.compute(2.0);
        Assert.assertEquals(xf, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(vf, estimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(af, estimator.getAcceleration(), 1.0E-4);
    }

    @Test
    public void testCubicWithInitialConstraints() {
        PolynomialEstimator unboundedEstimator = new PolynomialEstimator();
        PolynomialEstimator boundedEstimator = new PolynomialEstimator();
        unboundedEstimator.reshape(4);
        boundedEstimator.reshape(7);
        double duration = 2.0;
        double x0 = 2.0;
        double xf = 4.0;
        double v0 = 2.0;
        double vf = -2.0;
        unboundedEstimator.addObjectivePosition(0.0, x0);
        unboundedEstimator.addObjectiveVelocity(0.0, v0);
        unboundedEstimator.addObjectivePosition(duration, xf);
        unboundedEstimator.addObjectiveVelocity(duration, vf);
        unboundedEstimator.solve();
        double c2 = 3.0 / (duration * duration) * (xf - x0) - 1.0 / duration * (2.0 * v0 + vf);
        double c3 = 2.0 / (duration * duration * duration) * (x0 - xf) + 1.0 / (duration * duration) * (v0 + vf);
        double a0 = 2.0 * c2;
        double af = a0 + 6.0 * duration * c3;
        x0 = 3.0;
        v0 = 2.0;
        boundedEstimator.addConstraintPosition(0.0, x0);
        boundedEstimator.addConstraintVelocity(0.0, v0);
        boundedEstimator.addConstraintAcceleration(0.0, a0);
        for (double time = 0.0; time < duration; time += 0.005) {
            unboundedEstimator.compute(time);
            boundedEstimator.addObjectivePosition(time, unboundedEstimator.getPosition());
        }
        unboundedEstimator.compute(duration);
        boundedEstimator.addObjectivePosition(100.0, duration, unboundedEstimator.getPosition());
        boundedEstimator.solve();
        boundedEstimator.compute(0.0);
        Assert.assertEquals(x0, boundedEstimator.getPosition(), 1.0E-4);
        Assert.assertEquals(v0, boundedEstimator.getVelocity(), 1.0E-4);
        Assert.assertEquals(a0, boundedEstimator.getAcceleration(), 1.0E-4);
        boundedEstimator.compute(duration);
        Assert.assertEquals(xf, boundedEstimator.getPosition(), 0.1);
    }

    @Test
    public void testQuartic() {
        PolynomialEstimator estimator = new PolynomialEstimator();
        estimator.reshape(5);
        double duration = 2.0;
        double x0 = 2.0;
        double xf = 4.0;
        double v0 = 2.0;
        double vf = -2.0;
        estimator.addObjectivePosition(0.0, x0);
        estimator.addObjectiveVelocity(0.0, v0);
        estimator.addObjectivePosition(duration, xf);
        estimator.addObjectiveVelocity(duration, vf);
        estimator.solve();
        Assert.assertEquals(5L, estimator.getOrder());
        DMatrixRMaj coefficients = estimator.getCoefficients();
        Assert.assertEquals(5L, coefficients.getNumRows());
        Assert.assertEquals(1L, coefficients.getNumCols());
        estimator.compute(0.0);
        Assert.assertEquals(x0, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(v0, estimator.getVelocity(), 1.0E-4);
        estimator.compute(2.0);
        Assert.assertEquals(xf, estimator.getPosition(), 1.0E-4);
        Assert.assertEquals(vf, estimator.getVelocity(), 1.0E-4);
    }
}

