/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.PolynomialEstimator3D;

public class PolynomialEstimator3DTest {
    private static final double epsilon = 5.0E-4;

    @Test
    public void testLinear() {
        PolynomialEstimator3D estimator = new PolynomialEstimator3D();
        estimator.reshape(2);
        double duration = 2.0;
        Point3D startPosition = new Point3D(2.0, 3.0, 4.0);
        Point3D endPosition = new Point3D(7.5, 8.7, 3.2);
        Vector3D velocity = new Vector3D();
        velocity.sub((Tuple3DReadOnly)endPosition, (Tuple3DReadOnly)startPosition);
        velocity.scale(1.0 / duration);
        estimator.addObjectivePosition(0.0, (Tuple3DReadOnly)startPosition);
        estimator.addObjectivePosition(duration, (Tuple3DReadOnly)endPosition);
        estimator.initialize();
        estimator.compute(0.0);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)startPosition, (Point3DReadOnly)estimator.getPosition(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)velocity, (Vector3DReadOnly)estimator.getVelocity(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)estimator.getAcceleration(), (double)5.0E-4);
        estimator.compute(duration);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)endPosition, (Point3DReadOnly)estimator.getPosition(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)velocity, (Vector3DReadOnly)estimator.getVelocity(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)estimator.getAcceleration(), (double)5.0E-4);
        estimator.reset();
        estimator.addObjectivePosition(10.0, 0.0, (Tuple3DReadOnly)startPosition);
        estimator.addObjectivePosition(10.0, duration, (Tuple3DReadOnly)endPosition);
        estimator.initialize();
        estimator.compute(0.0);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)startPosition, (Point3DReadOnly)estimator.getPosition(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)velocity, (Vector3DReadOnly)estimator.getVelocity(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)estimator.getAcceleration(), (double)5.0E-4);
        estimator.compute(duration);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)endPosition, (Point3DReadOnly)estimator.getPosition(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)velocity, (Vector3DReadOnly)estimator.getVelocity(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)estimator.getAcceleration(), (double)5.0E-4);
        estimator.reset();
        estimator.addObjectivePosition(0.0, (Tuple3DReadOnly)startPosition);
        estimator.addObjectiveVelocity(0.0, (Tuple3DReadOnly)velocity);
        estimator.initialize();
        estimator.compute(0.0);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)startPosition, (Point3DReadOnly)estimator.getPosition(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)velocity, (Vector3DReadOnly)estimator.getVelocity(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)estimator.getAcceleration(), (double)5.0E-4);
        estimator.compute(duration);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)endPosition, (Point3DReadOnly)estimator.getPosition(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)velocity, (Vector3DReadOnly)estimator.getVelocity(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)estimator.getAcceleration(), (double)5.0E-4);
    }

    @Test
    public void testCubic() {
        PolynomialEstimator3D estimator = new PolynomialEstimator3D();
        estimator.reshape(4);
        double duration = 2.0;
        Point3D startPosition = new Point3D(2.0, 3.0, 4.0);
        Point3D endPosition = new Point3D(7.5, 8.7, 3.2);
        Vector3D startVelocity = new Vector3D(6.0, 7.0, 8.0);
        Vector3D endVelocity = new Vector3D(3.5, 4.3, -6.2);
        estimator.addObjectivePosition(0.0, (Tuple3DReadOnly)startPosition);
        estimator.addObjectiveVelocity(0.0, (Tuple3DReadOnly)startVelocity);
        estimator.addObjectivePosition(duration, (Tuple3DReadOnly)endPosition);
        estimator.addObjectiveVelocity(duration, (Tuple3DReadOnly)endVelocity);
        estimator.initialize();
        estimator.compute(0.0);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)startPosition, (Point3DReadOnly)estimator.getPosition(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)startVelocity, (Vector3DReadOnly)estimator.getVelocity(), (double)5.0E-4);
        estimator.compute(duration);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)endPosition, (Point3DReadOnly)estimator.getPosition(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)endVelocity, (Vector3DReadOnly)estimator.getVelocity(), (double)5.0E-4);
        estimator.reset();
        estimator.addObjectivePosition(10.0, 0.0, (Tuple3DReadOnly)startPosition);
        estimator.addObjectiveVelocity(10.0, 0.0, (Tuple3DReadOnly)startVelocity);
        estimator.addObjectivePosition(10.0, duration, (Tuple3DReadOnly)endPosition);
        estimator.addObjectiveVelocity(10.0, duration, (Tuple3DReadOnly)endVelocity);
        estimator.initialize();
        estimator.compute(0.0);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)startPosition, (Point3DReadOnly)estimator.getPosition(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)startVelocity, (Vector3DReadOnly)estimator.getVelocity(), (double)5.0E-4);
        estimator.compute(duration);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)endPosition, (Point3DReadOnly)estimator.getPosition(), (double)5.0E-4);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)endVelocity, (Vector3DReadOnly)estimator.getVelocity(), (double)5.0E-4);
    }
}

