/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.OneDoFJointQuinticTrajectoryGenerator;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class OneDoFJointQuinticTrajectoryGeneratorTest {
    private String namePrefix = "namePrefix";
    private YoRegistry parentRegistry = new YoRegistry("parentRegistry");
    private ReferenceFrame parentFrame = ReferenceFrameTools.constructARootFrame((String)"rootFrame");
    private RigidBodyBasics elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
    private OneDoFJointBasics joint = new RevoluteJoint("revoluteJoint", this.elevator, (Vector3DReadOnly)new Vector3D());
    private DoubleProvider trajectoryTimeProvider;
    private static final double timeRequired = 10.0;
    private static final double EPSILON = 1.0E-10;
    private static final double DT = 1.0;
    private OneDoFJointQuinticTrajectoryGenerator generator;

    @BeforeEach
    public void setUp() {
        this.joint.setQ(0.0);
        this.joint.setQd(0.0);
        this.joint.setQdd(0.0);
        this.trajectoryTimeProvider = () -> 10.0;
    }

    @Test
    public void testConstructor() {
        try {
            this.generator = new OneDoFJointQuinticTrajectoryGenerator(this.namePrefix, this.joint, this.trajectoryTimeProvider, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testIsDone() {
        this.generator = new OneDoFJointQuinticTrajectoryGenerator(this.namePrefix, this.joint, this.trajectoryTimeProvider, this.parentRegistry);
        this.generator.initialize();
        this.generator.compute(this.trajectoryTimeProvider.getValue() - 1.0E-10);
        Assert.assertFalse(this.generator.isDone());
        this.generator.compute(this.trajectoryTimeProvider.getValue());
        Assert.assertTrue(this.generator.isDone());
    }

    @Test
    public void test() {
        this.generator = new OneDoFJointQuinticTrajectoryGenerator(this.namePrefix, this.joint, this.trajectoryTimeProvider, this.parentRegistry);
        this.generator.setFinalPosition(10.0);
        this.generator.initialize();
        Assert.assertEquals(0.0, this.generator.getValue(), 1.0E-10);
        Assert.assertEquals(0.0, this.generator.getVelocity(), 1.0E-10);
        Assert.assertEquals(0.0, this.generator.getAcceleration(), 1.0E-10);
        double previous = 0.0;
        for (double t = 0.0; t < 10.0; t += 1.0) {
            previous = this.generator.getValue();
            this.generator.compute(t);
            Assert.assertTrue(this.generator.getValue() >= previous);
        }
        this.generator.compute(0.0);
        Assert.assertEquals(0.0, this.generator.getValue(), 1.0E-10);
        Assert.assertEquals(0.0, this.generator.getVelocity(), 1.0E-10);
        Assert.assertEquals(0.0, this.generator.getAcceleration(), 1.0E-10);
    }
}

