/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.C1ContinuousTrajectorySmoother;
import us.ihmc.robotics.trajectories.core.FramePolynomial3D;
import us.ihmc.robotics.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.yoVariables.parameters.DefaultParameterReader;
import us.ihmc.yoVariables.registry.YoRegistry;

public class C1ContinuousTrajectorySmootherTest {
    private static final double epsilon = 0.001;
    private static final boolean visualize = false;
    private SimulationConstructionSet scs;
    private FramePolynomial3D trajectory;
    private C1ContinuousTrajectorySmoother smoothedTrajectory;

    @BeforeEach
    public void setup() {
        this.trajectory = new FramePolynomial3D(4, ReferenceFrame.getWorldFrame());
        YoRegistry testRegistry = new YoRegistry("test");
        this.smoothedTrajectory = new C1ContinuousTrajectorySmoother("smoothed", (FixedFramePositionTrajectoryGenerator)this.trajectory, testRegistry);
        new DefaultParameterReader().readParametersInRegistry(testRegistry);
    }

    @AfterEach
    public void destroy() {
        this.trajectory = null;
        this.smoothedTrajectory = null;
        this.scs = null;
    }

    @Test
    public void testTrackingCubicTrajectoryWithNoError() {
        FrameVector3D positionChange = new FrameVector3D(ReferenceFrame.getWorldFrame(), 0.7, -0.3, 0.4);
        FrameVector3D velocityChange = new FrameVector3D(ReferenceFrame.getWorldFrame(), -0.3, 0.2, -0.3);
        FramePoint3D startPoint = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.1, 0.3, -0.2);
        FrameVector3D startVelocity = new FrameVector3D(ReferenceFrame.getWorldFrame(), 0.3, -0.2, 0.1);
        FramePoint3D endPoint = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.1, 0.3, -0.2);
        FrameVector3D endVelocity = new FrameVector3D(ReferenceFrame.getWorldFrame(), 0.1, 0.3, -0.2);
        endPoint.add((FrameTuple3DReadOnly)startPoint, (FrameTuple3DReadOnly)positionChange);
        endVelocity.add((FrameTuple3DReadOnly)startVelocity, (FrameTuple3DReadOnly)velocityChange);
        double duration = 3.0;
        this.trajectory.setCubic(0.0, duration, (FramePoint3DReadOnly)startPoint, (FrameVector3DReadOnly)startVelocity, (FramePoint3DReadOnly)endPoint, (FrameVector3DReadOnly)endVelocity);
        this.smoothedTrajectory.initialize();
        this.smoothedTrajectory.updateErrorDynamicsAtTime(0.0, (FramePoint3DReadOnly)startPoint, (FrameVector3DReadOnly)startVelocity);
        for (double time = 0.0; time <= duration; time += 0.001) {
            this.trajectory.compute(time);
            this.smoothedTrajectory.compute(time);
            String failure = " Failed at time " + time;
            EuclidFrameTestTools.assertGeometricallyEquals((String)("position" + failure), (EuclidFrameGeometry)this.trajectory.getPosition(), (EuclidFrameGeometry)this.smoothedTrajectory.getPosition(), (double)0.001);
            EuclidFrameTestTools.assertGeometricallyEquals((String)("velocity" + failure), (EuclidFrameGeometry)this.trajectory.getVelocity(), (EuclidFrameGeometry)this.smoothedTrajectory.getVelocity(), (double)0.001);
            EuclidFrameTestTools.assertGeometricallyEquals((String)("acceleration" + failure), (EuclidFrameGeometry)this.trajectory.getAcceleration(), (EuclidFrameGeometry)this.smoothedTrajectory.getAcceleration(), (double)0.001);
        }
    }

    @Test
    public void testTrackingCubicTrajectoryWithError() throws UnreasonableAccelerationException {
        double time;
        FrameVector3D positionChange = new FrameVector3D(ReferenceFrame.getWorldFrame(), 0.7, -0.3, 0.4);
        FrameVector3D velocityChange = new FrameVector3D(ReferenceFrame.getWorldFrame(), -0.3, 0.2, -0.3);
        FramePoint3D startPoint = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.1, 0.3, -0.2);
        FrameVector3D startVelocity = new FrameVector3D(ReferenceFrame.getWorldFrame(), 0.3, -0.2, 0.1);
        FramePoint3D endPoint = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.1, 0.3, -0.2);
        FrameVector3D endVelocity = new FrameVector3D(ReferenceFrame.getWorldFrame(), 0.1, 0.3, -0.2);
        endPoint.add((FrameTuple3DReadOnly)startPoint, (FrameTuple3DReadOnly)positionChange);
        endVelocity.add((FrameTuple3DReadOnly)startVelocity, (FrameTuple3DReadOnly)velocityChange);
        double duration = 3.0;
        this.trajectory.setCubic(0.0, duration, (FramePoint3DReadOnly)startPoint, (FrameVector3DReadOnly)startVelocity, (FramePoint3DReadOnly)endPoint, (FrameVector3DReadOnly)endVelocity);
        this.smoothedTrajectory.initialize();
        this.smoothedTrajectory.updateErrorDynamicsAtTime(0.0, (FramePoint3DReadOnly)startPoint, (FrameVector3DReadOnly)startVelocity);
        for (time = 0.0; time <= 0.5 * duration; time += 0.001) {
            this.trajectory.compute(time);
            this.smoothedTrajectory.compute(time);
            String failure = " Failed at time " + time;
            EuclidFrameTestTools.assertGeometricallyEquals((String)("position" + failure), (EuclidFrameGeometry)this.trajectory.getPosition(), (EuclidFrameGeometry)this.smoothedTrajectory.getPosition(), (double)0.001);
            EuclidFrameTestTools.assertGeometricallyEquals((String)("velocity" + failure), (EuclidFrameGeometry)this.trajectory.getVelocity(), (EuclidFrameGeometry)this.smoothedTrajectory.getVelocity(), (double)0.001);
            EuclidFrameTestTools.assertGeometricallyEquals((String)("acceleration" + failure), (EuclidFrameGeometry)this.trajectory.getAcceleration(), (EuclidFrameGeometry)this.smoothedTrajectory.getAcceleration(), (double)0.001);
        }
        LogTools.info((String)"updating the trajectory");
        endPoint.add((FrameTuple3DReadOnly)positionChange);
        FramePoint3D desiredPosition = new FramePoint3D((FrameTuple3DReadOnly)this.trajectory.getPosition());
        FrameVector3D desiredVelocity = new FrameVector3D((FrameTuple3DReadOnly)this.trajectory.getVelocity());
        this.trajectory.setCubic(0.0, duration, (FramePoint3DReadOnly)startPoint, (FrameVector3DReadOnly)startVelocity, (FramePoint3DReadOnly)endPoint, (FrameVector3DReadOnly)endVelocity);
        this.smoothedTrajectory.updateErrorDynamicsAtTime(time, (FramePoint3DReadOnly)desiredPosition, (FrameVector3DReadOnly)desiredVelocity);
        LogTools.info((String)"updated the trajectory");
        FrameVector3D positionErrorWhenChanged = new FrameVector3D((FrameTuple3DReadOnly)this.smoothedTrajectory.getPositionErrorWhenStartingCancellation());
        FrameVector3D velocityErrorWhenChanged = new FrameVector3D((FrameTuple3DReadOnly)this.smoothedTrajectory.getVelocityErrorWhenStartingCancellation());
        while (time <= duration) {
            this.trajectory.compute(time);
            this.smoothedTrajectory.compute(time);
            String failure = " Failed at time " + time;
            FrameVector3D positionError = new FrameVector3D();
            positionError.sub((FrameTuple3DReadOnly)this.smoothedTrajectory.getPosition(), (FrameTuple3DReadOnly)this.trajectory.getPosition());
            EuclidFrameTestTools.assertEquals((String)failure, (EuclidFrameGeometry)positionError, (EuclidFrameGeometry)this.smoothedTrajectory.getReferencePositionError(), (double)1.0E-5);
            Assert.assertTrue(failure + ", error should decrease from " + positionErrorWhenChanged.length() + ", but increased to " + positionError.length(), positionError.length() < positionErrorWhenChanged.length() + 0.001);
            time += 0.001;
        }
        this.trajectory.compute(duration);
        this.smoothedTrajectory.compute(duration);
        EuclidFrameTestTools.assertGeometricallyEquals((String)"Final position", (EuclidFrameGeometry)this.trajectory.getPosition(), (EuclidFrameGeometry)this.smoothedTrajectory.getPosition(), (double)0.001);
        EuclidFrameTestTools.assertGeometricallyEquals((String)"Final velocity", (EuclidFrameGeometry)this.trajectory.getVelocity(), (EuclidFrameGeometry)this.smoothedTrajectory.getVelocity(), (double)0.001);
        EuclidFrameTestTools.assertGeometricallyEquals((String)"Final acceleration", (EuclidFrameGeometry)this.trajectory.getAcceleration(), (EuclidFrameGeometry)this.smoothedTrajectory.getAcceleration(), (double)0.001);
    }

    private static class VisualizerController
    implements RobotController {
        private static final int numberOfBalls = 50;
        private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        private final FramePolynomial3D trajectory;
        private final C1ContinuousTrajectorySmoother smoothedTrajectory;
        private final BagOfBalls trajectoryViz;
        private final BagOfBalls smoothedTrajectoryViz;

        public VisualizerController(FramePolynomial3D trajectory, C1ContinuousTrajectorySmoother smoothedTrajectory, YoGraphicsListRegistry graphicsListRegistry) {
            this.trajectory = trajectory;
            this.smoothedTrajectory = smoothedTrajectory;
            this.trajectoryViz = new BagOfBalls(50, 0.01, "trajectoryViz", YoAppearance.Black(), this.registry, graphicsListRegistry);
            this.smoothedTrajectoryViz = new BagOfBalls(50, 0.01, "smoothedTrajectoryViz", YoAppearance.Blue(), this.registry, graphicsListRegistry);
        }

        public void doControl() {
            LogTools.info((String)"update");
            this.trajectoryViz.reset();
            this.smoothedTrajectoryViz.reset();
            for (double time = 0.0; time <= this.trajectory.getDuration(); time += this.trajectory.getDuration() / 50.0) {
                this.trajectory.compute(time);
                this.trajectoryViz.setBall(this.trajectory.getPosition());
                this.smoothedTrajectory.compute(time);
                this.smoothedTrajectoryViz.setBall(this.smoothedTrajectory.getPosition());
            }
        }

        public void initialize() {
        }

        public YoRegistry getYoRegistry() {
            return this.registry;
        }
    }
}

