/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.math.trajectories.BlendedWaypointPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BlendedWaypointPositionTrajectoryGeneratorTest {
    private final double EPSILON = 0.001;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    private FixedFramePositionTrajectoryGenerator createRandomReferenceTrajectory(Random random, int numberOfWaypoints, double duration, ReferenceFrame referenceFrame, YoRegistry registry) {
        MultipleWaypointsPositionTrajectoryGenerator referenceTrajectory = new MultipleWaypointsPositionTrajectoryGenerator("referenceTrajectory", 10, referenceFrame, registry);
        for (int i = 0; i < numberOfWaypoints; ++i) {
            double time = (double)i * duration / (double)(numberOfWaypoints - 1);
            PositionTrajectoryState state = new PositionTrajectoryState(random, time, referenceFrame);
            referenceTrajectory.appendWaypoint((FrameEuclideanTrajectoryPointReadOnly)state.getWaypoint());
        }
        referenceTrajectory.initialize();
        return referenceTrajectory;
    }

    @Test
    public void testNoConstraints() {
        Random random = new Random();
        double trajectoryDuration = 1.0;
        int numberOfSamples = 10;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePositionTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedWaypointPositionTrajectoryGenerator blendedTrajectory = new BlendedWaypointPositionTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        for (int i = 0; i < numberOfSamples; ++i) {
            double time = (double)i * trajectoryDuration / (double)(numberOfSamples - 1);
            PositionTrajectoryState stateA = new PositionTrajectoryState(referenceTrajectory, time, worldFrame);
            PositionTrajectoryState stateB = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, time, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testInitialPoseConstraint() {
        Random random = new Random();
        double initialBlendDuration = 0.25;
        double trajectoryDuration = 1.0;
        int numberOfSamples = 10;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePositionTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedWaypointPositionTrajectoryGenerator blendedTrajectory = new BlendedWaypointPositionTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        PositionTrajectoryState initialState = new PositionTrajectoryState(random, 0.0, worldFrame);
        blendedTrajectory.blendInitialConstraint(initialState.getPosition(), 0.0, initialBlendDuration);
        PositionTrajectoryState referenceInitialState = new PositionTrajectoryState(referenceTrajectory, 0.0, worldFrame);
        PositionTrajectoryState blendedInitialState = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, 0.0, worldFrame);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)blendedInitialState.getPosition(), (EuclidFrameGeometry)initialState.getPosition(), (double)0.001);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)blendedInitialState.getLinearVelocity(), (EuclidFrameGeometry)referenceInitialState.getLinearVelocity(), (double)0.001);
        for (int i = 0; i < numberOfSamples; ++i) {
            double time = (double)i * trajectoryDuration / (double)(numberOfSamples - 1);
            if (!(time > initialBlendDuration)) continue;
            PositionTrajectoryState stateA = new PositionTrajectoryState(referenceTrajectory, time, worldFrame);
            PositionTrajectoryState stateB = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, time, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testInitialPoseAndTwistConstraint() {
        Random random = new Random();
        double initialBlendDuration = 0.25;
        double trajectoryDuration = 1.0;
        int numberOfSamples = 100;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame bodyFrame = new PoseReferenceFrame("BodyFrame", worldFrame);
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePositionTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedWaypointPositionTrajectoryGenerator blendedTrajectory = new BlendedWaypointPositionTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        PositionTrajectoryState initialState = new PositionTrajectoryState(random, 0.0, worldFrame);
        blendedTrajectory.blendInitialConstraint(initialState.getPosition(), initialState.getLinearVelocity(), 0.0, initialBlendDuration);
        PositionTrajectoryState blendedInitialState = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, 0.0, worldFrame);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)blendedInitialState.getPosition(), (EuclidFrameGeometry)initialState.getPosition(), (double)0.001);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)blendedInitialState.getLinearVelocity(), (EuclidFrameGeometry)initialState.getLinearVelocity(), (double)0.001);
        for (int i = 0; i < numberOfSamples; ++i) {
            double time = (double)i * trajectoryDuration / (double)(numberOfSamples - 1);
            if (!(time > initialBlendDuration)) continue;
            PositionTrajectoryState stateA = new PositionTrajectoryState(referenceTrajectory, time, worldFrame);
            PositionTrajectoryState stateB = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, time, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testFinalPositionConstraint() {
        Random random = new Random(1738L);
        double finalBlendDuration = 0.25;
        double trajectoryDuration = 1.0;
        int numberOfSamples = 10;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePositionTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedWaypointPositionTrajectoryGenerator blendedTrajectory = new BlendedWaypointPositionTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        referenceTrajectory.compute(trajectoryDuration);
        PositionTrajectoryState finalState = new PositionTrajectoryState(random, trajectoryDuration, worldFrame);
        blendedTrajectory.blendFinalConstraint(finalState.getPosition(), trajectoryDuration, finalBlendDuration);
        FramePoint3D referencePose = new FramePoint3D(worldFrame);
        FramePoint3D blendedPose = new FramePoint3D(worldFrame);
        referenceTrajectory.compute(trajectoryDuration);
        blendedTrajectory.compute(trajectoryDuration);
        referencePose.setIncludingFrame((FrameTuple3DReadOnly)referenceTrajectory.getPosition());
        blendedPose.setIncludingFrame((FrameTuple3DReadOnly)blendedTrajectory.getPosition());
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)finalState.getPosition(), (EuclidFrameGeometry)blendedPose, (double)0.001);
        for (int i = 0; i < numberOfSamples; ++i) {
            double time = (double)i * trajectoryDuration / (double)(numberOfSamples - 1);
            if (!(time < trajectoryDuration - finalBlendDuration)) continue;
            PositionTrajectoryState stateA = new PositionTrajectoryState(referenceTrajectory, time, worldFrame);
            PositionTrajectoryState stateB = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, time, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testSameFinalPoseConstraint() {
        Random random = new Random(1738L);
        double finalBlendDuration = 0.25;
        double trajectoryDuration = 1.0;
        double dt = 0.01;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePositionTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedWaypointPositionTrajectoryGenerator blendedTrajectory = new BlendedWaypointPositionTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        FramePoint3D finalReferencePosition = new FramePoint3D(worldFrame);
        referenceTrajectory.compute(trajectoryDuration);
        finalReferencePosition.setIncludingFrame((FrameTuple3DReadOnly)referenceTrajectory.getPosition());
        blendedTrajectory.blendFinalConstraint((FramePoint3DReadOnly)finalReferencePosition, trajectoryDuration, trajectoryDuration);
        blendedTrajectory.initialize();
        PositionTrajectoryState referenceFinalState = new PositionTrajectoryState(referenceTrajectory, trajectoryDuration, worldFrame);
        PositionTrajectoryState blendedFinalState = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, trajectoryDuration, worldFrame);
        FramePoint3D referencePosition = new FramePoint3D(worldFrame);
        FramePoint3D BlendedWaypointPosition = new FramePoint3D(worldFrame);
        referenceTrajectory.compute(trajectoryDuration);
        blendedTrajectory.compute(trajectoryDuration);
        referencePosition.setIncludingFrame((FrameTuple3DReadOnly)referenceTrajectory.getPosition());
        BlendedWaypointPosition.setIncludingFrame((FrameTuple3DReadOnly)blendedTrajectory.getPosition());
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)blendedFinalState.getLinearVelocity(), (EuclidFrameGeometry)referenceFinalState.getLinearVelocity(), (double)0.001);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)finalReferencePosition, (EuclidFrameGeometry)BlendedWaypointPosition, (double)0.001);
        for (double time = 0.0; time <= trajectoryDuration; time += dt) {
            PositionTrajectoryState stateA = new PositionTrajectoryState(referenceTrajectory, time, worldFrame);
            PositionTrajectoryState stateB = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, time, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testFinalPoseAndTwistConstraint() {
        Random random = new Random();
        double finalBlendDuration = 0.25;
        double trajectoryDuration = 1.0;
        int numberOfSamples = 10;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePositionTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedWaypointPositionTrajectoryGenerator blendedTrajectory = new BlendedWaypointPositionTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        PositionTrajectoryState finalState = new PositionTrajectoryState(random, trajectoryDuration, worldFrame);
        blendedTrajectory.blendFinalConstraint(finalState.getPosition(), finalState.getLinearVelocity(), trajectoryDuration, finalBlendDuration);
        PositionTrajectoryState blendedFinalState = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, trajectoryDuration, worldFrame);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)blendedFinalState.getPosition(), (EuclidFrameGeometry)finalState.getPosition(), (double)0.001);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)blendedFinalState.getLinearVelocity(), (EuclidFrameGeometry)finalState.getLinearVelocity(), (double)0.001);
        for (int i = 0; i < numberOfSamples; ++i) {
            double time = (double)i * trajectoryDuration / (double)(numberOfSamples - 1);
            if (!(time < trajectoryDuration - finalBlendDuration)) continue;
            PositionTrajectoryState stateA = new PositionTrajectoryState(referenceTrajectory, time, worldFrame);
            PositionTrajectoryState stateB = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, time, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testInitialAndFinalConstraint() {
        Random random = new Random(1738L);
        double initialBlendDuration = 0.25;
        double finalBlendDuration = 0.25;
        double trajectoryDuration = 1.0;
        int numberOfSamples = 10;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePositionTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedWaypointPositionTrajectoryGenerator blendedTrajectory = new BlendedWaypointPositionTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        PositionTrajectoryState initialState = new PositionTrajectoryState(random, 0.0, worldFrame);
        blendedTrajectory.blendInitialConstraint(initialState.getPosition(), initialState.getLinearVelocity(), 0.0, initialBlendDuration);
        PositionTrajectoryState finalState = new PositionTrajectoryState(random, trajectoryDuration, worldFrame);
        blendedTrajectory.blendFinalConstraint(finalState.getPosition(), finalState.getLinearVelocity(), trajectoryDuration, finalBlendDuration);
        PositionTrajectoryState blendedInitialState = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, 0.0, worldFrame);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)blendedInitialState.getPosition(), (EuclidFrameGeometry)initialState.getPosition(), (double)0.001);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)blendedInitialState.getLinearVelocity(), (EuclidFrameGeometry)initialState.getLinearVelocity(), (double)0.001);
        PositionTrajectoryState blendedFinalState = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, trajectoryDuration, worldFrame);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)blendedFinalState.getPosition(), (EuclidFrameGeometry)finalState.getPosition(), (double)0.001);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)blendedFinalState.getLinearVelocity(), (EuclidFrameGeometry)finalState.getLinearVelocity(), (double)0.001);
        for (int i = 0; i < numberOfSamples; ++i) {
            double time = (double)i * trajectoryDuration / (double)(numberOfSamples - 1);
            if (!(time > initialBlendDuration) || !(time < trajectoryDuration - finalBlendDuration)) continue;
            PositionTrajectoryState stateA = new PositionTrajectoryState(referenceTrajectory, time, worldFrame);
            PositionTrajectoryState stateB = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, time, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testTroublingDataSet1WithBlending() {
        double trajectoryDuration = 0.6;
        double dt = 0.01;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoRegistry registry = new YoRegistry("trajectory");
        MultipleWaypointsPositionTrajectoryGenerator swingTrajectory = new MultipleWaypointsPositionTrajectoryGenerator("Swing", 6, worldFrame, registry);
        swingTrajectory.clear(worldFrame);
        FramePoint3D initialPosition = new FramePoint3D(worldFrame, -7.212, -0.636, 0.302);
        FrameVector3D initialVelocity = new FrameVector3D(worldFrame, -0.0, -0.0, -0.002);
        swingTrajectory.appendWaypoint(0.0, (FramePoint3DReadOnly)initialPosition, (FrameVector3DReadOnly)initialVelocity);
        FrameEuclideanTrajectoryPoint firstWaypoint = new FrameEuclideanTrajectoryPoint(0.2, (FramePoint3DReadOnly)new FramePoint3D(worldFrame, -7.293, -0.623, 0.402), (FrameVector3DReadOnly)new FrameVector3D(worldFrame, -1.372, 0.219, 0.475));
        FrameEuclideanTrajectoryPoint secondWaypoint = new FrameEuclideanTrajectoryPoint(0.4, (FramePoint3DReadOnly)new FramePoint3D(worldFrame, -7.669, -0.563, 0.4), (FrameVector3DReadOnly)new FrameVector3D(worldFrame, -1.372, 0.219, 0.425));
        swingTrajectory.appendWaypoint((FrameEuclideanTrajectoryPointReadOnly)firstWaypoint);
        swingTrajectory.appendWaypoint((FrameEuclideanTrajectoryPointReadOnly)secondWaypoint);
        FramePoint3D finalPosition = new FramePoint3D(worldFrame, -7.75, -0.55, 0.3);
        FrameVector3D finalVelocity = new FrameVector3D(worldFrame, -0.0, -0.0, -0.3);
        swingTrajectory.appendWaypoint(trajectoryDuration, (FramePoint3DReadOnly)finalPosition, (FrameVector3DReadOnly)finalVelocity);
        FramePoint3D finalPositionToBlend = new FramePoint3D(worldFrame, -7.75, -0.55, 0.3);
        swingTrajectory.initialize();
        BlendedWaypointPositionTrajectoryGenerator blendedTrajectory = new BlendedWaypointPositionTrajectoryGenerator("blendedTrajectory", (FixedFramePositionTrajectoryGenerator)swingTrajectory, worldFrame, registry);
        blendedTrajectory.blendFinalConstraint((FramePoint3DReadOnly)finalPositionToBlend, trajectoryDuration, trajectoryDuration);
        blendedTrajectory.initialize();
        FramePoint3D tempPosition = new FramePoint3D();
        swingTrajectory.compute(trajectoryDuration);
        tempPosition.setIncludingFrame((FrameTuple3DReadOnly)swingTrajectory.getPosition());
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)finalPosition, (EuclidFrameGeometry)tempPosition, (double)0.001);
        blendedTrajectory.compute(trajectoryDuration);
        tempPosition.setIncludingFrame((FrameTuple3DReadOnly)blendedTrajectory.getPosition());
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)finalPositionToBlend, (EuclidFrameGeometry)tempPosition, (double)0.001);
    }

    @Test
    public void testTroublingDataSet1WithoutBlending() {
        int numberOfSamples = 100;
        double trajectoryDuration = 0.6;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoRegistry registry = new YoRegistry("trajectory");
        MultipleWaypointsPositionTrajectoryGenerator swingTrajectory = new MultipleWaypointsPositionTrajectoryGenerator("Swing", 6, worldFrame, registry);
        BlendedWaypointPositionTrajectoryGenerator blendedTrajectory = new BlendedWaypointPositionTrajectoryGenerator("blendedTrajectory", (FixedFramePositionTrajectoryGenerator)swingTrajectory, worldFrame, registry);
        swingTrajectory.clear(worldFrame);
        FramePoint3D initialPosition = new FramePoint3D(worldFrame, -7.212, -0.636, 0.302);
        FrameVector3D initialVelocity = new FrameVector3D(worldFrame, -0.0, -0.0, -0.002);
        swingTrajectory.appendWaypoint(0.0, (FramePoint3DReadOnly)initialPosition, (FrameVector3DReadOnly)initialVelocity);
        FrameEuclideanTrajectoryPoint firstWaypoint = new FrameEuclideanTrajectoryPoint(0.2, (FramePoint3DReadOnly)new FramePoint3D(worldFrame, -7.293, -0.623, 0.402), (FrameVector3DReadOnly)new FrameVector3D(worldFrame, -1.372, 0.219, 0.475));
        FrameEuclideanTrajectoryPoint secondWaypoint = new FrameEuclideanTrajectoryPoint(0.4, (FramePoint3DReadOnly)new FramePoint3D(worldFrame, -7.669, -0.563, 0.4), (FrameVector3DReadOnly)new FrameVector3D(worldFrame, -1.372, 0.219, 0.425));
        swingTrajectory.appendWaypoint((FrameEuclideanTrajectoryPointReadOnly)firstWaypoint);
        swingTrajectory.appendWaypoint((FrameEuclideanTrajectoryPointReadOnly)secondWaypoint);
        FramePoint3D finalPosition = new FramePoint3D(worldFrame, -7.75, -0.55, 0.3);
        FrameVector3D finalVelocity = new FrameVector3D(worldFrame, -0.0, -0.0, -0.3);
        swingTrajectory.appendWaypoint(trajectoryDuration, (FramePoint3DReadOnly)finalPosition, (FrameVector3DReadOnly)finalVelocity);
        blendedTrajectory.initialize();
    }

    @Test
    public void testTroublingDataSet2WithBlending() {
        double dt = 0.01;
        double trajectoryDuration = 0.6;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoRegistry registry = new YoRegistry("trajectory");
        MultipleWaypointsPositionTrajectoryGenerator swingTrajectory = new MultipleWaypointsPositionTrajectoryGenerator("Swing", 6, worldFrame, registry);
        swingTrajectory.clear(worldFrame);
        FramePoint3D initialPosition = new FramePoint3D(worldFrame, -7.212, -0.636, 0.302);
        FrameVector3D initialVelocity = new FrameVector3D(worldFrame, -0.0, -0.0, -0.002);
        swingTrajectory.appendWaypoint(0.0, (FramePoint3DReadOnly)initialPosition, (FrameVector3DReadOnly)initialVelocity);
        FrameEuclideanTrajectoryPoint firstWaypoint = new FrameEuclideanTrajectoryPoint(0.2, (FramePoint3DReadOnly)new FramePoint3D(worldFrame, -7.293, -0.623, 0.402), (FrameVector3DReadOnly)new FrameVector3D(worldFrame, -1.372, 0.219, 0.475));
        FrameEuclideanTrajectoryPoint secondWaypoint = new FrameEuclideanTrajectoryPoint(0.4, (FramePoint3DReadOnly)new FramePoint3D(worldFrame, -7.669, -0.563, 0.4), (FrameVector3DReadOnly)new FrameVector3D(worldFrame, -1.372, 0.219, 0.425));
        swingTrajectory.appendWaypoint((FrameEuclideanTrajectoryPointReadOnly)firstWaypoint);
        swingTrajectory.appendWaypoint((FrameEuclideanTrajectoryPointReadOnly)secondWaypoint);
        FramePoint3D finalPosition = new FramePoint3D(worldFrame, -7.75, -0.55, 0.3);
        FrameVector3D finalVelocity = new FrameVector3D(worldFrame, -0.0, -0.0, -0.3);
        swingTrajectory.appendWaypoint(trajectoryDuration, (FramePoint3DReadOnly)finalPosition, (FrameVector3DReadOnly)finalVelocity);
        swingTrajectory.initialize();
        BlendedWaypointPositionTrajectoryGenerator blendedTrajectory = new BlendedWaypointPositionTrajectoryGenerator("blendedTrajectory", (FixedFramePositionTrajectoryGenerator)swingTrajectory, worldFrame, registry);
        FramePoint3D initialPositionToBlend = new FramePoint3D(worldFrame, (Tuple3DReadOnly)initialPosition);
        blendedTrajectory.blendInitialConstraint((FramePoint3DReadOnly)initialPositionToBlend, 0.0, 0.2);
        blendedTrajectory.initialize();
        for (double time = 0.0; time <= trajectoryDuration; time += dt) {
            PositionTrajectoryState stateA = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)swingTrajectory, time, worldFrame);
            PositionTrajectoryState stateB = new PositionTrajectoryState((FixedFramePositionTrajectoryGenerator)blendedTrajectory, time, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    private class PositionTrajectoryState {
        public final double time;
        public final FramePoint3D position;
        public final FrameVector3D linearVelocity;
        public final FrameVector3D linearAcceleration;
        private final ReferenceFrame expressedInFrame;

        public PositionTrajectoryState(FixedFramePositionTrajectoryGenerator trajectory, double time, ReferenceFrame expressedInFrame) {
            this.position = new FramePoint3D(expressedInFrame);
            this.linearVelocity = new FrameVector3D(expressedInFrame);
            this.linearAcceleration = new FrameVector3D(expressedInFrame);
            this.time = time;
            this.expressedInFrame = expressedInFrame;
            trajectory.compute(time);
            trajectory.getLinearData((FramePoint3DBasics)this.position, (FrameVector3DBasics)this.linearVelocity, (FrameVector3DBasics)this.linearAcceleration);
        }

        public PositionTrajectoryState(Random random, double time, ReferenceFrame expressedInFrame) {
            this.time = time;
            this.position = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expressedInFrame, (double)1.0, (double)1.0, (double)1.0);
            this.linearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expressedInFrame, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0);
            this.linearAcceleration = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expressedInFrame, (double)-100.0, (double)100.0, (double)-100.0, (double)100.0, (double)-100.0, (double)100.0);
            this.expressedInFrame = expressedInFrame;
        }

        public FrameEuclideanTrajectoryPoint getWaypoint() {
            return new FrameEuclideanTrajectoryPoint(this.time, (FramePoint3DReadOnly)this.position, (FrameVector3DReadOnly)this.linearVelocity);
        }

        public FramePoint3DReadOnly getPosition() {
            this.position.changeFrame(this.expressedInFrame);
            return new FramePoint3D((FrameTuple3DReadOnly)this.position);
        }

        public FrameVector3DReadOnly getLinearVelocity() {
            this.linearVelocity.changeFrame(this.expressedInFrame);
            return new FrameVector3D((FrameTuple3DReadOnly)this.linearVelocity);
        }

        public void assertEpsilonEquals(PositionTrajectoryState other, double epsilon) {
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)this.position, (EuclidFrameGeometry)other.position, (double)epsilon);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)this.linearVelocity, (EuclidFrameGeometry)other.linearVelocity, (double)epsilon);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)this.linearAcceleration, (EuclidFrameGeometry)other.linearAcceleration, (double)epsilon);
        }
    }
}

