/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.functionGenerator.YoFunctionGenerator;
import us.ihmc.robotics.math.functionGenerator.YoFunctionGeneratorMode;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoFunctionGeneratorTest {
    YoFunctionGenerator yoFunctionGenerator;

    @BeforeEach
    public void setUp() throws Exception {
        YoRegistry registry = new YoRegistry("testRegistry");
        this.yoFunctionGenerator = new YoFunctionGenerator("test", registry);
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testZeroFrequencyDC() {
        this.yoFunctionGenerator.setMode(YoFunctionGeneratorMode.DC);
        double amplitude = 1.0;
        this.yoFunctionGenerator.setAmplitude(amplitude);
        this.yoFunctionGenerator.setFrequency(0.0);
        for (double time = 0.0; time < 10.0; time += 0.01) {
            Assert.assertEquals(amplitude, this.yoFunctionGenerator.getValue(time), 1.0E-10);
        }
    }

    @Test
    public void testOutputContinuityDuringFrequencyChange() {
        double freq0 = 10.0;
        double amp0 = 10.0;
        this.yoFunctionGenerator.setMode(YoFunctionGeneratorMode.SINE);
        this.yoFunctionGenerator.setAmplitude(amp0);
        this.yoFunctionGenerator.setPhase(1.5707963267948966);
        double t0 = 0.134;
        double dt = 0.001;
        this.yoFunctionGenerator.setFrequency(freq0);
        double output0 = this.yoFunctionGenerator.getValue(t0 + 2.0 * dt);
        this.yoFunctionGenerator.setFrequencyWithContinuousOutput(freq0 * 3.0);
        double output1 = this.yoFunctionGenerator.getValue(t0 + 3.0 * dt);
        double tolerance = 6.0 * dt * amp0 * freq0 * 3.0;
        Assert.assertEquals("|" + output0 + "-" + output1 + "|<" + tolerance, 0.0, output1 - output0, tolerance);
    }

    @Test
    public void testZeroFrequencySine() {
        this.yoFunctionGenerator.setMode(YoFunctionGeneratorMode.SINE);
        double amplitude = 1.0;
        this.yoFunctionGenerator.setAmplitude(amplitude);
        this.yoFunctionGenerator.setFrequency(0.0);
        this.yoFunctionGenerator.setPhase(1.5707963267948966);
        for (double time = 0.0; time < 10.0; time += 0.01) {
            Assert.assertEquals(amplitude, this.yoFunctionGenerator.getValue(time), 1.0E-10);
        }
    }

    @Test
    public void testTriangle() {
        double value;
        this.yoFunctionGenerator.setMode(YoFunctionGeneratorMode.TRIANGLE);
        double amplitude = 1.0;
        double dt = 0.01;
        double frequency = 1.0;
        this.yoFunctionGenerator.setAmplitude(amplitude);
        this.yoFunctionGenerator.setFrequency(frequency);
        double singleRampTime = 1.0 / frequency / 2.0;
        double expectedVelocityAbs = Math.abs(2.0 * amplitude / singleRampTime);
        double previousValue = value = this.yoFunctionGenerator.getValue(dt);
        for (double time = 2.0 * dt; time < singleRampTime - dt; time += dt) {
            value = this.yoFunctionGenerator.getValue(time);
            double velocityAbs = Math.abs((value - previousValue) / dt);
            Assert.assertEquals(expectedVelocityAbs, velocityAbs, 1.0E-10);
            double computedVelocityAbs = Math.abs(this.yoFunctionGenerator.getValueDot());
            Assert.assertEquals(expectedVelocityAbs, computedVelocityAbs, 1.0E-10);
            previousValue = value;
        }
    }

    @Test
    public void testValueDotOnSineWithPhase() {
        this.yoFunctionGenerator.setMode(YoFunctionGeneratorMode.SINE);
        double amplitude = 1.0;
        this.yoFunctionGenerator.setAmplitude(amplitude);
        this.yoFunctionGenerator.setFrequency(0.1);
        this.yoFunctionGenerator.setPhase(1.5707963267948966);
        double value = 0.0;
        for (double time = 0.0; time < 10.0; time += 0.001) {
            value = this.yoFunctionGenerator.getValue(time);
            if (!(Math.abs(value - amplitude) <= 0.001)) continue;
            Assert.assertTrue(Math.abs(this.yoFunctionGenerator.getValueDot()) <= 0.05);
        }
    }
}

