/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.YoIMUMahonyFilter;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoIMUMahonyFilterTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testInitialization() throws Exception {
        String imuName = "test";
        String namePrefix = "q_est_";
        String nameSuffix = "";
        double updateDT = 0.001;
        YoRegistry registry = new YoRegistry("test");
        Random random = new Random(3454L);
        ReferenceFrame sensorFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        YoFrameQuaternion actualOrientation = new YoFrameQuaternion("q_act_", sensorFrame.getRootFrame(), registry);
        YoFrameVector3D inputAngularVelocity = new YoFrameVector3D("angularVelocity", sensorFrame, registry);
        YoFrameVector3D inputLinearAcceleration = new YoFrameVector3D("linearAcceleration", sensorFrame, registry);
        YoFrameVector3D inputMagneticVector = new YoFrameVector3D("magneticDirection", sensorFrame, registry);
        YoIMUMahonyFilter mahonyFilter = new YoIMUMahonyFilter(imuName, namePrefix, nameSuffix, updateDT, sensorFrame, registry);
        mahonyFilter.setInputs(inputAngularVelocity, inputLinearAcceleration, inputMagneticVector);
        mahonyFilter.setGains(0.5, 0.0);
        mahonyFilter.getEstimatedOrientation().set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
        actualOrientation.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
        Vector3D zUp = new Vector3D(0.0, 0.0, 1.0);
        actualOrientation.inverseTransform((Tuple3DBasics)zUp);
        inputLinearAcceleration.set((Tuple3DReadOnly)zUp);
        inputLinearAcceleration.scale(20.0);
        Vector3D xForward = new Vector3D(1.0, 0.0, 0.0);
        actualOrientation.inverseTransform((Tuple3DBasics)xForward);
        inputMagneticVector.set((Tuple3DReadOnly)xForward);
        inputMagneticVector.scale(0.5);
        mahonyFilter.update();
        double currentError = actualOrientation.distance((FrameOrientation3DReadOnly)mahonyFilter.getEstimatedOrientation());
        Assert.assertTrue(currentError <= 1.0E-10);
    }

    @Test
    public void testConvergenceToStaticOrientation() throws Exception {
        String imuName = "test";
        String namePrefix = "q_est_";
        String nameSuffix = "";
        double updateDT = 0.001;
        YoRegistry registry = new YoRegistry("test");
        Random random = new Random(3454L);
        ReferenceFrame sensorFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        YoFrameQuaternion actualOrientation = new YoFrameQuaternion("q_act_", sensorFrame.getRootFrame(), registry);
        YoFrameVector3D inputAngularVelocity = new YoFrameVector3D("angularVelocity", sensorFrame, registry);
        YoFrameVector3D inputLinearAcceleration = new YoFrameVector3D("linearAcceleration", sensorFrame, registry);
        YoFrameVector3D inputMagneticVector = new YoFrameVector3D("magneticDirection", sensorFrame, registry);
        YoIMUMahonyFilter mahonyFilter = new YoIMUMahonyFilter(imuName, namePrefix, nameSuffix, updateDT, sensorFrame, registry);
        mahonyFilter.setInputs(inputAngularVelocity, inputLinearAcceleration, inputMagneticVector);
        mahonyFilter.setHasBeenInitialized(true);
        mahonyFilter.setGains(0.5, 0.0);
        actualOrientation.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
        Vector3D zUp = new Vector3D(0.0, 0.0, 1.0);
        actualOrientation.inverseTransform((Tuple3DBasics)zUp);
        inputLinearAcceleration.set((Tuple3DReadOnly)zUp);
        inputLinearAcceleration.scale(20.0);
        Vector3D xForward = new Vector3D(1.0, 0.0, 0.0);
        actualOrientation.inverseTransform((Tuple3DBasics)xForward);
        inputMagneticVector.set((Tuple3DReadOnly)xForward);
        inputMagneticVector.scale(0.5);
        double currentError = 0.0;
        double previousError = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 50000; ++i) {
            mahonyFilter.update();
            currentError = actualOrientation.distance((FrameOrientation3DReadOnly)mahonyFilter.getEstimatedOrientation());
            Assert.assertTrue(currentError <= previousError);
            previousError = currentError;
        }
        Assert.assertTrue(currentError <= 3.0E-4);
    }

    @Test
    public void testConvergenceToStaticOrientationWithGyroBias() throws Exception {
        String imuName = "test";
        String namePrefix = "q_est_";
        String nameSuffix = "";
        double updateDT = 0.001;
        YoRegistry registry = new YoRegistry("test");
        Random random = new Random(3454L);
        ReferenceFrame sensorFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        YoFrameQuaternion actualOrientation = new YoFrameQuaternion("q_act_", sensorFrame.getRootFrame(), registry);
        YoFrameVector3D inputAngularVelocity = new YoFrameVector3D("angularVelocity", sensorFrame, registry);
        YoFrameVector3D inputLinearAcceleration = new YoFrameVector3D("linearAcceleration", sensorFrame, registry);
        YoFrameVector3D inputMagneticVector = new YoFrameVector3D("magneticDirection", sensorFrame, registry);
        YoIMUMahonyFilter mahonyFilter = new YoIMUMahonyFilter(imuName, namePrefix, nameSuffix, updateDT, sensorFrame, registry);
        mahonyFilter.setInputs(inputAngularVelocity, inputLinearAcceleration, inputMagneticVector);
        mahonyFilter.setHasBeenInitialized(true);
        mahonyFilter.setGains(0.5, 0.05);
        inputAngularVelocity.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)0.1));
        actualOrientation.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
        Vector3D zUp = new Vector3D(0.0, 0.0, 1.0);
        actualOrientation.inverseTransform((Tuple3DBasics)zUp);
        inputLinearAcceleration.set((Tuple3DReadOnly)zUp);
        inputLinearAcceleration.scale(20.0);
        Vector3D xForward = new Vector3D(1.0, 0.0, 0.0);
        actualOrientation.inverseTransform((Tuple3DBasics)xForward);
        inputMagneticVector.set((Tuple3DReadOnly)xForward);
        inputMagneticVector.scale(0.5);
        double currentError = 0.0;
        for (int i = 0; i < 100000; ++i) {
            mahonyFilter.update();
            currentError = actualOrientation.distance((FrameOrientation3DReadOnly)mahonyFilter.getEstimatedOrientation());
        }
        System.out.println(currentError);
        Assert.assertTrue(currentError <= 3.0E-4);
        Vector3D estimatedBias = new Vector3D();
        estimatedBias.set((Tuple3DReadOnly)mahonyFilter.getIntegralTerm());
        estimatedBias.negate();
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)inputAngularVelocity, (Vector3DReadOnly)estimatedBias, (double)1.0E-4);
    }
}

