/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.WeightedAverageYoBoolean;
import us.ihmc.robotics.math.filters.WeightedAverageYoFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class WeightedAverageYoFrameVector3DTest {
    private static final int iters = 1000;
    private static final double epsilon = 1.0E-8;
    private YoRegistry registry;
    private YoFrameVector3D yoVariable1ToAverage;
    private YoFrameVector3D yoVariable2ToAverage;
    private YoDouble yoVariable1Weight;
    private YoDouble yoVariable2Weight;
    private WeightedAverageYoFrameVector3D averageVariable;

    @BeforeEach
    public void setUp() {
        this.registry = new YoRegistry("testRegistry");
        this.yoVariable1ToAverage = new YoFrameVector3D("variable1ToFilter", ReferenceFrame.getWorldFrame(), this.registry);
        this.yoVariable2ToAverage = new YoFrameVector3D("variable2ToFilter", ReferenceFrame.getWorldFrame(), this.registry);
        this.yoVariable1Weight = new YoDouble("variable1Weight", this.registry);
        this.yoVariable2Weight = new YoDouble("variable2Weight", this.registry);
        this.averageVariable = new WeightedAverageYoFrameVector3D("averageVariable", ReferenceFrame.getWorldFrame(), this.registry);
        this.averageVariable.addFrameVector3DToAverage((DoubleProvider)this.yoVariable1Weight, this.yoVariable1ToAverage);
        this.averageVariable.addFrameVector3DToAverage((DoubleProvider)this.yoVariable2Weight, this.yoVariable2ToAverage);
    }

    @AfterEach
    public void tearDown() {
        this.registry = null;
        this.yoVariable1ToAverage = null;
        this.yoVariable2ToAverage = null;
        this.yoVariable1Weight = null;
        this.yoVariable2Weight = null;
        this.averageVariable = null;
    }

    @Test
    public void testConstructors_Set_Get() {
        WeightedAverageYoBoolean bool = new WeightedAverageYoBoolean("stringInt", this.registry);
        Assert.assertFalse(bool.getBooleanValue());
        bool.set(true);
        Assert.assertTrue(bool.getBooleanValue());
        bool.set(false);
        Assert.assertFalse(bool.getBooleanValue());
    }

    @Test
    public void testUpdate() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 1000; ++iter) {
            double weight1 = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
            double weight2 = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
            double totalWeight = weight1 + weight2;
            Vector3D variable1 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            Vector3D variable2 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            this.yoVariable1Weight.set(weight1);
            this.yoVariable2Weight.set(weight2);
            this.yoVariable1ToAverage.set((Tuple3DReadOnly)variable1);
            this.yoVariable2ToAverage.set((Tuple3DReadOnly)variable2);
            FrameVector3D expectedAverage = new FrameVector3D();
            FrameVector3D scaled1 = new FrameVector3D(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)variable1);
            FrameVector3D scaled2 = new FrameVector3D(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)variable2);
            scaled1.scale(weight1 / totalWeight);
            scaled2.scale(weight2 / totalWeight);
            expectedAverage.add((FrameTuple3DReadOnly)scaled1);
            expectedAverage.add((FrameTuple3DReadOnly)scaled2);
            this.averageVariable.update();
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)expectedAverage, (Vector3DReadOnly)this.averageVariable, (double)1.0E-8);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)variable1, (Vector3DReadOnly)this.yoVariable1ToAverage, (double)1.0E-8);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)variable2, (Vector3DReadOnly)this.yoVariable2ToAverage, (double)1.0E-8);
        }
        YoDouble yoVariable3Weight = new YoDouble("variable3Weight", this.registry);
        YoFrameVector3D yoVariable3ToAverage = new YoFrameVector3D("variable3ToFilter", ReferenceFrame.getWorldFrame(), this.registry);
        this.averageVariable.addFrameVector3DToAverage((DoubleProvider)yoVariable3Weight, yoVariable3ToAverage);
        for (int iter = 0; iter < 1000; ++iter) {
            double weight1 = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
            double weight2 = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
            double weight3 = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
            double totalWeight = weight1 + weight2 + weight3;
            Vector3D variable1 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            Vector3D variable2 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            Vector3D variable3 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
            this.yoVariable1Weight.set(weight1);
            this.yoVariable2Weight.set(weight2);
            yoVariable3Weight.set(weight3);
            this.yoVariable1ToAverage.set((Tuple3DReadOnly)variable1);
            this.yoVariable2ToAverage.set((Tuple3DReadOnly)variable2);
            yoVariable3ToAverage.set((Tuple3DReadOnly)variable3);
            FrameVector3D expectedAverage = new FrameVector3D();
            FrameVector3D scaled1 = new FrameVector3D(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)variable1);
            FrameVector3D scaled2 = new FrameVector3D(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)variable2);
            FrameVector3D scaled3 = new FrameVector3D(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)variable3);
            scaled1.scale(weight1 / totalWeight);
            scaled2.scale(weight2 / totalWeight);
            scaled3.scale(weight3 / totalWeight);
            expectedAverage.add((FrameTuple3DReadOnly)scaled1);
            expectedAverage.add((FrameTuple3DReadOnly)scaled2);
            expectedAverage.add((FrameTuple3DReadOnly)scaled3);
            this.averageVariable.update();
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)expectedAverage, (Vector3DReadOnly)this.averageVariable, (double)1.0E-8);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)variable1, (Vector3DReadOnly)this.yoVariable1ToAverage, (double)1.0E-8);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)variable2, (Vector3DReadOnly)this.yoVariable2ToAverage, (double)1.0E-8);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)variable3, (Vector3DReadOnly)yoVariable3ToAverage, (double)1.0E-8);
        }
    }
}

