/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.math.filters.IntegratorBiasCompensatorYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.variable.YoDouble;

public class IntegratorBiasCompensatorYoVariableTest {
    @Test
    public void test_PerfectMeasurements_Sinewave() {
        int i;
        double epsilon = 0.001;
        Random random = new Random(23524L);
        double kp = 0.1;
        double ki = 0.01;
        YoDouble position = new YoDouble("position", null);
        position.set(RandomNumbers.nextDouble((Random)random, (double)100.0));
        YoDouble rate = new YoDouble("rate", null);
        double dt = 0.001;
        IntegratorBiasCompensatorYoVariable filter = new IntegratorBiasCompensatorYoVariable("blop", null, kp, ki, (DoubleProvider)position, (DoubleProvider)rate, dt);
        double angle = 0.0;
        double angleRate = 0.0;
        double amp = 10.0;
        double freq = 1.0;
        for (i = 0; i < 100000; ++i) {
            angleRate = Math.PI * 2 * freq;
            rate.set(angleRate * amp * Math.cos(angle += angleRate * dt));
            position.set(amp * Math.sin(angle));
            filter.update();
        }
        for (i = 0; i < 5000; ++i) {
            angleRate = Math.PI * 2 * freq;
            rate.set(angleRate * amp * Math.cos(angle += angleRate * dt));
            position.set(amp * Math.sin(angle));
            filter.update();
            Assertions.assertEquals((double)0.0, (double)filter.getBiasEstimation().getValue(), (double)epsilon);
            Assertions.assertEquals((double)rate.getValue(), (double)filter.getRateEstimation().getValue(), (double)epsilon);
            Assertions.assertEquals((double)position.getValue(), (double)filter.getPositionEstimation().getValue(), (double)(Math.max(Math.abs(position.getValue()), 1.0) * epsilon));
        }
    }

    @Test
    public void test_RateConstantBias_Sinewave() {
        int i;
        double epsilon = 0.001;
        Random random = new Random(23524L);
        double kp = 0.1;
        double ki = 0.01;
        double rateBias = RandomNumbers.nextDouble((Random)random, (double)1.0);
        YoDouble position = new YoDouble("position", null);
        position.set(RandomNumbers.nextDouble((Random)random, (double)100.0));
        YoDouble rate = new YoDouble("rate", null);
        YoDouble biasedRate = new YoDouble("biasedRate", null);
        double dt = 0.001;
        IntegratorBiasCompensatorYoVariable filter = new IntegratorBiasCompensatorYoVariable("blop", null, kp, ki, (DoubleProvider)position, (DoubleProvider)biasedRate, dt);
        double angle = 0.0;
        double angleRate = 0.0;
        double amp = 10.0;
        double freq = 1.0;
        for (i = 0; i < 100000; ++i) {
            angleRate = Math.PI * 2 * freq;
            rate.set(angleRate * amp * Math.cos(angle += angleRate * dt));
            biasedRate.set(rate.getValue() + rateBias);
            position.set(amp * Math.sin(angle));
            filter.update();
        }
        for (i = 0; i < 5000; ++i) {
            angleRate = Math.PI * 2 * freq;
            rate.set(angleRate * amp * Math.cos(angle += angleRate * dt));
            biasedRate.set(rate.getValue() + rateBias);
            position.set(amp * Math.sin(angle));
            filter.update();
            Assertions.assertEquals((double)(-rateBias), (double)filter.getBiasEstimation().getValue(), (double)epsilon);
            Assertions.assertEquals((double)rate.getValue(), (double)filter.getRateEstimation().getValue(), (double)epsilon);
            Assertions.assertEquals((double)position.getValue(), (double)filter.getPositionEstimation().getValue(), (double)(Math.max(Math.abs(position.getValue()), 1.0) * epsilon));
        }
    }

    @Test
    public void test_PositionGaussianNoise_Sinewave() {
        Random random = new Random(23540L);
        double kp = 0.1;
        double ki = 0.01;
        YoDouble position = new YoDouble("position", null);
        position.set(RandomNumbers.nextDouble((Random)random, (double)100.0));
        YoDouble noisyPosition = new YoDouble("noisyPosition", null);
        YoDouble rate = new YoDouble("rate", null);
        double dt = 0.001;
        IntegratorBiasCompensatorYoVariable filter = new IntegratorBiasCompensatorYoVariable("blop", null, kp, ki, (DoubleProvider)noisyPosition, (DoubleProvider)rate, dt);
        double noiseAmplitude = RandomNumbers.nextDouble((Random)random, (double)0.1);
        double angle = 0.0;
        double angleRate = 0.0;
        double amp = 10.0;
        double freq = 1.0;
        double epsilon = 10.0 * Math.abs(kp * noiseAmplitude);
        double biasEpsilon = 2.0 * Math.abs(kp * noiseAmplitude);
        for (int i = 0; i < 5000; ++i) {
            angleRate = Math.PI * 2 * freq;
            rate.set(angleRate * amp * Math.cos(angle += angleRate * dt));
            position.set(amp * Math.sin(angle));
            double noise = noiseAmplitude * random.nextGaussian();
            noisyPosition.set(position.getValue() + noise);
            filter.update();
            Assertions.assertEquals((double)0.0, (double)filter.getBiasEstimation().getValue(), (double)biasEpsilon);
            Assertions.assertEquals((double)rate.getValue(), (double)filter.getRateEstimation().getValue(), (double)biasEpsilon);
            Assertions.assertEquals((double)position.getValue(), (double)filter.getPositionEstimation().getValue(), (double)epsilon);
        }
    }
}

