/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.math.filters.IntegratorBiasCompensatorYoFrameVector3D;
import us.ihmc.robotics.math.filters.IntegratorBiasCompensatorYoVariable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;

public class IntegratorBiasCompensatorYoFrameVector3DTest {
    @Test
    public void testCompareAgainst1DFilter() {
        Random random = new Random(34L);
        double kp = 0.1;
        double ki = 0.01;
        double dt = 0.001;
        YoFrameVector3D position = new YoFrameVector3D("position", ReferenceFrame.getWorldFrame(), null);
        YoFrameVector3D rate = new YoFrameVector3D("rate", ReferenceFrame.getWorldFrame(), null);
        IntegratorBiasCompensatorYoVariable[] oneDimensionFilters = new IntegratorBiasCompensatorYoVariable[3];
        for (int axis = 0; axis < 3; ++axis) {
            int axisFinal = axis;
            oneDimensionFilters[axis] = new IntegratorBiasCompensatorYoVariable("filter1D[" + axis + "]", null, kp, ki, () -> position.getElement(axisFinal), () -> rate.getElement(axisFinal), dt);
        }
        ReferenceFrame biasFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"biasFrame", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
        IntegratorBiasCompensatorYoFrameVector3D threeDimensionFilter = new IntegratorBiasCompensatorYoFrameVector3D("filter3D", null, kp, ki, (FrameTuple3DReadOnly)position, (FrameTuple3DReadOnly)rate, biasFrame, dt);
        for (int i = 0; i < 5000; ++i) {
            rate.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0));
            position.set((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0));
            for (IntegratorBiasCompensatorYoVariable oneDimensionFilter : oneDimensionFilters) {
                oneDimensionFilter.update();
            }
            threeDimensionFilter.update();
            FrameVector3D bias = new FrameVector3D((FrameTuple3DReadOnly)threeDimensionFilter.getBiasEstimation());
            bias.changeFrame(ReferenceFrame.getWorldFrame());
            double epsilon = 1.0E-11;
            for (int axis = 0; axis < 3; ++axis) {
                IntegratorBiasCompensatorYoVariable oneDimensionFilter = oneDimensionFilters[axis];
                Assertions.assertEquals((double)oneDimensionFilter.getValue(), (double)threeDimensionFilter.getElement(axis), (double)epsilon);
                Assertions.assertEquals((double)oneDimensionFilter.getBiasEstimation().getValue(), (double)bias.getElement(axis), (double)epsilon);
                Assertions.assertEquals((double)oneDimensionFilter.getRateEstimation().getValue(), (double)threeDimensionFilter.getRateEstimation().getElement(axis), (double)epsilon);
            }
        }
    }
}

