/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.linearAlgebra.PrincipalComponentAnalysis3D;

public class PrincipalComponentAnalysis3DTest {
    private static final boolean DEBUG = true;
    private static final double EPSILON_HIGH_PRECISION = 5.0E-7;
    private static final double EPSILON_LOW_PRECISION = 0.002;

    @Test
    public void testWith1DData() {
        Random random = new Random(5516315L);
        for (int trialNumber = 0; trialNumber < 20; ++trialNumber) {
            int i;
            System.out.println("----------- Iteration #" + trialNumber + " ---------------------------");
            Point3D origin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0, (double)1.0, (double)1.0);
            Point3D expectedMean = new Point3D();
            double pointScatteringAmplitude = 5.0;
            Vector3D expectedPrincipalAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            double expectedVarianceAlongPrincipalAxis = 0.0;
            double expectedStandardDeviationAlongPrincipalAxis = 0.0;
            int numberOfPoints = RandomNumbers.nextInt((Random)random, (int)10, (int)500);
            ArrayList<Point3D> listOfPoints = new ArrayList<Point3D>();
            ArrayList<Double> pointCloud1D = new ArrayList<Double>();
            double mean1D = 0.0;
            Vector3D offsetFromOrigin = new Vector3D();
            for (i = 0; i < numberOfPoints; ++i) {
                double nextGaussian = pointScatteringAmplitude * random.nextGaussian();
                offsetFromOrigin.set(expectedPrincipalAxis);
                offsetFromOrigin.scale(nextGaussian);
                Point3D newPoint = new Point3D();
                newPoint.set(origin);
                newPoint.add((Tuple3DReadOnly)offsetFromOrigin);
                listOfPoints.add(newPoint);
                expectedMean.setX(expectedMean.getX() + newPoint.getX() / (double)numberOfPoints);
                expectedMean.setY(expectedMean.getY() + newPoint.getY() / (double)numberOfPoints);
                expectedMean.setZ(expectedMean.getZ() + newPoint.getZ() / (double)numberOfPoints);
                pointCloud1D.add(nextGaussian);
                mean1D += nextGaussian / (double)numberOfPoints;
            }
            for (i = 0; i < numberOfPoints; ++i) {
                expectedVarianceAlongPrincipalAxis += MathTools.square((double)((Double)pointCloud1D.get(i) - mean1D)) / (double)numberOfPoints;
            }
            expectedStandardDeviationAlongPrincipalAxis = Math.sqrt(expectedVarianceAlongPrincipalAxis);
            Point3D estimatedMean = new Point3D();
            Vector3D estimatedPrincipalAxis = new Vector3D();
            Vector3D estimatedSecondaryAxis = new Vector3D();
            Vector3D estimatedThirdAxis = new Vector3D();
            Vector3D estimatedVariance = new Vector3D();
            Vector3D estimatedStandardDeviation = new Vector3D();
            Vector3D estimatedScaledPrincipalVector = new Vector3D();
            Vector3D estimatedScaledSecondaryVector = new Vector3D();
            Vector3D estimatedScaledThirdVector = new Vector3D();
            PrincipalComponentAnalysis3D pca = new PrincipalComponentAnalysis3D();
            pca.setPointCloud(listOfPoints);
            pca.compute();
            pca.getMean(estimatedMean);
            pca.getPrincipalVectors(estimatedPrincipalAxis, estimatedSecondaryAxis, estimatedThirdAxis);
            pca.getStandardDeviation(estimatedStandardDeviation);
            pca.getVariance(estimatedVariance);
            pca.getScaledPrincipalVectors(estimatedScaledPrincipalVector, estimatedScaledSecondaryVector, estimatedScaledThirdVector);
            if (estimatedPrincipalAxis.dot((Tuple3DReadOnly)expectedPrincipalAxis) < 0.0) {
                expectedPrincipalAxis.negate();
            }
            Vector3D errorPrincipalAxis = new Vector3D();
            errorPrincipalAxis.sub((Tuple3DReadOnly)expectedPrincipalAxis, (Tuple3DReadOnly)estimatedPrincipalAxis);
            System.out.println("Error for the principal axis: " + String.valueOf(errorPrincipalAxis));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPrincipalAxis, (EuclidGeometry)estimatedPrincipalAxis, (double)5.0E-7);
            Vector3D errorMean = new Vector3D();
            errorMean.sub((Tuple3DReadOnly)expectedMean, (Tuple3DReadOnly)estimatedMean);
            System.out.println("Error for the mean: " + String.valueOf(errorMean));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedMean, (EuclidGeometry)estimatedMean, (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedPrincipalAxis.dot((Tuple3DReadOnly)estimatedSecondaryAxis), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedPrincipalAxis.dot((Tuple3DReadOnly)estimatedThirdAxis), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedSecondaryAxis.dot((Tuple3DReadOnly)estimatedThirdAxis), (double)5.0E-7);
            System.out.println();
            System.out.println("Esimated principal axis: " + String.valueOf(estimatedPrincipalAxis));
            System.out.println("Esimated secondary axis: " + String.valueOf(estimatedSecondaryAxis));
            System.out.println("Esimated third axis: " + String.valueOf(estimatedThirdAxis));
            System.out.println();
            System.out.println("Estimated variance: " + String.valueOf(estimatedVariance));
            System.out.println("Estimated standard deviation: " + String.valueOf(estimatedStandardDeviation));
            Assertions.assertEquals((double)expectedStandardDeviationAlongPrincipalAxis, (double)estimatedStandardDeviation.getX(), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedStandardDeviation.getY(), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedStandardDeviation.getZ(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedVarianceAlongPrincipalAxis, (double)estimatedVariance.getX(), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedVariance.getY(), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedVariance.getZ(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedVarianceAlongPrincipalAxis, (double)estimatedScaledPrincipalVector.norm(), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedScaledSecondaryVector.norm(), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedScaledThirdVector.norm(), (double)5.0E-7);
            estimatedScaledPrincipalVector.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPrincipalAxis, (EuclidGeometry)estimatedScaledPrincipalVector, (double)5.0E-7);
            RotationMatrix rotationMatrix = new RotationMatrix();
            pca.getPrincipalFrameRotationMatrix(rotationMatrix);
            rotationMatrix.getColumn(0, (Tuple3DBasics)estimatedPrincipalAxis);
            rotationMatrix.getColumn(1, (Tuple3DBasics)estimatedSecondaryAxis);
            rotationMatrix.getColumn(2, (Tuple3DBasics)estimatedThirdAxis);
            Assertions.assertTrue((boolean)rotationMatrix.isRotationMatrix());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPrincipalAxis, (EuclidGeometry)estimatedPrincipalAxis, (double)5.0E-7);
        }
    }

    @Test
    public void testWith2DData() {
        Random random = new Random(5516315L);
        for (int trialNumber = 0; trialNumber < 20; ++trialNumber) {
            int i;
            System.out.println("----------- Iteration #" + trialNumber + " ---------------------------");
            Point3D origin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0, (double)1.0, (double)1.0);
            Point3D expectedMean = new Point3D();
            Vector2D pointScatteringAmplitude = new Vector2D(15.0, 1.0);
            Vector3D expectedPrincipalAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Vector3D randomVector = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Vector3D expectedSecondaryAxis = new Vector3D();
            expectedSecondaryAxis.cross((Tuple3DReadOnly)expectedPrincipalAxis, (Tuple3DReadOnly)randomVector);
            expectedSecondaryAxis.normalize();
            Vector3D expectedThirdAxis = new Vector3D();
            expectedThirdAxis.cross((Tuple3DReadOnly)expectedPrincipalAxis, (Tuple3DReadOnly)expectedSecondaryAxis);
            Vector2D expectedVariance = new Vector2D();
            Vector2D expectedStandardDeviation = new Vector2D();
            int numberOfPoints = RandomNumbers.nextInt((Random)random, (int)5000, (int)10000);
            ArrayList<Point3D> listOfPoints = new ArrayList<Point3D>();
            ArrayList<Point2D> pointCloudProjectedOnPrincipalAxes = new ArrayList<Point2D>();
            Point2D meanOnPrincipalAxes = new Point2D();
            Vector3D offsetFromOrigin = new Vector3D();
            for (int i2 = 0; i2 < numberOfPoints; ++i2) {
                Point3D newPoint = new Point3D();
                newPoint.set(origin);
                double nextGaussianForPrincipalAxis = pointScatteringAmplitude.getX() * (1.0 - 2.0 * random.nextDouble());
                offsetFromOrigin.set(expectedPrincipalAxis);
                offsetFromOrigin.scale(nextGaussianForPrincipalAxis);
                newPoint.add((Tuple3DReadOnly)offsetFromOrigin);
                double nextGaussianForSecondaryAxis = pointScatteringAmplitude.getY() * (1.0 - 2.0 * random.nextDouble());
                offsetFromOrigin.set(expectedSecondaryAxis);
                offsetFromOrigin.scale(nextGaussianForSecondaryAxis);
                newPoint.add((Tuple3DReadOnly)offsetFromOrigin);
                listOfPoints.add(newPoint);
                expectedMean.setX(expectedMean.getX() + newPoint.getX() / (double)numberOfPoints);
                expectedMean.setY(expectedMean.getY() + newPoint.getY() / (double)numberOfPoints);
                expectedMean.setZ(expectedMean.getZ() + newPoint.getZ() / (double)numberOfPoints);
            }
            Point3D estimatedMean = new Point3D();
            Vector3D estimatedPrincipalAxis = new Vector3D();
            Vector3D estimatedSecondaryAxis = new Vector3D();
            Vector3D estimatedThirdAxis = new Vector3D();
            Vector3D estimatedVariance = new Vector3D();
            Vector3D estimatedStandardDeviation = new Vector3D();
            Vector3D estimatedScaledPrincipalVector = new Vector3D();
            Vector3D estimatedScaledSecondaryVector = new Vector3D();
            Vector3D estimatedScaledThirdVector = new Vector3D();
            PrincipalComponentAnalysis3D pca = new PrincipalComponentAnalysis3D();
            pca.setPointCloud(listOfPoints);
            pca.compute();
            pca.getMean(estimatedMean);
            pca.getPrincipalVectors(estimatedPrincipalAxis, estimatedSecondaryAxis, estimatedThirdAxis);
            pca.getStandardDeviation(estimatedStandardDeviation);
            pca.getVariance(estimatedVariance);
            pca.getScaledPrincipalVectors(estimatedScaledPrincipalVector, estimatedScaledSecondaryVector, estimatedScaledThirdVector);
            for (i = 0; i < numberOfPoints; ++i) {
                Vector3D vectorToPoint = new Vector3D();
                vectorToPoint.set((Tuple3DReadOnly)listOfPoints.get(i));
                double dotProductOnPrincipalAxis = vectorToPoint.dot((Tuple3DReadOnly)estimatedPrincipalAxis);
                double dotProductOnSecondaryAxis = vectorToPoint.dot((Tuple3DReadOnly)estimatedSecondaryAxis);
                pointCloudProjectedOnPrincipalAxes.add(new Point2D(dotProductOnPrincipalAxis, dotProductOnSecondaryAxis));
                meanOnPrincipalAxes.setX(meanOnPrincipalAxes.getX() + dotProductOnPrincipalAxis / (double)numberOfPoints);
                meanOnPrincipalAxes.setY(meanOnPrincipalAxes.getY() + dotProductOnSecondaryAxis / (double)numberOfPoints);
            }
            for (i = 0; i < numberOfPoints; ++i) {
                expectedVariance.setX(expectedVariance.getX() + MathTools.square((double)(((Point2D)pointCloudProjectedOnPrincipalAxes.get(i)).getX() - meanOnPrincipalAxes.getX())) / (double)numberOfPoints);
                expectedVariance.setY(expectedVariance.getY() + MathTools.square((double)(((Point2D)pointCloudProjectedOnPrincipalAxes.get(i)).getY() - meanOnPrincipalAxes.getY())) / (double)numberOfPoints);
            }
            expectedStandardDeviation.setX(Math.sqrt(expectedVariance.getX()));
            expectedStandardDeviation.setY(Math.sqrt(expectedVariance.getY()));
            if (estimatedPrincipalAxis.dot((Tuple3DReadOnly)expectedPrincipalAxis) < 0.0) {
                expectedPrincipalAxis.negate();
            }
            if (estimatedSecondaryAxis.dot((Tuple3DReadOnly)expectedSecondaryAxis) < 0.0) {
                expectedSecondaryAxis.negate();
            }
            if (estimatedThirdAxis.dot((Tuple3DReadOnly)expectedThirdAxis) < 0.0) {
                expectedThirdAxis.negate();
            }
            System.out.println("Expected principal axis: " + String.valueOf(expectedPrincipalAxis));
            System.out.println("Expected secondary axis: " + String.valueOf(expectedSecondaryAxis));
            System.out.println("Expected third axis: " + String.valueOf(expectedThirdAxis));
            System.out.println();
            System.out.println("Expected variance: " + String.valueOf(expectedVariance));
            System.out.println("Expected standard deviation: " + String.valueOf(expectedStandardDeviation));
            System.out.println();
            Vector3D errorPrincipalAxis = new Vector3D();
            errorPrincipalAxis.sub((Tuple3DReadOnly)expectedPrincipalAxis, (Tuple3DReadOnly)estimatedPrincipalAxis);
            System.out.println("Error magnitude for the principal axis: " + errorPrincipalAxis.norm());
            Vector3D errorSecondaryAxis = new Vector3D();
            errorSecondaryAxis.sub((Tuple3DReadOnly)expectedSecondaryAxis, (Tuple3DReadOnly)estimatedSecondaryAxis);
            System.out.println("Error magnitude for the secondary axis: " + errorSecondaryAxis.norm());
            Vector3D errorThirdAxis = new Vector3D();
            errorThirdAxis.sub((Tuple3DReadOnly)expectedThirdAxis, (Tuple3DReadOnly)estimatedThirdAxis);
            System.out.println("Error magnitude for the third axis: " + errorThirdAxis.norm());
            Vector3D errorMean = new Vector3D();
            errorMean.sub((Tuple3DReadOnly)expectedMean, (Tuple3DReadOnly)estimatedMean);
            System.out.println("Error for the mean: " + String.valueOf(errorMean));
            System.out.println();
            System.out.println("Estimated principal axis: " + String.valueOf(estimatedPrincipalAxis));
            System.out.println("Estimated secondary axis: " + String.valueOf(estimatedSecondaryAxis));
            System.out.println("Estimated third axis: " + String.valueOf(estimatedThirdAxis));
            System.out.println();
            System.out.println("Estimated variance: " + String.valueOf(estimatedVariance));
            System.out.println("Estimated standard deviation: " + String.valueOf(estimatedStandardDeviation));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPrincipalAxis, (EuclidGeometry)estimatedPrincipalAxis, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondaryAxis, (EuclidGeometry)estimatedSecondaryAxis, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedThirdAxis, (EuclidGeometry)estimatedThirdAxis, (double)5.0E-7);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedMean, (EuclidGeometry)estimatedMean, (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedPrincipalAxis.dot((Tuple3DReadOnly)estimatedSecondaryAxis), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedPrincipalAxis.dot((Tuple3DReadOnly)estimatedThirdAxis), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedSecondaryAxis.dot((Tuple3DReadOnly)estimatedThirdAxis), (double)5.0E-7);
            Assertions.assertEquals((double)expectedStandardDeviation.getX(), (double)estimatedStandardDeviation.getX(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedStandardDeviation.getY(), (double)estimatedStandardDeviation.getY(), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedStandardDeviation.getZ(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedVariance.getX(), (double)estimatedVariance.getX(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedVariance.getY(), (double)estimatedVariance.getY(), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedVariance.getZ(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedVariance.getX(), (double)estimatedScaledPrincipalVector.norm(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedVariance.getY(), (double)estimatedScaledSecondaryVector.norm(), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedScaledThirdVector.norm(), (double)5.0E-7);
            estimatedScaledPrincipalVector.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPrincipalAxis, (EuclidGeometry)estimatedScaledPrincipalVector, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)estimatedPrincipalAxis, (EuclidGeometry)estimatedScaledPrincipalVector, (double)5.0E-7);
            estimatedScaledSecondaryVector.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondaryAxis, (EuclidGeometry)estimatedScaledSecondaryVector, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)estimatedSecondaryAxis, (EuclidGeometry)estimatedScaledSecondaryVector, (double)5.0E-7);
            RotationMatrix rotationMatrix = new RotationMatrix();
            pca.getPrincipalFrameRotationMatrix(rotationMatrix);
            rotationMatrix.getColumn(0, (Tuple3DBasics)estimatedPrincipalAxis);
            rotationMatrix.getColumn(1, (Tuple3DBasics)estimatedSecondaryAxis);
            rotationMatrix.getColumn(2, (Tuple3DBasics)estimatedThirdAxis);
            Assertions.assertTrue((boolean)rotationMatrix.isRotationMatrix());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPrincipalAxis, (EuclidGeometry)estimatedPrincipalAxis, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondaryAxis, (EuclidGeometry)estimatedSecondaryAxis, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)estimatedPrincipalAxis, (EuclidGeometry)estimatedScaledPrincipalVector, (double)5.0E-7);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)estimatedSecondaryAxis, (EuclidGeometry)estimatedScaledSecondaryVector, (double)5.0E-7);
        }
    }

    @Test
    public void testWith3DData() {
        Random random = new Random(5516315L);
        for (int trialNumber = 0; trialNumber < 1; ++trialNumber) {
            int i;
            System.out.println("----------- Iteration #" + trialNumber + " ---------------------------");
            Point3D origin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0, (double)1.0, (double)1.0);
            Point3D expectedMean = new Point3D();
            Vector3D pointScatteringAmplitude = new Vector3D(15.0, 1.0, 0.2);
            Vector3D expectedPrincipalAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Vector3D randomVector = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Vector3D expectedSecondaryAxis = new Vector3D();
            expectedSecondaryAxis.cross((Tuple3DReadOnly)expectedPrincipalAxis, (Tuple3DReadOnly)randomVector);
            expectedSecondaryAxis.normalize();
            Vector3D expectedThirdAxis = new Vector3D();
            expectedThirdAxis.cross((Tuple3DReadOnly)expectedPrincipalAxis, (Tuple3DReadOnly)expectedSecondaryAxis);
            Vector3D expectedVariance = new Vector3D();
            Vector3D expectedStandardDeviation = new Vector3D();
            int numberOfPoints = RandomNumbers.nextInt((Random)random, (int)5000, (int)10000);
            ArrayList<Point3D> listOfPoints = new ArrayList<Point3D>();
            ArrayList<Point3D> pointCloudProjectedOnPrincipalAxes = new ArrayList<Point3D>();
            Point3D meanOnPrincipalAxes = new Point3D();
            Vector3D offsetFromOrigin = new Vector3D();
            for (int i2 = 0; i2 < numberOfPoints; ++i2) {
                Point3D newPoint = new Point3D();
                newPoint.set(origin);
                double nextGaussianForPrincipalAxis = pointScatteringAmplitude.getX() * (1.0 - 2.0 * random.nextDouble());
                offsetFromOrigin.set(expectedPrincipalAxis);
                offsetFromOrigin.scale(nextGaussianForPrincipalAxis);
                newPoint.add((Tuple3DReadOnly)offsetFromOrigin);
                double nextGaussianForSecondaryAxis = pointScatteringAmplitude.getY() * (1.0 - 2.0 * random.nextDouble());
                offsetFromOrigin.set(expectedSecondaryAxis);
                offsetFromOrigin.scale(nextGaussianForSecondaryAxis);
                newPoint.add((Tuple3DReadOnly)offsetFromOrigin);
                double nextGaussianForThirdAxis = pointScatteringAmplitude.getZ() * (1.0 - 2.0 * random.nextDouble());
                offsetFromOrigin.set(expectedThirdAxis);
                offsetFromOrigin.scale(nextGaussianForThirdAxis);
                newPoint.add((Tuple3DReadOnly)offsetFromOrigin);
                listOfPoints.add(newPoint);
                expectedMean.setX(expectedMean.getX() + newPoint.getX() / (double)numberOfPoints);
                expectedMean.setY(expectedMean.getY() + newPoint.getY() / (double)numberOfPoints);
                expectedMean.setZ(expectedMean.getZ() + newPoint.getZ() / (double)numberOfPoints);
            }
            Point3D estimatedMean = new Point3D();
            Vector3D estimatedPrincipalAxis = new Vector3D();
            Vector3D estimatedSecondaryAxis = new Vector3D();
            Vector3D estimatedThirdAxis = new Vector3D();
            Vector3D estimatedVariance = new Vector3D();
            Vector3D estimatedStandardDeviation = new Vector3D();
            Vector3D estimatedScaledPrincipalVector = new Vector3D();
            Vector3D estimatedScaledSecondaryVector = new Vector3D();
            Vector3D estimatedScaledThirdVector = new Vector3D();
            PrincipalComponentAnalysis3D pca = new PrincipalComponentAnalysis3D();
            pca.setPointCloud(listOfPoints);
            pca.compute();
            pca.getMean(estimatedMean);
            pca.getPrincipalVectors(estimatedPrincipalAxis, estimatedSecondaryAxis, estimatedThirdAxis);
            pca.getStandardDeviation(estimatedStandardDeviation);
            pca.getVariance(estimatedVariance);
            pca.getScaledPrincipalVectors(estimatedScaledPrincipalVector, estimatedScaledSecondaryVector, estimatedScaledThirdVector);
            for (i = 0; i < numberOfPoints; ++i) {
                Vector3D vectorToPoint = new Vector3D();
                vectorToPoint.set((Tuple3DReadOnly)listOfPoints.get(i));
                double dotProductOnPrincipalAxis = vectorToPoint.dot((Tuple3DReadOnly)estimatedPrincipalAxis);
                double dotProductOnSecondaryAxis = vectorToPoint.dot((Tuple3DReadOnly)estimatedSecondaryAxis);
                double dotProductOnThirdAxis = vectorToPoint.dot((Tuple3DReadOnly)estimatedThirdAxis);
                pointCloudProjectedOnPrincipalAxes.add(new Point3D(dotProductOnPrincipalAxis, dotProductOnSecondaryAxis, dotProductOnThirdAxis));
                meanOnPrincipalAxes.setX(meanOnPrincipalAxes.getX() + dotProductOnPrincipalAxis / (double)numberOfPoints);
                meanOnPrincipalAxes.setY(meanOnPrincipalAxes.getY() + dotProductOnSecondaryAxis / (double)numberOfPoints);
                meanOnPrincipalAxes.setZ(meanOnPrincipalAxes.getZ() + dotProductOnThirdAxis / (double)numberOfPoints);
            }
            for (i = 0; i < numberOfPoints; ++i) {
                expectedVariance.setX(expectedVariance.getX() + MathTools.square((double)(((Point3D)pointCloudProjectedOnPrincipalAxes.get(i)).getX() - meanOnPrincipalAxes.getX())) / (double)numberOfPoints);
                expectedVariance.setY(expectedVariance.getY() + MathTools.square((double)(((Point3D)pointCloudProjectedOnPrincipalAxes.get(i)).getY() - meanOnPrincipalAxes.getY())) / (double)numberOfPoints);
                expectedVariance.setZ(expectedVariance.getZ() + MathTools.square((double)(((Point3D)pointCloudProjectedOnPrincipalAxes.get(i)).getZ() - meanOnPrincipalAxes.getZ())) / (double)numberOfPoints);
            }
            expectedStandardDeviation.setX(Math.sqrt(expectedVariance.getX()));
            expectedStandardDeviation.setY(Math.sqrt(expectedVariance.getY()));
            expectedStandardDeviation.setZ(Math.sqrt(expectedVariance.getZ()));
            if (estimatedPrincipalAxis.dot((Tuple3DReadOnly)expectedPrincipalAxis) < 0.0) {
                expectedPrincipalAxis.negate();
            }
            if (estimatedSecondaryAxis.dot((Tuple3DReadOnly)expectedSecondaryAxis) < 0.0) {
                expectedSecondaryAxis.negate();
            }
            if (estimatedThirdAxis.dot((Tuple3DReadOnly)expectedThirdAxis) < 0.0) {
                expectedThirdAxis.negate();
            }
            System.out.println("Expected principal axis: " + String.valueOf(expectedPrincipalAxis));
            System.out.println("Expected secondary axis: " + String.valueOf(expectedSecondaryAxis));
            System.out.println("Expected third axis: " + String.valueOf(expectedThirdAxis));
            System.out.println();
            System.out.println("Expected variance: " + String.valueOf(expectedVariance));
            System.out.println("Expected standard deviation: " + String.valueOf(expectedStandardDeviation));
            System.out.println();
            Vector3D errorPrincipalAxis = new Vector3D();
            errorPrincipalAxis.sub((Tuple3DReadOnly)expectedPrincipalAxis, (Tuple3DReadOnly)estimatedPrincipalAxis);
            System.out.println("Error magnitude for the principal axis: " + errorPrincipalAxis.length());
            Vector3D errorSecondaryAxis = new Vector3D();
            errorSecondaryAxis.sub((Tuple3DReadOnly)expectedSecondaryAxis, (Tuple3DReadOnly)estimatedSecondaryAxis);
            System.out.println("Error magnitude for the secondary axis: " + errorSecondaryAxis.length());
            Vector3D errorThirdAxis = new Vector3D();
            errorThirdAxis.sub((Tuple3DReadOnly)expectedThirdAxis, (Tuple3DReadOnly)estimatedThirdAxis);
            System.out.println("Error magnitude for the third axis: " + errorThirdAxis.length());
            Vector3D errorMean = new Vector3D();
            errorMean.sub((Tuple3DReadOnly)expectedMean, (Tuple3DReadOnly)estimatedMean);
            System.out.println("Error for the mean: " + String.valueOf(errorMean));
            System.out.println();
            System.out.println("Estimated principal axis: " + String.valueOf(estimatedPrincipalAxis));
            System.out.println("Estimated secondary axis: " + String.valueOf(estimatedSecondaryAxis));
            System.out.println("Estimated third axis: " + String.valueOf(estimatedThirdAxis));
            System.out.println();
            System.out.println("Estimated variance: " + String.valueOf(estimatedVariance));
            System.out.println("Estimated standard deviation: " + String.valueOf(estimatedStandardDeviation));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPrincipalAxis, (EuclidGeometry)estimatedPrincipalAxis, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondaryAxis, (EuclidGeometry)estimatedSecondaryAxis, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedThirdAxis, (EuclidGeometry)estimatedThirdAxis, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedMean, (EuclidGeometry)estimatedMean, (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedPrincipalAxis.dot((Tuple3DReadOnly)estimatedSecondaryAxis), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedPrincipalAxis.dot((Tuple3DReadOnly)estimatedThirdAxis), (double)5.0E-7);
            Assertions.assertEquals((double)0.0, (double)estimatedSecondaryAxis.dot((Tuple3DReadOnly)estimatedThirdAxis), (double)5.0E-7);
            Assertions.assertEquals((double)expectedStandardDeviation.getX(), (double)estimatedStandardDeviation.getX(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedStandardDeviation.getY(), (double)estimatedStandardDeviation.getY(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedStandardDeviation.getZ(), (double)estimatedStandardDeviation.getZ(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedVariance.getX(), (double)estimatedVariance.getX(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedVariance.getY(), (double)estimatedVariance.getY(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedVariance.getZ(), (double)estimatedVariance.getZ(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedVariance.getX(), (double)estimatedScaledPrincipalVector.norm(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedVariance.getY(), (double)estimatedScaledSecondaryVector.norm(), (double)5.0E-7);
            Assertions.assertEquals((double)expectedVariance.getZ(), (double)estimatedScaledThirdVector.norm(), (double)5.0E-7);
            estimatedScaledPrincipalVector.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPrincipalAxis, (EuclidGeometry)estimatedScaledPrincipalVector, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)estimatedPrincipalAxis, (EuclidGeometry)estimatedScaledPrincipalVector, (double)5.0E-7);
            estimatedScaledSecondaryVector.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondaryAxis, (EuclidGeometry)estimatedScaledSecondaryVector, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)estimatedSecondaryAxis, (EuclidGeometry)estimatedScaledSecondaryVector, (double)5.0E-7);
            estimatedScaledThirdVector.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedThirdAxis, (EuclidGeometry)estimatedScaledThirdVector, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)estimatedThirdAxis, (EuclidGeometry)estimatedScaledThirdVector, (double)5.0E-7);
            RotationMatrix rotationMatrix = new RotationMatrix();
            pca.getPrincipalFrameRotationMatrix(rotationMatrix);
            rotationMatrix.getColumn(0, (Tuple3DBasics)estimatedPrincipalAxis);
            rotationMatrix.getColumn(1, (Tuple3DBasics)estimatedSecondaryAxis);
            rotationMatrix.getColumn(2, (Tuple3DBasics)estimatedThirdAxis);
            Assertions.assertTrue((boolean)rotationMatrix.isRotationMatrix());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPrincipalAxis, (EuclidGeometry)estimatedPrincipalAxis, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)estimatedPrincipalAxis, (EuclidGeometry)estimatedScaledPrincipalVector, (double)5.0E-7);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondaryAxis, (EuclidGeometry)estimatedSecondaryAxis, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)estimatedSecondaryAxis, (EuclidGeometry)estimatedScaledSecondaryVector, (double)5.0E-7);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedThirdAxis, (EuclidGeometry)estimatedThirdAxis, (double)0.002);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)estimatedThirdAxis, (EuclidGeometry)estimatedScaledThirdVector, (double)5.0E-7);
        }
    }

    @Test
    public void testNoData() {
        PrincipalComponentAnalysis3D pca = new PrincipalComponentAnalysis3D();
        ArrayList listOfPoints = new ArrayList();
        pca.setPointCloud(listOfPoints);
        pca.compute();
    }

    @Test
    public void testSingleDataPoint() {
        Random random = new Random(1298490387L);
        PrincipalComponentAnalysis3D pca = new PrincipalComponentAnalysis3D();
        ArrayList<Point3D> listOfPoints = new ArrayList<Point3D>();
        listOfPoints.add(EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0));
        pca.setPointCloud(listOfPoints);
        pca.compute();
    }

    @Test
    public void testTwoDataPoint() {
        Random random = new Random(1298490387L);
        PrincipalComponentAnalysis3D pca = new PrincipalComponentAnalysis3D();
        ArrayList<Point3D> listOfPoints = new ArrayList<Point3D>();
        listOfPoints.add(EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0));
        listOfPoints.add(EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0));
        pca.setPointCloud(listOfPoints);
        pca.compute();
    }

    @Test
    public void testAllignedDataPointsOnY() {
        Random random = new Random(129849038127L);
        Vector3D direction = new Vector3D(0.0, 1.0, 0.0);
        direction.normalize();
        PrincipalComponentAnalysis3D pca = new PrincipalComponentAnalysis3D();
        ArrayList<Point3D> listOfPoints = new ArrayList<Point3D>();
        for (int i = 0; i < 100; ++i) {
            Point3D point = new Point3D((Tuple3DReadOnly)direction);
            point.scale(5.0 * random.nextGaussian());
            listOfPoints.add(point);
        }
        Vector3D estimatedPrincipalAxis = new Vector3D();
        pca.setPointCloud(listOfPoints);
        pca.compute();
        pca.getPrincipalVector(estimatedPrincipalAxis);
        Assertions.assertEquals((double)estimatedPrincipalAxis.norm(), (double)1.0, (double)5.0E-7);
        double dotProduct = Math.abs(estimatedPrincipalAxis.dot((Tuple3DReadOnly)direction));
        Assertions.assertEquals((double)1.0, (double)dotProduct, (double)5.0E-7);
    }
}

