/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ejml.EjmlUnitTests;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.linearAlgebra.IncrementalCovariance3D;

public class IncrementalCovariance3DTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testEasyCase() {
        Random random = new Random(51651L);
        IncrementalCovariance3D incrementalCovariance3D = new IncrementalCovariance3D();
        Point3D average = new Point3D();
        int length = 100;
        Vector3D maxAmplitude = new Vector3D(1.0, 1.0, 1.0);
        for (int i = 0; i < 100; ++i) {
            List<Point3D> dataset = IncrementalCovariance3DTest.createRandomDataset(random, average, length, maxAmplitude);
            incrementalCovariance3D.clear();
            incrementalCovariance3D.addAllDataPoints(dataset);
            this.assertCovarianceIsCorrect(incrementalCovariance3D, dataset);
            incrementalCovariance3D.clear();
            for (Point3D dataPoint : dataset) {
                incrementalCovariance3D.addDataPoint((Tuple3DReadOnly)dataPoint);
            }
            this.assertCovarianceIsCorrect(incrementalCovariance3D, dataset);
        }
    }

    @Test
    public void testNonZeroMean() {
        Random random = new Random(51651L);
        IncrementalCovariance3D incrementalCovariance3D = new IncrementalCovariance3D();
        int length = 100;
        Vector3D maxAmplitude = new Vector3D(1.0, 1.0, 1.0);
        for (int i = 0; i < 100; ++i) {
            Point3D average = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
            List<Point3D> dataset = IncrementalCovariance3DTest.createRandomDataset(random, average, length, maxAmplitude);
            incrementalCovariance3D.clear();
            incrementalCovariance3D.addAllDataPoints(dataset);
            this.assertCovarianceIsCorrect(incrementalCovariance3D, dataset);
            incrementalCovariance3D.clear();
            for (Point3D dataPoint : dataset) {
                incrementalCovariance3D.addDataPoint((Tuple3DReadOnly)dataPoint);
            }
            this.assertCovarianceIsCorrect(incrementalCovariance3D, dataset);
        }
    }

    private void assertCovarianceIsCorrect(IncrementalCovariance3D incrementalCovariance3D, List<Point3D> dataset) {
        Point3D expectedMean = EuclidGeometryTools.averagePoint3Ds(dataset);
        Point3D actualMean = new Point3D();
        incrementalCovariance3D.getMean((Tuple3DBasics)actualMean);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedMean, (EuclidGeometry)actualMean, (double)1.0E-12);
        DMatrixRMaj actualCovariance = new DMatrixRMaj(0, 0);
        incrementalCovariance3D.getCovariance(actualCovariance);
        DMatrixRMaj expectedCovariance = IncrementalCovariance3DTest.computeCovarianceMatrix(dataset, false);
        this.assertEquals(expectedCovariance, actualCovariance, 1.0E-12);
        incrementalCovariance3D.getCovarianceCorrected(actualCovariance);
        expectedCovariance = IncrementalCovariance3DTest.computeCovarianceMatrix(dataset, true);
        this.assertEquals(expectedCovariance, actualCovariance, 1.0E-12);
    }

    private void assertEquals(DMatrixRMaj expectedCovariance, DMatrixRMaj actualCovariance, double epsilon) {
        EjmlUnitTests.assertEquals((DMatrix)expectedCovariance, (DMatrix)actualCovariance, (double)epsilon);
    }

    private static String assertErrorMessage(DMatrixRMaj expectedCovariance, DMatrixRMaj actualCovariance) {
        return "Expected:\n" + String.valueOf(expectedCovariance) + "\nActual:\n" + String.valueOf(actualCovariance);
    }

    private static List<Point3D> createRandomDataset(Random random, Point3D average, int length, Vector3D maxAmplitude) {
        ArrayList<Point3D> dataset = new ArrayList<Point3D>(length);
        Point3D min = new Point3D();
        Point3D max = new Point3D();
        min.sub((Tuple3DReadOnly)average, (Tuple3DReadOnly)maxAmplitude);
        max.add((Tuple3DReadOnly)average, (Tuple3DReadOnly)maxAmplitude);
        for (int i = 0; i < length; ++i) {
            dataset.add(EuclidCoreRandomTools.nextPoint3D((Random)random, (double)min.getX(), (double)max.getX(), (double)min.getY(), (double)max.getY(), (double)min.getZ(), (double)max.getZ()));
        }
        return dataset;
    }

    private static DMatrixRMaj computeCovarianceMatrix(List<Point3D> dataset, boolean corrected) {
        DMatrixRMaj covariance = new DMatrixRMaj(3, 3);
        int n = dataset.size();
        DMatrixRMaj datasetMatrix = new DMatrixRMaj(n, 3);
        Point3D average = EuclidGeometryTools.averagePoint3Ds(dataset);
        for (int i = 0; i < n; ++i) {
            Point3D dataPoint = dataset.get(i);
            datasetMatrix.set(i, 0, dataPoint.getX() - average.getX());
            datasetMatrix.set(i, 1, dataPoint.getY() - average.getY());
            datasetMatrix.set(i, 2, dataPoint.getZ() - average.getZ());
        }
        CommonOps_DDRM.multInner((DMatrix1Row)datasetMatrix, (DMatrix1Row)covariance);
        if (corrected) {
            CommonOps_DDRM.scale((double)(1.0 / ((double)n - 1.0)), (DMatrixD1)covariance);
        } else {
            CommonOps_DDRM.scale((double)(1.0 / (double)n), (DMatrixD1)covariance);
        }
        return covariance;
    }
}

