/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.lidar;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.lidar.LidarScanParameters;

public class LidarScanParametersTest {
    @Test
    public void LidarScanParameters_1() {
        LidarScanParameters lidarScanParameters = new LidarScanParameters();
        Assert.assertEquals((double)lidarScanParameters.getMaxRange(), 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.getMinRange(), 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.getMinRange(), 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.pointsPerSweep, 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.sweepYawMin, 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.sweepYawMax, 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.timeIncrement, 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.scanTime, 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.timestamp, 0.0, 1.0E-7);
    }

    @Test
    public void LidarScanParameters_2() {
        long timeStamp = System.currentTimeMillis();
        LidarScanParameters lidarScanParameters = new LidarScanParameters(new LidarScanParameters(), timeStamp);
        Assert.assertEquals((double)lidarScanParameters.getMaxRange(), 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.getMinRange(), 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.getMinRange(), 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.pointsPerSweep, 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.sweepYawMin, 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.sweepYawMax, 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.timeIncrement, 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.scanTime, 0.0, 1.0E-7);
        Assert.assertEquals((double)lidarScanParameters.timestamp, (double)timeStamp, 1.0E-7);
    }

    @Test
    public void LidarScanParameters_3() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int pointsPerSweep = rand.nextInt();
            int fov = (int)((double)rand.nextFloat() * Math.PI);
            double minRange = rand.nextDouble();
            double maxRange = rand.nextDouble();
            LidarScanParameters lidarScanParameters = new LidarScanParameters(pointsPerSweep, (double)fov, minRange, maxRange);
            Assert.assertEquals((double)lidarScanParameters.getMaxRange(), maxRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getMinRange(), minRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getPointsPerSweep(), (double)pointsPerSweep, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getFieldOfView(), (double)fov, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMin(), (double)(-fov) / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMax(), (double)fov / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getTimeIncrement(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTime(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTimeNanos(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getTimestamp(), 0.0, 1.0E-7);
        }
    }

    @Test
    public void LidarScanParameters_4() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int pointsPerSweep = rand.nextInt();
            int fov = (int)((double)rand.nextFloat() * Math.PI);
            double minRange = rand.nextDouble();
            double maxRange = rand.nextDouble();
            LidarScanParameters lidarScanParameters = new LidarScanParameters(pointsPerSweep, (double)(-fov) / 2.0, (double)fov / 2.0, minRange, maxRange);
            Assert.assertEquals((double)lidarScanParameters.getMaxRange(), maxRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getMinRange(), minRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getPointsPerSweep(), (double)pointsPerSweep, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getFieldOfView(), (double)fov, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMin(), (double)(-fov) / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMax(), (double)fov / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getTimeIncrement(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTime(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTimeNanos(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getTimestamp(), 0.0, 1.0E-7);
        }
    }

    @Test
    public void LidarScanParameters_5() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int pointsPerSweep = rand.nextInt();
            int fov = (int)((double)rand.nextFloat() * Math.PI);
            double minRange = rand.nextDouble();
            double maxRange = rand.nextDouble();
            LidarScanParameters lidarScanParameters = new LidarScanParameters(pointsPerSweep, (double)(-fov) / 2.0, (double)fov / 2.0, minRange, maxRange);
            Assert.assertEquals((double)lidarScanParameters.getMaxRange(), maxRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getMinRange(), minRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getPointsPerSweep(), (double)pointsPerSweep, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getFieldOfView(), (double)fov, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMin(), (double)(-fov) / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMax(), (double)fov / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getTimeIncrement(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTime(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTimeNanos(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getTimestamp(), 0.0, 1.0E-7);
        }
    }

    @Test
    public void LidarScanParameters_6() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int pointsPerSweep = rand.nextInt();
            int fov = (int)((double)rand.nextFloat() * Math.PI);
            double minRange = rand.nextDouble();
            double maxRange = rand.nextDouble();
            double timeIncrement = rand.nextDouble();
            double scanTime = rand.nextDouble();
            double minYaw = (double)(-fov) / 2.0;
            double maxYaw = (double)fov / 2.0;
            LidarScanParameters lidarScanParameters = new LidarScanParameters(pointsPerSweep, minYaw, maxYaw, timeIncrement, minRange, maxRange, scanTime);
            Assert.assertEquals((double)lidarScanParameters.getMaxRange(), maxRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getMinRange(), minRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getPointsPerSweep(), (double)pointsPerSweep, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getFieldOfView(), (double)fov, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMin(), (double)(-fov) / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMax(), (double)fov / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getTimeIncrement(), timeIncrement, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTime(), scanTime, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTimeNanos(), scanTime * 1.0E9, 100.0);
            Assert.assertEquals((double)lidarScanParameters.getTimestamp(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getAngleIncrement(), (maxYaw - minYaw) / (double)pointsPerSweep, 1.0E-5);
        }
    }

    @Test
    public void LidarScanParameters_7() {
        Random rand = new Random();
        for (int i = 0; i < 10000; ++i) {
            int pointsPerSweep = rand.nextInt();
            int fov = (int)((double)rand.nextFloat() * Math.PI);
            double minRange = rand.nextDouble();
            double maxRange = rand.nextDouble();
            double timeIncrement = rand.nextDouble();
            double scanTime = rand.nextDouble();
            long timeStamp = System.currentTimeMillis();
            double minYaw = (double)(-fov) / 2.0;
            double maxYaw = (double)fov / 2.0;
            LidarScanParameters lidarScanParameters = new LidarScanParameters(pointsPerSweep, minYaw, maxYaw, timeIncrement, minRange, maxRange, scanTime);
            Assert.assertEquals((double)lidarScanParameters.getMaxRange(), maxRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getMinRange(), minRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getPointsPerSweep(), (double)pointsPerSweep, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getFieldOfView(), (double)fov, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMin(), (double)(-fov) / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMax(), (double)fov / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getTimeIncrement(), timeIncrement, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTime(), scanTime, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTimeNanos(), scanTime * 1.0E9, 100.0);
            Assert.assertEquals((double)lidarScanParameters.getTimestamp(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getAngleIncrement(), (maxYaw - minYaw) / (double)pointsPerSweep, 0.001);
        }
    }

    @Test
    public void LidarScanParameters_8() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int pointsPerSweep = rand.nextInt();
            int fov = (int)((double)rand.nextFloat() * Math.PI);
            double minRange = rand.nextDouble();
            double maxRange = rand.nextDouble();
            double timeIncrement = rand.nextDouble();
            double scanTime = rand.nextDouble();
            long timeStamp = System.currentTimeMillis();
            double minYaw = (double)(-fov) / 2.0;
            double maxYaw = (double)fov / 2.0;
            LidarScanParameters lidarScanParameters = new LidarScanParameters(pointsPerSweep, minYaw, maxYaw, minRange, maxRange);
            Assert.assertEquals((double)lidarScanParameters.getMaxRange(), maxRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getMinRange(), minRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getPointsPerSweep(), (double)pointsPerSweep, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getFieldOfView(), (double)fov, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMin(), (double)(-fov) / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMax(), (double)fov / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getTimeIncrement(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTime(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTimeNanos(), 0.0, 100.0);
            Assert.assertEquals((double)lidarScanParameters.getTimestamp(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getAngleIncrement(), (maxYaw - minYaw) / (double)pointsPerSweep, 0.001);
        }
    }

    @Test
    public void LidarScanParameters_9() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            int pointsPerSweep = rand.nextInt();
            int fov = (int)((double)rand.nextFloat() * Math.PI);
            double minRange = rand.nextDouble();
            double maxRange = rand.nextDouble();
            double timeIncrement = rand.nextDouble();
            double scanTime = rand.nextDouble();
            long timeStamp = System.currentTimeMillis();
            double minYaw = (double)(-fov) / 2.0;
            double maxYaw = (double)fov / 2.0;
            LidarScanParameters lidarScanParameters = new LidarScanParameters(pointsPerSweep, (float)minYaw, (float)maxYaw, (float)minRange, (float)maxRange);
            Assert.assertEquals((double)lidarScanParameters.getMaxRange(), maxRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getMinRange(), minRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getPointsPerSweep(), (double)pointsPerSweep, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getFieldOfView(), (double)fov, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMin(), (double)(-fov) / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMax(), (double)fov / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getTimeIncrement(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTime(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTimeNanos(), 0.0, 100.0);
            Assert.assertEquals((double)lidarScanParameters.getTimestamp(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getAngleIncrement(), (maxYaw - minYaw) / (double)pointsPerSweep, 0.001);
        }
    }

    @Test
    public void LidarScanParameters_10() {
        Random rand = new Random();
        for (int i = 0; i < 10000; ++i) {
            int pointsPerSweep = rand.nextInt();
            int fov = (int)((double)rand.nextFloat() * Math.PI);
            double minRange = rand.nextDouble();
            double maxRange = rand.nextDouble();
            double timeIncrement = rand.nextDouble();
            double scanTime = rand.nextDouble();
            long timeStamp = System.currentTimeMillis();
            double minYaw = (double)(-fov) / 2.0;
            double maxYaw = (double)fov / 2.0;
            LidarScanParameters lidarScanParameters = new LidarScanParameters(pointsPerSweep, (float)minYaw, (float)maxYaw, (float)timeIncrement, (float)minRange, (float)maxRange, (float)scanTime);
            Assert.assertEquals((double)lidarScanParameters.getMaxRange(), maxRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getMinRange(), minRange, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getPointsPerSweep(), (double)pointsPerSweep, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getFieldOfView(), (double)fov, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMin(), (double)(-fov) / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMax(), (double)fov / 2.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getTimeIncrement(), timeIncrement, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTime(), scanTime, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTimeNanos(), scanTime * 1.0E9, 100.0);
            Assert.assertEquals((double)lidarScanParameters.getTimestamp(), 0.0, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getAngleIncrement(), (maxYaw - minYaw) / (double)pointsPerSweep, 0.001);
        }
    }

    @Test
    public void LidarScanParameters_11() {
        Random rand = new Random();
        for (int i = 0; i < 10000; ++i) {
            int pointsPerSweep = rand.nextInt();
            int fov = (int)((double)rand.nextFloat() * Math.PI);
            double minRange = rand.nextDouble();
            double maxRange = rand.nextDouble();
            double timeIncrement = rand.nextDouble();
            double scanTime = rand.nextDouble();
            long timeStamp = System.currentTimeMillis();
            double minYaw = (double)(-fov) / 2.0;
            double maxYaw = (double)fov / 2.0;
            LidarScanParameters lidarScanParameters = new LidarScanParameters(new Random(10L));
            Assert.assertEquals((double)lidarScanParameters.getMaxRange(), 0.36817038, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getMinRange(), 0.2441172, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getPointsPerSweep(), -7.78209333E8, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getFieldOfView(), -0.1551098, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMin(), 0.41291266, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getSweepYawMax(), 0.25780278, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getTimeIncrement(), 0.059201955, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTime(), 0.67215943, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getScanTimeNanos(), 6.7215943E8, 100.0);
            Assert.assertEquals((double)lidarScanParameters.getTimestamp(), -4.972683369271454E18, 1.0E-7);
            Assert.assertEquals((double)lidarScanParameters.getAngleIncrement(), 1.9931639653054633E-10, 1.0E-7);
        }
    }

    @Test
    public void testEquals() {
        Random rand = new Random();
        for (int i = 0; i < 10000; ++i) {
            int pointsPerSweep = rand.nextInt();
            int fov = (int)((double)rand.nextFloat() * Math.PI);
            double minRange = rand.nextDouble();
            double maxRange = rand.nextDouble();
            double timeIncrement = rand.nextDouble();
            double scanTime = rand.nextDouble();
            long timeStamp = System.currentTimeMillis();
            double minYaw = (double)(-fov) / 2.0;
            double maxYaw = (double)fov / 2.0;
            LidarScanParameters lidarScanParameters = new LidarScanParameters(new Random(10L));
            Assert.assertTrue(lidarScanParameters.equals((Object)lidarScanParameters));
        }
    }

    @Test
    public void testEquals_1() {
        Random rand = new Random();
        for (int i = 0; i < 10000; ++i) {
            int pointsPerSweep = rand.nextInt();
            int fov = (int)((double)rand.nextFloat() * Math.PI);
            double minRange = rand.nextDouble();
            double maxRange = rand.nextDouble();
            double timeIncrement = rand.nextDouble();
            double scanTime = rand.nextDouble();
            long timeStamp = System.currentTimeMillis();
            double minYaw = (double)(-fov) / 2.0;
            double maxYaw = (double)fov / 2.0;
            LidarScanParameters lidarScanParameters = new LidarScanParameters(new Random(10L));
            LidarScanParameters lidarScanParameters2 = new LidarScanParameters(new Random(1L));
            Assert.assertFalse(lidarScanParameters.equals((Object)lidarScanParameters2));
            Assert.assertFalse(lidarScanParameters.equals(null));
        }
    }
}

