/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.kinematics.TimeStampedTransform3D;
import us.ihmc.robotics.kinematics.TransformInterpolationCalculator;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class TransformInterpolationCalculatorTest {
    public TransformInterpolationCalculator transformInterpolationCalculator = new TransformInterpolationCalculator();

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testComputeInterpolationOne() throws Exception {
        RigidBodyTransform t1 = new RigidBodyTransform();
        t1.setIdentity();
        RigidBodyTransform t2 = new RigidBodyTransform();
        t2.setIdentity();
        RigidBodyTransform t3 = new RigidBodyTransform();
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, 0.0);
        Assert.assertTrue(t1.equals((EuclidGeometry)t3));
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, 1.0);
        Assert.assertTrue(t2.equals((EuclidGeometry)t3));
    }

    @Test
    public void testComputeInterpolationForTranslation() throws Exception {
        RotationMatrix maxtrixIdentity = new RotationMatrix();
        maxtrixIdentity.setIdentity();
        Vector3D vector1 = new Vector3D(0.0, 0.0, 0.0);
        Vector3D vector2 = new Vector3D(5.0, 8.0, 10.0);
        RigidBodyTransform t1 = new RigidBodyTransform((Orientation3DReadOnly)maxtrixIdentity, (Tuple3DReadOnly)vector1);
        RigidBodyTransform t2 = new RigidBodyTransform((Orientation3DReadOnly)maxtrixIdentity, (Tuple3DReadOnly)vector2);
        RigidBodyTransform t3 = new RigidBodyTransform();
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, 0.0);
        Vector3D interpolatedVector = new Vector3D();
        interpolatedVector.set((Tuple3DReadOnly)t3.getTranslation());
        Assert.assertTrue(vector1.epsilonEquals((EuclidGeometry)interpolatedVector, 1.0E-8));
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, 1.0);
        interpolatedVector = new Vector3D();
        interpolatedVector.set((Tuple3DReadOnly)t3.getTranslation());
        Assert.assertTrue(vector2.epsilonEquals((EuclidGeometry)interpolatedVector, 1.0E-8));
        double alpha = 0.25;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        interpolatedVector = new Vector3D();
        interpolatedVector.set((Tuple3DReadOnly)t3.getTranslation());
        Vector3D expectedVector = new Vector3D();
        expectedVector.scaleAdd(1.0 - alpha, (Tuple3DReadOnly)vector1, (Tuple3DReadOnly)expectedVector);
        expectedVector.scaleAdd(alpha, (Tuple3DReadOnly)vector2, (Tuple3DReadOnly)expectedVector);
        Assert.assertTrue(expectedVector.epsilonEquals((EuclidGeometry)interpolatedVector, 1.0E-8));
    }

    @Test
    public void testComputeInterpolationForRotationYaw() throws Exception {
        RigidBodyTransform t1 = new RigidBodyTransform();
        RigidBodyTransform t2 = new RigidBodyTransform();
        RigidBodyTransform t3 = new RigidBodyTransform();
        double[] yawPitchRoll = new double[3];
        double yaw1 = 0.0;
        double pitch1 = 0.0;
        double roll1 = 0.0;
        double yaw2 = 1.0;
        double pitch2 = 0.0;
        double roll2 = 0.0;
        t1.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll1, pitch1, yaw1));
        t2.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll2, pitch2, yaw2));
        double alpha = 0.0;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        Assert.assertTrue(t1.equals((EuclidGeometry)t3));
        alpha = 1.0;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        Assert.assertTrue(t2.epsilonEquals((EuclidGeometry)t3, 1.0E-6));
        alpha = 0.25;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        this.getYawPitchRoll(yawPitchRoll, t3);
        Assert.assertEquals(yawPitchRoll[0], (alpha - 1.0) * yaw1 + alpha * yaw2, 1.0E-6);
        yaw1 = 0.0;
        pitch1 = 0.0;
        roll1 = 0.0;
        yaw2 = 1.0;
        pitch2 = 0.0;
        roll2 = 0.0;
        t1.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll1, pitch1, yaw1));
        t2.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll2, pitch2, yaw2));
        alpha = 0.0;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        Assert.assertTrue(t1.equals((EuclidGeometry)t3));
        alpha = 1.0;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        Assert.assertTrue(t2.epsilonEquals((EuclidGeometry)t3, 1.0E-6));
        alpha = 0.25;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        this.getYawPitchRoll(yawPitchRoll, t3);
        Assert.assertEquals(yawPitchRoll[0], (alpha - 1.0) * yaw1 + alpha * yaw2, 1.0E-6);
    }

    @Test
    public void testComputeInterpolationForRotationRoll() throws Exception {
        RigidBodyTransform t1 = new RigidBodyTransform();
        RigidBodyTransform t2 = new RigidBodyTransform();
        RigidBodyTransform t3 = new RigidBodyTransform();
        double[] yawPitchRoll = new double[3];
        double yaw1 = 0.0;
        double pitch1 = 0.0;
        double roll1 = 0.0;
        double yaw2 = 0.0;
        double pitch2 = 0.0;
        double roll2 = 1.0;
        t1.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll1, pitch1, yaw1));
        t2.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll2, pitch2, yaw2));
        double alpha = 0.0;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        Assert.assertTrue(t1.equals((EuclidGeometry)t3));
        alpha = 1.0;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        Assert.assertTrue(t2.epsilonEquals((EuclidGeometry)t3, 1.0E-6));
        alpha = 0.25;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        this.getYawPitchRoll(yawPitchRoll, t3);
        Assert.assertEquals(yawPitchRoll[2], (alpha - 1.0) * roll1 + alpha * roll2, 1.0E-6);
    }

    @Test
    public void testComputeInterpolationForRotationPitch() throws Exception {
        RigidBodyTransform t1 = new RigidBodyTransform();
        RigidBodyTransform t2 = new RigidBodyTransform();
        RigidBodyTransform t3 = new RigidBodyTransform();
        double[] yawPitchRoll = new double[3];
        double yaw1 = 0.0;
        double pitch1 = 0.0;
        double roll1 = 0.0;
        double yaw2 = 0.0;
        double pitch2 = 1.0;
        double roll2 = 0.0;
        t1.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll1, pitch1, yaw1));
        t2.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll2, pitch2, yaw2));
        double alpha = 0.0;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        Assert.assertTrue(t1.equals((EuclidGeometry)t3));
        alpha = 1.0;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        Assert.assertTrue(t2.epsilonEquals((EuclidGeometry)t3, 1.0E-6));
        alpha = 0.25;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        this.getYawPitchRoll(yawPitchRoll, t3);
        Assert.assertEquals(yawPitchRoll[1], (alpha - 1.0) * pitch1 + alpha * pitch2, 1.0E-6);
    }

    @Test
    public void testComputeInterpolationForRotationYawEdgeCases() throws Exception {
        RigidBodyTransform t1 = new RigidBodyTransform();
        RigidBodyTransform t2 = new RigidBodyTransform();
        RigidBodyTransform t3 = new RigidBodyTransform();
        double[] yawPitchRoll = new double[3];
        double yaw1 = 0.0;
        double pitch1 = 0.0;
        double roll1 = 0.0;
        double yaw2 = 10.0;
        yaw2 = AngleTools.shiftAngleToStartOfRange((double)yaw2, (double)(-Math.PI));
        double pitch2 = 0.0;
        double roll2 = 0.0;
        t1.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll1, pitch1, yaw1));
        t2.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll2, pitch2, yaw2));
        double alpha = 0.0;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        Assert.assertTrue(t1.equals((EuclidGeometry)t3));
        alpha = 1.0;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        this.getYawPitchRoll(yawPitchRoll, t3);
        Assert.assertTrue(t2.epsilonEquals((EuclidGeometry)t3, 1.0E-6));
        alpha = 0.25;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        this.getYawPitchRoll(yawPitchRoll, t3);
        Assert.assertEquals(yawPitchRoll[0], (alpha - 1.0) * yaw1 + alpha * yaw2, 1.0E-6);
        yaw1 = 0.0;
        pitch1 = 0.0;
        roll1 = 0.0;
        yaw2 = 100.0;
        pitch2 = 0.0;
        roll2 = 0.0;
        t1.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll1, pitch1, yaw1));
        t2.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll2, pitch2, yaw2));
        alpha = 0.0;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        Assert.assertTrue(t1.equals((EuclidGeometry)t3));
        alpha = 1.0;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        this.getYawPitchRoll(yawPitchRoll, t3);
        Assert.assertTrue(t2.epsilonEquals((EuclidGeometry)t3, 1.0E-6));
        alpha = 0.25;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        this.getYawPitchRoll(yawPitchRoll, t3);
        yaw2 = AngleTools.shiftAngleToStartOfRange((double)yaw2, (double)(-Math.PI));
        Assert.assertEquals(yawPitchRoll[0], (alpha - 1.0) * yaw1 + alpha * yaw2, 1.0E-6);
    }

    @Test
    public void testComputeInterpolationForRotationCombined() throws Exception {
        RigidBodyTransform t1 = new RigidBodyTransform();
        RigidBodyTransform t2 = new RigidBodyTransform();
        RigidBodyTransform t3 = new RigidBodyTransform();
        double[] yawPitchRoll = new double[3];
        double yaw1 = 0.0;
        double pitch1 = 0.0;
        double roll1 = 0.0;
        double yaw2 = 1.0;
        double pitch2 = -1.0;
        double roll2 = 1.6;
        t1.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll1, pitch1, yaw1));
        t2.setRotationEulerAndZeroTranslation((Vector3DReadOnly)new Vector3D(roll2, pitch2, yaw2));
        AxisAngle axist1 = new AxisAngle();
        RotationMatrix maxtrixt1 = new RotationMatrix();
        maxtrixt1.set((RotationMatrixReadOnly)t1.getRotation());
        axist1.set((Orientation3DReadOnly)maxtrixt1);
        AxisAngle axist2 = new AxisAngle();
        RotationMatrix maxtrixt2 = new RotationMatrix();
        maxtrixt2.set((RotationMatrixReadOnly)t2.getRotation());
        axist2.set((Orientation3DReadOnly)maxtrixt2);
        double alpha = 0.25;
        this.transformInterpolationCalculator.computeInterpolation(t1, t2, t3, alpha);
        this.getYawPitchRoll(yawPitchRoll, t3);
        AxisAngle axist3 = new AxisAngle();
        RotationMatrix maxtrixt3 = new RotationMatrix();
        maxtrixt3.set((RotationMatrixReadOnly)t3.getRotation());
        axist3.set((Orientation3DReadOnly)maxtrixt3);
        double[] t2xyztheta = new double[4];
        axist2.get(t2xyztheta);
        double[] t3xyztheta = new double[4];
        axist3.get(t3xyztheta);
        Vector3D t2vector = new Vector3D(t2xyztheta[0], t2xyztheta[1], t2xyztheta[2]);
        Vector3D t3vector = new Vector3D(t3xyztheta[0], t3xyztheta[1], t3xyztheta[2]);
        double anlgeBetweenVectors = t2vector.angle((Vector3DReadOnly)t3vector);
        Assert.assertEquals(0.0, anlgeBetweenVectors, 1.0E-6);
        double expectedAngleRotation = alpha * t2xyztheta[3];
        Assert.assertEquals(expectedAngleRotation, t3xyztheta[3], 1.0E-6);
    }

    private void getYawPitchRoll(double[] yawPitchRoll, RigidBodyTransform transform3D) {
        RotationMatrix rotationMatrix = new RotationMatrix();
        rotationMatrix.set((RotationMatrixReadOnly)transform3D.getRotation());
        yawPitchRoll[0] = Math.atan2(rotationMatrix.getM10(), rotationMatrix.getM00());
        yawPitchRoll[1] = Math.asin(-rotationMatrix.getM20());
        yawPitchRoll[2] = Math.atan2(rotationMatrix.getM21(), rotationMatrix.getM22());
        if (Double.isNaN(yawPitchRoll[0]) || Double.isNaN(yawPitchRoll[1]) || Double.isNaN(yawPitchRoll[2])) {
            throw new RuntimeException("yaw, pitch, or roll are NaN! transform3D = " + String.valueOf(transform3D));
        }
    }

    @Test
    public void testInterpolationWithFramePoses() {
        Random random = new Random(52156165L);
        RigidBodyTransform transform1 = new RigidBodyTransform();
        RigidBodyTransform transform2 = new RigidBodyTransform();
        RigidBodyTransform toTestTransform = new RigidBodyTransform();
        RigidBodyTransform expectedTransform = new RigidBodyTransform();
        FramePose3D framePose1 = new FramePose3D();
        FramePose3D framePose2 = new FramePose3D();
        FramePose3D expectedFramePose = new FramePose3D();
        PoseReferenceFrame frame1 = new PoseReferenceFrame("frame1", (FramePose3DReadOnly)framePose1);
        PoseReferenceFrame frame2 = new PoseReferenceFrame("frame2", (FramePose3DReadOnly)framePose2);
        TransformInterpolationCalculator transformInterpolationCalculator = new TransformInterpolationCalculator();
        for (int i = 0; i < 1000; ++i) {
            transform1.set(EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
            transform2.set(EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
            framePose1.setIncludingFrame(ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)transform1);
            framePose2.setIncludingFrame(ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)transform2);
            double alpha = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1.0);
            transformInterpolationCalculator.computeInterpolation(transform1, transform2, toTestTransform, alpha);
            frame1.setPoseAndUpdate((FramePose3DReadOnly)framePose1);
            frame2.setPoseAndUpdate((FramePose3DReadOnly)framePose2);
            framePose1.changeFrame((ReferenceFrame)frame1);
            framePose2.changeFrame((ReferenceFrame)frame1);
            expectedFramePose.changeFrame((ReferenceFrame)frame1);
            expectedFramePose.interpolate((FramePose3DReadOnly)framePose1, (FramePose3DReadOnly)framePose2, alpha);
            expectedFramePose.changeFrame(ReferenceFrame.getWorldFrame());
            expectedFramePose.get((RigidBodyTransformBasics)expectedTransform);
            Assert.assertTrue(expectedTransform.epsilonEquals((EuclidGeometry)toTestTransform, 1.0E-10));
        }
    }

    @Test
    public void testInterpolationForTimeStampedTransform() {
        Random random = new Random(52156165L);
        TimeStampedTransform3D firstTimeStampedTransform = new TimeStampedTransform3D();
        TimeStampedTransform3D secondTimeStampedTransform = new TimeStampedTransform3D();
        TimeStampedTransform3D toTestTimeStampedTransform = new TimeStampedTransform3D();
        RigidBodyTransform expectedTransform = new RigidBodyTransform();
        TransformInterpolationCalculator transformInterpolationCalculator = new TransformInterpolationCalculator();
        firstTimeStampedTransform.setTimeStamp((long)RandomNumbers.nextInt((Random)random, (int)123, (int)45196516));
        secondTimeStampedTransform.setTimeStamp(firstTimeStampedTransform.getTimeStamp() - 1L);
        try {
            transformInterpolationCalculator.interpolate(firstTimeStampedTransform, secondTimeStampedTransform, toTestTimeStampedTransform, 216515L);
            Assert.fail("Should have thrown a RuntimeException as firstTimestamp is smaller than secondTimestamp.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        firstTimeStampedTransform.setTimeStamp((long)RandomNumbers.nextInt((Random)random, (int)123, (int)45196516));
        secondTimeStampedTransform.setTimeStamp(firstTimeStampedTransform.getTimeStamp() + (long)RandomNumbers.nextInt((Random)random, (int)1, (int)20));
        try {
            transformInterpolationCalculator.interpolate(firstTimeStampedTransform, secondTimeStampedTransform, toTestTimeStampedTransform, secondTimeStampedTransform.getTimeStamp() + 1L);
            Assert.fail("Should have thrown a RuntimeException as the given timestamp is outside bounds.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            transformInterpolationCalculator.interpolate(firstTimeStampedTransform, secondTimeStampedTransform, toTestTimeStampedTransform, firstTimeStampedTransform.getTimeStamp() - 1L);
            Assert.fail("Should have thrown a RuntimeException as the given timestamp is outside bounds.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        for (int i = 0; i < 100; ++i) {
            firstTimeStampedTransform.setTransform3D(EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
            secondTimeStampedTransform.setTransform3D(EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
            long timestamp1 = RandomNumbers.nextInt((Random)random, (int)123, (int)0x1FFFFFFF);
            long timestamp2 = timestamp1 + (long)RandomNumbers.nextInt((Random)random, (int)1, (int)200);
            firstTimeStampedTransform.setTimeStamp(timestamp1);
            secondTimeStampedTransform.setTimeStamp(timestamp2);
            long timeStampForInterpolation = RandomNumbers.nextInt((Random)random, (int)((int)firstTimeStampedTransform.getTimeStamp()), (int)((int)secondTimeStampedTransform.getTimeStamp()));
            transformInterpolationCalculator.interpolate(firstTimeStampedTransform, secondTimeStampedTransform, toTestTimeStampedTransform, timeStampForInterpolation);
            double alpha = ((double)timeStampForInterpolation - (double)timestamp1) / ((double)timestamp2 - (double)timestamp1);
            transformInterpolationCalculator.computeInterpolation(firstTimeStampedTransform.getTransform3D(), secondTimeStampedTransform.getTransform3D(), expectedTransform, alpha);
            Assert.assertTrue(expectedTransform.epsilonEquals((EuclidGeometry)toTestTimeStampedTransform.getTransform3D(), 1.0E-10));
        }
    }
}

