/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.kinematics.AverageQuaternionCalculator;

public class AverageQuaternionCalculatorTest {
    @Test
    public void testAgainstInterpolation() throws Exception {
        for (int nTest = 0; nTest < 10; ++nTest) {
            double epsilon = 1.0E-15;
            Random random = new Random(56416456L);
            Quaternion quat1 = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion quat2 = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion expectedAverageQuat = new Quaternion();
            expectedAverageQuat.interpolate((QuaternionReadOnly)quat1, (QuaternionReadOnly)quat2, 0.5);
            AverageQuaternionCalculator averageQuaternionCalculator = new AverageQuaternionCalculator();
            averageQuaternionCalculator.queueQuaternion(quat1);
            averageQuaternionCalculator.queueQuaternion(quat2);
            averageQuaternionCalculator.compute();
            Quaternion actualAverageQuat = new Quaternion();
            averageQuaternionCalculator.getAverageQuaternion(actualAverageQuat);
            if (expectedAverageQuat.getS() * actualAverageQuat.getS() < 0.0) {
                expectedAverageQuat.negate();
            }
            double[] expecteds = new double[4];
            expectedAverageQuat.get(expecteds);
            double[] actuals = new double[4];
            actualAverageQuat.get(actuals);
            Assertions.assertArrayEquals((double[])expecteds, (double[])actuals, (double)epsilon);
        }
    }

    @Test
    public void testWithRotationsAroundTheSameAxis() throws Exception {
        for (int nTest = 0; nTest < 10; ++nTest) {
            double epsilon = 1.0E-15;
            Random random = new Random(56416456L);
            Vector3D randomRotationAxis = EuclidCoreRandomTools.nextVector3D((Random)random, (double)1.0);
            double[] randomAngles = RandomNumbers.nextDoubleArray((Random)random, (int)100, (double)Math.PI);
            AxisAngle expectedAverageAxisAngle = new AxisAngle((Vector3DReadOnly)randomRotationAxis, AngleTools.computeAngleAverage((double[])randomAngles));
            Quaternion expectedAverageQuat = new Quaternion();
            expectedAverageQuat.set((Orientation3DReadOnly)expectedAverageAxisAngle);
            AverageQuaternionCalculator averageQuaternionCalculator = new AverageQuaternionCalculator();
            for (int i = 0; i < randomAngles.length; ++i) {
                AxisAngle tempAxisAngle = new AxisAngle((Vector3DReadOnly)randomRotationAxis, randomAngles[i]);
                Quaternion tempQuat4d = new Quaternion();
                tempQuat4d.set((Orientation3DReadOnly)tempAxisAngle);
                averageQuaternionCalculator.queueQuaternion(tempQuat4d);
            }
            averageQuaternionCalculator.compute();
            Quaternion actualAverageQuat = new Quaternion();
            averageQuaternionCalculator.getAverageQuaternion(actualAverageQuat);
            if (expectedAverageQuat.getS() * actualAverageQuat.getS() < 0.0) {
                expectedAverageQuat.negate();
            }
            double[] expecteds = new double[4];
            expectedAverageQuat.get(expecteds);
            double[] actuals = new double[4];
            actualAverageQuat.get(actuals);
            Assertions.assertArrayEquals((double[])expecteds, (double[])actuals, (double)epsilon);
        }
    }
}

