/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.concaveHull.clippingAndMerging;

import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2D;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2DReadOnly;
import us.ihmc.robotics.geometry.concavePolygon2D.clippingAndMerging.ConcavePolygon2DClippingTools;

public class ConcavePolygon2DClippingToolsTest {
    @Test
    public void testCreateLinkedPointList() {
        int i;
        ConcavePolygon2D polygon = new ConcavePolygon2D();
        polygon.addVertex(-1.0, 1.0);
        polygon.addVertex(1.0, 1.0);
        polygon.addVertex(1.0, -1.0);
        polygon.addVertex(-1.0, -1.0);
        polygon.update();
        ConcavePolygon2DClippingTools.LinkedPointList pointList = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygon);
        ConcavePolygon2DClippingTools.LinkedPoint point = pointList.getFirstPoint();
        for (i = 0; i < polygon.getNumberOfVertices(); ++i) {
            point = point.getSuccessor();
        }
        Assert.assertTrue(point == pointList.getFirstPoint());
        for (i = 0; i < polygon.getNumberOfVertices(); ++i) {
            EuclidCoreTestTools.assertPoint2DGeometricallyEquals((String)("Failed at vertex " + i), (Point2DReadOnly)polygon.getVertex(i), (Point2DReadOnly)point.getPoint(), (double)1.0E-6);
            point = point.getSuccessor();
        }
        polygon.clear();
        polygon.addVertex(0.0, 1.0);
        polygon.addVertex(1.0, 0.0);
        polygon.addVertex(-1.0, 0.0);
        polygon.update();
        pointList = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygon);
        point = pointList.getFirstPoint();
        for (i = 0; i < polygon.getNumberOfVertices(); ++i) {
            point = point.getSuccessor();
        }
        Assert.assertTrue(point == pointList.getFirstPoint());
        for (i = 0; i < polygon.getNumberOfVertices(); ++i) {
            EuclidCoreTestTools.assertPoint2DGeometricallyEquals((String)("Failed at vertex " + i), (Point2DReadOnly)polygon.getVertex(i), (Point2DReadOnly)point.getPoint(), (double)1.0E-6);
            point = point.getSuccessor();
        }
    }

    @Test
    public void testAddingIntersections() {
        ConcavePolygon2D polygonA = new ConcavePolygon2D();
        polygonA.addVertex(-1.0, 1.0);
        polygonA.addVertex(1.0, 1.0);
        polygonA.addVertex(1.0, -1.0);
        polygonA.addVertex(-1.0, -1.0);
        polygonA.update();
        ConcavePolygon2D polygonB = new ConcavePolygon2D();
        polygonB.addVertex(0.5, 0.5);
        polygonB.addVertex(1.5, 0.5);
        polygonB.addVertex(1.5, -0.5);
        polygonB.addVertex(0.5, -0.5);
        polygonB.update();
        ConcavePolygon2DClippingTools.LinkedPointList pointListA = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygonA);
        ConcavePolygon2DClippingTools.LinkedPointList pointListB = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygonB);
        ConcavePolygon2D polygonAWithIntersectionsExpected = new ConcavePolygon2D();
        polygonAWithIntersectionsExpected.addVertex(-1.0, 1.0);
        polygonAWithIntersectionsExpected.addVertex(1.0, 1.0);
        polygonAWithIntersectionsExpected.addVertex(1.0, 0.5);
        polygonAWithIntersectionsExpected.addVertex(1.0, -0.5);
        polygonAWithIntersectionsExpected.addVertex(1.0, -1.0);
        polygonAWithIntersectionsExpected.addVertex(-1.0, -1.0);
        polygonAWithIntersectionsExpected.update();
        ConcavePolygon2D polygonBWithIntersectionsExpected = new ConcavePolygon2D();
        polygonBWithIntersectionsExpected.addVertex(0.5, 0.5);
        polygonBWithIntersectionsExpected.addVertex(1.0, 0.5);
        polygonBWithIntersectionsExpected.addVertex(1.5, 0.5);
        polygonBWithIntersectionsExpected.addVertex(1.5, -0.5);
        polygonBWithIntersectionsExpected.addVertex(1.0, -0.5);
        polygonBWithIntersectionsExpected.addVertex(0.5, -0.5);
        polygonBWithIntersectionsExpected.update();
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)pointListA, (ConcavePolygon2DReadOnly)polygonB);
        ConcavePolygon2DClippingTools.LinkedPoint pointOnA = pointListA.getFirstPoint();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((String)"Failed at vertex 0", (Point2DReadOnly)polygonAWithIntersectionsExpected.getVertex(0), (Point2DReadOnly)pointOnA.getPoint(), (double)1.0E-6);
        pointOnA = pointOnA.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((String)"Failed at vertex 1", (Point2DReadOnly)polygonAWithIntersectionsExpected.getVertex(1), (Point2DReadOnly)pointOnA.getPoint(), (double)1.0E-6);
        pointOnA = pointOnA.getSuccessor();
        pointOnA = pointOnA.getSuccessor();
        pointOnA = pointOnA.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((String)"Failed at vertex 2", (Point2DReadOnly)polygonAWithIntersectionsExpected.getVertex(2), (Point2DReadOnly)pointOnA.getPoint(), (double)1.0E-6);
        pointOnA = pointOnA.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((String)"Failed at vertex 3", (Point2DReadOnly)polygonAWithIntersectionsExpected.getVertex(3), (Point2DReadOnly)pointOnA.getPoint(), (double)1.0E-6);
        pointOnA = pointOnA.getSuccessor();
        Assert.assertEquals(4L, polygonAWithIntersectionsExpected.getNumberOfVertices());
        Assert.assertTrue(pointOnA == pointListA.getFirstPoint());
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)pointListB, (ConcavePolygon2DReadOnly)polygonA);
        ConcavePolygon2DClippingTools.LinkedPoint pointOnB = pointListB.getFirstPoint();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((String)"Failed at vertex 0", (Point2DReadOnly)polygonBWithIntersectionsExpected.getVertex(0), (Point2DReadOnly)pointOnB.getPoint(), (double)1.0E-6);
        pointOnB = pointOnB.getSuccessor();
        pointOnB = pointOnB.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((String)"Failed at vertex 1", (Point2DReadOnly)polygonBWithIntersectionsExpected.getVertex(1), (Point2DReadOnly)pointOnB.getPoint(), (double)1.0E-6);
        pointOnB = pointOnB.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((String)"Failed at vertex 2", (Point2DReadOnly)polygonBWithIntersectionsExpected.getVertex(2), (Point2DReadOnly)pointOnB.getPoint(), (double)1.0E-6);
        pointOnB = pointOnB.getSuccessor();
        pointOnB = pointOnB.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((String)"Failed at vertex 3", (Point2DReadOnly)polygonBWithIntersectionsExpected.getVertex(3), (Point2DReadOnly)pointOnB.getPoint(), (double)1.0E-6);
        pointOnB = pointOnB.getSuccessor();
        Assert.assertTrue(pointOnB == pointListB.getFirstPoint());
    }

    @Test
    public void testSingleVertexIntersection() {
        ConcavePolygon2D polygonToClip = new ConcavePolygon2D();
        polygonToClip.addVertex(1.0, 1.0);
        polygonToClip.addVertex(1.0, -1.0);
        polygonToClip.addVertex(-1.0, -1.0);
        polygonToClip.addVertex(-1.0, 1.0);
        polygonToClip.update();
        ConcavePolygon2D clippingPolygon = new ConcavePolygon2D();
        clippingPolygon.addVertex(-0.5, 1.5);
        clippingPolygon.addVertex(0.5, 1.5);
        clippingPolygon.addVertex(0.0, 1.0);
        clippingPolygon.update();
        ConcavePolygon2DClippingTools.LinkedPointList pointList = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygonToClip);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)pointList, (ConcavePolygon2DReadOnly)clippingPolygon);
        ConcavePolygon2DClippingTools.LinkedPoint vertex = pointList.getFirstPoint();
        do {
            Assert.assertFalse(vertex.getIsIntersectionPoint());
        } while ((vertex = vertex.getSuccessor()) != pointList.getFirstPoint());
    }

    @Test
    public void testTrickyInsertIntersections() {
        ConcavePolygon2D polygonToClip = new ConcavePolygon2D();
        polygonToClip.addVertex(-1.0, 1.0);
        polygonToClip.addVertex(1.0, 1.0);
        polygonToClip.addVertex(1.0, -1.0);
        polygonToClip.addVertex(-1.0, -1.0);
        polygonToClip.update();
        ConcavePolygon2D clippingPolygon = new ConcavePolygon2D();
        clippingPolygon.addVertex(0.5, 1.5);
        clippingPolygon.addVertex(1.5, 1.5);
        clippingPolygon.addVertex(0.5, 0.5);
        clippingPolygon.update();
        ConcavePolygon2DClippingTools.LinkedPointList listA = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygonToClip);
        ConcavePolygon2DClippingTools.LinkedPointList listB = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)clippingPolygon);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)listA, (ConcavePolygon2DReadOnly)clippingPolygon);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)listB, (ConcavePolygon2DReadOnly)polygonToClip);
        ConcavePolygon2DClippingTools.LinkedPoint pointA = listA.getFirstPoint();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0, 1.0), (Point2DReadOnly)pointA.getPoint(), (double)1.0E-7);
        pointA = pointA.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.5, 1.0), (Point2DReadOnly)pointA.getPoint(), (double)1.0E-7);
        pointA = pointA.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)pointA.getPoint(), (double)1.0E-7);
        pointA = pointA.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, -1.0), (Point2DReadOnly)pointA.getPoint(), (double)1.0E-7);
        pointA = pointA.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0, -1.0), (Point2DReadOnly)pointA.getPoint(), (double)1.0E-7);
        ConcavePolygon2DClippingTools.LinkedPoint pointB = listB.getFirstPoint();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.5, 1.5), (Point2DReadOnly)pointB.getPoint(), (double)1.0E-7);
        pointB = pointB.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.5, 1.5), (Point2DReadOnly)pointB.getPoint(), (double)1.0E-7);
        pointB = pointB.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)pointB.getPoint(), (double)1.0E-7);
        pointB = pointB.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.5, 0.5), (Point2DReadOnly)pointB.getPoint(), (double)1.0E-7);
        pointB = pointB.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.5, 1.0), (Point2DReadOnly)pointB.getPoint(), (double)1.0E-7);
    }

    @Test
    public void testInsertIntersections() {
        ConcavePolygon2D polygon1 = new ConcavePolygon2D();
        polygon1.addVertex(-1.0, 1.0);
        polygon1.addVertex(1.0, 1.0);
        polygon1.addVertex(1.0, -1.0);
        polygon1.addVertex(-1.0, -1.0);
        polygon1.update();
        ConcavePolygon2D polygon2 = new ConcavePolygon2D();
        polygon2.addVertex(0.5, 0.5);
        polygon2.addVertex(1.5, 0.5);
        polygon2.addVertex(1.5, -0.5);
        polygon2.addVertex(0.5, -0.5);
        polygon2.update();
        ConcavePolygon2DClippingTools.LinkedPointList list = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygon1);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)list, (ConcavePolygon2DReadOnly)polygon2);
        ConcavePolygon2DClippingTools.LinkedPoint point = list.getFirstPoint();
        point = point.getSuccessor();
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 0.5), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, -0.5), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
    }

    @Test
    public void testInsertIntersections2() {
        ConcavePolygon2D polygon1 = new ConcavePolygon2D();
        polygon1.addVertex(-1.0, 1.0);
        polygon1.addVertex(1.0, 1.0);
        polygon1.addVertex(1.0, -1.0);
        polygon1.addVertex(-1.0, -1.0);
        polygon1.update();
        ConcavePolygon2D polygon2 = new ConcavePolygon2D();
        polygon2.addVertex(-1.0, 1.5);
        polygon2.addVertex(1.0, 1.5);
        polygon2.addVertex(0.0, 0.5);
        polygon2.update();
        ConcavePolygon2DClippingTools.LinkedPointList list = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygon1);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)list, (ConcavePolygon2DReadOnly)polygon2);
        ConcavePolygon2DClippingTools.LinkedPoint point = list.getFirstPoint();
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.5, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.5, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointBeforeInsideOther());
        Assert.assertFalse(point.isPointAfterInsideOther());
        list = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygon2);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)list, (ConcavePolygon2DReadOnly)polygon1);
        point = list.getFirstPoint();
        point = point.getSuccessor();
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.5, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.5, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
    }

    @Test
    public void testInsertIntersections3() {
        ConcavePolygon2D polygon1 = new ConcavePolygon2D();
        polygon1.addVertex(-1.0, 1.0);
        polygon1.addVertex(1.0, 1.0);
        polygon1.addVertex(1.0, -1.0);
        polygon1.addVertex(-1.0, -1.0);
        polygon1.update();
        ConcavePolygon2D polygon2 = new ConcavePolygon2D();
        polygon2.addVertex(-0.5, 1.5);
        polygon2.addVertex(0.5, 1.5);
        polygon2.addVertex(0.0, 1.0);
        polygon2.update();
        ConcavePolygon2DClippingTools.LinkedPointList list = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygon1);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)list, (ConcavePolygon2DReadOnly)polygon2);
        ConcavePolygon2DClippingTools.LinkedPoint point = list.getFirstPoint();
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertFalse(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        list = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygon2);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)list, (ConcavePolygon2DReadOnly)polygon1);
        point = list.getFirstPoint();
        point = point.getSuccessor();
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertFalse(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
    }

    @Test
    public void testInsertIntersections4() {
        ConcavePolygon2D uPolygon = new ConcavePolygon2D();
        uPolygon.addVertex(-1.0, 1.0);
        uPolygon.addVertex(-0.9, 1.0);
        uPolygon.addVertex(-0.9, -0.9);
        uPolygon.addVertex(0.9, -0.9);
        uPolygon.addVertex(0.9, 1.0);
        uPolygon.addVertex(1.0, 1.0);
        uPolygon.addVertex(1.0, -1.0);
        uPolygon.addVertex(-1.0, -1.0);
        uPolygon.update();
        ConcavePolygon2D hat = new ConcavePolygon2D();
        hat.addVertex(-1.0, 1.0);
        hat.addVertex(1.0, 1.0);
        hat.addVertex(1.0, 0.9);
        hat.addVertex(-1.0, 0.9);
        hat.update();
        ConcavePolygon2DClippingTools.LinkedPointList list = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)uPolygon);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)list, (ConcavePolygon2DReadOnly)hat);
        ConcavePolygon2DClippingTools.LinkedPoint point = list.getFirstPoint();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.9, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.9, 0.9), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.9, -0.9), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertFalse(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.9, -0.9), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertFalse(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        list = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)hat);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)list, (ConcavePolygon2DReadOnly)uPolygon);
        point = list.getFirstPoint();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.9, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.9, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 0.9), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.9, 0.9), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.9, 0.9), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0, 0.9), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
    }

    @Test
    public void testInsertIntersections7() {
        ConcavePolygon2D polygonA = new ConcavePolygon2D();
        polygonA.addVertex(-1.0, 1.0);
        polygonA.addVertex(1.0, 1.0);
        polygonA.addVertex(1.0, -1.0);
        polygonA.addVertex(-1.0, -1.0);
        polygonA.update();
        ConcavePolygon2D polygonB = new ConcavePolygon2D();
        polygonB.addVertex(-1.5, 1.5);
        polygonB.addVertex(1.5, 1.5);
        polygonB.addVertex(0.0, 0.0);
        polygonB.update();
        ConcavePolygon2D mergedPolygonExpected = new ConcavePolygon2D();
        mergedPolygonExpected.addVertex(-1.0, 1.0);
        mergedPolygonExpected.addVertex(-1.5, 1.5);
        mergedPolygonExpected.addVertex(1.5, 1.5);
        mergedPolygonExpected.addVertex(1.0, 1.0);
        mergedPolygonExpected.addVertex(1.0, -1.0);
        mergedPolygonExpected.addVertex(-1.0, -1.0);
        mergedPolygonExpected.update();
        ConcavePolygon2DClippingTools.LinkedPointList list = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygonA);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)list, (ConcavePolygon2DReadOnly)polygonB);
        ConcavePolygon2DClippingTools.LinkedPoint point = list.getFirstPoint();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)point.getPoint(), (Point2DReadOnly)new Point2D(-1.0, 1.0), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)point.getPoint(), (Point2DReadOnly)new Point2D(1.0, 1.0), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
    }

    @Test
    public void testInsertIntersections5() {
        ConcavePolygon2D polygon1 = new ConcavePolygon2D();
        polygon1.addVertex(1.0, 1.0);
        polygon1.addVertex(1.0, -1.0);
        polygon1.addVertex(-1.0, -1.0);
        polygon1.addVertex(-1.0, 1.0);
        polygon1.update();
        ConcavePolygon2D polygon2 = new ConcavePolygon2D();
        polygon2.addVertex(-0.1, 1.0);
        polygon2.addVertex(0.0, 1.1);
        polygon2.addVertex(0.1, 1.0);
        polygon2.addVertex(0.1, -1.0);
        polygon2.addVertex(0.0, -1.1);
        polygon2.addVertex(-0.1, -1.0);
        polygon2.update();
        ConcavePolygon2DClippingTools.LinkedPointList list = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygon1);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)list, (ConcavePolygon2DReadOnly)polygon2);
        ConcavePolygon2DClippingTools.LinkedPoint point = list.getFirstPoint();
        point = point.getSuccessor();
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.1, -1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.1, -1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        point = point.getSuccessor();
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.1, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.1, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
    }

    @Test
    public void testInsertIntersections6() {
        ConcavePolygon2D polygon1 = new ConcavePolygon2D();
        polygon1.addVertex(-1.0, 1.0);
        polygon1.addVertex(1.0, 1.0);
        polygon1.addVertex(0.75, 0.5);
        polygon1.addVertex(1.0, -1.0);
        polygon1.addVertex(-1.0, -1.0);
        polygon1.update();
        ConcavePolygon2D polygon2 = new ConcavePolygon2D();
        polygon2.addVertex(0.5, 1.5);
        polygon2.addVertex(1.5, 1.5);
        polygon2.addVertex(1.5, 0.5);
        polygon2.addVertex(0.5, 0.5);
        polygon2.update();
        ConcavePolygon2DClippingTools.LinkedPointList list = ConcavePolygon2DClippingTools.createLinkedPointList((ConcavePolygon2DReadOnly)polygon1);
        ConcavePolygon2DClippingTools.insertIntersectionsIntoList((ConcavePolygon2DClippingTools.LinkedPointList)list, (ConcavePolygon2DReadOnly)polygon2);
        ConcavePolygon2DClippingTools.LinkedPoint point = list.getFirstPoint();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertFalse(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.5, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertTrue(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertFalse(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.75, 0.5), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertTrue(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertTrue(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, -1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertFalse(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        point = point.getSuccessor();
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0, -1.0), (Point2DReadOnly)point.getPoint(), (double)1.0E-7);
        Assert.assertFalse(point.getIsIntersectionPoint());
        Assert.assertFalse(point.isPointAfterInsideOther());
        Assert.assertFalse(point.isPointBeforeInsideOther());
        Assert.assertEquals(list.getFirstPoint(), point.getSuccessor());
    }
}

