/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.concaveHull;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2D;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2DReadOnly;
import us.ihmc.robotics.geometry.concavePolygon2D.GeometryPolygonTools;

public class GeometryPolygonToolsTest {
    @Test
    public void testConcavePolygonAreaAndCentroid() {
        ConvexPolygon2D polygon1 = new ConvexPolygon2D();
        ConvexPolygon2D polygon2 = new ConvexPolygon2D();
        polygon1.addVertex(-1.0, 1.0);
        polygon1.addVertex(-1.0, -1.0);
        polygon1.addVertex(1.0, 1.0);
        polygon1.addVertex(1.0, -1.0);
        polygon1.update();
        polygon2.addVertex(1.0, 0.5);
        polygon2.addVertex(1.0, -0.5);
        polygon2.addVertex(2.0, -0.5);
        polygon2.addVertex(2.0, 0.5);
        polygon2.update();
        ArrayList<Point2D> concaveHull = new ArrayList<Point2D>();
        concaveHull.add(new Point2D(-1.0, 1.0));
        concaveHull.add(new Point2D(1.0, 1.0));
        concaveHull.add(new Point2D(1.0, 0.5));
        concaveHull.add(new Point2D(2.0, 0.5));
        concaveHull.add(new Point2D(2.0, -0.5));
        concaveHull.add(new Point2D(1.0, -0.5));
        concaveHull.add(new Point2D(1.0, -1.0));
        concaveHull.add(new Point2D(-1.0, -1.0));
        double totalArea = polygon1.getArea() + polygon2.getArea();
        Point2D totalCentroid = new Point2D();
        Point2D scaledCentroid1 = new Point2D();
        Point2D scaledCentroid2 = new Point2D();
        scaledCentroid1.set((Tuple2DReadOnly)polygon1.getCentroid());
        scaledCentroid1.scale(polygon1.getArea() / totalArea);
        scaledCentroid2.set((Tuple2DReadOnly)polygon2.getCentroid());
        scaledCentroid2.scale(polygon2.getArea() / totalArea);
        totalCentroid.add((Tuple2DReadOnly)scaledCentroid1, (Tuple2DReadOnly)scaledCentroid2);
        Point2D centroid = new Point2D();
        double actualArea = EuclidGeometryPolygonTools.computeConvexPolygon2DArea(concaveHull, (int)concaveHull.size(), (boolean)true, (Point2DBasics)centroid);
        Assert.assertEquals(totalArea, actualArea, 1.0E-7);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)totalCentroid, (Point2DReadOnly)centroid, (double)1.0E-7);
    }

    @Test
    public void testPolygonInsideOtherPolygonTricky() {
        ConcavePolygon2D uPolygon = new ConcavePolygon2D();
        uPolygon.addVertex(-1.0, 1.0);
        uPolygon.addVertex(-0.9, 1.0);
        uPolygon.addVertex(-0.9, -0.9);
        uPolygon.addVertex(0.9, -0.9);
        uPolygon.addVertex(0.9, 1.0);
        uPolygon.addVertex(1.0, 1.0);
        uPolygon.addVertex(1.0, -1.0);
        uPolygon.addVertex(-1.0, -1.0);
        uPolygon.update();
        ConcavePolygon2D hat = new ConcavePolygon2D();
        hat.addVertex(-1.0, 1.0);
        hat.addVertex(1.0, 1.0);
        hat.addVertex(1.0, 0.9);
        hat.addVertex(-1.0, 0.9);
        hat.update();
        Assert.assertFalse(GeometryPolygonTools.isPolygonInsideOtherPolygon((Vertex2DSupplier)hat, (ConcavePolygon2DReadOnly)uPolygon));
    }

    @Test
    public void testTrickyIsPointInside() {
        ConcavePolygon2D uPolygon = new ConcavePolygon2D();
        uPolygon.addVertex(-1.0, 1.0);
        uPolygon.addVertex(-0.9, 1.0);
        uPolygon.addVertex(-0.9, -0.9);
        uPolygon.addVertex(0.9, -0.9);
        uPolygon.addVertex(0.9, 1.0);
        uPolygon.addVertex(1.0, 1.0);
        uPolygon.addVertex(1.0, -1.0);
        uPolygon.addVertex(-1.0, -1.0);
        uPolygon.update();
        Assert.assertFalse(uPolygon.isPointInside(0.0, 1.0));
        Assert.assertFalse(uPolygon.isPointInside(-0.8995, 1.0));
        Assert.assertFalse(uPolygon.isPointInsideEpsilon(-0.8995, 1.0, 1.0E-5));
        Point2D pointToTest = new Point2D(-0.8995000000000001, 1.0);
        Assert.assertFalse(GeometryPolygonTools.isPoint2DInsideSimplePolygon2D((Point2DReadOnly)pointToTest, (List)uPolygon.getVertexBufferView(), (int)uPolygon.getNumberOfVertices(), (double)1.0E-7));
    }

    @Test
    public void testTrickyIsPointInside2() {
        ConcavePolygon2D polygon = new ConcavePolygon2D();
        polygon.addVertex(1.5, 1.5);
        polygon.addVertex(1.5, 0.5);
        polygon.addVertex(1.0, 0.5);
        polygon.addVertex(1.0, -1.0);
        polygon.addVertex(-1.0, -1.0);
        polygon.addVertex(-1.0, 1.0);
        polygon.addVertex(0.5, 1.0);
        polygon.addVertex(0.5, 1.5);
        polygon.update();
        Assert.assertTrue(polygon.isPointInside(0.5, 0.5));
    }

    @Test
    public void testEasyInteriorPolygon() {
        ConcavePolygon2D outerPolygon = new ConcavePolygon2D();
        ConcavePolygon2D innerPolygon = new ConcavePolygon2D();
        outerPolygon.addVertex(-1.0, 1.0);
        outerPolygon.addVertex(1.0, 1.0);
        outerPolygon.addVertex(1.0, -1.0);
        outerPolygon.addVertex(-1.0, -1.0);
        outerPolygon.update();
        innerPolygon.addVertex(-0.5, 0.5);
        innerPolygon.addVertex(0.5, 0.5);
        innerPolygon.addVertex(0.5, -0.5);
        innerPolygon.addVertex(-0.5, -0.5);
        innerPolygon.update();
        Assert.assertTrue(GeometryPolygonTools.isPolygonInsideOtherPolygon((Vertex2DSupplier)innerPolygon, (ConcavePolygon2DReadOnly)outerPolygon));
        innerPolygon.clear();
        innerPolygon.addVertex(-0.5, 0.5);
        innerPolygon.addVertex(1.5, 0.5);
        innerPolygon.addVertex(1.5, -0.5);
        innerPolygon.addVertex(-0.5, -0.5);
        innerPolygon.update();
        Assert.assertFalse(GeometryPolygonTools.isPolygonInsideOtherPolygon((Vertex2DSupplier)innerPolygon, (ConcavePolygon2DReadOnly)outerPolygon));
    }

    @Test
    public void testIsPolygonInsideOtherPolygon() {
        ConcavePolygon2D polygon1 = new ConcavePolygon2D();
        polygon1.addVertex(-0.1, 1.0);
        polygon1.addVertex(0.1, 1.0);
        polygon1.addVertex(0.1, -1.0);
        polygon1.addVertex(-0.1, -1.0);
        polygon1.update();
        ConcavePolygon2D polygon2 = new ConcavePolygon2D();
        polygon2.addVertex(0.9, 1.0);
        polygon2.addVertex(1.1, 1.0);
        polygon2.addVertex(1.1, -1.0);
        polygon2.addVertex(0.9, -1.0);
        polygon2.update();
        Assert.assertFalse(GeometryPolygonTools.isPolygonInsideOtherPolygon((Vertex2DSupplier)polygon1, (ConcavePolygon2DReadOnly)polygon2));
        Assert.assertFalse(GeometryPolygonTools.isPolygonInsideOtherPolygon((Vertex2DSupplier)polygon2, (ConcavePolygon2DReadOnly)polygon1));
    }

    @Test
    public void testIsPointInside() {
        int i;
        ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
        convexPolygon.addVertex(-0.1, 1.0);
        convexPolygon.addVertex(0.0, 1.1);
        convexPolygon.addVertex(0.1, 1.0);
        convexPolygon.addVertex(0.1, -1.0);
        convexPolygon.addVertex(0.0, -1.1);
        convexPolygon.addVertex(-0.1, -1.0);
        convexPolygon.update();
        ConcavePolygon2D concavePolygon = new ConcavePolygon2D((Vertex2DSupplier)convexPolygon);
        ConcavePolygon2D concavePolygonOther = new ConcavePolygon2D();
        concavePolygonOther.addVertex(-0.1, 1.0);
        concavePolygonOther.addVertex(0.0, 1.1);
        concavePolygonOther.addVertex(0.1, 1.0);
        concavePolygonOther.addVertex(0.1, -1.0);
        concavePolygonOther.addVertex(0.0, -1.1);
        concavePolygonOther.addVertex(-0.1, -1.0);
        concavePolygonOther.update();
        Assert.assertTrue(convexPolygon.isPointInside(0.08, -1.0));
        Assert.assertTrue(concavePolygonOther.isPointInside(0.08, -1.0));
        Random random = new Random(1738L);
        for (i = 0; i < 10000; ++i) {
            Point2DReadOnly interiorPoint = GeometryPolygonToolsTest.getRandomInteriorPoint(random, (ConvexPolygon2DReadOnly)convexPolygon);
            Assert.assertTrue(convexPolygon.isPointInside(interiorPoint));
            Assert.assertTrue(concavePolygon.isPointInside(interiorPoint));
            Assert.assertTrue(concavePolygonOther.isPointInside(interiorPoint));
            Assert.assertTrue(GeometryPolygonTools.isPoint2DInsideSimplePolygon2D((Point2DReadOnly)interiorPoint, (List)concavePolygon.getVertexBufferView(), (int)concavePolygon.getNumberOfVertices()));
        }
        for (i = 0; i < convexPolygon.getNumberOfVertices(); ++i) {
            for (int j = 0; j < 100; ++j) {
                Point2DReadOnly vertex = convexPolygon.getVertex(i);
                Point2DReadOnly nextVertex = convexPolygon.getNextVertex(i);
                Point2D edgePoint = new Point2D();
                edgePoint.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, (double)(j / 100));
                Assert.assertTrue(convexPolygon.isPointInside((Point2DReadOnly)edgePoint));
                Assert.assertTrue(concavePolygon.isPointInside((Point2DReadOnly)edgePoint));
                Assert.assertTrue(concavePolygonOther.isPointInside((Point2DReadOnly)edgePoint));
                Assert.assertTrue(GeometryPolygonTools.isPoint2DInsideSimplePolygon2D((Point2DReadOnly)edgePoint, (List)concavePolygon.getVertexBufferView(), (int)concavePolygon.getNumberOfVertices()));
            }
        }
    }

    private static Point2DReadOnly getRandomInteriorPoint(Random random, ConvexPolygon2DReadOnly polygon2D) {
        int numberOfPoints = polygon2D.getNumberOfVertices();
        double maxAlpha = 1.0;
        Point2D randomPoint = new Point2D();
        for (int i = 0; i < numberOfPoints; ++i) {
            double alpha = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)maxAlpha);
            maxAlpha -= alpha;
            randomPoint.scaleAdd(alpha, (Tuple2DReadOnly)polygon2D.getVertex(i), (Tuple2DReadOnly)randomPoint);
        }
        return randomPoint;
    }

    @Test
    public void doPolygonIntersectTest() {
        ConcavePolygon2D polygonToClip = new ConcavePolygon2D();
        polygonToClip.addVertex(-1.0, 1.0);
        polygonToClip.addVertex(1.0, 1.0);
        polygonToClip.addVertex(1.0, -1.0);
        polygonToClip.addVertex(-1.0, -1.0);
        polygonToClip.update();
        Assert.assertTrue(polygonToClip.isPointInside(0.5, 0.5));
        ConcavePolygon2D clippingPolygon = new ConcavePolygon2D();
        clippingPolygon.addVertex(0.5, 0.5);
        clippingPolygon.addVertex(1.5, 0.5);
        clippingPolygon.addVertex(1.5, -0.5);
        clippingPolygon.addVertex(0.5, -0.5);
        clippingPolygon.update();
        Assert.assertTrue(polygonToClip.isPointInside(clippingPolygon.getVertex(0)));
        Assert.assertFalse(polygonToClip.isPointInside(clippingPolygon.getVertex(1)));
        Assert.assertFalse(polygonToClip.isPointInside(clippingPolygon.getVertex(2)));
        Assert.assertTrue(polygonToClip.isPointInside(clippingPolygon.getVertex(3)));
        ConcavePolygon2D polygonToClipUnmodified = new ConcavePolygon2D((Vertex2DSupplier)polygonToClip);
        ConcavePolygon2D clippingPolygonUnmodified = new ConcavePolygon2D((Vertex2DSupplier)clippingPolygon);
        Assert.assertTrue(GeometryPolygonTools.doPolygonsIntersect((ConcavePolygon2DReadOnly)polygonToClip, (ConcavePolygon2DReadOnly)clippingPolygon));
        Assert.assertTrue(polygonToClip.epsilonEquals((ConcavePolygon2DReadOnly)polygonToClipUnmodified, 1.0E-8));
        Assert.assertTrue(clippingPolygon.epsilonEquals((ConcavePolygon2DReadOnly)clippingPolygonUnmodified, 1.0E-8));
    }

    @Test
    public void testIsPoint2DInsideSimplePolygon2D() {
        ConcavePolygon2D polygon = new ConcavePolygon2D();
        polygon.addVertex(1.5, 1.5);
        polygon.addVertex(0.0, 0.0);
        polygon.addVertex(-1.5, 1.5);
        polygon.update();
        Assert.assertTrue(GeometryPolygonTools.isPoint2DInsideSimplePolygon2D((double)1.0, (double)1.0, (List)polygon.getVertexBufferView(), (int)3));
        Assert.assertTrue(GeometryPolygonTools.isPoint2DInsideSimplePolygon2D((double)-1.0, (double)1.0, (List)polygon.getVertexBufferView(), (int)3));
        ConcavePolygon2D polygon1 = new ConcavePolygon2D();
        polygon1.addVertex(-0.1, 1.0);
        polygon1.addVertex(0.1, 1.0);
        polygon1.addVertex(0.1, -1.0);
        polygon1.addVertex(-0.1, -1.0);
        polygon1.update();
        ConcavePolygon2D polygon2 = new ConcavePolygon2D();
        polygon2.addVertex(0.9, 1.0);
        polygon2.addVertex(1.1, 1.0);
        polygon2.addVertex(1.1, -1.0);
        polygon2.addVertex(0.9, -1.0);
        polygon2.update();
        for (int i = 0; i < 4; ++i) {
            Assert.assertFalse(GeometryPolygonTools.isPoint2DInsideSimplePolygon2D((Point2DReadOnly)polygon1.getVertex(i), (List)polygon2.getVertexBufferView(), (int)4));
            Assert.assertFalse(GeometryPolygonTools.isPoint2DInsideSimplePolygon2D((Point2DReadOnly)polygon2.getVertex(i), (List)polygon1.getVertexBufferView(), (int)4));
        }
    }

    @Test
    public void testNastyPointInsideBug() {
        ConcavePolygon2D polygon1 = new ConcavePolygon2D();
        polygon1.addVertex(-0.1, 1.0);
        polygon1.addVertex(0.1, 1.0);
        polygon1.addVertex(0.1, -1.0);
        polygon1.addVertex(-0.1, -1.0);
        polygon1.update();
        Assert.assertFalse(GeometryPolygonTools.isPoint2DInsideSimplePolygon2D((double)-0.3, (double)1.0, (List)polygon1.getVertexBufferView(), (int)4));
    }

    @Test
    public void testPointInside() {
        ConcavePolygon2D polygon2 = new ConcavePolygon2D();
        polygon2.addVertex(-1.0, 1.5);
        polygon2.addVertex(1.0, 1.5);
        polygon2.addVertex(0.0, 0.5);
        polygon2.update();
        ConvexPolygon2D convexPolygon2D = new ConvexPolygon2D((Vertex2DSupplier)polygon2);
        Assert.assertTrue(convexPolygon2D.isPointInside(0.499, 1.0));
        Assert.assertTrue(polygon2.isPointInside(0.499, 1.0));
        Assert.assertFalse(convexPolygon2D.isPointInside(0.501, 1.0));
        Assert.assertFalse(polygon2.isPointInside(0.501, 1.0));
    }
}

