/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.concaveHull;

import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2D;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2DReadOnly;

public class ConcavePolygon2DToolsTest {
    @Test
    public void testConcavePolygonAreaAndCentroid() {
        ConvexPolygon2D polygon1 = new ConvexPolygon2D();
        ConvexPolygon2D polygon2 = new ConvexPolygon2D();
        polygon1.addVertex(-1.0, 1.0);
        polygon1.addVertex(-1.0, -1.0);
        polygon1.addVertex(1.0, 1.0);
        polygon1.addVertex(1.0, -1.0);
        polygon1.update();
        polygon2.addVertex(1.0, 0.5);
        polygon2.addVertex(1.0, -0.5);
        polygon2.addVertex(2.0, -0.5);
        polygon2.addVertex(2.0, 0.5);
        polygon2.update();
        ConcavePolygon2D concaveHull = new ConcavePolygon2D();
        concaveHull.addVertex(-1.0, 1.0);
        concaveHull.addVertex(1.0, 1.0);
        concaveHull.addVertex(1.0, 0.5);
        concaveHull.addVertex(2.0, 0.5);
        concaveHull.addVertex(2.0, -0.5);
        concaveHull.addVertex(1.0, -0.5);
        concaveHull.addVertex(1.0, -1.0);
        concaveHull.addVertex(-1.0, -1.0);
        concaveHull.update();
        double totalArea = polygon1.getArea() + polygon2.getArea();
        Point2D totalCentroid = new Point2D();
        Point2D scaledCentroid1 = new Point2D();
        Point2D scaledCentroid2 = new Point2D();
        scaledCentroid1.set((Tuple2DReadOnly)polygon1.getCentroid());
        scaledCentroid1.scale(polygon1.getArea() / totalArea);
        scaledCentroid2.set((Tuple2DReadOnly)polygon2.getCentroid());
        scaledCentroid2.scale(polygon2.getArea() / totalArea);
        totalCentroid.add((Tuple2DReadOnly)scaledCentroid1, (Tuple2DReadOnly)scaledCentroid2);
        Assert.assertEquals(totalArea, concaveHull.getArea(), 1.0E-7);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)totalCentroid, (Point2DReadOnly)concaveHull.getCentroid(), (double)1.0E-7);
    }

    @Test
    public void testInsertVertex() {
        ConcavePolygon2D polygon = new ConcavePolygon2D();
        polygon.addVertex(-1.0, 1.0);
        polygon.addVertex(1.0, 1.0);
        polygon.addVertex(1.0, -1.0);
        polygon.addVertex(-1.0, -1.0);
        polygon.update();
        double area = 4.0;
        Assert.assertEquals(4L, polygon.getNumberOfVertices());
        Assert.assertEquals(area, polygon.getArea(), 1.0E-7);
        polygon.insertVertex(1, 0.0, 0.9);
        Assert.assertFalse(polygon.isUpToDate());
        polygon.update();
        Assert.assertTrue(polygon.isUpToDate());
        Assert.assertEquals(5L, polygon.getNumberOfVertices());
        Assert.assertEquals(area -= 0.1, polygon.getArea(), 1.0E-7);
        polygon.removeVertex(1);
        Assert.assertFalse(polygon.isUpToDate());
        polygon.update();
        area = 4.0;
        Assert.assertTrue(polygon.isUpToDate());
        Assert.assertEquals(4L, polygon.getNumberOfVertices());
        Assert.assertEquals(area, polygon.getArea(), 1.0E-7);
        polygon.insertVertex(1, 0.0, 0.0);
        Assert.assertFalse(polygon.isUpToDate());
        polygon.update();
        Assert.assertTrue(polygon.isUpToDate());
        Assert.assertEquals(5L, polygon.getNumberOfVertices());
        Assert.assertEquals(3.0, polygon.getArea(), 1.0E-7);
    }

    @Test
    public void testEpsilonEquals() {
        ConcavePolygon2D polygonA = new ConcavePolygon2D();
        polygonA.addVertex(1.0, 1.0);
        polygonA.addVertex(1.0, -1.0);
        polygonA.addVertex(-1.0, -1.0);
        polygonA.update();
        ConcavePolygon2D polygonB = new ConcavePolygon2D();
        polygonB.addVertex(1.0, 1.0);
        polygonB.addVertex(1.0, -1.0);
        polygonB.addVertex(-1.0, -1.0);
        polygonB.update();
        Assert.assertTrue(polygonA.epsilonEquals((ConcavePolygon2DReadOnly)polygonB, 1.0E-7));
        polygonB.clear();
        polygonB.addVertex(0.5, 0.5);
        polygonB.addVertex(0.5, -0.5);
        polygonB.addVertex(-0.5, -0.5);
        polygonB.update();
        Assert.assertFalse(polygonA.epsilonEquals((ConcavePolygon2DReadOnly)polygonB, 1.0E-7));
    }
}

